/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.SendMessageOptions;
import net.i2p.client.datagram.Datagram2;
import net.i2p.client.datagram.Datagram3;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.I2PSnarkUtil;

class UDPTrackerClient
implements I2PSessionMuxedListener {
    private final I2PAppContext _context;
    private final Log _log;
    private final I2PSession _session;
    private final I2PSnarkUtil _util;
    private final Hash _myHash;
    private final int _rPort;
    private final ConcurrentHashMap<HostPort, Tracker> _trackers;
    private final Map<Integer, ReplyWaiter> _sentQueries;
    private boolean _isRunning;
    private static final long INIT_CONN_ID = 4497486125440L;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_COMPLETED = 1;
    public static final int EVENT_STARTED = 2;
    public static final int EVENT_STOPPED = 3;
    private static final int ACTION_CONNECT = 0;
    private static final int ACTION_ANNOUNCE = 1;
    private static final int ACTION_SCRAPE = 2;
    private static final int ACTION_ERROR = 3;
    private static final int SEND_CRYPTO_TAGS = 8;
    private static final int LOW_CRYPTO_TAGS = 4;
    private static final long CONN_EXPIRATION = 60000L;
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final long DEFAULT_QUERY_TIMEOUT = 60000L;
    private static final long CLEAN_TIME = 163000L;
    private static final int DEFAULT_INTERVAL = 3600;
    private static final int MIN_INTERVAL = 900;
    private static final int MAX_INTERVAL = 28800;

    public UDPTrackerClient(I2PAppContext ctx, I2PSession session, I2PSnarkUtil util) {
        this._context = ctx;
        this._session = session;
        this._util = util;
        this._log = ctx.logManager().getLog(UDPTrackerClient.class);
        this._rPort = 6880;
        this._myHash = session.getMyDestination().calculateHash();
        this._trackers = new ConcurrentHashMap(8);
        this._sentQueries = new ConcurrentHashMap<Integer, ReplyWaiter>(32);
    }

    public synchronized void start() {
        if (this._isRunning) {
            return;
        }
        this._session.addMuxedSessionListener(this, 18, this._rPort);
        this._isRunning = true;
    }

    public synchronized void stop() {
        if (!this._isRunning) {
            return;
        }
        this._isRunning = false;
        this._session.removeListener(18, this._rPort);
        this._trackers.clear();
        for (ReplyWaiter w : this._sentQueries.values()) {
            w.cancel();
        }
        this._sentQueries.clear();
    }

    public TrackerResponse announce(byte[] ih, byte[] peerID, int max, long maxWait, String toHost, int toPort, long downloaded, long left, long uploaded, int event, boolean fast) {
        long now = this._context.clock().now();
        long end = now + maxWait;
        if (toPort <= 0) {
            throw new IllegalArgumentException();
        }
        Tracker tr = this.getTracker(toHost, toPort);
        if (tr.getDest(fast) == null) {
            if (this._log.shouldInfo()) {
                this._log.info("cannot resolve " + String.valueOf(tr));
            }
            return null;
        }
        long toWait = end - now;
        if (!fast) {
            toWait = toWait * 3L / 4L;
        }
        if (toWait < 1000L) {
            if (this._log.shouldInfo()) {
                this._log.info("out of time after resolving: " + String.valueOf(tr));
            }
            return null;
        }
        Long cid = this.getConnection(tr, now + toWait);
        if (cid == null) {
            if (this._log.shouldInfo()) {
                this._log.info("no connection for: " + String.valueOf(tr));
            }
            return null;
        }
        if (fast) {
            toWait = 0L;
        } else {
            now = this._context.clock().now();
            toWait = end - now;
            if (toWait < 1000L) {
                if (this._log.shouldInfo()) {
                    this._log.info("out of time after getting conn: " + String.valueOf(tr));
                }
                return null;
            }
        }
        ReplyWaiter w = this.sendAnnounce(tr, cid, ih, peerID, downloaded, left, uploaded, event, max, toWait);
        if (fast) {
            return null;
        }
        if (w == null) {
            if (this._log.shouldInfo()) {
                this._log.info("initial announce failed: " + String.valueOf(tr));
            }
            return null;
        }
        boolean success = this.waitAndRetransmit(w, end);
        this._sentQueries.remove(w.getID());
        if (success) {
            return w.getReplyObject();
        }
        if (this._log.shouldInfo()) {
            this._log.info("announce failed after retx: " + String.valueOf(tr));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getConnection(Tracker tr, long untilTime) {
        boolean shouldConnect = false;
        Tracker tracker = tr;
        synchronized (tracker) {
            boolean wasInProgress = false;
            while (true) {
                Long conn;
                if ((conn = tr.getConnection()) != null) {
                    return conn;
                }
                if (wasInProgress) {
                    return null;
                }
                long now = this._context.clock().now();
                long toWait = untilTime - now;
                if (toWait <= 0L) {
                    return null;
                }
                if (!tr.isConnInProgress()) break;
                wasInProgress = true;
                try {
                    tr.wait(toWait);
                }
                catch (InterruptedException interruptedException) {}
            }
            shouldConnect = true;
            tr.setConnInProgress(true);
        }
        if (shouldConnect) {
            long now = this._context.clock().now();
            long toWait = untilTime - now;
            if (toWait <= 1000L) {
                tr.setConnInProgress(false);
                return null;
            }
            ReplyWaiter w = this.sendConnReq(tr, toWait);
            if (w == null) {
                tr.setConnInProgress(false);
                return null;
            }
            boolean success = this.waitAndRetransmit(w, untilTime);
            if (success) {
                return tr.getConnection();
            }
        }
        return null;
    }

    private Tracker getTracker(String host, int port) {
        Tracker ndp = new Tracker(host, port);
        Tracker odp = this._trackers.putIfAbsent(ndp, ndp);
        if (odp != null) {
            ndp = odp;
        }
        return ndp;
    }

    private ReplyWaiter sendConnReq(Tracker tr, long toWait) {
        if (toWait <= 0L) {
            throw new IllegalArgumentException();
        }
        int tid = this._context.random().nextInt();
        byte[] payload = this.sendConnReq(tr, tid);
        if (payload != null) {
            ReplyWaiter rv = new ReplyWaiter(tid, tr, 0, payload, toWait);
            this._sentQueries.put(tid, rv);
            if (this._log.shouldInfo()) {
                this._log.info("Sent: " + String.valueOf(rv) + " timeout: " + toWait);
            }
            return rv;
        }
        return null;
    }

    private byte[] sendConnReq(Tracker tr, int tid) {
        byte[] payload = new byte[16];
        DataHelper.toLong8(payload, 0, 4497486125440L);
        DataHelper.toLong(payload, 12, 4, tid);
        boolean rv = this.sendMessage(tr.getDest(true), tr.getPort(), payload, true);
        return (byte[])(rv ? payload : null);
    }

    private ReplyWaiter sendAnnounce(Tracker tr, long connID, byte[] ih, byte[] id, long downloaded, long left, long uploaded, int event, int numWant, long toWait) {
        int tid = this._context.random().nextInt();
        byte[] payload = this.sendAnnounce(tr, tid, connID, ih, id, downloaded, left, uploaded, event, numWant);
        if (payload != null) {
            if (toWait > 0L) {
                ReplyWaiter rv = new ReplyWaiter(tid, tr, 1, payload, toWait);
                this._sentQueries.put(tid, rv);
                if (this._log.shouldInfo()) {
                    this._log.info("Sent: " + String.valueOf(rv) + " timeout: " + toWait);
                }
                return rv;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Sent annc " + event + " to " + String.valueOf(tr) + " no wait");
            }
        }
        return null;
    }

    private byte[] sendAnnounce(Tracker tr, int tid, long connID, byte[] ih, byte[] id, long downloaded, long left, long uploaded, int event, int numWant) {
        byte[] payload = new byte[98];
        DataHelper.toLong8(payload, 0, connID);
        DataHelper.toLong(payload, 8, 4, 1L);
        DataHelper.toLong(payload, 12, 4, tid);
        System.arraycopy(ih, 0, payload, 16, 20);
        System.arraycopy(id, 0, payload, 36, 20);
        DataHelper.toLong(payload, 56, 8, downloaded);
        DataHelper.toLong(payload, 64, 8, left);
        DataHelper.toLong(payload, 72, 8, uploaded);
        DataHelper.toLong(payload, 80, 4, event);
        DataHelper.toLong(payload, 92, 4, numWant);
        DataHelper.toLong(payload, 96, 2, this._rPort);
        boolean rv = this.sendMessage(tr.getDest(true), tr.getPort(), payload, false);
        return (byte[])(rv ? payload : null);
    }

    private boolean waitAndRetransmit(ReplyWaiter w, long untilTime) {
        ReplyWaiter replyWaiter = w;
        synchronized (replyWaiter) {
            block10: while (true) {
                try {
                    long toWait = Math.min(15000L, untilTime + 100L - this._context.clock().now());
                    if (toWait <= 0L) {
                        return false;
                    }
                    w.wait(toWait);
                }
                catch (InterruptedException toWait) {
                    // empty catch block
                }
                switch (w.getState()) {
                    case SUCCESS: {
                        return true;
                    }
                    case TIMEOUT: 
                    case FAIL: {
                        return false;
                    }
                    case INIT: {
                        if (this._log.shouldInfo()) {
                            this._log.info("Timeout: " + String.valueOf(w));
                        }
                        if ((toWait = untilTime - this._context.clock().now()) <= 1000L) {
                            return false;
                        }
                        boolean ok = this.resend(w, Math.min(toWait, w.getSentTo().getTimeout()));
                        if (ok) continue block10;
                        return false;
                    }
                }
            }
        }
    }

    private boolean resend(ReplyWaiter w, long toWait) {
        boolean repliable = w.getExpectedAction() == 0;
        Tracker tr = w.getSentTo();
        int port = tr.getPort();
        if (this._log.shouldInfo()) {
            this._log.info("Resending: " + String.valueOf(w) + " timeout: " + toWait);
        }
        boolean rv = this.sendMessage(tr.getDest(true), port, w.getPayload(), repliable);
        return rv;
    }

    private boolean sendMessage(Destination dest, int toPort, byte[] payload, boolean repliable) {
        if (!this._isRunning) {
            if (this._log.shouldInfo()) {
                this._log.info("send failed, not running");
            }
            return false;
        }
        if (dest == null) {
            if (this._log.shouldInfo()) {
                this._log.info("send failed, no dest");
            }
            return false;
        }
        Hash to = dest.calculateHash();
        if (to.equals(this._myHash)) {
            throw new IllegalArgumentException("don't send to ourselves");
        }
        if (repliable) {
            try {
                payload = Datagram2.make(this._context, this._session, payload, to);
            }
            catch (DataFormatException dfe) {
                if (this._log.shouldWarn()) {
                    this._log.warn("DG2 fail", dfe);
                }
                return false;
            }
        }
        try {
            payload = Datagram3.make(this._context, this._session, payload);
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldWarn()) {
                this._log.warn("DG3 fail", dfe);
            }
            return false;
        }
        SendMessageOptions opts = new SendMessageOptions();
        opts.setDate(this._context.clock().now() + 60000L);
        if (!repliable) {
            opts.setSendLeaseSet(false);
        }
        try {
            boolean success = this._session.sendMessage(dest, payload, 0, payload.length, repliable ? 19 : 20, this._rPort, toPort, opts);
            if (!success && this._log.shouldWarn()) {
                this._log.warn("sendMessage fail");
            }
            return success;
        }
        catch (I2PSessionException ise) {
            if (this._log.shouldWarn()) {
                this._log.warn("sendMessage fail", ise);
            }
            return false;
        }
    }

    private void receiveMessage(Destination from, int fromPort, byte[] payload) {
        if (payload.length < 8) {
            if (this._log.shouldInfo()) {
                this._log.info("Got short message: " + payload.length + " bytes");
            }
            return;
        }
        int action = (int)DataHelper.fromLong(payload, 0, 4);
        int tid = (int)DataHelper.fromLong(payload, 4, 4);
        ReplyWaiter waiter = this._sentQueries.remove(tid);
        if (waiter == null) {
            if (this._log.shouldInfo()) {
                this._log.info("Rcvd msg with no one waiting: " + tid);
            }
            return;
        }
        int expect = waiter.getExpectedAction();
        if (expect != action && action != 3) {
            if (this._log.shouldInfo()) {
                this._log.info("Got action " + action + " but wanted " + expect + " for: " + String.valueOf(waiter));
            }
            waiter.gotReply(false);
            return;
        }
        switch (action) {
            case 0: {
                this.receiveConnection(waiter, payload, fromPort);
                break;
            }
            case 1: {
                this.receiveAnnounce(waiter, payload);
                break;
            }
            case 3: {
                this.receiveError(waiter, payload, expect);
                break;
            }
            default: {
                if (this._log.shouldInfo()) {
                    this._log.info("Rcvd msg with unknown action: " + action + " for: " + String.valueOf(waiter));
                }
                waiter.gotReply(false);
                Tracker tr = waiter.getSentTo();
                tr.gotError();
            }
        }
    }

    private void receiveConnection(ReplyWaiter waiter, byte[] payload, int fromPort) {
        Tracker tr = waiter.getSentTo();
        if (payload.length >= 16) {
            long cid = DataHelper.fromLong8(payload, 8);
            long lifetime = payload.length >= 18 ? DataHelper.fromLong(payload, 16, 2) * 1000L : 60000L;
            if (this._log.shouldInfo()) {
                this._log.info("Rcvd connect response, id = " + cid + " lifetime = " + lifetime / 1000L + " from " + String.valueOf(tr));
            }
            tr.setConnection(cid, fromPort, lifetime);
            waiter.gotReply(true);
        } else {
            waiter.gotReply(false);
            tr.gotError();
        }
    }

    private void receiveAnnounce(ReplyWaiter waiter, byte[] payload) {
        Tracker tr = waiter.getSentTo();
        if (payload.length >= 20) {
            Set<Hash> hashes;
            int interval = Math.min(28800, Math.max(900, (int)DataHelper.fromLong(payload, 8, 4)));
            int leeches = (int)DataHelper.fromLong(payload, 12, 4);
            int seeds = (int)DataHelper.fromLong(payload, 16, 4);
            int peers = (payload.length - 20) / 32;
            if (this._log.shouldInfo()) {
                this._log.info("Rcvd " + peers + " peers from " + String.valueOf(tr));
            }
            if (peers > 0) {
                hashes = new HashSet(peers);
                for (int off = 20; off <= payload.length - 32; off += 32) {
                    hashes.add(Hash.create(payload, off));
                }
            } else {
                hashes = Collections.emptySet();
            }
            TrackerResponse resp = new TrackerResponse(interval, seeds, leeches, hashes);
            waiter.gotResponse(resp);
            tr.setInterval(interval);
        } else {
            waiter.gotReply(false);
            tr.gotError();
        }
    }

    private void receiveError(ReplyWaiter waiter, byte[] payload, int expected) {
        String msg = payload.length > 8 ? DataHelper.getUTF8(payload, 8, payload.length - 8) : "";
        TrackerResponse resp = new TrackerResponse(msg);
        waiter.gotResponse(resp);
        Tracker tr = waiter.getSentTo();
        tr.gotError();
        if (waiter.getExpectedAction() == 1) {
            // empty if block
        }
    }

    @Override
    public void messageAvailable(I2PSession session, int msgId, long size, int proto, int fromPort, int toPort) {
        block6: {
            try {
                byte[] payload = session.receiveMessage(msgId);
                if (payload == null) {
                    return;
                }
                if (toPort == this._rPort) {
                    this.receiveMessage(null, fromPort, payload);
                } else if (this._log.shouldWarn()) {
                    this._log.warn("msg on bad port");
                }
            }
            catch (I2PSessionException e) {
                if (!this._log.shouldWarn()) break block6;
                this._log.warn("bad msg");
            }
        }
    }

    @Override
    public void messageAvailable(I2PSession session, int msgId, long size) {
    }

    @Override
    public void reportAbuse(I2PSession session, int severity) {
    }

    @Override
    public void disconnected(I2PSession session) {
        if (this._log.shouldWarn()) {
            this._log.warn("UDPTC disconnected");
        }
    }

    @Override
    public void errorOccurred(I2PSession session, String message, Throwable error) {
        if (this._log.shouldWarn()) {
            this._log.warn("UDPTC got error msg: ", error);
        }
    }

    private class ReplyWaiter
    extends SimpleTimer2.TimedEvent {
        private final int tid;
        private final Tracker sentTo;
        private final int action;
        private final byte[] data;
        private TrackerResponse replyObject;
        private WaitState state;

        public ReplyWaiter(int tid, Tracker tracker, int action, byte[] payload, long toWait) {
            super(SimpleTimer2.getInstance(), toWait);
            this.state = WaitState.INIT;
            this.tid = tid;
            this.sentTo = tracker;
            this.action = action;
            this.data = payload;
        }

        public int getID() {
            return this.tid;
        }

        public Tracker getSentTo() {
            return this.sentTo;
        }

        public int getExpectedAction() {
            return this.action;
        }

        public byte[] getPayload() {
            return this.data;
        }

        public synchronized TrackerResponse getReplyObject() {
            return this.replyObject;
        }

        public synchronized WaitState getState() {
            return this.state;
        }

        public synchronized void gotReply(boolean success) {
            this.cancel();
            UDPTrackerClient.this._sentQueries.remove(this.tid);
            this.setState(success ? WaitState.SUCCESS : WaitState.FAIL);
        }

        private synchronized void setState(WaitState state) {
            this.state = state;
            this.notifyAll();
        }

        public synchronized void gotResponse(TrackerResponse resp) {
            this.replyObject = resp;
            this.gotReply(resp.error == null);
        }

        @Override
        public synchronized void schedule(long toWait) {
            this.state = WaitState.INIT;
            super.schedule(toWait);
        }

        @Override
        public synchronized void timeReached() {
            if (this.state != WaitState.INIT) {
                return;
            }
            if (this.action == 0) {
                this.sentTo.connFailed();
            } else {
                this.sentTo.replyTimeout();
            }
            this.setState(WaitState.TIMEOUT);
            if (UDPTrackerClient.this._log.shouldWarn()) {
                UDPTrackerClient.this._log.warn("timeout waiting for reply from " + String.valueOf(this.sentTo));
            }
        }

        @Override
        public String toString() {
            return "Message type: " + this.action + " ID: " + this.tid + " to: " + String.valueOf(this.sentTo) + " state: " + String.valueOf((Object)this.state);
        }
    }

    private class Tracker
    extends HostPort {
        private final Object destLock;
        private Destination dest;
        private Long cid;
        private long expires;
        private long lastHeardFrom;
        private long lastFailed;
        private int consecFails;
        private int responsePort;
        private int interval;
        private ConnState state;
        private static final long DELAY = 15000L;

        public Tracker(String host, int port) {
            super(host, port);
            this.destLock = new Object();
            this.interval = 3600;
            this.state = ConnState.INVALID;
            this.responsePort = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Destination getDest(boolean fast) {
            Object object = this.destLock;
            synchronized (object) {
                if (this.dest == null && !fast) {
                    this.dest = UDPTrackerClient.this._util.getDestination(this.host);
                }
                return this.dest;
            }
        }

        public synchronized void setConnInProgress(boolean yes) {
            if (yes) {
                this.state = ConnState.IN_PROGRESS;
            } else if (this.state == ConnState.IN_PROGRESS) {
                this.state = ConnState.INVALID;
            }
        }

        public synchronized boolean isConnInProgress() {
            return this.state == ConnState.IN_PROGRESS;
        }

        public synchronized boolean isConnValid() {
            return this.state == ConnState.VALID && this.expires > UDPTrackerClient.this._context.clock().now();
        }

        public synchronized void connFailed() {
            this.replyTimeout();
            this.expires = 0L;
            this.state = ConnState.INVALID;
        }

        public synchronized void replyTimeout() {
            ++this.consecFails;
            this.lastFailed = UDPTrackerClient.this._context.clock().now();
        }

        public synchronized void setConnection(long cid, int rport, long lifetime) {
            long now;
            this.cid = cid;
            this.responsePort = rport;
            this.lastHeardFrom = now = UDPTrackerClient.this._context.clock().now();
            this.expires = now + lifetime;
            this.consecFails = 0;
            this.state = ConnState.VALID;
        }

        public synchronized Long getConnection() {
            if (this.isConnValid()) {
                return this.cid;
            }
            return null;
        }

        public synchronized int getInterval() {
            return this.interval;
        }

        public synchronized void setInterval(int interval) {
            long now;
            this.lastHeardFrom = now = UDPTrackerClient.this._context.clock().now();
            this.consecFails = 0;
            this.interval = interval;
            this.notifyAll();
        }

        public synchronized void gotError() {
            long now;
            this.lastHeardFrom = now = UDPTrackerClient.this._context.clock().now();
            ++this.consecFails;
            this.state = ConnState.INVALID;
            this.cid = null;
            this.notifyAll();
        }

        public synchronized long getTimeout() {
            return 15000L << Math.min(this.consecFails, 3);
        }

        @Override
        public String toString() {
            return "UDP Tracker " + this.host + ":" + this.port + " hasDest? " + (this.dest != null) + " valid? " + this.isConnValid() + " conn ID: " + String.valueOf(this.cid != null ? this.cid : "none") + " " + String.valueOf((Object)this.state);
        }
    }

    public static class TrackerResponse {
        private final int interval;
        private final int complete;
        private final int incomplete;
        private final String error;
        private final Set<Hash> peers;

        public TrackerResponse(int interval, int seeds, int leeches, Set<Hash> peers) {
            this.interval = interval;
            this.complete = seeds;
            this.incomplete = leeches;
            this.peers = peers;
            this.error = null;
        }

        public TrackerResponse(String errorMsg) {
            this.interval = 3600;
            this.complete = 0;
            this.incomplete = 0;
            this.peers = null;
            this.error = errorMsg;
        }

        public Set<Hash> getPeers() {
            return this.peers;
        }

        public int getPeerCount() {
            int pc = this.peers == null ? 0 : this.peers.size();
            return Math.max(pc, this.complete + this.incomplete - 1);
        }

        public int getSeedCount() {
            return this.complete;
        }

        public int getLeechCount() {
            return this.incomplete;
        }

        public String getFailureReason() {
            return this.error;
        }

        public int getInterval() {
            return this.interval;
        }
    }

    private static enum WaitState {
        INIT,
        SUCCESS,
        TIMEOUT,
        FAIL;

    }

    private static enum ConnState {
        INVALID,
        IN_PROGRESS,
        VALID;

    }

    private static class HostPort {
        protected final String host;
        protected final int port;

        public HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public int hashCode() {
            return this.host.hashCode() ^ this.port;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof HostPort)) {
                return false;
            }
            HostPort dp = (HostPort)o;
            return this.port == dp.port && this.host.equals(dp.host);
        }

        public String toString() {
            return "UDP Tracker " + this.host + ":" + this.port;
        }
    }
}

