/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA1;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SecureFile;
import org.klomp.snark.BandwidthListener;
import org.klomp.snark.BitField;
import org.klomp.snark.Piece;
import org.klomp.snark.Request;

class PartialPiece
implements Comparable<PartialPiece> {
    private final Piece piece;
    private final byte[] bs;
    private int off;
    private File tempfile;
    private RandomAccessFile raf;
    private final int pclen;
    private final File tempDir;
    private final BitField bitfield;
    private static final int BUFSIZE = 16384;
    private static final ByteCache _cache = ByteCache.getInstance(16, 16384);
    private static final int MAX_IN_MEM = 131072;
    private static int _max_in_mem = 131072;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartialPiece(Piece piece, int len, File tempDir) {
        block7: {
            this.piece = piece;
            this.pclen = len;
            this.tempDir = tempDir;
            this.bitfield = new BitField((len + 16384 - 1) / 16384);
            byte[] tbs = null;
            try {
                if (len > 131072) break block7;
                try {
                    tbs = new byte[len];
                    return;
                }
                catch (OutOfMemoryError oom) {
                    if (_max_in_mem > 16384) {
                        _max_in_mem /= 2;
                    }
                    Log log = I2PAppContext.getGlobalContext().logManager().getLog(PartialPiece.class);
                    log.logAlways(30, "OOM creating new partial piece");
                }
            }
            finally {
                this.bs = tbs;
            }
        }
    }

    private void createTemp() throws IOException {
        this.tempfile = SecureFile.createTempFile("piece_" + this.piece.getId() + "_", null, this.tempDir);
        this.raf = new RandomAccessFile(this.tempfile, "rw");
    }

    public synchronized Request getRequest() {
        int chunk = this.off / 16384;
        int sz = this.bitfield.size();
        for (int i = chunk; i < sz; ++i) {
            if (!this.bitfield.get(i)) {
                return new Request(this, this.off, Math.min(this.pclen - this.off, 16384));
            }
            if (i == sz - 1) {
                this.off = this.pclen;
                continue;
            }
            this.off += 16384;
        }
        return null;
    }

    public int getPiece() {
        return this.piece.getId();
    }

    public int getLength() {
        return this.pclen;
    }

    public synchronized boolean isComplete() {
        return this.bitfield.complete();
    }

    public synchronized boolean hasData() {
        return this.bitfield.count() > 0;
    }

    public synchronized boolean hasChunk(int chunk) {
        return this.bitfield.get(chunk);
    }

    public synchronized int getDownloaded() {
        if (this.bitfield.complete()) {
            return this.pclen;
        }
        int sz = this.bitfield.count();
        int rv = sz * 16384;
        int rem = this.pclen % 16384;
        if (rem != 0 && this.bitfield.get(sz - 1)) {
            rv -= 16384 - rem;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHash() throws IOException {
        MessageDigest sha1 = SHA1.getInstance();
        if (this.bs != null) {
            sha1.update(this.bs);
        } else {
            byte[] buf;
            ByteArray ba;
            int read = 0;
            int buflen = Math.min(this.pclen, 16384);
            if (buflen == 16384) {
                ba = (ByteArray)_cache.acquire();
                buf = ba.getData();
            } else {
                ba = null;
                buf = new byte[buflen];
            }
            PartialPiece partialPiece = this;
            synchronized (partialPiece) {
                int rd;
                if (this.raf == null) {
                    throw new IOException();
                }
                this.raf.seek(0L);
                while (read < this.pclen && (rd = this.raf.read(buf, 0, Math.min(buf.length, this.pclen - read))) >= 0) {
                    read += rd;
                    sha1.update(buf, 0, rd);
                }
            }
            if (ba != null) {
                _cache.release(ba, false);
            }
            if (read < this.pclen) {
                throw new IOException();
            }
        }
        return sha1.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DataInputStream din, int offset, int len, BandwidthListener bwl) throws IOException {
        int numRead;
        byte[] tmp;
        ByteArray ba;
        if (offset % 16384 != 0) {
            throw new IOException("Bad offset " + offset);
        }
        int chunk = offset / 16384;
        if (this.bs != null) {
            int numRead22;
            int offs = offset;
            for (int toRead = len; toRead > 0; toRead -= numRead22) {
                numRead22 = din.read(this.bs, offs, toRead);
                if (numRead22 < 0) {
                    throw new EOFException();
                }
                offs += numRead22;
                bwl.downloaded(numRead22);
            }
            PartialPiece numRead22 = this;
            synchronized (numRead22) {
                if (this.bitfield.get(chunk)) {
                    PartialPiece.warn("Already have chunk " + chunk + " on " + String.valueOf(this));
                } else {
                    this.bitfield.set(chunk);
                    if (this.off == offset) {
                        this.off += len;
                        int sz = this.bitfield.size();
                        for (int i = chunk + 1; i < sz && this.bitfield.get(i); ++i) {
                            PartialPiece.warn("Hole filled in before chunk " + i + " on " + String.valueOf(this) + " " + String.valueOf(this.bitfield));
                            if (i == sz - 1) {
                                this.off = this.pclen;
                                continue;
                            }
                            this.off += 16384;
                        }
                    } else {
                        PartialPiece.warn("Out of order chunk " + chunk + " on " + String.valueOf(this) + " " + String.valueOf(this.bitfield));
                    }
                }
            }
        }
        if (len == 16384) {
            ba = (ByteArray)_cache.acquire();
            tmp = ba.getData();
        } else {
            ba = null;
            tmp = new byte[len];
        }
        int offs = 0;
        for (int toRead = len; toRead > 0; toRead -= numRead) {
            numRead = din.read(tmp, offs, toRead);
            if (numRead < 0) {
                throw new EOFException();
            }
            offs += numRead;
            bwl.downloaded(numRead);
        }
        PartialPiece partialPiece = this;
        synchronized (partialPiece) {
            if (this.bitfield.get(chunk)) {
                PartialPiece.warn("Already have chunk " + chunk + " on " + String.valueOf(this));
            } else {
                if (this.raf == null) {
                    this.createTemp();
                }
                this.raf.seek(offset);
                this.raf.write(tmp);
                this.bitfield.set(chunk);
                if (this.off == offset) {
                    this.off += len;
                    int sz = this.bitfield.size();
                    for (int i = chunk + 1; i < sz && this.bitfield.get(i); ++i) {
                        PartialPiece.warn("Hole filled in before chunk " + i + " on " + String.valueOf(this) + " " + String.valueOf(this.bitfield));
                        if (i == sz - 1) {
                            this.off = this.pclen;
                            continue;
                        }
                        this.off += 16384;
                    }
                } else {
                    PartialPiece.warn("Out of order chunk " + chunk + " on " + String.valueOf(this) + " " + String.valueOf(this.bitfield));
                }
            }
        }
        if (ba != null) {
            _cache.release(ba, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutput out, int offset, int len) throws IOException {
        if (this.bs != null) {
            out.write(this.bs, offset, len);
        } else {
            byte[] buf;
            ByteArray ba;
            int read = 0;
            int buflen = Math.min(len, 16384);
            if (buflen == 16384) {
                ba = (ByteArray)_cache.acquire();
                buf = ba.getData();
            } else {
                ba = null;
                buf = new byte[buflen];
            }
            PartialPiece partialPiece = this;
            synchronized (partialPiece) {
                if (this.raf == null) {
                    throw new IOException();
                }
                this.raf.seek(offset);
                while (read < len) {
                    int rd = Math.min(buf.length, len - read);
                    this.raf.readFully(buf, 0, rd);
                    read += rd;
                    out.write(buf, 0, rd);
                }
            }
            if (ba != null) {
                _cache.release(ba, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.bs == null) {
            PartialPiece partialPiece = this;
            synchronized (partialPiece) {
                if (this.raf != null) {
                    this.locked_release();
                    this.raf = null;
                }
            }
        }
    }

    private void locked_release() {
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tempfile.delete();
    }

    @Override
    public int compareTo(PartialPiece opp) {
        int d = this.piece.compareTo(opp.piece);
        if (d != 0) {
            return d;
        }
        return opp.getDownloaded() - this.getDownloaded();
    }

    public int hashCode() {
        return this.piece.getId() * 7777;
    }

    public boolean equals(Object o) {
        if (o instanceof PartialPiece) {
            PartialPiece pp = (PartialPiece)o;
            return pp.piece.getId() == this.piece.getId();
        }
        return false;
    }

    public String toString() {
        return "Partial(" + this.piece.getId() + "," + this.off + "," + this.getDownloaded() + "," + this.pclen + ")";
    }

    public static void warn(String s) {
        I2PAppContext.getGlobalContext().logManager().getLog(PartialPiece.class).warn(s);
    }
}

