/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.http;

import java.net.URL;

public class HTTP {
    public static final String HOST = "Host";
    public static final String VERSION = "1.1";
    public static final String VERSION_10 = "1.0";
    public static final String VERSION_11 = "1.1";
    public static final String CRLF = "\r\n";
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final String TAB = "\t";
    public static final String SOAP_ACTION = "SOAPAction";
    public static final String M_SEARCH = "M-SEARCH";
    public static final String NOTIFY = "NOTIFY";
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String SUBSCRIBE = "SUBSCRIBE";
    public static final String UNSUBSCRIBE = "UNSUBSCRIBE";
    public static final String DATE = "Date";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String NO_CACHE = "no-cache";
    public static final String MAX_AGE = "max-age";
    public static final String CONNECTION = "Connection";
    public static final String CLOSE = "close";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHARSET = "charset";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String CONTENT_RANGE_BYTES = "bytes";
    public static final String RANGE = "Range";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CHUNKED = "Chunked";
    public static final String LOCATION = "Location";
    public static final String SERVER = "Server";
    public static final String ST = "ST";
    public static final String MX = "MX";
    public static final String MAN = "MAN";
    public static final String NT = "NT";
    public static final String NTS = "NTS";
    public static final String USN = "USN";
    public static final String EXT = "EXT";
    public static final String SID = "SID";
    public static final String SEQ = "SEQ";
    public static final String CALLBACK = "CALLBACK";
    public static final String TIMEOUT = "TIMEOUT";
    public static final String BOOTID_UPNP_ORG = "BOOTID.UPNP.ORG";
    public static final String MYNAME = "MYNAME";
    public static final String REQEST_LINE_DELIM = " ";
    public static final String HEADER_LINE_DELIM = " :";
    public static final String STATUS_LINE_DELIM = " ";
    public static final int DEFAULT_PORT = 80;
    public static final int DEFAULT_CHUNK_SIZE = 524288;
    public static final int DEFAULT_TIMEOUT = 30;
    private static int chunkSize = 524288;

    public static final boolean isAbsoluteURL(String urlStr) {
        try {
            new URL(urlStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final String getHost(String urlStr) {
        try {
            URL url = new URL(urlStr);
            return url.getHost();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static final int getPort(String urlStr) {
        try {
            URL url = new URL(urlStr);
            int port = url.getPort();
            if (port <= 0) {
                port = 80;
            }
            return port;
        }
        catch (Exception e) {
            return 80;
        }
    }

    public static final String getRequestHostURL(String host, int port) {
        String reqHost = "http://" + host + ":" + port;
        return reqHost;
    }

    public static final String toRelativeURL(String urlStr, boolean withParam) {
        Object uri = urlStr;
        if (!HTTP.isAbsoluteURL(urlStr)) {
            if (0 < urlStr.length() && urlStr.charAt(0) != '/') {
                uri = "/" + urlStr;
            }
        } else {
            try {
                String queryStr;
                URL url = new URL(urlStr);
                uri = url.getPath();
                if (withParam && !(queryStr = url.getQuery()).equals("")) {
                    uri = (String)uri + "?" + queryStr;
                }
                if (((String)uri).endsWith("/")) {
                    uri = ((String)uri).substring(0, ((String)uri).length() - 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uri;
    }

    public static final String toRelativeURL(String urlStr) {
        return HTTP.toRelativeURL(urlStr, true);
    }

    public static final String getAbsoluteURL(String baseURLStr, String relURlStr) {
        try {
            URL baseURL = new URL(baseURLStr);
            String url = baseURL.getProtocol() + "://" + baseURL.getHost() + ":" + baseURL.getPort() + HTTP.toRelativeURL(relURlStr);
            return url;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static final void setChunkSize(int size) {
        chunkSize = size;
    }

    public static final int getChunkSize() {
        return chunkSize;
    }
}

