/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.Payload;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.ClientMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.message.GarlicMessageReceiver;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

class InboundMessageDistributor
implements GarlicMessageReceiver.CloveReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final Hash _client;
    private final GarlicMessageReceiver _receiver;
    private final String _clientNickname;
    private final long _msgIDBloomXor;

    public InboundMessageDistributor(RouterContext ctx, Hash client) {
        this._context = ctx;
        this._client = client;
        this._log = ctx.logManager().getLog(InboundMessageDistributor.class);
        this._receiver = new GarlicMessageReceiver(ctx, this, client);
        if (this._client != null) {
            String nickname;
            TunnelPoolSettings clienttps = this._context.tunnelManager().getInboundSettings(this._client);
            String string = nickname = clienttps != null ? clienttps.getDestinationNickname() : "UNKNOWN";
            if (this._log.shouldLog(10)) {
                this._log.debug("Initializing client (nickname: " + nickname + " b32: " + this._client.toBase32() + ") InboundMessageDistributor with tunnel pool settings: " + String.valueOf(clienttps));
            }
            this._clientNickname = nickname;
            this._msgIDBloomXor = clienttps.getMsgIdBloomXor();
        } else {
            this._clientNickname = "NULL/Expl";
            this._msgIDBloomXor = RandomSource.getInstance().nextLong(0xFFFFFFFFL);
            if (this._log.shouldLog(10)) {
                this._log.debug("Initializing null or exploratory InboundMessageDistributor");
            }
        }
    }

    public void distribute(I2NPMessage msg, Hash target) {
        this.distribute(msg, target, null);
    }

    public void distribute(I2NPMessage msg, Hash target, TunnelId tunnel) {
        int type;
        block31: {
            DatabaseEntry dbe;
            DatabaseStoreMessage dsm;
            block30: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("IBMD for " + this._clientNickname + " (" + (this._client != null ? this._client.toBase32() : "null") + ") to " + String.valueOf(target) + " / " + String.valueOf(tunnel) + " : " + String.valueOf(msg));
                }
                type = msg.getType();
                if (this._client == null) break block30;
                switch (type) {
                    case 3: {
                        break block31;
                    }
                    case 1: {
                        dsm = (DatabaseStoreMessage)msg;
                        dbe = dsm.getEntry();
                        if (dbe.getType() == 0) {
                            if (this._log.shouldLog(30)) {
                                this._log.warn("Inbound DSM received down a tunnel for " + this._clientNickname + " (" + this._client.toBase32() + "): " + String.valueOf(msg));
                            }
                            Hash key = dsm.getKey();
                            if (this._context.routerHash().equals(key)) {
                                return;
                            }
                            RouterInfo ri = (RouterInfo)dbe;
                            if (!key.equals(ri.getIdentity().getHash())) {
                                return;
                            }
                            if (!ri.isValid()) {
                                return;
                            }
                            RouterInfo oldri = this._context.netDb().lookupRouterInfoLocally(key);
                            if (oldri != null && oldri.getPublished() < ri.getPublished() && !FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Updating caps for RI " + String.valueOf(key) + " from \"" + oldri.getCapabilities() + "\" to \"" + ri.getCapabilities() + "\"");
                                }
                                this._context.peerManager().setCapabilities(key, ri.getCapabilities());
                            }
                            return;
                        }
                        if (dsm.getReplyToken() != 0L) {
                            this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, type);
                            this._log.error("Dropping LS DSM w/ reply token down a tunnel for " + this._client.toBase32() + ": " + String.valueOf(msg));
                            return;
                        }
                        dbe.setReceivedBy(this._client);
                        break block31;
                    }
                    case 10: 
                    case 11: 
                    case 22: 
                    case 24: 
                    case 26: {
                        break block31;
                    }
                    default: {
                        this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, type);
                        this._log.error("Dropped dangerous message down a tunnel for " + this._client.toBase32() + ": " + String.valueOf(msg), new Exception("cause"));
                        return;
                    }
                }
            }
            switch (type) {
                case 1: {
                    dsm = (DatabaseStoreMessage)msg;
                    if (dsm.getReplyToken() != 0L) {
                        this._context.statManager().addRateData("tunnel.dropDangerousExplTunnelMessage", 1L, type);
                        this._log.error("Dropping DSM w/ reply token down a expl. tunnel: " + String.valueOf(msg));
                        return;
                    }
                    dbe = dsm.getEntry();
                    if (!dbe.isLeaseSet()) break;
                    dbe.setReceivedBy(this._client);
                    break;
                }
                case 3: 
                case 10: 
                case 11: 
                case 22: 
                case 24: 
                case 26: {
                    break;
                }
                default: {
                    this._context.statManager().addRateData("tunnel.dropDangerousExplTunnelMessage", 1L, type);
                    this._log.error("Dropped dangerous message down expl tunnel: " + String.valueOf(msg), new Exception("cause"));
                    return;
                }
            }
        }
        if (target == null || tunnel == null && this._context.routerHash().equals(target)) {
            if (type == 11) {
                this._context.inNetMessagePool().handleReplies(msg);
                this._receiver.receive((GarlicMessage)msg);
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("distributing inbound tunnel message into our inNetMessagePool: " + String.valueOf(msg));
                }
                this._context.inNetMessagePool().add(msg, null, null);
            }
        } else {
            TunnelId outId;
            TunnelInfo out = this._context.tunnelManager().selectOutboundTunnel(this._client, target);
            if (out == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("no outbound tunnel to send the client message for " + String.valueOf(this._client) + ": " + String.valueOf(msg));
                }
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("distributing IB tunnel msg type " + type + " back out " + String.valueOf(out) + " targetting " + String.valueOf(target));
            }
            if ((outId = out.getSendTunnelId(0)) == null) {
                if (this._log.shouldLog(40)) {
                    this._log.error("strange? outbound tunnel has no outboundId? " + String.valueOf(out) + " failing to distribute " + String.valueOf(msg));
                }
                return;
            }
            long exp = this._context.clock().now() + 20000L;
            if (msg.getMessageExpiration() < exp) {
                msg.setMessageExpiration(exp);
            }
            this._context.tunnelDispatcher().dispatchOutbound(msg, outId, tunnel, target);
        }
    }

    @Override
    public void handleClove(DeliveryInstructions instructions, I2NPMessage data) {
        int type = data.getType();
        switch (instructions.getDeliveryMode()) {
            case 0: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("local delivery instructions for clove: " + data.getClass().getSimpleName());
                }
                switch (type) {
                    case 11: {
                        this._receiver.receive((GarlicMessage)data);
                        break;
                    }
                    case 1: {
                        DatabaseStoreMessage dsm = (DatabaseStoreMessage)data;
                        dsm.setReplyToken(0L);
                        dsm.setReplyTunnel(null);
                        dsm.setReplyGateway(null);
                        DatabaseEntry dbe = dsm.getEntry();
                        if (dbe.isLeaseSet()) {
                            dbe.setReceivedBy(this._client);
                            if (this._log.shouldLog(20)) {
                                this._log.info("Storing garlic LS down tunnel for: " + String.valueOf(dsm.getKey()) + " sent to: " + this._clientNickname + " (" + (this._client != null ? this._client.toBase32() : ") router"));
                            }
                            this._context.inNetMessagePool().add(dsm, null, null, this._msgIDBloomXor);
                            break;
                        }
                        if (this._client != null) {
                            this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, 1L);
                            this._log.error("Dropped dangerous message down a tunnel for " + this._clientNickname + " (" + this._client.toBase32() + ") : " + String.valueOf(dsm), new Exception("cause"));
                            return;
                        }
                        if (this._log.shouldLog(20)) {
                            this._log.info("Storing garlic RI down tunnel (" + this._clientNickname + ") for: " + String.valueOf(dsm.getKey()));
                        }
                        this._context.inNetMessagePool().add(dsm, null, null, this._msgIDBloomXor);
                        break;
                    }
                    case 3: {
                        DatabaseSearchReplyMessage orig = (DatabaseSearchReplyMessage)data;
                        this._context.inNetMessagePool().add(orig, null, null, this._msgIDBloomXor);
                        break;
                    }
                    case 20: {
                        this._context.statManager().addRateData("tunnel.handleLoadClove", 1L);
                        data = null;
                        break;
                    }
                    case 10: 
                    case 26: {
                        this._context.inNetMessagePool().add(data, null, null, this._msgIDBloomXor);
                        break;
                    }
                    default: {
                        if (this._client != null) {
                            this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, data.getType());
                            this._log.error("Dropped dangerous message received down a tunnel for " + this._clientNickname + " (" + this._client.toBase32() + ") : " + String.valueOf(data), new Exception("cause"));
                            break;
                        }
                        this._log.error("Dropped dangerous message received down an expl. tunnel " + String.valueOf(data), new Exception("cause"));
                    }
                }
                return;
            }
            case 1: {
                Hash to = instructions.getDestination();
                if (type != 20) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("cant send a " + data.getClass().getSimpleName() + " to a destination");
                    }
                } else if (this._client != null && this._client.equals(to)) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("data message came down a tunnel for " + this._client.toBase32());
                    }
                    DataMessage dm = (DataMessage)data;
                    Payload payload = new Payload();
                    payload.setEncryptedData(dm.getData());
                    ClientMessage m = new ClientMessage(this._client, payload);
                    this._context.clientManager().messageReceived(m);
                } else if (this._client != null) {
                    TunnelPoolSettings tgt = this._context.tunnelManager().getInboundSettings(to);
                    if (tgt != null && this._client.equals(tgt.getAliasOf())) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("data message came down a tunnel for " + this._client.toBase32() + " targeting shared " + to.toBase32());
                        }
                        DataMessage dm = (DataMessage)data;
                        Payload payload = new Payload();
                        payload.setEncryptedData(dm.getData());
                        ClientMessage m = new ClientMessage(to, payload);
                        this._context.clientManager().messageReceived(m);
                    } else if (this._log.shouldLog(40)) {
                        this._log.error("Data message came down a tunnel for " + this._client.toBase32() + " but targetted " + to.toBase32());
                    }
                } else if (this._log.shouldLog(40)) {
                    this._log.error("Data message came down an exploratory tunnel targeting " + String.valueOf(to));
                }
                return;
            }
            case 2: 
            case 3: {
                if (this._log.shouldLog(20)) {
                    this._log.info("Recursively handling message from targeted clove (for client:" + this._clientNickname + " " + (this._client != null ? this._client.toBase32() : "null") + ", msg type: " + data.getClass().getSimpleName() + "): " + String.valueOf(instructions.getRouter()) + ":" + String.valueOf(instructions.getTunnelId()) + " msg: " + String.valueOf(data));
                }
                this.distribute(data, instructions.getRouter(), instructions.getTunnelId());
                return;
            }
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Unknown instruction " + instructions.getDeliveryMode() + ": " + String.valueOf(instructions));
        }
    }
}

