/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.crypto.AESEngine;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.tunnel.HashSetIVValidator;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.IVValidator;
import net.i2p.util.Log;

class HopProcessor {
    protected final I2PAppContext _context;
    private final Log _log;
    protected final HopConfig _config;
    private final IVValidator _validator;
    static final int IV_LENGTH = 16;

    @Deprecated
    HopProcessor(I2PAppContext ctx, HopConfig config) {
        this(ctx, config, HopProcessor.createValidator());
    }

    public HopProcessor(I2PAppContext ctx, HopConfig config, IVValidator validator) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(HopProcessor.class);
        this._config = config;
        this._validator = validator;
    }

    @Deprecated
    private static IVValidator createValidator() {
        return new HashSetIVValidator();
    }

    public boolean process(byte[] orig, int offset, int length, Hash prev) {
        boolean okIV;
        if (prev != null) {
            if (this._config.getReceiveFrom() == null) {
                this._config.setReceiveFrom(prev);
            } else if (!this._config.getReceiveFrom().equals(prev)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Attempted mid-tunnel injection from " + String.valueOf(prev) + ", expected " + String.valueOf(this._config.getReceiveFrom()));
                }
                return false;
            }
        }
        if (!(okIV = this._validator.receiveIV(orig, offset, orig, offset + 16))) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid IV, dropping at hop " + String.valueOf(this._config));
            }
            return false;
        }
        SessionKey ivkey = this._config.getIVKey();
        AESEngine aes = this._context.aes();
        aes.encryptBlock(orig, offset, ivkey, orig, offset);
        aes.encrypt(orig, offset + 16, orig, offset + 16, this._config.getLayerKey(), orig, offset, length - 16);
        aes.encryptBlock(orig, offset, ivkey, orig, offset);
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + String.valueOf(this._config);
    }
}

