/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

abstract class EstablishBase
implements EstablishState {
    public static final VerifiedEstablishState VERIFIED = new VerifiedEstablishState();
    public static final FailedEstablishState FAILED = new FailedEstablishState();
    protected final RouterContext _context;
    protected final Log _log;
    protected final byte[] _X;
    protected final byte[] _Y;
    protected transient long _peerSkew;
    protected byte[] _prevEncrypted;
    protected int _received;
    protected final NTCPTransport _transport;
    protected final NTCPConnection _con;
    protected static final int MIN_RI_SIZE = 387;
    protected static final int MAX_RI_SIZE = 3072;
    protected static final int AES_SIZE = 16;
    protected static final int XY_SIZE = 256;
    protected final Object _stateLock = new Object();
    protected volatile State _state;
    private final AtomicBoolean _isCorrupt = new AtomicBoolean();
    private final AtomicBoolean _isComplete = new AtomicBoolean();
    protected static final Set<State> STATES_DONE = EnumSet.of(State.VERIFIED, State.CORRUPT);

    private EstablishBase() {
        this._context = null;
        this._log = null;
        this._X = null;
        this._Y = null;
        this._transport = null;
        this._con = null;
    }

    protected EstablishBase(RouterContext ctx, NTCPTransport transport, NTCPConnection con) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._transport = transport;
        this._con = con;
        if (!this._con.isInbound()) {
            throw new IllegalStateException();
        }
        this._X = SimpleByteCache.acquire(256);
        this._Y = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(State state) {
        Object object = this._stateLock;
        synchronized (object) {
            this._state = state;
            this._isCorrupt.set(state == State.CORRUPT);
            this._isComplete.set(state == State.VERIFIED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void receive(ByteBuffer src) {
        Object object = this._stateLock;
        synchronized (object) {
            if (STATES_DONE.contains((Object)this._state)) {
                throw new IllegalStateException(this.prefix() + "received unexpected data on " + String.valueOf(this._con));
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "Receiving: " + src.remaining() + " Received: " + this._received);
        }
    }

    @Override
    public void prepareOutbound() {
    }

    @Override
    public boolean isCorrupt() {
        return this._isCorrupt.get();
    }

    @Override
    public boolean isComplete() {
        return this._isComplete.get();
    }

    @Override
    public abstract int getVersion();

    @Override
    public synchronized void close(String reason, Exception e) {
        this.fail(reason, e);
    }

    protected void fail(String reason) {
        this.fail(reason, null);
    }

    protected void fail(String reason, Exception e) {
        this.fail(reason, e, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fail(String reason, Exception e, boolean bySkew) {
        Object object = this._stateLock;
        synchronized (object) {
            if (STATES_DONE.contains((Object)this._state)) {
                return;
            }
            this.changeState(State.CORRUPT);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn(this.prefix() + "Failed to establish: " + reason, e);
        }
        if (!bySkew) {
            this._context.statManager().addRateData("ntcp.receiveCorruptEstablishment", 1L);
        }
        this.releaseBufs(false);
    }

    protected void releaseBufs(boolean isVerified) {
        if (this._prevEncrypted != null && this._prevEncrypted.length == 16) {
            SimpleByteCache.release(this._prevEncrypted);
        }
    }

    protected String prefix() {
        return this.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        if (this._con.isInbound()) {
            buf.append("IBES ");
        } else {
            buf.append("OBES ");
        }
        buf.append(this._con.toString());
        buf.append(' ').append((Object)this._state);
        if (this._con.isEstablished()) {
            buf.append(" established");
        }
        buf.append(": ");
        return buf.toString();
    }

    protected static final String _x(String s) {
        return s;
    }

    protected static enum State {
        OB_INIT,
        IB_INIT,
        IB_NTCP2_INIT,
        IB_NTCP2_GOT_X,
        IB_NTCP2_GOT_PADDING,
        IB_NTCP2_SENT_Y,
        IB_NTCP2_GOT_RI,
        IB_NTCP2_READ_RANDOM,
        VERIFIED,
        CORRUPT;

    }

    private static class VerifiedEstablishState
    extends EstablishBase {
        public VerifiedEstablishState() {
            this.changeState(State.VERIFIED);
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public void receive(ByteBuffer src) {
            throw new IllegalStateException("receive() " + src.remaining() + " on verified state, doing nothing!");
        }

        @Override
        public void prepareOutbound() {
            throw new IllegalStateException("prepareOutbound() on verified state, doing nothing!");
        }

        @Override
        public String toString() {
            return "VerifiedEstablishState: ";
        }
    }

    private static class FailedEstablishState
    extends EstablishBase {
        public FailedEstablishState() {
            this.changeState(State.CORRUPT);
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public void receive(ByteBuffer src) {
            throw new IllegalStateException("receive() " + src.remaining() + " on failed state, doing nothing!");
        }

        @Override
        public void prepareOutbound() {
            throw new IllegalStateException("prepareOutbound() on failed state, doing nothing!");
        }

        @Override
        public String toString() {
            return "FailedEstablishState: ";
        }
    }
}

