/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.router.tasks.ThreadDump;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class OOMListener
implements I2PThread.OOMEventListener {
    private final RouterContext _context;
    private final AtomicBoolean _wasCalled = new AtomicBoolean();

    public OOMListener(RouterContext ctx) {
        this._context = ctx;
    }

    @Override
    public void outOfMemory(OutOfMemoryError oom) {
        try {
            if (this._context.router().isFinalShutdownInProgress()) {
                return;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            if (this._wasCalled.getAndSet(true)) {
                return;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            Thread.currentThread().setPriority(9);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            Router.clearCaches();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        Log log = null;
        try {
            log = this._context.logManager().getLog(Router.class);
            log.log(50, "Thread ran out of memory, shutting down I2P", oom);
            log.log(50, "free mem: " + Runtime.getRuntime().freeMemory() + " total mem: " + Runtime.getRuntime().totalMemory());
            String path = OOMListener.getWrapperConfigPath(this._context);
            if (this._context.hasWrapper()) {
                log.log(50, "To prevent future shutdowns, increase wrapper.java.maxmemory in " + path);
            } else if (!SystemVersion.isWindows()) {
                log.log(50, "To prevent future shutdowns, increase MAXMEMOPT in " + String.valueOf(this._context.getBaseDir()) + File.separatorChar + "runplain.sh or /usr/bin/i2prouter-nowrapper");
            } else {
                log.log(50, "To prevent future shutdowns, run the restartable version of I2P, and increase wrapper.java.maxmemory in " + path);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            ThreadDump.dump(this._context, 1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            this._context.router().eventLog().addEvent("oom");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            this._context.router().shutdown(10);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    private static boolean isDebianPackage(RouterContext ctx) {
        boolean isDebian = !SystemVersion.isWindows() && !SystemVersion.isMac() && !SystemVersion.isGentoo() && !SystemVersion.isAndroid() && System.getProperty("os.name").startsWith("Linux") && new File("/etc/debian_version").exists();
        return isDebian && ctx.getBaseDir().getPath().equals("/usr/share/i2p") && ctx.getBooleanProperty("router.updateDisabled");
    }

    public static String getWrapperConfigPath(RouterContext ctx) {
        File path = SystemVersion.isLinuxService() ? (SystemVersion.isGentoo() ? new File("/usr/share/i2p") : new File("/etc/i2p")) : (OOMListener.isDebianPackage(ctx) ? new File("/etc/i2p") : ctx.getBaseDir());
        path = new File(path, "wrapper.config");
        return path.getPath();
    }
}

