/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import java.io.IOException;
import net.i2p.data.DataHelper;
import net.i2p.router.Router;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleTimer;

public class MarkLiveliness
implements SimpleTimer.TimedEvent {
    private final Router _router;
    private final File _pingFile;
    private volatile boolean _errorLogged;

    public MarkLiveliness(Router router, File pingFile) {
        this._router = router;
        this._pingFile = pingFile;
        this._pingFile.deleteOnExit();
    }

    @Override
    public void timeReached() {
        if (this._router.isAlive()) {
            this.ping();
        } else {
            this._pingFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ping() {
        SecureFileOutputStream fos = null;
        try {
            fos = new SecureFileOutputStream(this._pingFile);
            fos.write(DataHelper.getASCII(Long.toString(System.currentTimeMillis())));
        }
        catch (IOException ioe) {
            if (!this._errorLogged) {
                Log log = this._router.getContext().logManager().getLog(MarkLiveliness.class);
                log.logAlways(30, "Error writing to ping file " + String.valueOf(this._pingFile) + ": " + String.valueOf(ioe));
                this._errorLogged = true;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

