/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.CreateRouterInfoJob;
import net.i2p.router.startup.LoadRouterInfoJob;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;

class RebuildRouterInfoJob
extends JobImpl {
    private final Log _log;
    private static final long REBUILD_DELAY = 45000L;

    public RebuildRouterInfoJob(RouterContext context) {
        super(context);
        this._log = context.logManager().getLog(RebuildRouterInfoJob.class);
    }

    @Override
    public String getName() {
        return "Rebuild Router Info";
    }

    @Override
    public void runJob() {
        throw new UnsupportedOperationException();
    }

    void rebuildRouterInfo() {
        this.rebuildRouterInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildRouterInfo(boolean alreadyRunning) {
        this._log.debug("Rebuilding the new router info");
        RouterInfo info = null;
        File infoFile = new File(this.getContext().getRouterDir(), "router.info");
        File keyFile = new File(this.getContext().getRouterDir(), "router.keys");
        File keyFile2 = new File(this.getContext().getRouterDir(), "router.keys.dat");
        if (keyFile2.exists() || keyFile.exists()) {
            RouterInfo oldinfo = this.getContext().router().getRouterInfo();
            if (oldinfo == null) {
                try {
                    LoadRouterInfoJob.KeyData kd = LoadRouterInfoJob.readKeyData(keyFile, keyFile2);
                    info = new RouterInfo();
                    info.setIdentity(kd.routerIdentity);
                }
                catch (DataFormatException e) {
                    this._log.log(50, "Error reading in the key data from " + keyFile.getAbsolutePath(), e);
                    keyFile.delete();
                    keyFile2.delete();
                    this.rebuildRouterInfo(alreadyRunning);
                    return;
                }
                catch (IOException e) {
                    this._log.log(50, "Error reading in the key data from " + keyFile.getAbsolutePath(), e);
                    keyFile.delete();
                    keyFile2.delete();
                    this.rebuildRouterInfo(alreadyRunning);
                    return;
                }
            } else {
                info = new RouterInfo(oldinfo);
            }
            try {
                info.setAddresses(this.getContext().commSystem().createAddresses());
                Properties stats = this.getContext().statPublisher().publishStatistics(info.getHash());
                info.setOptions(stats);
                info.setPublished(CreateRouterInfoJob.getCurrentPublishDate(this.getContext()));
                info.sign(this.getContext().keyManager().getSigningPrivateKey());
            }
            catch (DataFormatException dfe) {
                this._log.log(50, "Error rebuilding the new router info", dfe);
                return;
            }
            if (!info.isValid()) {
                this._log.log(50, "RouterInfo we just built is invalid: " + String.valueOf(info), new Exception());
                return;
            }
            SecureFileOutputStream fos = null;
            Object object = this.getContext().router().routerInfoFileLock;
            synchronized (object) {
                try {
                    fos = new SecureFileOutputStream(infoFile);
                    info.writeBytes(fos);
                }
                catch (DataFormatException dfe) {
                    this._log.log(50, "Error rebuilding the router information", dfe);
                }
                catch (IOException ioe) {
                    this._log.log(50, "Error writing out the rebuilt router information", ioe);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException dfe) {}
                    }
                }
            }
        }
        this._log.warn("Private key file " + keyFile.getAbsolutePath() + " deleted!  Rebuilding a brand new router identity!");
        CreateRouterInfoJob j = new CreateRouterInfoJob(this.getContext(), null);
        Object object = this.getContext().router().routerInfoFileLock;
        synchronized (object) {
            info = j.createRouterInfo();
        }
        this.getContext().router().setRouterInfo(info);
        this._log.info("Router info rebuilt and stored at " + String.valueOf(infoFile) + " [" + String.valueOf(info) + "]");
    }
}

