/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collection;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.data.router.RouterKeyGenerator;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.UnsupportedCryptoException;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class HandleFloodfillDatabaseStoreMessageJob
extends JobImpl {
    private final Log _log;
    private final DatabaseStoreMessage _message;
    private final RouterIdentity _from;
    private Hash _fromHash;
    private final FloodfillNetworkDatabaseFacade _facade;
    private static final int REPLY_TIMEOUT = 60000;
    private static final int MESSAGE_PRIORITY = 300;
    private static final int LIMIT_ROUTERS = SystemVersion.isSlow() ? 1000 : 4000;
    private final long _msgIDBloomXor;

    public HandleFloodfillDatabaseStoreMessageJob(RouterContext ctx, DatabaseStoreMessage receivedMessage, RouterIdentity from, Hash fromHash, FloodfillNetworkDatabaseFacade facade, long msgIDBloomXor) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._message = receivedMessage;
        this._from = from;
        this._fromHash = fromHash;
        this._facade = facade;
        this._msgIDBloomXor = msgIDBloomXor;
    }

    @Override
    public void runJob() {
        DatabaseEntry entry;
        Hash key;
        boolean wasNew;
        boolean dontBlamePeer;
        String invalidMessage;
        long recvBegin;
        block98: {
            recvBegin = System.currentTimeMillis();
            invalidMessage = null;
            dontBlamePeer = false;
            wasNew = false;
            RouterInfo prevNetDb = null;
            key = this._message.getKey();
            entry = this._message.getEntry();
            int type = entry.getType();
            if (DatabaseEntry.isLeaseSet(type)) {
                this.getContext().statManager().addRateData("netDb.storeLeaseSetHandled", 1L);
                if (this._log.shouldDebug()) {
                    this._log.debug("(dbid: " + String.valueOf(this._facade) + ") Starting handling of dbStore of leaseset " + String.valueOf(this._message));
                }
                try {
                    LeaseSet match;
                    LeaseSet ls = (LeaseSet)entry;
                    if (!this._facade.isClientDb()) {
                        if (!ls.getReceivedAsReply()) {
                            ls.setReceivedAsPublished();
                        }
                    } else if (this.getContext().netDbSegmentor().clientNetDB(ls.getHash()).equals(this._facade)) {
                        this.getContext().statManager().addRateData("netDb.storeLocalLeaseSetToLocalClient", 1L, 0L);
                        dontBlamePeer = true;
                        throw new IllegalArgumentException("(dbid: " + String.valueOf(this._facade) + ") Peer attempted to store local leaseSet: " + key.toBase32() + " to client subDB " + String.valueOf(this._facade) + "which is it's own publisher");
                    }
                    if ((match = this._facade.store(key, ls)) == null) {
                        wasNew = true;
                        break block98;
                    }
                    if (KademliaNetworkDatabaseFacade.isNewer(ls, match)) {
                        wasNew = true;
                        break block98;
                    }
                    wasNew = false;
                }
                catch (UnsupportedCryptoException uce) {
                    if (this._log.shouldError()) {
                        this._log.error("UCE: ", uce);
                    }
                    invalidMessage = uce.getMessage();
                    dontBlamePeer = true;
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else if (type == 0) {
                RouterInfo ri = (RouterInfo)entry;
                if (this._log.shouldDebug()) {
                    this._log.debug("(dbid: " + String.valueOf(this._facade) + ") Starting handling of dbStore of RI " + String.valueOf(this._message));
                }
                this.getContext().statManager().addRateData("netDb.storeRouterInfoHandled", 1L);
                if (this._fromHash == null && this._from != null) {
                    this._fromHash = this._from.getHash();
                }
                boolean isUs = this.getContext().routerHash().equals(key);
                if (!key.equals(this._fromHash) && !isUs) {
                    if (this._message.getReceivedAsReply()) {
                        ri.setReceivedAsReply();
                        if (this._message.getReplyToken() > 0L) {
                            ri.setReceivedAsPublished();
                        }
                    } else {
                        ri.setReceivedAsPublished();
                    }
                }
                if (this._log.shouldInfo()) {
                    String req = (this._message.getReplyToken() > 0L ? " reply req." : "") + (this._fromHash == null && ri.getReceivedAsPublished() ? " unsolicited" : "");
                    if (this._fromHash == null) {
                        this._log.info("(dbid: " + String.valueOf(this._facade) + ") Handling dbStore (_fromHash == NULL) of router " + key.toBase64() + " published " + DataHelper.formatTime(ri.getPublished()) + " (ReceivedAsReply[" + ri.getReceivedAsReply() + "], ReceivedAsPublished[" + ri.getReceivedAsPublished() + "])" + req);
                    } else if (this._fromHash.equals(key)) {
                        this._log.info("(dbid: " + String.valueOf(this._facade) + ") Handling dbStore (_fromHash equals key) of router " + key.toBase64() + " published " + DataHelper.formatTime(ri.getPublished()) + " from that router  (ReceivedAsReply[" + ri.getReceivedAsReply() + "], ReceivedAsPublished[" + ri.getReceivedAsPublished() + "])" + req);
                    } else {
                        this._log.info("(dbid: " + String.valueOf(this._facade) + ") Handling dbStore of router " + key.toBase64() + " published " + DataHelper.formatTime(ri.getPublished()) + " from: " + this._fromHash.toBase64() + " (ReceivedAsReply[" + ri.getReceivedAsReply() + "], ReceivedAsPublished[" + ri.getReceivedAsPublished() + "])" + req);
                    }
                }
                try {
                    if (isUs) {
                        dontBlamePeer = true;
                        throw new IllegalArgumentException("Peer attempted to store our RouterInfo");
                    }
                    if (this._facade.isClientDb() && this._log.shouldWarn()) {
                        this._log.warn("[dbid: " + String.valueOf(this._facade) + "]:  Handling RI dbStore in client netDb context of router " + key.toBase64());
                    }
                    boolean shouldStore = true;
                    if (ri.getReceivedAsPublished()) {
                        prevNetDb = (RouterInfo)this._facade.lookupLocallyWithoutValidation(key);
                        if (prevNetDb == null) {
                            int count = this._facade.getDataStore().size();
                            if (count > LIMIT_ROUTERS) {
                                boolean isOld;
                                String caps = ri.getCapabilities();
                                boolean isU = caps.indexOf(85) >= 0;
                                boolean isG = caps.indexOf(71) >= 0;
                                boolean isFF = caps.indexOf(102) >= 0;
                                boolean notFrom = !key.equals(this._fromHash);
                                boolean isSlow = caps.indexOf(76) >= 0;
                                boolean bl = isOld = VersionComparator.comp(ri.getVersion(), "0.9.62") < 0;
                                if (this._facade.floodfillEnabled()) {
                                    byte[] ourRKey;
                                    RouterKeyGenerator gen = this.getContext().routerKeyGenerator();
                                    byte[] rkey = gen.getRoutingKey(key).getData();
                                    int distance = ((rkey[0] ^ (ourRKey = this.getContext().routerHash().getData())[0]) & 0xFF) << 8 | (rkey[1] ^ ourRKey[1]) & 0xFF;
                                    if (distance >= 256) {
                                        long until = gen.getTimeTillMidnight();
                                        if (until > 2700000L) {
                                            int pdrop = Math.min(110, 128 * count / LIMIT_ROUTERS - 128);
                                            if (isU) {
                                                pdrop *= 3;
                                            }
                                            if (isG) {
                                                pdrop *= 3;
                                            }
                                            if (isFF) {
                                                pdrop *= 3;
                                            }
                                            if (notFrom) {
                                                pdrop *= 3;
                                            }
                                            if (isSlow) {
                                                pdrop *= 2;
                                            }
                                            if (isOld) {
                                                pdrop *= 2;
                                            }
                                            if (pdrop > 0 && (pdrop >= 128 || this.getContext().random().nextInt(128) < pdrop)) {
                                                if (this._log.shouldWarn()) {
                                                    this._log.warn("(dbid: " + String.valueOf(this._facade) + ") Dropping new unsolicited dbStore of " + ri.getCapabilities() + " router " + key.toBase64() + " with distance " + distance + " drop probability " + pdrop * 100 / 128);
                                                }
                                                shouldStore = false;
                                                if (this._message.getReplyToken() > 0L) {
                                                    wasNew = true;
                                                }
                                            }
                                        } else {
                                            rkey = gen.getNextRoutingKey(key).getData();
                                            distance = ((rkey[0] ^ (ourRKey = gen.getNextRoutingKey(this.getContext().routerHash()).getData())[0]) & 0xFF) << 8 | (rkey[1] ^ ourRKey[1]) & 0xFF;
                                            if (distance >= 256) {
                                                int pdrop = Math.min(110, 128 * count / LIMIT_ROUTERS - 128);
                                                if (isU) {
                                                    pdrop *= 3;
                                                }
                                                if (isFF) {
                                                    pdrop *= 3;
                                                }
                                                if (notFrom) {
                                                    pdrop *= 3;
                                                }
                                                if (pdrop > 0 && (pdrop >= 128 || this.getContext().random().nextInt(128) < pdrop)) {
                                                    if (this._log.shouldWarn()) {
                                                        this._log.warn("(dbid: " + String.valueOf(this._facade) + ") Dropping new unsolicited dbStore of router " + key.toBase64() + " with distance " + distance);
                                                    }
                                                    shouldStore = false;
                                                    if (this._message.getReplyToken() > 0L) {
                                                        wasNew = true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if (shouldStore && this._log.shouldDebug()) {
                                        this._log.debug("(dbid: " + String.valueOf(this._facade) + ") Allowing new unsolicited dbStore of router " + key.toBase64() + " with distance " + distance);
                                    }
                                } else {
                                    int pdrop = 128 * count / LIMIT_ROUTERS - 128;
                                    if (isU) {
                                        pdrop *= 3;
                                    }
                                    if (isG) {
                                        pdrop *= 3;
                                    }
                                    if (isFF) {
                                        pdrop *= 3;
                                    }
                                    if (notFrom) {
                                        pdrop *= 3;
                                    }
                                    if (isSlow) {
                                        pdrop *= 2;
                                    }
                                    if (isOld) {
                                        pdrop *= 2;
                                    }
                                    if (pdrop > 0 && (pdrop >= 128 || this.getContext().random().nextInt(128) < pdrop)) {
                                        if (this._log.shouldWarn()) {
                                            this._log.warn("(dbid: " + String.valueOf(this._facade) + ") Dropping new unsolicited dbStore of router " + key.toBase64() + " drop probability " + pdrop * 100 / 128);
                                        }
                                        shouldStore = false;
                                    }
                                }
                            }
                            if (shouldStore && this._log.shouldDebug()) {
                                this._log.debug("(dbid: " + String.valueOf(this._facade) + ") Handling new unsolicited dbStore of router " + key.toBase64());
                            }
                        } else if (prevNetDb.getPublished() >= ri.getPublished()) {
                            shouldStore = false;
                        } else if (this._log.shouldInfo()) {
                            this._log.info("(dbid: " + String.valueOf(this._facade) + ") Newer RouterInfo encountered in dbStore Message (for router " + key.toBase64() + ") with a pulished date (" + ri.getPublished() + ") newer than the one for the RI already stored in our database (" + prevNetDb.getPublished() + ")");
                            if (!ri.getIdentity().getPublicKey().equals(prevNetDb.getIdentity().getPublicKey())) {
                                this._log.info("(dbid: " + String.valueOf(this._facade) + ") Warning! The old (" + String.valueOf(prevNetDb.getIdentity().getPublicKey()) + ") and new (" + String.valueOf(ri.getIdentity().getPublicKey()) + ") public keys do not match!");
                            }
                            if (!ri.getIdentity().getSigningPublicKey().equals(prevNetDb.getIdentity().getSigningPublicKey())) {
                                this._log.info("(dbid: " + String.valueOf(this._facade) + ") Warning! The old (" + String.valueOf(prevNetDb.getIdentity().getSigningPublicKey()) + ") and new (" + String.valueOf(ri.getIdentity().getSigningPublicKey()) + ") signing public keys do not match!");
                            }
                        }
                    }
                    if (shouldStore) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("[dbid: " + String.valueOf(this._facade) + "]: Storing RI with the context netDb " + key.toBase64());
                        }
                        prevNetDb = this._facade.store(key, ri);
                        if (this._facade.isClientDb() && this._log.shouldWarn()) {
                            this._log.warn("[dbid: " + String.valueOf(this._facade) + "] Storing RI to client netDb (this is rare, should have been handled by IBMD) " + key.toBase64());
                        }
                        boolean bl = wasNew = null == prevNetDb || prevNetDb.getPublished() < ri.getPublished();
                    }
                    if (wasNew) {
                        boolean forever = this.getContext().banlist().isBanlistedForever(key);
                        if (forever) {
                            wasNew = false;
                            shouldStore = false;
                        }
                        if (prevNetDb == null) {
                            if (!forever && this.getContext().blocklist().isBlocklisted(ri)) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("(dbid: " + String.valueOf(this._facade) + ") Blocklisting new peer " + String.valueOf(key) + " " + String.valueOf(ri));
                                }
                                wasNew = false;
                                shouldStore = false;
                            }
                        } else if (!forever) {
                            Collection<RouterAddress> oldAddr = prevNetDb.getAddresses();
                            Collection<RouterAddress> newAddr = ri.getAddresses();
                            if (!newAddr.equals(oldAddr) && this.getContext().blocklist().isBlocklisted(ri)) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("(dbid: " + String.valueOf(this._facade) + ") New address received, Blocklisting old peer " + String.valueOf(key) + " " + String.valueOf(ri));
                                }
                                wasNew = false;
                                shouldStore = false;
                            }
                        }
                    }
                    if (shouldStore && ri.getCapabilities().indexOf(82) >= 0) {
                        this.getContext().profileManager().heardAbout(key);
                    }
                }
                catch (UnsupportedCryptoException uce) {
                    invalidMessage = uce.getMessage();
                    dontBlamePeer = true;
                }
                catch (IllegalArgumentException iae) {
                    invalidMessage = iae.getMessage();
                }
            } else {
                if (this._log.shouldLog(40)) {
                    this._log.error("(dbid: " + String.valueOf(this._facade) + ") Invalid DatabaseStoreMessage data type - " + type + ": " + String.valueOf(this._message));
                }
                return;
            }
        }
        long recvEnd = System.currentTimeMillis();
        this.getContext().statManager().addRateData("netDb.storeRecvTime", recvEnd - recvBegin);
        if (this._message.getReplyToken() > 0L) {
            this.sendAck(key);
        }
        long ackEnd = System.currentTimeMillis();
        if (this._from != null) {
            this._fromHash = this._from.getHash();
        }
        if (this._fromHash != null) {
            if (invalidMessage == null || dontBlamePeer) {
                this.getContext().profileManager().dbStoreReceived(this._fromHash, wasNew);
                this.getContext().statManager().addRateData("netDb.storeHandled", ackEnd - recvEnd);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("(dbid: " + String.valueOf(this._facade) + ") Peer " + this._fromHash.toBase64() + " sent bad data key: " + key.toBase64() + " replyreq? " + (this._message.getReplyToken() > 0L) + ": " + invalidMessage);
            }
        } else if (invalidMessage != null && !dontBlamePeer && this._log.shouldLog(30)) {
            this._log.warn("(dbid: " + String.valueOf(this._facade) + ") Unknown peer sent bad data key: " + key.toBase64() + " replyreq? " + (this._message.getReplyToken() > 0L) + ": " + invalidMessage);
        }
        if (invalidMessage == null && this._facade.floodfillEnabled() && this._message.getReplyToken() > 0L) {
            if (wasNew) {
                if (this._facade.shouldThrottleFlood(key)) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("(dbid: " + String.valueOf(this._facade) + "Too many recent stores, not flooding key: " + String.valueOf(key));
                    }
                    this.getContext().statManager().addRateData("netDb.floodThrottled", 1L);
                    return;
                }
                long floodBegin = System.currentTimeMillis();
                this._facade.flood(entry);
                long floodEnd = System.currentTimeMillis();
                this.getContext().statManager().addRateData("netDb.storeFloodNew", floodEnd - floodBegin, 60000L);
            } else {
                this.getContext().statManager().addRateData("netDb.storeFloodOld", 1L);
            }
        }
    }

    private void sendAck(Hash storedKey) {
        boolean isEstab;
        DatabaseStoreMessage msg2;
        DeliveryStatusMessage msg = new DeliveryStatusMessage(this.getContext());
        msg.setMessageId(this._message.getReplyToken());
        msg.setArrival(this.getContext().clock().now() - (long)this.getContext().random().nextInt(3000));
        TunnelId replyTunnel = this._message.getReplyTunnel();
        if (this._facade.floodfillEnabled() || storedKey.equals(this.getContext().routerHash())) {
            msg2 = null;
        } else {
            msg2 = new DatabaseStoreMessage(this.getContext());
            RouterInfo me = this.getContext().router().getRouterInfo();
            msg2.setEntry(me);
            if (this._log.shouldWarn()) {
                this._log.warn("(dbid: " + String.valueOf(this._facade) + ") Got a store w/ reply token, but we aren't ff: from: " + String.valueOf(this._from) + " fromHash: " + String.valueOf(this._fromHash) + " msg: " + String.valueOf(this._message), new Exception());
            }
        }
        Hash toPeer = this._message.getReplyGateway();
        boolean toUs = this.getContext().routerHash().equals(toPeer);
        if (toUs && replyTunnel != null) {
            TunnelGatewayMessage tgm = new TunnelGatewayMessage(this.getContext());
            tgm.setMessage(msg);
            tgm.setTunnelId(replyTunnel);
            tgm.setMessageExpiration(msg.getMessageExpiration());
            this.getContext().tunnelDispatcher().dispatch(tgm);
            if (msg2 != null) {
                TunnelGatewayMessage tgm2 = new TunnelGatewayMessage(this.getContext());
                tgm2.setMessage(msg2);
                tgm2.setTunnelId(replyTunnel);
                tgm2.setMessageExpiration(msg.getMessageExpiration());
                this.getContext().tunnelDispatcher().dispatch(tgm2);
            }
            return;
        }
        if (toUs) {
            if (this._facade.isClientDb()) {
                this._log.error("Error! SendMessageDirectJob (toUs) attempted in Client netDb (" + String.valueOf(this._facade) + ")! Message: " + String.valueOf(msg));
                return;
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), msg, toPeer, 60000, 300, this._msgIDBloomXor);
            send.runJob();
            if (msg2 != null) {
                SendMessageDirectJob send2 = new SendMessageDirectJob(this.getContext(), msg2, toPeer, 60000, 300, this._msgIDBloomXor);
                send2.runJob();
            }
            return;
        }
        DatabaseEntry entry = this._message.getEntry();
        int type = entry.getType();
        boolean bl = isEstab = (type == 0 || replyTunnel == null) && this.getContext().commSystem().isEstablished(toPeer);
        if (isEstab && !this._facade.isClientDb()) {
            FastI2NPMessageImpl out1 = msg;
            FastI2NPMessageImpl out2 = msg2;
            if (replyTunnel != null) {
                TunnelGatewayMessage tgm = new TunnelGatewayMessage(this.getContext());
                tgm.setMessage(msg);
                tgm.setTunnelId(replyTunnel);
                tgm.setMessageExpiration(msg.getMessageExpiration());
                out1 = tgm;
                if (out2 != null) {
                    TunnelGatewayMessage tgm2 = new TunnelGatewayMessage(this.getContext());
                    tgm2.setMessage(msg2);
                    tgm2.setTunnelId(replyTunnel);
                    tgm2.setMessageExpiration(msg.getMessageExpiration());
                    out2 = tgm2;
                }
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), out1, toPeer, 60000, 300, this._msgIDBloomXor);
            send.runJob();
            if (msg2 != null) {
                SendMessageDirectJob send2 = new SendMessageDirectJob(this.getContext(), out2, toPeer, 60000, 300, this._msgIDBloomXor);
                send2.runJob();
            }
            return;
        }
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(toPeer);
        if (outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("(dbid: " + String.valueOf(this._facade) + ") No outbound tunnel could be found");
            }
            return;
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), replyTunnel, toPeer);
        if (msg2 != null) {
            this.getContext().tunnelDispatcher().dispatchOutbound(msg2, outTunnel.getSendTunnelId(0), replyTunnel, toPeer);
        }
    }

    @Override
    public String getName() {
        return "Handle Database Store Message";
    }

    @Override
    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

