/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.MessageSelector;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodOnlySearchJob;
import net.i2p.router.networkdb.kademlia.SingleLookupJob;
import net.i2p.util.Log;

class FloodOnlyLookupSelector
implements MessageSelector {
    private final RouterContext _context;
    private final FloodOnlySearchJob _search;
    private boolean _matchFound;
    private final Log _log;

    public FloodOnlyLookupSelector(RouterContext ctx, FloodOnlySearchJob search) {
        this._context = ctx;
        this._search = search;
        this._log = ctx.logManager().getLog(this.getClass());
    }

    @Override
    public boolean continueMatching() {
        return this._search.getLookupsRemaining() > 0 && !this._matchFound && this._context.clock().now() < this.getExpiration();
    }

    @Override
    public long getExpiration() {
        return this._matchFound ? -1L : this._search.getExpiration();
    }

    @Override
    public boolean isMatch(I2NPMessage message) {
        if (message == null) {
            return false;
        }
        int type = message.getType();
        if (type == 1) {
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
            if (this._search.getKey().equals(dsm.getKey())) {
                this._search.decrementRemaining();
                this._matchFound = true;
                return true;
            }
        } else if (type == 3) {
            DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)message;
            if (this._search.getKey().equals(dsrm.getSearchKey())) {
                int remaining;
                this._context.profileManager().dbLookupReply(dsrm.getFromHash(), 0, dsrm.getNumReplies(), 0, 0, System.currentTimeMillis() - this._search.getCreated());
                if (this._search.shouldProcessDSRM()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info(this._search.getJobId() + ": Processing DSRM via SingleLookupJob, apparently from " + String.valueOf(dsrm.getFromHash()));
                    }
                    this._context.jobQueue().addJob(new SingleLookupJob(this._context, dsrm));
                } else if (this._log.shouldLog(20)) {
                    remaining = this._search.getLookupsRemaining();
                    this._log.info(this._search.getJobId() + ": got a DSRM apparently from " + String.valueOf(dsrm.getFromHash()) + " when we were looking for " + String.valueOf(this._search.getKey()) + ", with " + remaining + " outstanding searches");
                }
                remaining = this._search.decrementRemaining(dsrm.getFromHash());
                return remaining <= 0;
            }
        }
        return false;
    }

    public String toString() {
        return "FOL Selector for " + String.valueOf(this._search.getKey());
    }
}

