/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.Set;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Certificate;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.crypto.ratchet.ReplyCallback;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.util.Log;

class OutboundClientMessageJobHelper {
    private static final long ACK_EXTRA_EXPIRATION = 60000L;

    OutboundClientMessageJobHelper() {
    }

    static GarlicMessage createGarlicMessage(RouterContext ctx, long replyToken, long expiration, PublicKey recipientPK, PayloadGarlicConfig dataClove, Hash from, Destination dest, TunnelInfo replyTunnel, int tagsToSendOverride, int lowTagsOverride, SessionKey wrappedKey, Set<SessionTag> wrappedTags, boolean requireAck, LeaseSet bundledReplyLeaseSet, ReplyCallback callback) {
        GarlicMessage msg;
        SessionKeyManager skm = ctx.clientManager().getClientSessionKeyManager(from);
        if (skm == null) {
            return null;
        }
        boolean isECIES = recipientPK.getType() != EncType.ELGAMAL_2048;
        boolean ackInGarlic = isECIES ? false : requireAck;
        GarlicConfig config = OutboundClientMessageJobHelper.createGarlicConfig(ctx, replyToken, expiration, recipientPK, dataClove, from, dest, replyTunnel, ackInGarlic, bundledReplyLeaseSet, skm);
        if (config == null) {
            return null;
        }
        if (isECIES) {
            msg = GarlicMessageBuilder.buildECIESMessage(ctx, config, from, dest, skm, callback);
        } else {
            int tagsToSend = replyToken >= 0L ? (tagsToSendOverride > 0 ? tagsToSendOverride : skm.getTagsToSend()) : 0;
            int lowThreshold = lowTagsOverride > 0 ? lowTagsOverride : skm.getLowThreshold();
            msg = GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, tagsToSend, lowThreshold, skm);
        }
        return msg;
    }

    private static GarlicConfig createGarlicConfig(RouterContext ctx, long replyToken, long expiration, PublicKey recipientPK, PayloadGarlicConfig dataClove, Hash from, Destination dest, TunnelInfo replyTunnel, boolean requireAck, LeaseSet bundledReplyLeaseSet, SessionKeyManager skm) {
        Log log = ctx.logManager().getLog(OutboundClientMessageJobHelper.class);
        if (replyToken >= 0L && log.shouldLog(10)) {
            log.debug("Reply token: " + replyToken);
        }
        GarlicConfig config = new GarlicConfig(Certificate.NULL_CERT, ctx.random().nextLong(0xFFFFFFFFL), expiration, DeliveryInstructions.LOCAL);
        if (requireAck && (bundledReplyLeaseSet != null || recipientPK.getType() == EncType.ELGAMAL_2048)) {
            PayloadGarlicConfig ackClove = OutboundClientMessageJobHelper.buildAckClove(ctx, from, replyTunnel, replyToken, expiration + 60000L, skm);
            if (ackClove == null) {
                return null;
            }
            config.addClove(ackClove);
        }
        if (bundledReplyLeaseSet != null) {
            PayloadGarlicConfig leaseSetClove = OutboundClientMessageJobHelper.buildLeaseSetClove(ctx, expiration, bundledReplyLeaseSet);
            config.addClove(leaseSetClove);
        }
        if (dataClove != null) {
            config.addClove(dataClove);
        }
        config.setRecipientPublicKey(recipientPK);
        if (log.shouldLog(20)) {
            log.info("Creating garlic config to be encrypted to " + String.valueOf(recipientPK) + " for destination " + dest.calculateHash().toBase64());
        }
        return config;
    }

    private static PayloadGarlicConfig buildAckClove(RouterContext ctx, Hash from, TunnelInfo replyToTunnel, long replyToken, long expiration, SessionKeyManager skm) {
        FastI2NPMessageImpl msg;
        Log log = ctx.logManager().getLog(OutboundClientMessageJobHelper.class);
        if (replyToTunnel == null) {
            if (log.shouldLog(30)) {
                log.warn("Unable to send client message from " + from.toBase64() + ", as there are no inbound tunnels available");
            }
            return null;
        }
        TunnelId replyToTunnelId = replyToTunnel.getReceiveTunnelId(0);
        Hash replyToTunnelRouter = replyToTunnel.getPeer(0);
        if (log.shouldLog(10)) {
            log.debug("Ack for the data message will come back along tunnel " + String.valueOf(replyToTunnelId) + ": " + String.valueOf(replyToTunnel));
        }
        DeliveryInstructions ackInstructions = new DeliveryInstructions();
        ackInstructions.setDeliveryMode(3);
        ackInstructions.setRouter(replyToTunnelRouter);
        ackInstructions.setTunnelId(replyToTunnelId);
        DeliveryStatusMessage dsm = OutboundClientMessageJobHelper.buildDSM(ctx, replyToken);
        LeaseSetKeys lsk = ctx.keyManager().getKeys(from);
        if (lsk == null || lsk.isSupported(EncType.ELGAMAL_2048)) {
            msg = OutboundClientMessageJobHelper.wrapDSM(ctx, skm, dsm, expiration);
            if (msg == null) {
                if (log.shouldLog(30)) {
                    log.warn("Failed to wrap ack clove");
                }
                return null;
            }
        } else {
            msg = dsm;
        }
        PayloadGarlicConfig ackClove = new PayloadGarlicConfig(Certificate.NULL_CERT, ctx.random().nextLong(0xFFFFFFFFL), expiration, ackInstructions, msg);
        return ackClove;
    }

    private static DeliveryStatusMessage buildDSM(RouterContext ctx, long replyToken) {
        DeliveryStatusMessage msg = new DeliveryStatusMessage(ctx);
        msg.setArrival(ctx.clock().now());
        msg.setMessageId(replyToken);
        return msg;
    }

    private static GarlicMessage wrapDSM(RouterContext ctx, SessionKeyManager skm, DeliveryStatusMessage dsm, long expiration) {
        long fromNow = expiration - ctx.clock().now();
        MessageWrapper.OneTimeSession sess = MessageWrapper.generateSession(ctx, skm, fromNow, true);
        GarlicMessage msg = MessageWrapper.wrap(ctx, (I2NPMessage)dsm, sess);
        return msg;
    }

    private static PayloadGarlicConfig buildLeaseSetClove(RouterContext ctx, long expiration, LeaseSet replyLeaseSet) {
        DatabaseStoreMessage msg = new DatabaseStoreMessage(ctx);
        msg.setEntry(replyLeaseSet);
        msg.setMessageExpiration(expiration);
        PayloadGarlicConfig clove = new PayloadGarlicConfig(Certificate.NULL_CERT, ctx.random().nextLong(0xFFFFFFFFL), expiration, DeliveryInstructions.LOCAL, msg);
        return clove;
    }
}

