/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.pqc;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyFactory;
import net.i2p.crypto.KeyPair;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.util.RandomSource;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;

public final class MLKEM {
    public static final KeyFactory MLKEM512KeyFactory = new MLKEMFactory(EncType.MLKEM512_X25519_INT);
    public static final KeyFactory MLKEM768KeyFactory = new MLKEMFactory(EncType.MLKEM768_X25519_INT);
    public static final KeyFactory MLKEM1024KeyFactory = new MLKEMFactory(EncType.MLKEM1024_X25519_INT);

    public static KeyPair getKeys(EncType type) throws GeneralSecurityException {
        byte[][] keys = MLKEM.generateKeys(type);
        PublicKey pub = new PublicKey(type, keys[0]);
        PrivateKey priv = new PrivateKey(type, keys[1]);
        return new KeyPair(pub, priv);
    }

    public static byte[][] generateKeys(EncType type) throws GeneralSecurityException {
        MLKEMParameters param = MLKEM.getParam(type);
        MLKEMKeyPairGenerator kpg = new MLKEMKeyPairGenerator();
        kpg.init(new MLKEMKeyGenerationParameters((SecureRandom)RandomSource.getInstance(), param));
        AsymmetricCipherKeyPair pair = kpg.generateKeyPair();
        MLKEMPublicKeyParameters pubkey = (MLKEMPublicKeyParameters)pair.getPublic();
        MLKEMPrivateKeyParameters privkey = (MLKEMPrivateKeyParameters)pair.getPrivate();
        byte[][] keys = new byte[][]{pubkey.getEncoded(), privkey.getEncoded()};
        return keys;
    }

    public static byte[][] encaps(EncType type, byte[] pub) throws GeneralSecurityException {
        SecretWithEncapsulation swe;
        MLKEMParameters param = MLKEM.getParam(type);
        MLKEMGenerator gen = new MLKEMGenerator(I2PAppContext.getGlobalContext().random());
        MLKEMPublicKeyParameters ppub = new MLKEMPublicKeyParameters(param, pub);
        try {
            swe = gen.generateEncapsulated(ppub);
        }
        catch (IllegalArgumentException iae) {
            throw new GeneralSecurityException(iae);
        }
        byte[][] keys = new byte[][]{swe.getEncapsulation(), swe.getSecret()};
        return keys;
    }

    public static byte[] decaps(EncType type, byte[] ciphertext, byte[] decapkey) throws GeneralSecurityException {
        MLKEMParameters param = MLKEM.getParam(type);
        MLKEMPrivateKeyParameters priv = new MLKEMPrivateKeyParameters(param, decapkey);
        MLKEMExtractor ext = new MLKEMExtractor(priv);
        return ext.extractSecret(ciphertext);
    }

    private static MLKEMParameters getParam(EncType type) throws GeneralSecurityException {
        switch (type) {
            case MLKEM512_X25519_INT: 
            case MLKEM512_X25519_CT: {
                return MLKEMParameters.ml_kem_512;
            }
            case MLKEM768_X25519_INT: 
            case MLKEM768_X25519_CT: {
                return MLKEMParameters.ml_kem_768;
            }
            case MLKEM1024_X25519_INT: 
            case MLKEM1024_X25519_CT: {
                return MLKEMParameters.ml_kem_1024;
            }
        }
        throw new InvalidKeyException("unsupported type: " + String.valueOf((Object)type));
    }

    private static class MLKEMFactory
    implements KeyFactory {
        private final EncType t;

        public MLKEMFactory(EncType type) {
            this.t = type;
        }

        @Override
        public KeyPair getKeys() {
            try {
                return MLKEM.getKeys(this.t);
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException(gse);
            }
        }
    }
}

