/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.DisconnectMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.data.i2cp.SendMessageExpiresMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientManager;
import net.i2p.router.client.ClientMessageEventListener;
import net.i2p.router.client.ClientWriterRunner;
import net.i2p.router.client.LeaseRequestState;
import net.i2p.router.client.MessageReceivedJob;
import net.i2p.router.client.ReportAbuseJob;
import net.i2p.router.client.RequestLeaseSetJob;
import net.i2p.router.crypto.TransientSessionKeyManager;
import net.i2p.router.crypto.ratchet.MuxedPQSKM;
import net.i2p.router.crypto.ratchet.MuxedSKM;
import net.i2p.router.crypto.ratchet.RatchetSKM;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class ClientConnectionRunner {
    protected final Log _log;
    protected final RouterContext _context;
    protected final ClientManager _manager;
    private final Socket _socket;
    private OutputStream _out;
    private final ConcurrentHashMap<Hash, SessionParams> _sessions;
    private String _clientVersion;
    private final Map<MessageId, Payload> _messages;
    private int _consecutiveLeaseRequestFails;
    private final Set<MessageId> _acceptedPending;
    protected I2CPMessageReader _reader;
    private SessionKeyManager _sessionKeyManager;
    private FloodfillNetworkDatabaseFacade _floodfillNetworkDatabaseFacade;
    private final List<MessageId> _alreadyProcessed;
    private ClientWriterRunner _writer;
    private volatile boolean _dead;
    private boolean _dontSendMSM;
    private boolean _dontSendMSMOnReceive;
    private final AtomicInteger _messageId;
    private Hash _encryptedLSHash;
    private static final int MAX_MESSAGE_ID = 0x4000000;
    private static final int MAX_LEASE_FAILS = 5;
    private static final int BUF_SIZE = 32768;
    private static final int MAX_SESSIONS = 4;
    private static final String PROP_TAGS = "crypto.tagsToSend";
    private static final String PROP_THRESH = "crypto.lowTagThreshold";
    private static final AtomicInteger __id = new AtomicInteger();
    private static final long REQUEUE_DELAY = 500L;
    private static final int MAX_REQUEUE = 60;

    public ClientConnectionRunner(RouterContext context, ClientManager manager, Socket socket) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientConnectionRunner.class);
        this._manager = manager;
        this._socket = socket;
        this._messages = new ConcurrentHashMap<MessageId, Payload>();
        this._sessions = new ConcurrentHashMap(4);
        this._alreadyProcessed = new ArrayList<MessageId>();
        this._acceptedPending = new ConcurrentHashSet<MessageId>();
        this._messageId = new AtomicInteger(this._context.random().nextInt());
    }

    public synchronized void startRunning() throws IOException {
        if (this._dead || this._reader != null) {
            throw new IllegalStateException();
        }
        this._reader = new I2CPMessageReader(new BufferedInputStream(this._socket.getInputStream(), 32768), this.createListener());
        this._writer = new ClientWriterRunner(this._context, this);
        I2PThread t = new I2PThread(this._writer);
        t.setName("I2CP Writer " + __id.incrementAndGet());
        t.setDaemon(true);
        t.start();
        this._out = new BufferedOutputStream(this._socket.getOutputStream());
        this._reader.startReading();
    }

    protected I2CPMessageReader.I2CPMessageEventListener createListener() {
        return new ClientMessageEventListener(this._context, this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopRunning() {
        if (this._dead) {
            return;
        }
        if ((this._context.router() == null || this._context.router().isAlive()) && this._log.shouldWarn()) {
            this._log.warn("Stop the I2CP connection!", new Exception("Stop client connection"));
        }
        this._dead = true;
        if (this._reader != null) {
            this._reader.stopReading();
        }
        if (this._writer != null) {
            this._writer.stopWriting();
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._messages.clear();
        this._acceptedPending.clear();
        if (this._sessionKeyManager != null) {
            this._sessionKeyManager.shutdown();
        }
        if (this._encryptedLSHash != null) {
            this._manager.unregisterEncryptedDestination(this, this._encryptedLSHash);
        }
        this._manager.unregisterConnection(this);
        if (this._context.netDb() != null) {
            for (SessionParams sp : this._sessions.values()) {
                if (sp.isPrimary) continue;
                this._context.tunnelManager().removeAlias(sp.dest);
            }
            for (SessionParams sp : this._sessions.values()) {
                if (sp.isPrimary) {
                    this._context.tunnelManager().removeTunnels(sp.dest);
                }
                if (sp.rerequestTimer == null) continue;
                sp.rerequestTimer.cancel();
            }
        }
        if (this._floodfillNetworkDatabaseFacade != null) {
            this._floodfillNetworkDatabaseFacade.shutdown();
        }
        Iterator<SessionParams> iterator = this._alreadyProcessed;
        synchronized (iterator) {
            this._alreadyProcessed.clear();
        }
        this._sessions.clear();
    }

    public InetAddress getAddress() {
        return this._socket.getInetAddress();
    }

    public SessionConfig getConfig(Hash h) {
        SessionParams sp = this._sessions.get(h);
        if (sp == null) {
            return null;
        }
        return sp.config;
    }

    public SessionConfig getConfig(SessionId id) {
        if (id == null) {
            return null;
        }
        for (SessionParams sp : this._sessions.values()) {
            if (!id.equals(sp.sessionId)) continue;
            return sp.config;
        }
        return null;
    }

    public SessionConfig getPrimaryConfig() {
        for (SessionParams sp : this._sessions.values()) {
            if (!sp.isPrimary) continue;
            return sp.config;
        }
        return null;
    }

    public void setClientVersion(String version) {
        this._clientVersion = version;
    }

    public String getClientVersion() {
        return this._clientVersion;
    }

    public SessionKeyManager getSessionKeyManager() {
        return this._sessionKeyManager;
    }

    public LeaseSet getLeaseSet(Hash h) {
        SessionParams sp = this._sessions.get(h);
        if (sp == null) {
            return null;
        }
        return sp.currentLeaseSet;
    }

    public Hash getDestHash() {
        SessionConfig cfg = this.getPrimaryConfig();
        if (cfg != null) {
            return cfg.getDestination().calculateHash();
        }
        return null;
    }

    public Hash getDestHash(SessionId id) {
        if (id == null) {
            return null;
        }
        for (Map.Entry<Hash, SessionParams> e : this._sessions.entrySet()) {
            if (!id.equals(e.getValue().sessionId)) continue;
            return e.getKey();
        }
        return null;
    }

    public Destination getDestination(SessionId id) {
        if (id == null) {
            return null;
        }
        for (SessionParams sp : this._sessions.values()) {
            if (!id.equals(sp.sessionId)) continue;
            return sp.dest;
        }
        return null;
    }

    SessionId getSessionId(Hash h) {
        SessionParams sp = this._sessions.get(h);
        if (sp == null) {
            return null;
        }
        return sp.sessionId;
    }

    List<SessionId> getSessionIds() {
        ArrayList<SessionId> rv = new ArrayList<SessionId>(this._sessions.size());
        for (SessionParams sp : this._sessions.values()) {
            SessionId id = sp.sessionId;
            if (id == null) continue;
            rv.add(id);
        }
        return rv;
    }

    List<Destination> getDestinations() {
        ArrayList<Destination> rv = new ArrayList<Destination>(this._sessions.size());
        for (SessionParams sp : this._sessions.values()) {
            rv.add(sp.dest);
        }
        return rv;
    }

    void setSessionId(Hash hash, SessionId id) {
        if (hash == null) {
            throw new IllegalStateException();
        }
        if (id == null) {
            throw new NullPointerException();
        }
        SessionParams sp = this._sessions.get(hash);
        if (sp == null || sp.sessionId != null) {
            throw new IllegalStateException();
        }
        sp.sessionId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(SessionId id) {
        ClientConnectionRunner clientConnectionRunner;
        LeaseSet ls;
        if (id == null) {
            return;
        }
        boolean isPrimary = false;
        Iterator<SessionParams> iter = this._sessions.values().iterator();
        while (iter.hasNext()) {
            SessionParams sp = iter.next();
            if (!id.equals(sp.sessionId)) continue;
            if (this._log.shouldLog(20)) {
                this._log.info("Destroying client session " + String.valueOf(id));
            }
            iter.remove();
            this._manager.unregisterSession(id, sp.dest);
            ls = sp.currentLeaseSet;
            if (ls != null && this._floodfillNetworkDatabaseFacade != null) {
                this._floodfillNetworkDatabaseFacade.unpublish(ls);
            }
            if ((ls = sp.currentEncryptedLeaseSet) != null && this._floodfillNetworkDatabaseFacade != null) {
                this._floodfillNetworkDatabaseFacade.unpublish(ls);
            }
            if (isPrimary = sp.isPrimary) {
                this._context.tunnelManager().removeTunnels(sp.dest);
            } else {
                this._context.tunnelManager().removeAlias(sp.dest);
            }
            clientConnectionRunner = this;
            synchronized (clientConnectionRunner) {
                if (sp.rerequestTimer != null) {
                    sp.rerequestTimer.cancel();
                }
                break;
            }
        }
        if (isPrimary && !this._sessions.isEmpty()) {
            for (SessionParams sp : this._sessions.values()) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Destroying remaining client subsession " + String.valueOf(sp.sessionId));
                }
                this._manager.unregisterSession(sp.sessionId, sp.dest);
                ls = sp.currentLeaseSet;
                if (ls != null && this._floodfillNetworkDatabaseFacade != null) {
                    this._floodfillNetworkDatabaseFacade.unpublish(ls);
                }
                if ((ls = sp.currentEncryptedLeaseSet) != null && this._floodfillNetworkDatabaseFacade != null) {
                    this._floodfillNetworkDatabaseFacade.unpublish(ls);
                }
                this._context.tunnelManager().removeAlias(sp.dest);
                clientConnectionRunner = this;
                synchronized (clientConnectionRunner) {
                    if (sp.rerequestTimer != null) {
                        sp.rerequestTimer.cancel();
                    }
                }
            }
            this._sessions.clear();
        }
    }

    LeaseRequestState getLeaseRequest(Hash h) {
        SessionParams sp = this._sessions.get(h);
        if (sp == null) {
            return null;
        }
        return sp.leaseRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failLeaseRequest(LeaseRequestState req) {
        boolean disconnect = false;
        Hash h = req.getRequested().getDestination().calculateHash();
        SessionParams sp = this._sessions.get(h);
        if (sp == null) {
            return;
        }
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            if (sp.leaseRequest == req) {
                sp.leaseRequest = null;
                disconnect = ++this._consecutiveLeaseRequestFails > 5;
            }
        }
        if (disconnect) {
            this.disconnectClient("Too many leaseset request fails");
        }
    }

    boolean isDead() {
        return this._dead;
    }

    Payload getPayload(MessageId id) {
        return this._messages.get(id);
    }

    void setPayload(MessageId id, Payload payload) {
        if (!this._dontSendMSMOnReceive) {
            this._messages.put(id, payload);
        }
    }

    void removePayload(MessageId id) {
        this._messages.remove(id);
    }

    public int sessionEstablished(SessionConfig config) {
        Destination dest = config.getDestination();
        Hash destHash = dest.calculateHash();
        if (this._log.shouldLog(10)) {
            this._log.debug("SessionEstablished called for destination " + String.valueOf(destHash));
        }
        if (this._sessions.size() > 4) {
            return 4;
        }
        boolean isPrimary = this._sessions.isEmpty();
        if (!isPrimary) {
            for (SessionParams sp : this._sessions.values()) {
                if (dest.getPublicKey().equals(sp.dest.getPublicKey())) continue;
                this._log.error("LS pubkey mismatch");
                return 3;
            }
        }
        SessionParams sp = new SessionParams(dest, isPrimary);
        sp.config = config;
        SessionParams old = this._sessions.putIfAbsent(destHash, sp);
        if (old != null) {
            return 5;
        }
        Properties opts = config.getOptions();
        if (isPrimary && opts != null) {
            this._dontSendMSM = "none".equals(opts.getProperty("i2cp.messageReliability", "").toLowerCase(Locale.US));
            this._dontSendMSMOnReceive = Boolean.parseBoolean(opts.getProperty("i2cp.fastReceive"));
        }
        if (isPrimary && this._sessionKeyManager == null) {
            int tags = 40;
            int thresh = 30;
            boolean hasElg = false;
            boolean hasEC = false;
            boolean hasPQ = false;
            int pqType = 0;
            if (opts != null && this._context.router() != null) {
                String senc;
                String pthresh;
                String ptags = opts.getProperty(PROP_TAGS);
                if (ptags != null) {
                    try {
                        tags = Integer.parseInt(ptags);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((pthresh = opts.getProperty(PROP_THRESH)) != null) {
                    try {
                        thresh = Integer.parseInt(pthresh);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((senc = opts.getProperty("i2cp.leaseSetEncType")) != null) {
                    String[] senca;
                    for (String sencaa : senca = DataHelper.split(senc, ",")) {
                        if (sencaa.equals("0")) {
                            hasElg = true;
                            continue;
                        }
                        if (sencaa.equals("4")) {
                            hasEC = true;
                            continue;
                        }
                        if (!sencaa.equals("5") && !sencaa.equals("6") && !sencaa.equals("7")) continue;
                        if (hasPQ) {
                            this._log.error("Bad encryption type combination in i2cp.leaseSetEncType for " + dest.toBase32());
                            return 3;
                        }
                        pqType = Integer.parseInt(sencaa);
                        hasPQ = true;
                    }
                } else {
                    hasElg = true;
                }
            } else {
                hasElg = true;
            }
            if (hasElg) {
                if (hasPQ) {
                    this._log.error("Bad encryption type combination in i2cp.leaseSetEncType for " + dest.toBase32());
                    return 3;
                }
                TransientSessionKeyManager tskm = new TransientSessionKeyManager(this._context, tags, thresh);
                if (hasEC) {
                    RatchetSKM rskm = new RatchetSKM(this._context, dest);
                    this._sessionKeyManager = new MuxedSKM(tskm, rskm);
                } else {
                    this._sessionKeyManager = tskm;
                }
            } else if (hasPQ) {
                if (hasEC) {
                    RatchetSKM rskm1 = new RatchetSKM(this._context, dest);
                    RatchetSKM rskm2 = new RatchetSKM(this._context, dest, EncType.getByCode(pqType));
                    this._sessionKeyManager = new MuxedPQSKM(rskm1, rskm2);
                } else {
                    this._sessionKeyManager = new RatchetSKM(this._context, dest, EncType.getByCode(pqType));
                }
            } else if (hasEC) {
                this._sessionKeyManager = new RatchetSKM(this._context, dest);
            } else {
                this._log.error("No supported encryption types in i2cp.leaseSetEncType for " + dest.toBase32());
                return 3;
            }
        }
        if (isPrimary && this._floodfillNetworkDatabaseFacade == null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Initializing subDb for client" + String.valueOf(destHash));
            }
            this._floodfillNetworkDatabaseFacade = new FloodfillNetworkDatabaseFacade(this._context, destHash);
            this._floodfillNetworkDatabaseFacade.startup();
        }
        return this._manager.destinationEstablished(this, dest);
    }

    void updateMessageDeliveryStatus(Destination dest, MessageId id, long messageNonce, int status) {
        if (this._dead || messageNonce <= 0L) {
            return;
        }
        SessionParams sp = this._sessions.get(dest.calculateHash());
        if (sp == null) {
            return;
        }
        SessionId sid = sp.sessionId;
        if (sid == null) {
            return;
        }
        this._context.jobQueue().addJob(new MessageDeliveryStatusUpdate(sid, id, messageNonce, status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaseSetCreated(LeaseSet ls) {
        LeaseRequestState state;
        Hash h = ls.getDestination().calculateHash();
        SessionParams sp = this._sessions.get(h);
        if (sp == null) {
            return;
        }
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            if (ls.getType() == 5) {
                EncryptedLeaseSet encls = (EncryptedLeaseSet)ls;
                sp.currentEncryptedLeaseSet = encls;
                ls = encls.getDecryptedLeaseSet();
            }
            sp.currentLeaseSet = ls;
            state = sp.leaseRequest;
            if (state == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("LeaseRequest is null and we've received a new lease? " + String.valueOf(ls));
                }
                return;
            }
            state.setIsSuccessful(true);
            if (this._log.shouldLog(10)) {
                this._log.debug("LeaseSet created fully: " + String.valueOf(state) + "\n" + String.valueOf(ls));
            }
            sp.leaseRequest = null;
            this._consecutiveLeaseRequestFails = 0;
            if (sp.rerequestTimer != null) {
                sp.rerequestTimer.cancel();
                sp.rerequestTimer = null;
            }
        }
        if (state != null && state.getOnGranted() != null) {
            this._context.jobQueue().addJob(state.getOnGranted());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerEncryptedLS(Hash hash) {
        boolean rv = true;
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            if (!hash.equals(this._encryptedLSHash)) {
                if (this._encryptedLSHash != null) {
                    this._manager.unregisterEncryptedDestination(this, this._encryptedLSHash);
                }
                if (rv = this._manager.registerEncryptedDestination(this, hash)) {
                    this._encryptedLSHash = hash;
                }
            }
        }
        return rv;
    }

    void disconnectClient(String reason) {
        this.disconnectClient(reason, 40);
    }

    void disconnectClient(String reason, int logLevel) {
        block6: {
            if (this._log.shouldLog(logLevel)) {
                this._log.log(logLevel, "Disconnecting the client - " + reason);
            }
            DisconnectMessage msg = new DisconnectMessage();
            if (reason.length() > 255) {
                reason = reason.substring(0, 255);
            }
            msg.setReason(reason);
            try {
                this.doSend(msg);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block6;
                this._log.warn("Error writing out the disconnect message", ime);
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stopRunning();
    }

    MessageId distributeMessage(SendMessageMessage message) {
        Destination fromDest;
        Payload payload = message.getPayload();
        Destination dest = message.getDestination();
        MessageId id = new MessageId();
        id.setMessageId(this.getNextMessageId());
        long expiration = 0L;
        int flags = 0;
        if (message.getType() == 36) {
            SendMessageExpiresMessage msg = (SendMessageExpiresMessage)message;
            expiration = msg.getExpirationTime();
            flags = msg.getFlags();
        }
        if (!this._dontSendMSM && message.getNonce() != 0L) {
            this._acceptedPending.add(id);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("** Receiving message " + id.getMessageId() + " with payload of size " + payload.getSize() + " for session " + String.valueOf(message.getSessionId()));
        }
        if ((fromDest = this.getDestination(message.getSessionId())) != null) {
            this._manager.distributeMessage(this, fromDest, dest, payload, id, message.getNonce(), expiration, flags);
        }
        return id;
    }

    void ackSendMessage(SessionId sid, MessageId id, long nonce) {
        block4: {
            if (this._dontSendMSM || nonce == 0L) {
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Acking message send [accepted]" + String.valueOf(id) + " / " + nonce + " for sessionId " + String.valueOf(sid));
            }
            MessageStatusMessage status = new MessageStatusMessage();
            status.setMessageId(id.getMessageId());
            status.setSessionId(sid.getSessionId());
            status.setSize(0L);
            status.setNonce(nonce);
            status.setStatus(1);
            try {
                this.doSend(status);
                this._acceptedPending.remove(id);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error writing out the message status message", ime);
            }
        }
    }

    boolean receiveMessage(Destination toDest, Destination fromDest, Payload payload) {
        if (this._dead) {
            return false;
        }
        MessageReceivedJob j = new MessageReceivedJob(this._context, this, toDest, fromDest, payload, this._dontSendMSMOnReceive);
        return j.receiveMessage();
    }

    boolean receiveMessage(Hash toHash, Destination fromDest, Payload payload) {
        SessionParams sp = this._sessions.get(toHash);
        if (sp == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No session found for receiveMessage()");
            }
            return false;
        }
        return this.receiveMessage(sp.dest, fromDest, payload);
    }

    public void reportAbuse(Destination dest, String reason, int severity) {
        if (this._dead) {
            return;
        }
        this._context.jobQueue().addJob(new ReportAbuseJob(this._context, this, dest, reason, severity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestLeaseSet(Hash h, LeaseSet set, long expirationTime, Job onCreateJob, Job onFailedJob) {
        LeaseRequestState state;
        if (this._dead) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Requesting leaseSet from a dead client: " + String.valueOf(set));
            }
            if (onFailedJob != null) {
                this._context.jobQueue().addJob(onFailedJob);
            }
            return;
        }
        SessionParams sp = this._sessions.get(h);
        if (sp == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Requesting leaseSet for an unknown sesssion");
            }
            return;
        }
        int leases = set.getLeaseCount();
        Destination dest = sp.dest;
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            LeaseSet current = sp.currentLeaseSet;
            if (current != null && current.getLeaseCount() == leases && current.getType() != 7) {
                for (int i = 0; i < leases && current.getLease(i).getTunnelId().equals(set.getLease(i).getTunnelId()) && current.getLease(i).getGateway().equals(set.getLease(i).getGateway()); ++i) {
                    if (i != leases - 1) continue;
                    if (this._log.shouldDebug()) {
                        this._log.debug("Requested leaseSet hasn't changed");
                    }
                    if (onCreateJob != null) {
                        this._context.jobQueue().addJob(onCreateJob);
                    }
                    return;
                }
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Current leaseSet " + String.valueOf(current) + "\nNew leaseSet " + String.valueOf(set));
            }
            if ((state = sp.leaseRequest) != null) {
                LeaseSet requested = state.getRequested();
                LeaseSet granted = state.getGranted();
                long ours = set.getEarliestLeaseDate();
                if (requested != null && requested.getEarliestLeaseDate() > ours || granted != null && granted.getEarliestLeaseDate() > ours) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Already requesting, theirs newer, do nothing: " + String.valueOf(state));
                    }
                } else {
                    Rerequest timer;
                    set.setDestination(dest);
                    sp.rerequestTimer = timer = new Rerequest(set, expirationTime, onCreateJob, onFailedJob);
                    timer.schedule(3000L);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Already requesting, ours newer, wait 3 sec: " + String.valueOf(state));
                    }
                }
                return;
            }
            set.setDestination(dest);
            if (current == null && this._context.tunnelManager().getOutboundClientTunnelCount(h) <= 0) {
                Rerequest timer;
                sp.rerequestTimer = timer = new Rerequest(set, expirationTime, onCreateJob, onFailedJob);
                timer.schedule(1000L);
                if (this._log.shouldLog(10)) {
                    this._log.debug("No current LS but no OB tunnels, wait 1 sec for " + String.valueOf(h));
                }
                return;
            }
            if (sp.rerequestTimer != null) {
                sp.rerequestTimer.cancel();
                sp.rerequestTimer = null;
            }
            long earliest = current != null ? current.getEarliestLeaseDate() : 0L;
            sp.leaseRequest = state = new LeaseRequestState(onCreateJob, onFailedJob, earliest, this._context.clock().now() + expirationTime, set);
            if (this._log.shouldLog(10)) {
                this._log.debug("New request: " + String.valueOf(state));
            }
        }
        this._context.jobQueue().addJob(new RequestLeaseSetJob(this._context, this, state));
    }

    void disconnected() {
        if (this._log.shouldLog(30)) {
            this._log.warn("Disconnected", new Exception("Disconnected?"));
        }
        this.stopRunning();
    }

    boolean getIsDead() {
        return this._dead;
    }

    void writeMessage(I2CPMessage msg) {
        try {
            msg.writeMessage(this._out);
            this._out.flush();
        }
        catch (I2CPMessageException ime) {
            this._log.error("Error sending I2CP message to client", ime);
            this.stopRunning();
        }
        catch (EOFException eofe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error sending I2CP message - client went away", eofe);
            }
            this.stopRunning();
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("IO Error sending I2CP message to client", ioe);
            }
            this.stopRunning();
        }
        catch (Throwable t) {
            this._log.log(50, "Unhandled exception sending I2CP message to client", t);
            this.stopRunning();
        }
    }

    void doSend(I2CPMessage msg) throws I2CPMessageException {
        if (this._out == null) {
            throw new I2CPMessageException("Output stream is not initialized");
        }
        if (msg == null) {
            throw new I2CPMessageException("Null message?!");
        }
        this._writer.addMessage(msg);
    }

    public int getNextMessageId() {
        return this._messageId.incrementAndGet() & 0x3FFFFFF;
    }

    private boolean alreadyAccepted(MessageId id) {
        if (this._dead) {
            return false;
        }
        return !this._acceptedPending.contains(id);
    }

    public FloodfillNetworkDatabaseFacade getFloodfillNetworkDatabaseFacade() {
        return this._floodfillNetworkDatabaseFacade;
    }

    private static class SessionParams {
        final Destination dest;
        final boolean isPrimary;
        SessionId sessionId;
        SessionConfig config;
        LeaseRequestState leaseRequest;
        Rerequest rerequestTimer;
        LeaseSet currentLeaseSet;
        LeaseSet currentEncryptedLeaseSet;

        SessionParams(Destination d, boolean isPrimary) {
            this.dest = d;
            this.isPrimary = isPrimary;
        }
    }

    private class Rerequest
    extends SimpleTimer2.TimedEvent {
        private final LeaseSet _ls;
        private final long _expirationTime;
        private final Job _onCreate;
        private final Job _onFailed;

        public Rerequest(LeaseSet ls, long expirationTime, Job onCreate, Job onFailed) {
            super(ClientConnectionRunner.this._context.simpleTimer2());
            this._ls = ls;
            this._expirationTime = expirationTime;
            this._onCreate = onCreate;
            this._onFailed = onFailed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            Hash h = this._ls.getDestination().calculateHash();
            SessionParams sp = ClientConnectionRunner.this._sessions.get(h);
            if (sp == null) {
                if (ClientConnectionRunner.this._log.shouldLog(30)) {
                    ClientConnectionRunner.this._log.warn("cancelling rerequest, session went away: " + String.valueOf(h));
                }
                return;
            }
            ClientConnectionRunner clientConnectionRunner = ClientConnectionRunner.this;
            synchronized (clientConnectionRunner) {
                if (sp.rerequestTimer != this) {
                    if (ClientConnectionRunner.this._log.shouldLog(30)) {
                        ClientConnectionRunner.this._log.warn("cancelling rerequest, newer request came in: " + String.valueOf(h));
                    }
                    return;
                }
            }
            ClientConnectionRunner.this.requestLeaseSet(h, this._ls, this._expirationTime, this._onCreate, this._onFailed);
        }
    }

    private class MessageDeliveryStatusUpdate
    extends JobImpl {
        private final SessionId _sessId;
        private final MessageId _messageId;
        private final long _messageNonce;
        private final int _status;
        private long _lastTried;
        private int _requeueCount;

        public MessageDeliveryStatusUpdate(SessionId sid, MessageId id, long messageNonce, int status) {
            super(ClientConnectionRunner.this._context);
            this._sessId = sid;
            this._messageId = id;
            this._messageNonce = messageNonce;
            this._status = status;
        }

        @Override
        public String getName() {
            return "Update Delivery Status";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            block19: {
                if (ClientConnectionRunner.this._dead) {
                    return;
                }
                MessageStatusMessage msg = new MessageStatusMessage();
                msg.setMessageId(this._messageId.getMessageId());
                msg.setSessionId(this._sessId.getSessionId());
                msg.setNonce(this._messageNonce);
                msg.setSize(0L);
                msg.setStatus(this._status);
                if (!ClientConnectionRunner.this.alreadyAccepted(this._messageId)) {
                    if (this._requeueCount++ > 60) {
                        ClientConnectionRunner.this._log.error("Abandon update for message " + String.valueOf(this._messageId) + " to " + MessageStatusMessage.getStatusString(msg.getStatus()) + " for " + String.valueOf(this._sessId));
                    } else {
                        if (ClientConnectionRunner.this._log.shouldLog(30)) {
                            ClientConnectionRunner.this._log.warn("Almost send an update for message " + String.valueOf(this._messageId) + " to " + MessageStatusMessage.getStatusString(msg.getStatus()) + " for " + String.valueOf(this._sessId) + " before they knew the messageId!  delaying .5s");
                        }
                        this._lastTried = ClientConnectionRunner.this._context.clock().now();
                        this.requeue(500L);
                    }
                    return;
                }
                boolean alreadyProcessed = false;
                long beforeLock = ClientConnectionRunner.this._context.clock().now();
                long inLock = 0L;
                List<MessageId> list = ClientConnectionRunner.this._alreadyProcessed;
                synchronized (list) {
                    inLock = ClientConnectionRunner.this._context.clock().now();
                    if (ClientConnectionRunner.this._alreadyProcessed.contains(this._messageId)) {
                        ClientConnectionRunner.this._log.info("Status already updated");
                        alreadyProcessed = true;
                    } else {
                        ClientConnectionRunner.this._alreadyProcessed.add(this._messageId);
                        while (ClientConnectionRunner.this._alreadyProcessed.size() > 10) {
                            ClientConnectionRunner.this._alreadyProcessed.remove(0);
                        }
                    }
                }
                long afterLock = ClientConnectionRunner.this._context.clock().now();
                if (afterLock - beforeLock > 50L) {
                    ClientConnectionRunner.this._log.warn("MessageDeliveryStatusUpdate.locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
                }
                if (alreadyProcessed) {
                    return;
                }
                if (this._lastTried > 0L) {
                    if (ClientConnectionRunner.this._log.shouldLog(10)) {
                        ClientConnectionRunner.this._log.info("Updating message status for message " + String.valueOf(this._messageId) + " to " + MessageStatusMessage.getStatusString(msg.getStatus()) + " for " + String.valueOf(this._sessId) + " (with nonce=2), retrying after " + (ClientConnectionRunner.this._context.clock().now() - this._lastTried));
                    }
                } else if (ClientConnectionRunner.this._log.shouldLog(10)) {
                    ClientConnectionRunner.this._log.debug("Updating message status for message " + String.valueOf(this._messageId) + " to " + MessageStatusMessage.getStatusString(msg.getStatus()) + " for " + String.valueOf(this._sessId) + " (with nonce=2)");
                }
                try {
                    ClientConnectionRunner.this.doSend(msg);
                }
                catch (I2CPMessageException ime) {
                    if (!ClientConnectionRunner.this._log.shouldLog(30)) break block19;
                    ClientConnectionRunner.this._log.warn("Error updating the status for message ID " + String.valueOf(this._messageId), ime);
                }
            }
        }
    }
}

