/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.util.VersionComparator;

public class DatabaseLookupMessage
extends FastI2NPMessageImpl {
    public static final int MESSAGE_TYPE = 2;
    private Hash _key;
    private Hash _fromHash;
    private TunnelId _replyTunnel;
    private List<Hash> _dontIncludePeers;
    private SessionKey _replyKey;
    private SessionTag _replyTag;
    private RatchetSessionTag _ratchetReplyTag;
    private PublicKey _ratchetPubKey;
    private Type _type = Type.ANY;
    public static final boolean USE_ECIES_FF = true;
    private static final int MAX_NUM_PEERS = 512;
    private static final byte FLAG_TUNNEL = 1;
    private static final byte FLAG_ENCRYPT = 2;
    private static final byte FLAG_TYPE_MASK = 12;
    private static final byte FLAG_TYPE_ANY = 0;
    private static final byte FLAG_TYPE_LS = 4;
    private static final byte FLAG_TYPE_RI = 8;
    private static final byte FLAG_TYPE_EXPL = 12;
    private static final byte FLAG_RATCHET = 16;
    private static final String MIN_ENCRYPTION_VERSION = "0.9.7";
    private static final String MIN_RATCHET_VERSION = "0.9.46";

    public DatabaseLookupMessage(I2PAppContext context) {
        this(context, false);
    }

    public DatabaseLookupMessage(I2PAppContext context, boolean locallyCreated) {
        super(context);
    }

    public Hash getSearchKey() {
        return this._key;
    }

    public void setSearchKey(Hash key) {
        if (this._key != null) {
            throw new IllegalStateException();
        }
        this._key = key;
    }

    public Type getSearchType() {
        return this._type;
    }

    public void setSearchType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this._type = type;
    }

    public Hash getFrom() {
        return this._fromHash;
    }

    public void setFrom(Hash from) {
        if (this._fromHash != null) {
            throw new IllegalStateException();
        }
        this._fromHash = from;
    }

    public TunnelId getReplyTunnel() {
        return this._replyTunnel;
    }

    public void setReplyTunnel(TunnelId replyTunnel) {
        if (this._replyTunnel != null) {
            throw new IllegalStateException();
        }
        this._replyTunnel = replyTunnel;
    }

    public static boolean supportsEncryptedReplies(RouterInfo to) {
        if (to == null) {
            return false;
        }
        String v = to.getVersion();
        if (VersionComparator.comp(v, MIN_ENCRYPTION_VERSION) < 0) {
            return false;
        }
        RouterIdentity ident = to.getIdentity();
        EncType type = ident.getPublicKey().getType();
        return LeaseSetKeys.SET_BOTH.contains((Object)type);
    }

    public static boolean supportsRatchetReplies(RouterInfo to) {
        if (to == null) {
            return false;
        }
        String v = to.getVersion();
        if (VersionComparator.comp(v, MIN_RATCHET_VERSION) < 0) {
            return false;
        }
        RouterIdentity ident = to.getIdentity();
        EncType type = ident.getPublicKey().getType();
        return LeaseSetKeys.SET_BOTH.contains((Object)type);
    }

    public SessionKey getReplyKey() {
        return this._replyKey;
    }

    public SessionTag getReplyTag() {
        return this._replyTag;
    }

    public void setReplySession(SessionKey encryptKey, SessionTag encryptTag) {
        if (this._replyKey != null || this._replyTag != null || this._ratchetReplyTag != null || this._ratchetPubKey != null) {
            throw new IllegalStateException();
        }
        this._replyKey = encryptKey;
        this._replyTag = encryptTag;
    }

    public RatchetSessionTag getRatchetReplyTag() {
        return this._ratchetReplyTag;
    }

    public void setReplySession(SessionKey encryptKey, RatchetSessionTag encryptTag) {
        if (this._replyKey != null || this._replyTag != null || this._ratchetReplyTag != null || this._ratchetPubKey != null) {
            throw new IllegalStateException();
        }
        this._replyKey = encryptKey;
        this._ratchetReplyTag = encryptTag;
    }

    public PublicKey getRatchetPublicKey() {
        return this._ratchetPubKey;
    }

    public void setReplySession(PublicKey pubKey) {
        this._ratchetPubKey = pubKey;
    }

    public Set<Hash> getDontIncludePeers() {
        if (this._dontIncludePeers == null) {
            return null;
        }
        return new HashSet<Hash>(this._dontIncludePeers);
    }

    public void setDontIncludePeers(Collection<Hash> peers) {
        this._hasChecksum = false;
        this._dontIncludePeers = peers != null ? new ArrayList<Hash>(peers) : null;
    }

    public void addDontIncludePeer(Hash peer) {
        if (this._dontIncludePeers == null) {
            this._dontIncludePeers = new ArrayList<Hash>();
        } else if (this._dontIncludePeers.contains(peer)) {
            return;
        }
        this._hasChecksum = false;
        this._dontIncludePeers.add(peer);
    }

    public void addDontIncludePeers(Collection<Hash> peers) {
        this._hasChecksum = false;
        if (this._dontIncludePeers == null) {
            this._dontIncludePeers = new ArrayList<Hash>(peers);
        } else {
            for (Hash peer : peers) {
                if (this._dontIncludePeers.contains(peer)) continue;
                this._dontIncludePeers.add(peer);
            }
        }
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (type != 2) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._key = Hash.create(data, curIndex);
        this._fromHash = Hash.create(data, curIndex += 32);
        boolean tunnelSpecified = (data[curIndex += 32] & 1) != 0;
        boolean replyKeySpecified = (data[curIndex] & 2) != 0;
        boolean ratchetSpecified = (data[curIndex] & 0x10) != 0;
        switch (data[curIndex] & 0xC) {
            case 4: {
                this._type = Type.LS;
                break;
            }
            case 8: {
                this._type = Type.RI;
                break;
            }
            case 12: {
                this._type = Type.EXPL;
                break;
            }
            default: {
                this._type = Type.ANY;
            }
        }
        ++curIndex;
        if (tunnelSpecified) {
            this._replyTunnel = new TunnelId(DataHelper.fromLong(data, curIndex, 4));
            curIndex += 4;
        }
        int numPeers = (int)DataHelper.fromLong(data, curIndex, 2);
        curIndex += 2;
        if (numPeers < 0 || numPeers > 512) {
            throw new I2NPMessageException("Invalid number of peers - " + numPeers);
        }
        ArrayList<Hash> peers = numPeers > 0 ? new ArrayList<Hash>(numPeers) : null;
        for (int i = 0; i < numPeers; ++i) {
            Hash p = Hash.create(data, curIndex);
            curIndex += 32;
            peers.add(p);
        }
        this._dontIncludePeers = peers;
        if (replyKeySpecified || ratchetSpecified) {
            byte[] rk = new byte[32];
            System.arraycopy(data, curIndex, rk, 0, 32);
            if (replyKeySpecified && ratchetSpecified) {
                this._ratchetPubKey = new PublicKey(EncType.ECIES_X25519, rk);
            } else {
                this._replyKey = new SessionKey(rk);
            }
            curIndex += 32;
            if (!replyKeySpecified || !ratchetSpecified) {
                ++curIndex;
                if (replyKeySpecified) {
                    rt = new byte[32];
                    System.arraycopy(data, curIndex, rt, 0, 32);
                    this._replyTag = new SessionTag(rt);
                } else {
                    rt = new byte[8];
                    System.arraycopy(data, curIndex, rt, 0, 8);
                    this._ratchetReplyTag = new RatchetSessionTag(rt);
                }
            }
        }
    }

    @Override
    protected int calculateWrittenLength() {
        int totalLength = 0;
        totalLength += 64;
        ++totalLength;
        if (this._replyTunnel != null) {
            totalLength += 4;
        }
        totalLength += 2;
        if (this._dontIncludePeers != null) {
            totalLength += 32 * this._dontIncludePeers.size();
        }
        if (this._replyKey != null) {
            totalLength += 33;
            totalLength = this._ratchetReplyTag != null ? (totalLength += 8) : (totalLength += 32);
        } else if (this._ratchetPubKey != null) {
            totalLength += 32;
        }
        return totalLength;
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._key == null) {
            throw new I2NPMessageException("Key being searched for not specified");
        }
        if (this._fromHash == null) {
            throw new I2NPMessageException("From address not specified");
        }
        System.arraycopy(this._key.getData(), 0, out, curIndex, 32);
        System.arraycopy(this._fromHash.getData(), 0, out, curIndex += 32, 32);
        curIndex += 32;
        int flag = this._replyTag != null ? 2 : (this._ratchetReplyTag != null ? 16 : (this._ratchetPubKey != null ? 18 : 0));
        switch (this._type) {
            case LS: {
                flag = (byte)(flag | 4);
                break;
            }
            case RI: {
                flag = (byte)(flag | 8);
                break;
            }
            case EXPL: {
                flag = (byte)(flag | 0xC);
                break;
            }
        }
        if (this._replyTunnel != null) {
            flag = (byte)(flag | 1);
            out[curIndex++] = flag;
            DataHelper.toLong(out, curIndex, 4, this._replyTunnel.getTunnelId());
            curIndex += 4;
        } else {
            out[curIndex++] = flag;
        }
        if (this._dontIncludePeers == null || this._dontIncludePeers.isEmpty()) {
            out[curIndex++] = 0;
            out[curIndex++] = 0;
        } else {
            int size = this._dontIncludePeers.size();
            if (size > 512) {
                throw new I2NPMessageException("Too many peers: " + size);
            }
            DataHelper.toLong(out, curIndex, 2, size);
            curIndex += 2;
            for (Hash peer : this._dontIncludePeers) {
                System.arraycopy(peer.getData(), 0, out, curIndex, 32);
                curIndex += 32;
            }
        }
        if (this._replyKey != null) {
            System.arraycopy(this._replyKey.getData(), 0, out, curIndex, 32);
            curIndex += 32;
            out[curIndex++] = 1;
            if (this._replyTag != null) {
                System.arraycopy(this._replyTag.getData(), 0, out, curIndex, 32);
                curIndex += 32;
            } else {
                System.arraycopy(this._ratchetReplyTag.getData(), 0, out, curIndex, 8);
                curIndex += 8;
            }
        } else if (this._ratchetPubKey != null) {
            System.arraycopy(this._ratchetPubKey.getData(), 0, out, curIndex, this._ratchetPubKey.length());
            curIndex += this._ratchetPubKey.length();
        }
        return curIndex;
    }

    @Override
    public int getType() {
        return 2;
    }

    public int hashCode() {
        return DataHelper.hashCode(this._key) + DataHelper.hashCode(this._fromHash) + DataHelper.hashCode(this._replyTunnel) + DataHelper.hashCode(this._dontIncludePeers);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DatabaseLookupMessage) {
            DatabaseLookupMessage msg = (DatabaseLookupMessage)object;
            return DataHelper.eq(this._key, msg._key) && DataHelper.eq(this._fromHash, msg._fromHash) && DataHelper.eq(this._replyTunnel, msg._replyTunnel) && DataHelper.eq(this._dontIncludePeers, msg._dontIncludePeers);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("[DatabaseLookupMessage: ");
        buf.append("\n\tSearch Type: ").append((Object)this._type);
        buf.append("\n\tSearch Key: ");
        if (this._type == Type.LS) {
            buf.append(this._key.toBase32());
        } else {
            buf.append(this._key);
        }
        if (this._replyTunnel != null) {
            buf.append("\n\tReply GW: ");
        } else {
            buf.append("\n\tFrom: ");
        }
        buf.append(this._fromHash.toBase64());
        if (this._replyTunnel != null) {
            buf.append("\n\tReply Tunnel: ").append(this._replyTunnel);
        }
        if (this._replyKey != null) {
            buf.append("\n\tReply Key: ").append(this._replyKey);
        }
        if (this._replyTag != null) {
            buf.append("\n\tReply Tag: ").append(this._replyTag);
        } else if (this._ratchetReplyTag != null) {
            buf.append("\n\tRatchetReply Tag: ").append(this._ratchetReplyTag);
        }
        if (this._dontIncludePeers != null) {
            buf.append("\n\tDon't Include Peers: ");
            buf.append(this._dontIncludePeers.size());
        }
        buf.append("]");
        return buf.toString();
    }

    public static enum Type {
        ANY,
        LS,
        RI,
        EXPL;

    }
}

