/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import java.util.Date;
import java.util.List;
import java.util.Map;

public final class Metadata {
    private final int binaryFormatMajorVersion;
    private final int binaryFormatMinorVersion;
    private final long buildEpoch;
    private final String databaseType;
    private final Map<String, String> description;
    private final int ipVersion;
    private final List<String> languages;
    private final int nodeByteSize;
    private final int nodeCount;
    private final int recordSize;
    private final int searchTreeSize;

    Metadata(Map metadata) {
        this.binaryFormatMajorVersion = Metadata.getInt(metadata, "binary_format_major_version");
        this.binaryFormatMinorVersion = Metadata.getInt(metadata, "binary_format_minor_version");
        this.buildEpoch = Metadata.getLong(metadata, "build_epoch");
        this.databaseType = Metadata.getString(metadata, "database_type");
        this.languages = (List)metadata.get("languages");
        this.description = (Map)metadata.get("description");
        this.ipVersion = Metadata.getInt(metadata, "ip_version");
        this.nodeCount = Metadata.getInt(metadata, "node_count");
        this.recordSize = Metadata.getInt(metadata, "record_size");
        this.nodeByteSize = this.recordSize / 4;
        this.searchTreeSize = this.nodeCount * this.nodeByteSize;
    }

    private static int getInt(Object m, String key) {
        Map map = (Map)m;
        Number i = (Number)map.get(key);
        if (i != null) {
            return i.intValue();
        }
        return 0;
    }

    private static long getLong(Object m, String key) {
        Map map = (Map)m;
        Number i = (Number)map.get(key);
        if (i != null) {
            return i.longValue();
        }
        return 0L;
    }

    private static String getString(Object m, String key) {
        Map map = (Map)m;
        return (String)map.get(key);
    }

    public int getBinaryFormatMajorVersion() {
        return this.binaryFormatMajorVersion;
    }

    public int getBinaryFormatMinorVersion() {
        return this.binaryFormatMinorVersion;
    }

    public Date getBuildDate() {
        return new Date(this.buildEpoch * 1000L);
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, String> getDescription() {
        return this.description;
    }

    public int getIpVersion() {
        return this.ipVersion;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    int getNodeByteSize() {
        return this.nodeByteSize;
    }

    int getNodeCount() {
        return this.nodeCount;
    }

    int getRecordSize() {
        return this.recordSize;
    }

    int getSearchTreeSize() {
        return this.searchTreeSize;
    }

    public String toString() {
        return "Metadata [binaryFormatMajorVersion=" + this.binaryFormatMajorVersion + ", binaryFormatMinorVersion=" + this.binaryFormatMinorVersion + ", buildEpoch=" + this.buildEpoch + ", databaseType=" + this.databaseType + ", description=" + String.valueOf(this.description) + ", ipVersion=" + this.ipVersion + ", nodeCount=" + this.nodeCount + ", recordSize=" + this.recordSize + "]";
    }
}

