/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.gettext.GettextResource;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.util.ConcurrentHashSet;

public abstract class Translate {
    public static final String PROP_LANG = "routerconsole.lang";
    public static final String PROP_COUNTRY = "routerconsole.country";
    private static final String _localeLang = Locale.getDefault().getLanguage();
    private static final String _localeCountry = Locale.getDefault().getCountry();
    private static final Map<String, ResourceBundle> _bundles = new ConcurrentHashMap<String, ResourceBundle>(16);
    private static final Set<String> _missing = new ConcurrentHashSet<String>(16);
    private static final String TEST_LANG = "xx";
    private static final String TEST_STRING = "XXXX";

    public static String getString(String key, I2PAppContext ctx, String bun) {
        if (key == null) {
            new NullPointerException("null translation string").printStackTrace();
            return "";
        }
        String lang = Translate.getLanguage(ctx);
        if (lang.equals("en")) {
            return key;
        }
        if (lang.equals(TEST_LANG)) {
            return TEST_STRING;
        }
        if (key.equals("")) {
            return key;
        }
        ResourceBundle bundle = Translate.findBundle(bun, lang, Translate.getCountry(ctx));
        if (bundle == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getString(String s, Object o, I2PAppContext ctx, String bun) {
        return Translate.getString(s, ctx, bun, o);
    }

    public static String getString(String s, Object o, Object o2, I2PAppContext ctx, String bun) {
        return Translate.getString(s, ctx, bun, o, o2);
    }

    public static String getString(String s, I2PAppContext ctx, String bun, Object ... oArray) {
        String lang = Translate.getLanguage(ctx);
        if (lang.equals(TEST_LANG)) {
            return TEST_STRING + Arrays.toString(oArray) + TEST_STRING;
        }
        String x = Translate.getString(s, ctx, bun);
        try {
            MessageFormat fmt = new MessageFormat(x, new Locale(lang));
            return fmt.format(oArray, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Bad format: orig: \"" + s + "\" trans: \"" + x + "\" params: " + Arrays.toString(oArray) + " lang: " + lang);
            return "FIXME: " + x + " " + Arrays.toString(oArray);
        }
    }

    public static String getString(int n, String s, String p, I2PAppContext ctx, String bun) {
        String lang = Translate.getLanguage(ctx);
        if (lang.equals(TEST_LANG)) {
            return "XXXX(" + n + ")XXXX";
        }
        ResourceBundle bundle = null;
        if (!lang.equals("en")) {
            bundle = Translate.findBundle(bun, lang, Translate.getCountry(ctx));
        }
        String x = bundle == null ? (n == 1 ? s : p) : GettextResource.ngettext(bundle, s, p, n);
        Object[] oArray = new Object[]{n};
        try {
            MessageFormat fmt = new MessageFormat(x, new Locale(lang));
            return fmt.format(oArray, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Bad format: sing: \"" + s + "\" plural: \"" + p + "\" lang: " + lang);
            return "FIXME: " + s + " " + p + "," + n;
        }
    }

    public static String getLanguage(I2PAppContext ctx) {
        String lang = ctx.getProperty(PROP_LANG);
        if (lang == null || lang.length() <= 0) {
            lang = _localeLang;
        }
        return lang;
    }

    public static boolean isRTL(I2PAppContext ctx) {
        return Translate.isRTL(Translate.getLanguage(ctx));
    }

    public static boolean isRTL(String lang) {
        return lang.equals("ar") || lang.equals("fa") || lang.equals("iw");
    }

    public static String getCountry(I2PAppContext ctx) {
        return ctx.getProperty(PROP_COUNTRY, _localeCountry);
    }

    public static void setLanguage(String lang, String country) {
        if (lang != null) {
            System.setProperty(PROP_LANG, lang);
        } else {
            System.clearProperty(PROP_LANG);
        }
        if (country != null) {
            System.setProperty(PROP_COUNTRY, country);
        } else {
            System.clearProperty(PROP_COUNTRY);
        }
    }

    private static ResourceBundle findBundle(String bun, String lang, String country) {
        String key = bun + "-" + lang + "-" + country;
        ResourceBundle rv = _bundles.get(key);
        if (rv == null && !_missing.contains(key)) {
            if ("".equals(lang)) {
                _missing.add(key);
                return null;
            }
            try {
                Locale loc = "".equals(country) ? new Locale(lang) : new Locale(lang, country);
                rv = ResourceBundle.getBundle(bun, loc, Thread.currentThread().getContextClassLoader());
                if (rv != null) {
                    _bundles.put(key, rv);
                }
            }
            catch (MissingResourceException e) {
                _missing.add(key);
            }
        }
        return rv;
    }

    public static String getDisplayLanguage(String langCode, String dflt, I2PAppContext ctx, String bun) {
        String curLang = Translate.getLanguage(ctx);
        if (!"en".equals(curLang)) {
            String rv = Translate.getString(dflt, ctx, bun);
            if (!rv.equals(dflt)) {
                return rv;
            }
            Locale curLocale = new Locale(curLang);
            rv = new Locale(langCode).getDisplayLanguage(curLocale);
            if (rv.length() > 0 && !rv.equals(langCode)) {
                return rv;
            }
        }
        return dflt;
    }

    public static void clearCache() {
        _missing.clear();
        _bundles.clear();
        ResourceBundle.clearCache();
    }
}

