/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.BandwidthEstimator;
import net.i2p.util.Log;

public class SyntheticREDQueue
implements BandwidthEstimator {
    private final I2PAppContext _context;
    private final Log _log;
    private long _tAck;
    private float _bKFiltered;
    private float _bK_ns_est;
    private int _acked;
    private int _count = -1;
    private float _avgQSize;
    private float _qSize;
    private int _newDataSize;
    private long _tQSize;
    private final int _minth;
    private final int _maxth;
    private final int _bwBps;
    private final float _bwBpms;
    private static final float MAXP = 0.02f;
    private static final int DECAY_FACTOR = 8;
    private static final int WESTWOOD_RTT_MIN = 500;
    private static final int DEFAULT_LOW_THRESHOLD = 13;
    private static final int DEFAULT_HIGH_THRESHOLD = 3;

    public SyntheticREDQueue(I2PAppContext ctx, int bwBps) {
        this(ctx, bwBps, bwBps / 13, bwBps / 3);
    }

    SyntheticREDQueue(I2PAppContext ctx, int bwBps, int minThB, int maxThB) {
        this._log = ctx.logManager().getLog(SyntheticREDQueue.class);
        this._context = ctx;
        this._tAck = ctx.clock().now();
        this._acked = -1;
        this._minth = minThB;
        this._maxth = maxThB;
        this._bwBps = bwBps;
        this._bwBpms = (float)bwBps / 1000.0f;
        this._tQSize = this._tAck;
        if (this._log.shouldDebug()) {
            this._log.debug("Configured " + bwBps + " BPS, min: " + minThB + " B, max: " + maxThB + " B");
        }
    }

    public int getMaxBandwidth() {
        return this._bwBps;
    }

    @Override
    public void addSample(int size) {
        this.offer(size, 0.0f);
    }

    public boolean offer(int size, float factor) {
        long now = this._context.clock().now();
        return this.addSample(size, factor, now);
    }

    private synchronized boolean addSample(int acked, float factor, long now) {
        if (this._acked < 0) {
            float bkdt;
            long deltaT = Math.max(now - this._tAck, 500L);
            this._bKFiltered = bkdt = (float)acked / (float)deltaT;
            this._bK_ns_est = bkdt;
            this._acked = 0;
            this._tAck = now;
            this._tQSize = now;
            this._newDataSize = acked;
            if (this._log.shouldDebug()) {
                this._log.debug("first sample bytes: " + acked + " deltaT: " + deltaT + " " + String.valueOf(this));
            }
            return true;
        }
        long deltaT = now - this._tQSize;
        if (deltaT > 500L) {
            this.updateQSize(now, deltaT);
        }
        if (factor > 0.0f) {
            if (this._avgQSize > (float)this._maxth) {
                if (this._log.shouldWarn()) {
                    this._log.warn("drop bytes (qsize): " + acked + " " + String.valueOf(this));
                }
                this._count = 0;
                return false;
            }
            if (this._avgQSize > (float)this._minth) {
                ++this._count;
                float pb = (float)acked / 1024.0f * factor * 0.02f * (this._avgQSize - (float)this._minth) / (float)(this._maxth - this._minth);
                float pa = pb / (1.0f - (float)this._count * pb);
                float rand = this._context.random().nextFloat();
                if (rand < pa) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("drop bytes (prob): " + acked + " factor " + factor + " prob: " + pa + " deltaT: " + deltaT + " " + String.valueOf(this));
                    }
                    this._count = 0;
                    return false;
                }
                this._count = -1;
            }
        }
        this._newDataSize += acked;
        this._acked += acked;
        deltaT = now - this._tAck;
        if (deltaT >= 500L) {
            this.computeBWE(now, (int)deltaT);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("accept bytes: " + acked + " factor " + factor + " " + String.valueOf(this));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getBandwidthEstimate() {
        long now = this._context.clock().now();
        SyntheticREDQueue syntheticREDQueue = this;
        synchronized (syntheticREDQueue) {
            long deltaT = now - this._tAck;
            if (deltaT >= 500L) {
                return this.computeBWE(now, (int)deltaT);
            }
            return this._bKFiltered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getQueueSizeEstimate() {
        long now = this._context.clock().now();
        SyntheticREDQueue syntheticREDQueue = this;
        synchronized (syntheticREDQueue) {
            long deltaT = now - this._tQSize;
            if (deltaT >= 500L) {
                this.updateQSize(now, deltaT);
            }
            return this._avgQSize;
        }
    }

    private synchronized float computeBWE(long now, int rtt) {
        if (this._acked < 0) {
            return 0.0f;
        }
        this.updateBK(now, this._acked, rtt);
        this._acked = 0;
        return this._bKFiltered;
    }

    private void decay() {
        this._bK_ns_est *= 0.875f;
        this._bKFiltered = SyntheticREDQueue.westwood_do_filter(this._bKFiltered, this._bK_ns_est);
    }

    private void decayQueue(int rtt) {
        this._qSize -= (float)rtt * this._bwBpms;
        if (this._qSize < 1.0f) {
            this._qSize = 0.0f;
        }
        this._avgQSize = SyntheticREDQueue.westwood_do_filter(this._avgQSize, this._qSize);
    }

    private void updateBK(long time, int packets, int rtt) {
        long deltaT = time - this._tAck;
        if (rtt < 500) {
            rtt = 500;
        }
        if (deltaT > (long)(2 * rtt)) {
            int numrtts = Math.min((int)(deltaT / (long)rtt - 1L), 16);
            for (int i = 0; i < numrtts && !(this._bKFiltered <= 0.0f); ++i) {
                this.decay();
            }
            deltaT -= (long)(numrtts * rtt);
        }
        if (packets > 0) {
            float bkdt = (float)packets / (float)deltaT;
            this._bK_ns_est = SyntheticREDQueue.westwood_do_filter(this._bK_ns_est, bkdt);
            this._bKFiltered = SyntheticREDQueue.westwood_do_filter(this._bKFiltered, this._bK_ns_est);
        } else {
            float bkdt = 0.0f;
            this.decay();
        }
        this._tAck = time;
    }

    private void updateQSize(long time, long deltaT) {
        long origDT = deltaT;
        if (deltaT > 1000L) {
            int numrtts = Math.min((int)(deltaT / 500L - 1L), 16);
            for (int i = 0; i < numrtts && !(this._avgQSize <= 0.0f); ++i) {
                this.decayQueue(500);
            }
            deltaT -= (long)(numrtts * 500);
        }
        int origNDS = this._newDataSize;
        float newQSize = this._newDataSize;
        if (this._newDataSize > 0) {
            if ((newQSize -= (float)deltaT * this._bwBpms) < 1.0f) {
                newQSize = 0.0f;
            }
            this._qSize = SyntheticREDQueue.westwood_do_filter(this._qSize, newQSize);
            this._avgQSize = SyntheticREDQueue.westwood_do_filter(this._avgQSize, this._qSize);
            this._newDataSize = 0;
        } else {
            this.decayQueue((int)deltaT);
        }
        this._tQSize = time;
        if (this._log.shouldDebug()) {
            this._log.debug("computeQS deltaT: " + origDT + " newData: " + origNDS + " newQsize: " + newQSize + " qSize: " + this._qSize + " " + String.valueOf(this));
        }
    }

    private static float westwood_do_filter(float a, float b) {
        return (7.0f * a + b) / 8.0f;
    }

    public synchronized String toString() {
        return "SREDQ[ " + DataHelper.formatSize2Decimal((long)(this._bKFiltered * 1000.0f), false) + "Bps, avg_qsize " + DataHelper.formatSize2((long)this._avgQSize, false) + "B, limit " + DataHelper.formatSize2Decimal(this._bwBps, false) + "Bps]";
    }
}

