/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.i2p.crypto.EncType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.KeyCertificate;
import net.i2p.data.SDSCache;
import net.i2p.data.SimpleDataStructure;

public class PublicKey
extends SimpleDataStructure {
    private static final EncType DEF_TYPE = EncType.ELGAMAL_2048;
    public static final int KEYSIZE_BYTES = DEF_TYPE.getPubkeyLen();
    private static final int CACHE_SIZE = 1024;
    private static final SDSCache<PublicKey> _cache = new SDSCache<PublicKey>(PublicKey.class, KEYSIZE_BYTES, 1024);
    private final EncType _type;
    private final int _unknownTypeCode;

    public static PublicKey create(byte[] data, int off) {
        return _cache.get(data, off);
    }

    public static PublicKey create(InputStream in) throws IOException {
        return _cache.get(in);
    }

    public PublicKey() {
        this(DEF_TYPE);
    }

    public PublicKey(EncType type) {
        this._type = type;
        this._unknownTypeCode = type != null ? type.getCode() : -1;
    }

    public PublicKey(byte[] data) {
        this(DEF_TYPE, data);
    }

    public PublicKey(EncType type, byte[] data) {
        this(type);
        if (data == null) {
            throw new IllegalArgumentException("Data must be specified");
        }
        this.setData(data);
    }

    public PublicKey(int typeCode, byte[] data) {
        this._type = null;
        if (data == null) {
            throw new IllegalArgumentException("Data must be specified");
        }
        this._data = data;
        if (typeCode <= 0 || typeCode > 255) {
            throw new IllegalArgumentException();
        }
        this._unknownTypeCode = typeCode;
    }

    public PublicKey(String base64Data) throws DataFormatException {
        this(DEF_TYPE);
        this.fromBase64(base64Data);
    }

    @Override
    public int length() {
        if (this._type != null) {
            return this._type.getPubkeyLen();
        }
        if (this._data != null) {
            return this._data.length;
        }
        return KEYSIZE_BYTES;
    }

    public EncType getType() {
        return this._type;
    }

    public int getUnknownTypeCode() {
        return this._unknownTypeCode;
    }

    PublicKey toTypedKey(KeyCertificate kcert) {
        if (this._data == null) {
            throw new IllegalStateException();
        }
        EncType newType = kcert.getEncType();
        if (this._type == newType) {
            return this;
        }
        if (this._type != EncType.ELGAMAL_2048) {
            throw new IllegalArgumentException("Cannot convert " + String.valueOf((Object)this._type) + " to " + String.valueOf((Object)newType));
        }
        if (newType == null) {
            return new PublicKey(null, this._data);
        }
        int newLen = newType.getPubkeyLen();
        if (newLen == KEYSIZE_BYTES) {
            return new PublicKey(newType, this._data);
        }
        byte[] newData = new byte[newLen];
        if (newLen >= KEYSIZE_BYTES) {
            throw new IllegalArgumentException("TODO");
        }
        System.arraycopy(this._data, 0, newData, 0, newLen);
        return new PublicKey(newType, newData);
    }

    public byte[] getPadding(KeyCertificate kcert) {
        if (this._data == null) {
            throw new IllegalStateException();
        }
        EncType newType = kcert.getEncType();
        if (this._type == newType || newType == null) {
            return null;
        }
        if (this._type != EncType.ELGAMAL_2048) {
            throw new IllegalStateException("Cannot convert " + String.valueOf((Object)this._type) + " to " + String.valueOf((Object)newType));
        }
        int newLen = newType.getPubkeyLen();
        if (newLen >= KEYSIZE_BYTES) {
            return null;
        }
        int padLen = KEYSIZE_BYTES - newLen;
        byte[] pad = new byte[padLen];
        System.arraycopy(this._data, this._data.length - padLen, pad, 0, padLen);
        return pad;
    }

    public static void clearCache() {
        _cache.clear();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[PublicKey ").append((String)(this._type != null ? this._type.toString() : "unknown type: " + this._unknownTypeCode)).append(' ');
        if (this._data == null) {
            buf.append("null");
        } else {
            int length = this.length();
            if (length <= 32) {
                buf.append(this.toBase64());
            } else {
                buf.append("size: ").append(length);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        return DataHelper.hashCode((Object)this._type) ^ super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PublicKey)) {
            return false;
        }
        PublicKey s = (PublicKey)obj;
        return this._type == s._type && Arrays.equals(this._data, s._data);
    }
}

