/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.impl.HandlerImpl;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.SessionStatusMessage;

class SessionStatusMessageHandler
extends HandlerImpl {
    public SessionStatusMessageHandler(I2PAppContext context) {
        super(context, 20);
    }

    @Override
    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + String.valueOf(message));
        }
        SessionStatusMessage msg = (SessionStatusMessage)message;
        session.setSessionId(msg.getSessionId());
        switch (msg.getStatus()) {
            case 1: {
                this._log.info("Session created successfully");
                break;
            }
            case 0: {
                this._log.warn("Session destroyed");
                break;
            }
            case 3: {
                this._log.warn("Session invalid");
                session.propogateError("Invalid", new I2PSessionException("Session Status Message received"));
                session.destroySession();
                break;
            }
            case 2: {
                this._log.info("Session status updated");
                break;
            }
            default: {
                if (!this._log.shouldLog(30)) break;
                this._log.warn("Unknown session status sent: " + msg.getStatus());
            }
        }
    }
}

