/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet.filters;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKeyFile;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.Log;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class XI2PLocationFilter
extends Handler.Wrapper {
    private String X_I2P_Location = null;
    private long lastFailure = -1L;
    private static final long failTimeout = 600000L;
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(XI2PLocationFilter.class);

    private synchronized void setLocation(String xi2plocation) {
        if (this._log.shouldInfo()) {
            this._log.info("Checking X-I2P-Location header prefix: " + xi2plocation);
        }
        if (this.X_I2P_Location != null) {
            return;
        }
        if (xi2plocation == null) {
            return;
        }
        if (xi2plocation.equals("")) {
            return;
        }
        this.X_I2P_Location = xi2plocation;
        if (this._log.shouldInfo()) {
            this._log.info("Caching X-I2P-Location header prefix: " + this.X_I2P_Location);
        }
    }

    private synchronized boolean shouldRecheck() {
        boolean settable;
        boolean bl = settable = this.X_I2P_Location == null;
        if (!settable) {
            return settable;
        }
        if (this.lastFailure == -1L) {
            this.lastFailure = System.currentTimeMillis();
            if (this._log.shouldDebug()) {
                this._log.debug("New instance, attempting to set X-I2P-Location header for the first time");
            }
            return settable;
        }
        if (System.currentTimeMillis() - this.lastFailure > 600000L) {
            this.lastFailure = System.currentTimeMillis();
            if (this._log.shouldDebug()) {
                this._log.debug("More than ten minutes since failing attempt to re-check X-I2P-Location header");
            }
            return settable;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Not attempting to re-check X-I2P-Location header");
        }
        return false;
    }

    private synchronized String getXI2PLocation(String host, String port) {
        File configDir = I2PAppContext.getGlobalContext().getConfigDir();
        File tunnelConfig = new File(configDir, "i2ptunnel.config");
        boolean isSingleFile = tunnelConfig.exists();
        if (!isSingleFile) {
            File tunnelConfigD;
            File[] configFiles;
            if (host.startsWith("[") && host.endsWith("]")) {
                host = host.substring(1, host.length() - 1);
            }
            if ((configFiles = (tunnelConfigD = new File(configDir, "i2ptunnel.config.d")).listFiles((FileFilter)new FileSuffixFilter(".config"))) == null) {
                return null;
            }
            for (int fnum = 0; fnum < configFiles.length; ++fnum) {
                Properties tunnelProps = new Properties();
                try {
                    boolean hostmatch;
                    DataHelper.loadProps((Properties)tunnelProps, (File)configFiles[fnum]);
                    String targetHost = tunnelProps.getProperty("targetHost");
                    boolean bl = hostmatch = host.equals(targetHost) || "0.0.0.0".equals(targetHost) || "::".equals(targetHost);
                    if (!hostmatch || !port.equals(tunnelProps.getProperty("targetPort"))) continue;
                    String sh = tunnelProps.getProperty("spoofedHost");
                    if (sh != null && sh.endsWith(".i2p")) {
                        return sh;
                    }
                    String kf = tunnelProps.getProperty("privKeyFile");
                    if (kf != null) {
                        File keyFile = new File(kf);
                        if (!keyFile.isAbsolute()) {
                            keyFile = new File(configDir, kf);
                        }
                        if (keyFile.exists()) {
                            PrivateKeyFile pkf = new PrivateKeyFile(keyFile);
                            try {
                                Destination rv = pkf.getDestination();
                                if (rv != null) {
                                    return rv.toBase32();
                                }
                            }
                            catch (I2PException e) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("I2PException Unable to set X-I2P-Location, keys arent ready. This is probably safe to ignore and will go away after the first run." + String.valueOf((Object)e));
                                }
                                return null;
                            }
                            catch (IOException e) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("IOE Unable to set X-I2P-Location, location is uninitialized due file not found. This probably means the keys aren't ready. This is probably safe to ignore." + String.valueOf(e));
                                }
                                return null;
                            }
                        }
                    }
                    if (this._log.shouldWarn()) {
                        this._log.warn("Unable to set X-I2P-Location, location is target not found in any I2PTunnel config file. This should never happen.");
                    }
                    return null;
                }
                catch (IOException ioe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("IOE Unable to set X-I2P-Location, location is uninitialized. This is probably safe to ignore. location='" + String.valueOf(ioe) + "'");
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private synchronized String headerContents(Request request) {
        HttpURI uri = request.getHttpURI();
        if (this.X_I2P_Location != null) {
            String scheme = uri.getScheme();
            if (scheme == null) {
                return null;
            }
            String path = uri.getPath();
            if (path == null) {
                path = "/";
            }
            String query = uri.getQuery();
            int port = uri.getPort();
            StringBuilder buf = new StringBuilder(256);
            buf.append(scheme).append("://").append(this.X_I2P_Location);
            if (port > 0) {
                buf.append(':').append(port);
            }
            buf.append(path);
            if (query != null) {
                buf.append('?').append(query);
            }
            return buf.toString();
        }
        return null;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String hashHeader = request.getHeaders().get("X-I2P-DestHash");
        if (hashHeader == null) {
            String headerURL;
            if (this.shouldRecheck()) {
                String xi2plocation = this.getXI2PLocation(Request.getLocalAddr((Request)request), String.valueOf(Request.getLocalPort((Request)request)));
                if (this._log.shouldInfo()) {
                    this._log.info("Checking X-I2P-Location header: IP " + Request.getLocalAddr((Request)request) + " port " + Request.getLocalPort((Request)request) + " prefix " + xi2plocation);
                }
                if (xi2plocation != null) {
                    this.setLocation(xi2plocation);
                }
            }
            if ((headerURL = this.headerContents(request)) != null) {
                if (this._log.shouldInfo()) {
                    this._log.info("Setting X-I2P-Location header: " + headerURL);
                }
                response.getHeaders().put("X-I2P-Location", headerURL);
            }
        }
        return super.handle(request, response, callback);
    }
}

