/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet;

import java.io.File;
import java.io.FileFilter;
import net.i2p.I2PAppContext;
import net.i2p.util.FileSuffixFilter;
import org.eclipse.jetty.ee8.servlet.ErrorPageErrorHandler;

public class I2PErrorHandler
extends ErrorPageErrorHandler {
    private final File _docroot;
    private static final String RESOURCES = ".resources";

    public I2PErrorHandler() {
        this(new File(I2PAppContext.getGlobalContext().getConfigDir(), "eepsite/docroot"));
    }

    public I2PErrorHandler(String docroot) {
        this(new File(docroot));
    }

    public I2PErrorHandler(File docroot) {
        this._docroot = docroot;
        this.setShowServlet(false);
        this.setShowStacks(false);
        this.setErrorPages();
    }

    private void setErrorPages() {
        File dir = new File(this._docroot, RESOURCES);
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles((FileFilter)new FileSuffixFilter(".html"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            int code;
            String name = file.getName();
            if (name.equals("000.html")) {
                this.addErrorPage("org.eclipse.jetty.server.error_page.global", "/.resources/000.html");
                continue;
            }
            if (name.equals("4xx.html")) {
                this.addErrorPage(400, 499, "/.resources/4xx.html");
                continue;
            }
            if (name.equals("5xx.html")) {
                this.addErrorPage(500, 599, "/.resources/5xx.html");
                continue;
            }
            if (name.length() != 8 || !name.startsWith("4") && !name.startsWith("5")) continue;
            try {
                code = Integer.parseInt(name.substring(0, 3));
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            this.addErrorPage(code, "/.resources/" + name);
        }
    }
}

