/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.jetty;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.xml.XmlParser;
import org.xml.sax.SAXException;

public class JettyXmlConfigurationParser {
    private static XmlParser initParser() {
        XmlParser parser = new XmlParser();
        return parser;
    }

    public static XmlParser.Node parse(File f) throws SAXException, IOException {
        return JettyXmlConfigurationParser.initParser().parse(f);
    }

    public static String getValue(XmlParser.Node node, String name) {
        String nameLC = name.toLowerCase(Locale.US);
        for (Object o : node) {
            if (!(o instanceof XmlParser.Node)) continue;
            XmlParser.Node n = (XmlParser.Node)o;
            String tag = n.getTag();
            if (tag != null && "set".equals(tag.toLowerCase(Locale.US))) {
                String aname = n.getAttribute("name");
                if (aname == null || !aname.toLowerCase(Locale.US).equals(nameLC)) continue;
                return n.toString(false);
            }
            String rv = JettyXmlConfigurationParser.getValue(n, name);
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    public static boolean setValue(XmlParser.Node node, String name, String value) {
        String nameLC = name.toLowerCase(Locale.US);
        for (Object o : node) {
            if (!(o instanceof XmlParser.Node)) continue;
            XmlParser.Node n = (XmlParser.Node)o;
            String tag = n.getTag();
            if (tag != null && "set".equals(tag.toLowerCase(Locale.US))) {
                String aname = n.getAttribute("name");
                if (aname == null || !aname.toLowerCase(Locale.US).equals(nameLC)) continue;
                n.clear();
                n.add(0);
                n.clear();
                n.add(value);
                return true;
            }
            boolean rv = JettyXmlConfigurationParser.setValue(n, name, value);
            if (!rv) continue;
            return rv;
        }
        return false;
    }

    public static void write(XmlParser.Node node, Writer out) throws IOException {
        int size;
        out.write(60);
        String tag = node.getTag();
        out.write(tag);
        XmlParser.Attribute[] attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                out.write(32);
                out.write(attrs[i].getName());
                out.write("=\"");
                out.write(attrs[i].getValue());
                out.write(34);
            }
        }
        if ((size = node.size()) > 0) {
            out.write(">");
            for (int i = 0; i < size; ++i) {
                Object o = node.get(i);
                if (o == null) continue;
                if (o instanceof XmlParser.Node) {
                    JettyXmlConfigurationParser.write((XmlParser.Node)o, out);
                    continue;
                }
                out.write(o.toString());
            }
            out.write("</");
            out.write(tag);
            out.write(">\n");
        } else {
            out.write("/>\n");
        }
    }

    public static String obfuscate(String s) {
        if (s.startsWith("OBF:")) {
            return s;
        }
        return Password.obfuscate((String)s);
    }

    public static String deobfuscate(String s) {
        if (!s.startsWith("OBF:")) {
            return s;
        }
        return Password.deobfuscate((String)s);
    }
}

