/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.IValidatable;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class OptJTextAreaBinding
implements Binding,
ActionListener {
    private final String _property;
    private final String _stateProperty;
    private final JToggleButton _button;
    private final JTextArea _textArea;
    private final Color _validColor;

    public OptJTextAreaBinding(String property, String stateProperty, JToggleButton button, JTextArea textArea) {
        if (property == null || button == null || textArea == null) {
            throw new NullPointerException();
        }
        if (property.equals("")) {
            throw new IllegalArgumentException();
        }
        this._property = property;
        this._stateProperty = stateProperty;
        this._button = button;
        this._textArea = textArea;
        this._validColor = this._textArea.getBackground();
        button.addActionListener(this);
    }

    @Override
    public String getProperty() {
        return this._property;
    }

    @Override
    public void clear(IValidatable bean) {
        this.put(bean);
    }

    @Override
    public void put(IValidatable bean) {
        try {
            boolean selected = "true".equals(BeanUtils.getProperty(bean, this._stateProperty));
            this._button.setSelected(selected);
            this._textArea.setEnabled(selected);
            List list = (List)PropertyUtils.getProperty(bean, this._property);
            StringBuffer sb = new StringBuffer();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    sb.append(list.get(i));
                    if (i >= list.size() - 1) continue;
                    sb.append("\n");
                }
            }
            this._textArea.setText(sb.toString());
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void get(IValidatable bean) {
        try {
            String text = this._textArea.getText();
            if (this._button.isSelected() && !text.equals("")) {
                String[] items = text.split("\n");
                ArrayList<String> list = new ArrayList<String>();
                for (String s : items) {
                    list.add(s);
                }
                PropertyUtils.setProperty(bean, this._property, list);
            } else {
                PropertyUtils.setProperty(bean, this._property, null);
            }
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void markValid() {
        this._textArea.setBackground(this._validColor);
        this._textArea.requestFocusInWindow();
    }

    @Override
    public void markInvalid() {
        this._textArea.setBackground(Binding.INVALID_COLOR);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._textArea.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._textArea.setEnabled(this._button.isSelected());
    }
}

