/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.OsVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Housekeeper {
    private List<CleanupClient> cleanupClients = new ArrayList<CleanupClient>();
    private static final Logger logger = Logger.getLogger(Housekeeper.class.getName());

    public void registerForCleanup(CleanupClient client) {
        if (client instanceof Librarian) {
            this.cleanupClients.add(0, client);
        } else {
            this.cleanupClients.add(client);
        }
    }

    public void shutDown(int exitCode) {
        this.shutDown(exitCode, false);
    }

    public void shutDown(int exitCode, boolean reboot) {
        for (int i = this.cleanupClients.size() - 1; i >= 0; --i) {
            try {
                this.cleanupClients.get(i).cleanUp();
                continue;
            }
            catch (Throwable exception) {
                logger.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        this.terminate(exitCode, reboot);
    }

    protected void terminate(int exitCode, boolean reboot) {
        if (reboot) {
            try {
                this.systemReboot();
            }
            catch (IOException exception) {
                logger.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        System.exit(exitCode);
    }

    private void systemReboot() throws IOException {
        int waitseconds = 2;
        if (OsVersion.IS_UNIX) {
            Runtime.getRuntime().exec("sudo /sbin/shutdown -r -t 2 now");
        } else if (OsVersion.IS_WINDOWS) {
            Runtime.getRuntime().exec("shutdown /r /f /t 2");
        } else {
            throw new IOException("Reboot not implemented for your OS");
        }
    }
}

