/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.requirement;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.installer.RequirementChecker;
import com.izforge.izpack.api.rules.ComparisonOperator;
import com.izforge.izpack.core.rules.process.CompareVersionsMajorCondition;

public class JavaVersionChecker
implements RequirementChecker {
    private final InstallData installData;
    private final Prompt prompt;

    public JavaVersionChecker(InstallData installData, Prompt prompt) {
        this.installData = installData;
        this.prompt = prompt;
    }

    @Override
    public boolean check() {
        String version = this.getJavaVersion();
        String required = this.installData.getInfo().getJavaVersion();
        if (required == null || version == null) {
            return true;
        }
        CompareVersionsMajorCondition comparator = new CompareVersionsMajorCondition();
        comparator.setInstallData(this.installData);
        comparator.setLeftOperand(version);
        comparator.setRightOperand(required);
        comparator.setOperator(ComparisonOperator.GREATEREQUAL);
        if (!comparator.isTrue()) {
            this.versionNotAvailable(version, required);
            return false;
        }
        return true;
    }

    protected void versionNotAvailable(String version, String requiredVersion) {
        this.prompt.message(Prompt.Type.ERROR, this.getVersionNotAvailable(version, requiredVersion));
    }

    protected String getVersionNotAvailable(String version, String requiredVersion) {
        StringBuilder msg = new StringBuilder();
        msg.append("The application that you are trying to install requires a ");
        msg.append(requiredVersion);
        msg.append(" version or later of the Java platform.\n");
        msg.append("You are running a ");
        msg.append(version);
        msg.append(" version of the Java platform.\n");
        msg.append("Please upgrade to a newer version.");
        return msg.toString();
    }

    protected String getJavaVersion() {
        return System.getProperty("java.version");
    }
}

