/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.MasterSession;
import net.i2p.sam.ReadLine;
import net.i2p.sam.SAMBridge;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMMessageSession;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.SAMv1Handler;
import net.i2p.sam.SAMv3DatagramServer;
import net.i2p.sam.SAMv3DatagramSession;
import net.i2p.sam.SAMv3RawSession;
import net.i2p.sam.SAMv3StreamSession;
import net.i2p.sam.Session;
import net.i2p.sam.SessionRecord;
import net.i2p.sam.SessionsDB;
import net.i2p.util.PasswordManager;

class SAMv3Handler
extends SAMv1Handler {
    private Session session;
    public static final SessionsDB sSessionsHash = new SessionsDB();
    private volatile boolean stolenSocket;
    private volatile boolean streamForwardingSocket;
    private final boolean sendPorts;
    private long _lastPing;
    private static final int FIRST_READ_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 180000;
    private static final String AUTH_ERROR = "AUTH STATUS RESULT=I2P_ERROR";

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor, SAMBridge parent) throws SAMException, IOException {
        this(s, verMajor, verMinor, new Properties(), parent);
    }

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps, SAMBridge parent) throws SAMException, IOException {
        super(s, verMajor, verMinor, i2cpProps, parent);
        boolean bl = this.sendPorts = verMajor == 3 && verMinor >= 2 || verMajor > 3;
        if (this._log.shouldLog(10)) {
            this._log.debug("SAM version 3 handler instantiated");
        }
    }

    @Override
    public boolean verifVersion() {
        return this.verMajor == 3;
    }

    public String getClientIP() {
        return this.socket.socket().getInetAddress().getHostAddress();
    }

    public void stealSocket() {
        this.stolenSocket = true;
        if (this.sendPorts) {
            try {
                this.socket.socket().setSoTimeout(0);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        this.stopHandling();
    }

    SAMBridge getBridge() {
        return this.bridge;
    }

    Session getSession() {
        return this.session;
    }

    void setSession(SAMv3RawSession sess) {
        this.rawSession = sess;
        this.session = sess;
    }

    void setSession(SAMv3DatagramSession sess) {
        this.datagramSession = sess;
        this.session = sess;
    }

    void setSession(SAMv3StreamSession sess) {
        this.streamSession = sess;
        this.session = sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() {
        String msg = null;
        String domain = null;
        String opcode = null;
        boolean canContinue = false;
        this.thread.setName("SAMv3Handler " + this._id);
        if (this._log.shouldLog(10)) {
            this._log.debug("SAMv3 handling started");
        }
        try {
            Socket socket = this.getClientSocket().socket();
            StringBuilder buf = new StringBuilder(1024);
            boolean gotFirstLine = false;
            while (true) {
                Properties props;
                String line;
                block87: {
                    if (this.shouldStop()) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Stop request found");
                        }
                        break;
                    }
                    if (this.sendPorts) {
                        try {
                            ReadLine.readLine(socket, buf, 180000);
                            line = buf.toString();
                            buf.setLength(0);
                            break block87;
                        }
                        catch (SocketTimeoutException ste) {
                            long now = System.currentTimeMillis();
                            if (buf.length() <= 0) {
                                if (this._lastPing > 0L) {
                                    if (now - this._lastPing >= 180000L) {
                                        if (this._log.shouldWarn()) {
                                            this._log.warn("Failed to respond to PING");
                                        }
                                        this.writeString("SESSION STATUS RESULT=I2P_ERROR", "PONG timeout");
                                        break;
                                    }
                                } else {
                                    if (this._log.shouldDebug()) {
                                        this._log.debug("Sendng PING " + now);
                                    }
                                    this._lastPing = now;
                                    if (!this.writeString("PING " + now + '\n')) {
                                        break;
                                    }
                                }
                            } else if (this._lastPing > 0L) {
                                if (now - this._lastPing >= 360000L) {
                                    if (this._log.shouldWarn()) {
                                        this._log.warn("Failed to respond to PING");
                                    }
                                    this.writeString("SESSION STATUS RESULT=I2P_ERROR", "PONG timeout");
                                    break;
                                }
                            } else {
                                if (this._lastPing < 0L) {
                                    if (this._log.shouldWarn()) {
                                        this._log.warn("2nd timeout");
                                    }
                                    this.writeString("SESSION STATUS RESULT=I2P_ERROR", "command timeout, bye");
                                    break;
                                }
                                this._lastPing = -1L;
                                if (this._log.shouldWarn()) {
                                    this._log.warn("timeout after partial: " + buf);
                                }
                            }
                            if (!this._log.shouldDebug()) continue;
                            this._log.debug("loop after timeout");
                            continue;
                        }
                    }
                    buf.setLength(0);
                    try {
                        ReadLine.readLine(socket, buf, gotFirstLine ? 0 : 60000);
                        socket.setSoTimeout(0);
                    }
                    catch (SocketTimeoutException ste) {
                        this.writeString("SESSION STATUS RESULT=I2P_ERROR", "command timeout, bye");
                        break;
                    }
                    line = buf.toString();
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("New message received: [" + line + ']');
                }
                if ((domain = (String)(props = SAMUtils.parseParams(line)).remove("\"\"COMMAND\"\"")) == null) {
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Ignoring newline");
                    continue;
                }
                gotFirstLine = true;
                opcode = (String)props.remove("\"\"OPCODE\"\"");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Parsing (domain: \"" + domain + "\"; opcode: \"" + opcode + "\")");
                }
                if (domain.equals("PING")) {
                    this.execPingMessage(opcode);
                    continue;
                }
                if (domain.equals("PONG")) {
                    this.execPongMessage(opcode);
                    continue;
                }
                if (domain.equals("QUIT") || domain.equals("STOP") || domain.equals("EXIT")) {
                    this.writeString(domain + " STATUS RESULT=OK MESSAGE=bye\n");
                    break;
                }
                if (opcode == null) {
                    if (this.writeString(domain + " STATUS RESULT=I2P_ERROR", "command not specified")) {
                        continue;
                    }
                    break;
                }
                if (domain.equals("STREAM")) {
                    canContinue = this.execStreamMessage(opcode, props);
                } else if (domain.equals("SESSION")) {
                    if (this.i2cpProps != null) {
                        props.putAll((Map<?, ?>)this.i2cpProps);
                    }
                    canContinue = this.execSessionMessage(opcode, props);
                } else if (domain.equals("DEST")) {
                    canContinue = this.execDestMessage(opcode, props);
                } else if (domain.equals("NAMING")) {
                    canContinue = this.execNamingMessage(opcode, props);
                } else if (domain.equals("DATAGRAM")) {
                    canContinue = this.execDatagramMessage(opcode, props);
                } else if (domain.equals("RAW")) {
                    canContinue = this.execRawMessage(opcode, props);
                } else {
                    if (!domain.equals("AUTH")) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Unrecognized message domain: \"" + domain + "\"");
                        }
                        break;
                    }
                    canContinue = this.execAuthMessage(opcode, props);
                }
                if (!canContinue) break;
            }
        }
        catch (IOException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Caught IOException in handler", e);
            }
            this.writeString("SESSION STATUS RESULT=I2P_ERROR", e.getMessage());
        }
        catch (SAMException e) {
            this._log.error("Unexpected exception for message [" + msg + ']', e);
            this.writeString("SESSION STATUS RESULT=I2P_ERROR", e.getMessage());
        }
        catch (RuntimeException e) {
            this._log.error("Unexpected exception for message [" + msg + ']', e);
            this.writeString("SESSION STATUS RESULT=I2P_ERROR", e.getMessage());
        }
        finally {
            block89: {
                block88: {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Stopping handler");
                    }
                    if (!this.stolenSocket) {
                        try {
                            this.closeClientSocket();
                        }
                        catch (IOException e) {
                            if (!this._log.shouldWarn()) break block88;
                            this._log.warn("Error closing socket", e);
                        }
                    }
                }
                if (this.streamForwardingSocket && this.getStreamSession() != null) {
                    try {
                        ((SAMv3StreamSession)this.streamSession).stopForwardingIncoming();
                    }
                    catch (SAMException e) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Error while stopping forwarding connections", e);
                        }
                    }
                    catch (InterruptedIOException e) {
                        if (!this._log.shouldWarn()) break block89;
                        this._log.warn("Interrupted while stopping forwarding connections", e);
                    }
                }
            }
            this.die();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopHandling() {
        if (this._log.shouldInfo()) {
            this._log.info("Stopping (stolen? " + this.stolenSocket + "): " + this, new Exception("I did it"));
        }
        Object object = this.stopLock;
        synchronized (object) {
            this.stopHandler = true;
        }
        if (!this.stolenSocket) {
            try {
                this.closeClientSocket();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.bridge.unregister(this);
    }

    private void die() {
        SessionRecord rec = null;
        if (this.session != null) {
            this.session.close();
            rec = sSessionsHash.get(this.session.getNick());
        }
        if (rec != null) {
            rec.getThreadGroup().interrupt();
            while (rec.getThreadGroup().activeCount() > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            rec.getThreadGroup().destroy();
            sSessionsHash.del(this.session.getNick());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean execSessionMessage(String opcode, Properties props) {
        String dest = "BUG!";
        boolean ok = false;
        String nick = (String)props.remove("ID");
        if (nick == null) {
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR", "ID not specified");
        }
        String style = (String)props.remove("STYLE");
        if (style == null && !opcode.equals("REMOVE")) {
            return this.writeString("SESSION STATUS RESULT=I2P_ERROR", "No SESSION STYLE specified");
        }
        try {
            if (opcode.equals("CREATE")) {
                Session v3;
                SAMv3DatagramServer dgs;
                if (this.getRawSession() != null || this.getDatagramSession() != null || this.getStreamSession() != null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Trying to create a session, but one still exists");
                    }
                    boolean bl = this.writeString("SESSION STATUS RESULT=I2P_ERROR", "Session already exists");
                    return bl;
                }
                if (props.isEmpty()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("No parameters specified in SESSION CREATE message");
                    }
                    boolean bl = this.writeString("SESSION STATUS RESULT=I2P_ERROR", "No parameters for SESSION CREATE");
                    return bl;
                }
                dest = (String)props.remove("DESTINATION");
                if (dest == null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("SESSION DESTINATION parameter not specified");
                    }
                    boolean bl = this.writeString("SESSION STATUS RESULT=I2P_ERROR", "DESTINATION not specified");
                    return bl;
                }
                if (dest.equals("TRANSIENT")) {
                    SigType sigType;
                    String sigTypeStr;
                    if (this._log.shouldLog(10)) {
                        this._log.debug("TRANSIENT destination requested");
                    }
                    if ((sigTypeStr = (String)props.remove("SIGNATURE_TYPE")) != null) {
                        sigType = SigType.parseSigType(sigTypeStr);
                        if (sigType == null) {
                            boolean bl = this.writeString("SESSION STATUS RESULT=I2P_ERROR", "SIGNATURE_TYPE " + sigTypeStr + " unsupported");
                            return bl;
                        }
                    } else {
                        sigType = SigType.DSA_SHA1;
                    }
                    ByteArrayOutputStream priv = new ByteArrayOutputStream(663);
                    SAMUtils.genRandomKey(priv, null, sigType);
                    dest = Base64.encode(priv.toByteArray());
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Custom destination specified [" + dest + "]");
                    }
                    if (!SAMUtils.checkPrivateDestination(dest)) {
                        boolean sigTypeStr = this.writeString("SESSION STATUS RESULT=INVALID_KEY\n");
                        return sigTypeStr;
                    }
                }
                this.i2cpProps.setProperty("i2cp.messageReliability", "none");
                this.i2cpProps.setProperty("i2cp.fastReceive", "true");
                Properties allProps = new Properties();
                allProps.putAll((Map<?, ?>)this.i2cpProps);
                allProps.putAll((Map<?, ?>)props);
                if (style.equals("MASTER")) {
                    allProps.setProperty("i2p.streaming.enforceProtocol", "true");
                    allProps.setProperty("i2cp.dontPublishLeaseSet", "false");
                }
                try {
                    sSessionsHash.put(nick, new SessionRecord(dest, allProps, this));
                }
                catch (SessionsDB.ExistingIdException e) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("SESSION ID parameter already in use");
                    }
                    boolean priv = this.writeString("SESSION STATUS RESULT=DUPLICATED_ID\n");
                    if (!ok && nick != null) {
                        sSessionsHash.del(nick);
                        this.session = null;
                    }
                    return priv;
                }
                catch (SessionsDB.ExistingDestException e) {
                    boolean priv;
                    block60: {
                        priv = this.writeString("SESSION STATUS RESULT=DUPLICATED_DEST\n");
                        if (ok || nick == null) break block60;
                        sSessionsHash.del(nick);
                        this.session = null;
                    }
                    return priv;
                }
                if (style.equals("RAW")) {
                    dgs = this.bridge.getV3DatagramServer(props);
                    v3 = new SAMv3RawSession(nick, dgs);
                    this.rawSession = v3;
                    this.session = v3;
                    ((SAMMessageSession)((Object)v3)).start();
                } else if (style.equals("DATAGRAM")) {
                    dgs = this.bridge.getV3DatagramServer(props);
                    v3 = new SAMv3DatagramSession(nick, dgs);
                    this.datagramSession = v3;
                    this.session = v3;
                    ((SAMMessageSession)((Object)v3)).start();
                } else if (style.equals("STREAM")) {
                    SAMv3StreamSession v32 = SAMv3Handler.newSAMStreamSession(nick);
                    this.streamSession = v32;
                    this.session = v32;
                    v32.start();
                } else if (style.equals("MASTER")) {
                    dgs = this.bridge.getV3DatagramServer(props);
                    v3 = new MasterSession(nick, dgs, this, allProps);
                    this.streamSession = v3;
                    this.datagramSession = v3;
                    this.rawSession = v3;
                    this.session = v3;
                    ((MasterSession)v3).start();
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Unrecognized SESSION STYLE: \"" + style + "\"");
                    }
                    boolean dgs2 = this.writeString("SESSION STATUS RESULT=I2P_ERROR", "Unrecognized SESSION STYLE");
                    return dgs2;
                }
                ok = true;
                boolean dgs2 = this.writeString("SESSION STATUS RESULT=OK DESTINATION=" + dest + "\n");
                return dgs2;
            }
            if (opcode.equals("ADD") || opcode.equals("REMOVE")) {
                ok = true;
                if (this.streamSession == null || this.datagramSession == null || this.rawSession == null) {
                    boolean allProps = this.writeString("SESSION STATUS RESULT=I2P_ERROR", "Not a MASTER session");
                    return allProps;
                }
                MasterSession msess = (MasterSession)this.session;
                String msg = opcode.equals("ADD") ? msess.add(nick, style, props) : msess.remove(nick, props);
                if (msg == null) {
                    boolean bl = this.writeString("SESSION STATUS RESULT=OK ID=\"" + nick + '\"', opcode + ' ' + nick);
                    return bl;
                }
                boolean bl = this.writeString("SESSION STATUS RESULT=I2P_ERROR ID=\"" + nick + '\"', msg);
                return bl;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Unrecognized SESSION message opcode: \"" + opcode + "\"");
            }
            boolean msess = this.writeString("SESSION STATUS RESULT=I2P_ERROR", "Unrecognized opcode");
            return msess;
            {
                catch (DataFormatException e) {
                    this._log.error("Invalid SAM destination specified", e);
                    boolean bl = this.writeString("SESSION STATUS RESULT=INVALID_KEY", e.getMessage());
                    return bl;
                }
                catch (I2PSessionException e) {
                    this._log.error("Failed to start SAM session", e);
                    boolean bl = this.writeString("SESSION STATUS RESULT=I2P_ERROR", e.getMessage());
                    return bl;
                }
                catch (SAMException e) {
                    this._log.error("Failed to start SAM session", e);
                    boolean bl = this.writeString("SESSION STATUS RESULT=I2P_ERROR", e.getMessage());
                    return bl;
                }
                catch (IOException e) {
                    this._log.error("Failed to start SAM session", e);
                    boolean bl = this.writeString("SESSION STATUS RESULT=I2P_ERROR", e.getMessage());
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!ok && nick != null) {
                sSessionsHash.del(nick);
                this.session = null;
            }
        }
    }

    private static SAMv3StreamSession newSAMStreamSession(String login) throws IOException, DataFormatException, SAMException {
        return new SAMv3StreamSession(login);
    }

    @Override
    protected boolean execStreamMessage(String opcode, Properties props) {
        String nick = null;
        SessionRecord rec = null;
        if (this.session != null) {
            this._log.error("v3 control socket cannot be used for STREAM");
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "v3 control socket cannot be used for STREAM");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        nick = (String)props.remove("ID");
        if (nick == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("SESSION ID parameter not specified");
            }
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "ID not specified");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        rec = sSessionsHash.get(nick);
        if (rec == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("STREAM SESSION ID does not exist");
            }
            try {
                this.notifyStreamResult(true, "INVALID_ID", "STREAM SESSION ID " + nick + " does not exist");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        this.streamSession = rec.getHandler().streamSession;
        if (this.streamSession == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("specified ID is not a stream session");
            }
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "specified ID " + nick + " is not a STREAM session");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        if (opcode.equals("CONNECT")) {
            return this.execStreamConnect(props);
        }
        if (opcode.equals("ACCEPT")) {
            return this.execStreamAccept(props);
        }
        if (opcode.equals("FORWARD")) {
            return this.execStreamForwardIncoming(props);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized STREAM message opcode: \"" + opcode + "\"");
        }
        try {
            this.notifyStreamResult(true, "I2P_ERROR", "Unrecognized STREAM message opcode: " + opcode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected boolean execStreamConnect(Properties props) {
        boolean verbose = !Boolean.parseBoolean(props.getProperty("SILENT"));
        try {
            if (props.isEmpty()) {
                this.notifyStreamResult(verbose, "I2P_ERROR", "No parameters specified in STREAM CONNECT message");
                if (this._log.shouldLog(10)) {
                    this._log.debug("No parameters specified in STREAM CONNECT message");
                }
                return false;
            }
            String dest = (String)props.remove("DESTINATION");
            if (dest == null) {
                this.notifyStreamResult(verbose, "I2P_ERROR", "Destination not specified in STREAM CONNECT message");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Destination not specified in STREAM CONNECT message");
                }
                return false;
            }
            try {
                ((SAMv3StreamSession)this.streamSession).connect(this, dest, props);
                return true;
            }
            catch (DataFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid destination in STREAM CONNECT message");
                }
                this.notifyStreamResult(verbose, "INVALID_KEY", e.getMessage());
            }
            catch (ConnectException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "CONNECTION_REFUSED", e.getMessage());
            }
            catch (NoRouteToHostException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "CANT_REACH_PEER", e.getMessage());
            }
            catch (InterruptedIOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "TIMEOUT", e.getMessage());
            }
            catch (I2PException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean execStreamForwardIncoming(Properties props) {
        try {
            try {
                this.streamForwardingSocket = true;
                ((SAMv3StreamSession)this.streamSession).startForwardingIncoming(props, this.sendPorts);
                this.notifyStreamResult(true, "OK", null);
                return true;
            }
            catch (SAMException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Forwarding STREAM connections failed", e);
                }
                this.notifyStreamResult(true, "I2P_ERROR", "Forwarding failed : " + e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean execStreamAccept(Properties props) {
        boolean verbose = !Boolean.parseBoolean(props.getProperty("SILENT"));
        try {
            try {
                this.notifyStreamResult(verbose, "OK", null);
                ((SAMv3StreamSession)this.streamSession).accept(this, verbose);
                return true;
            }
            catch (InterruptedIOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM ACCEPT failed", e);
                }
                this.notifyStreamResult(verbose, "TIMEOUT", e.getMessage());
            }
            catch (I2PException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM ACCEPT failed", e);
                }
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
            catch (SAMException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM ACCEPT failed", e);
                }
                this.notifyStreamResult(verbose, "ALREADY_ACCEPTING", e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void notifyStreamResult(boolean verbose, String result, String message) throws IOException {
        if (!verbose) {
            return;
        }
        String msgString = SAMv3Handler.createMessageString(message);
        String out = "STREAM STATUS RESULT=" + result + msgString + '\n';
        if (!this.writeString(out)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public void notifyStreamIncomingConnection(Destination d, int fromPort, int toPort) throws IOException {
        if (this.getStreamSession() == null) {
            this._log.error("BUG! Received stream connection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        StringBuilder buf = new StringBuilder(600);
        buf.append(d.toBase64());
        if (this.sendPorts) {
            buf.append(" FROM_PORT=").append(fromPort).append(" TO_PORT=").append(toPort);
        }
        buf.append('\n');
        if (!this.writeString(buf.toString())) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static void notifyStreamIncomingConnection(SocketChannel client, Destination d) throws IOException {
        if (!SAMv3Handler.writeString(d.toBase64() + "\n", client)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static void notifyStreamIncomingConnection(SocketChannel client, Destination d, int fromPort, int toPort) throws IOException {
        if (!SAMv3Handler.writeString(d.toBase64() + " FROM_PORT=" + fromPort + " TO_PORT=" + toPort + '\n', client)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    private boolean execAuthMessage(String opcode, Properties props) {
        String user;
        if (opcode.equals("ENABLE")) {
            this.i2cpProps.setProperty("sam.auth", "true");
        } else if (opcode.equals("DISABLE")) {
            this.i2cpProps.setProperty("sam.auth", "false");
        } else if (opcode.equals("ADD")) {
            user = props.getProperty("USER");
            String pw = props.getProperty("PASSWORD");
            if (user == null || pw == null) {
                return this.writeString(AUTH_ERROR, "USER and PASSWORD required");
            }
            String prop = "sam.auth." + user + ".shash";
            if (this.i2cpProps.containsKey(prop)) {
                return this.writeString(AUTH_ERROR, "user " + user + " already exists");
            }
            PasswordManager pm = new PasswordManager(I2PAppContext.getGlobalContext());
            String shash = pm.createHash(pw);
            this.i2cpProps.setProperty(prop, shash);
        } else if (opcode.equals("REMOVE")) {
            user = props.getProperty("USER");
            if (user == null) {
                return this.writeString(AUTH_ERROR, "USER required");
            }
            String prop = "sam.auth." + user + ".shash";
            if (!this.i2cpProps.containsKey(prop)) {
                return this.writeString(AUTH_ERROR, "user " + user + " not found");
            }
            this.i2cpProps.remove(prop);
        } else {
            return this.writeString(AUTH_ERROR, "Unknown AUTH command");
        }
        try {
            this.bridge.saveConfig();
            return this.writeString("AUTH STATUS RESULT=OK\n");
        }
        catch (IOException ioe) {
            return this.writeString(AUTH_ERROR, "Config save failed: " + ioe);
        }
    }

    private void execPingMessage(String msg) {
        StringBuilder buf = new StringBuilder();
        buf.append("PONG");
        if (msg != null) {
            buf.append(' ').append(msg);
        }
        buf.append('\n');
        this.writeString(buf.toString());
    }

    private void execPongMessage(String s) {
        if (s == null) {
            s = "";
        }
        if (this._lastPing > 0L) {
            String expected = Long.toString(this._lastPing);
            if (expected.equals(s)) {
                this._lastPing = 0L;
                if (this._log.shouldInfo()) {
                    this._log.warn("Got expected pong: " + s);
                }
            } else if (this._log.shouldInfo()) {
                this._log.warn("Got unexpected pong: " + s);
            }
        } else if (this._log.shouldWarn()) {
            this._log.warn("Pong received without a ping: " + s);
        }
    }
}

