/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMInvalidDirectionException;
import net.i2p.sam.SAMMessageSess;
import net.i2p.sam.SAMStreamReceiver;
import net.i2p.sam.SAMUtils;
import net.i2p.util.ByteCache;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

class SAMStreamSession
implements SAMMessageSess {
    protected final Log _log;
    protected static final int SOCKET_HANDLER_BUF_SIZE = 32768;
    protected final SAMStreamReceiver recv;
    protected final SAMStreamSessionServer server;
    protected final I2PSocketManager socketMgr;
    private final HashMap<Integer, SAMStreamSessionSocketReader> handlersMap = new HashMap();
    private final HashMap<Integer, StreamSender> sendersMap = new HashMap();
    private final AtomicInteger lastNegativeId = new AtomicInteger();
    protected final boolean canCreate;
    private final int listenProtocol;
    private final int listenPort;
    protected final boolean _isOwnSession;
    protected final boolean forceFlush;
    public static final String PROP_FORCE_FLUSH = "sam.forceFlush";
    public static final String DEFAULT_FORCE_FLUSH = "false";

    public SAMStreamSession(String dest, String dir, Properties props, SAMStreamReceiver recv) throws IOException, DataFormatException, SAMException {
        this(new ByteArrayInputStream(Base64.decode(dest)), dir, props, recv);
    }

    protected SAMStreamSession(InputStream destStream, String dir, Properties props, SAMStreamReceiver recv) throws IOException, DataFormatException, SAMException {
        boolean startAcceptor;
        boolean canReceive;
        this.recv = recv;
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
        if (dir.equals("BOTH")) {
            this.canCreate = true;
            canReceive = true;
            startAcceptor = true;
        } else if (dir.equals("__v3__")) {
            this.canCreate = true;
            canReceive = true;
            startAcceptor = false;
        } else if (dir.equals("CREATE")) {
            this.canCreate = true;
            canReceive = false;
            startAcceptor = false;
        } else if (dir.equals("RECEIVE")) {
            this.canCreate = false;
            canReceive = true;
            startAcceptor = true;
        } else {
            this._log.error("BUG! Wrong direction passed to SAMStreamSession: " + dir);
            throw new SAMException("BUG! Wrong direction specified!");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("SAM STREAM session instantiated");
        }
        Properties allprops = (Properties)System.getProperties().clone();
        allprops.putAll((Map<?, ?>)props);
        String i2cpHost = allprops.getProperty("i2cp.tcp.host", "127.0.0.1");
        int i2cpPort = 7654;
        String sport = allprops.getProperty("i2cp.tcp.port");
        if (sport != null) {
            try {
                i2cpPort = Integer.parseInt(sport);
            }
            catch (NumberFormatException nfe) {
                throw new SAMException("Invalid I2CP port specified [" + sport + "]");
            }
        }
        if (!canReceive) {
            allprops.setProperty("i2cp.dontPublishLeaseSet", "true");
        }
        if (!allprops.containsKey("inbound.nickname") && !allprops.containsKey("outbound.nickname")) {
            allprops.setProperty("inbound.nickname", "SAM TCP Client");
            allprops.setProperty("outbound.nickname", "SAM TCP Client");
        }
        this._isOwnSession = true;
        if (this._log.shouldLog(10)) {
            this._log.debug("Creating I2PSocketManager...");
        }
        try {
            this.socketMgr = I2PSocketManagerFactory.createDisconnectedManager(destStream, i2cpHost, i2cpPort, allprops);
            this.socketMgr.getSession().connect();
        }
        catch (I2PSessionException ise) {
            throw new SAMException("Error creating I2PSocketManager: " + ise.getMessage(), ise);
        }
        this.socketMgr.addDisconnectListener(new DisconnectListener());
        this.forceFlush = Boolean.parseBoolean(allprops.getProperty(PROP_FORCE_FLUSH, DEFAULT_FORCE_FLUSH));
        this.listenProtocol = Boolean.parseBoolean(props.getProperty("i2p.streaming.enforceProtocol")) ? 6 : 0;
        this.listenPort = 0;
        this.server = startAcceptor ? new SAMStreamSessionServer() : null;
    }

    protected SAMStreamSession(I2PSocketManager mgr, Properties props, SAMStreamReceiver recv, int listenport) throws IOException, DataFormatException, SAMException {
        this.recv = recv;
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
        if (this._log.shouldLog(10)) {
            this._log.debug("SAM STREAM session instantiated");
        }
        this.canCreate = true;
        Properties allprops = (Properties)System.getProperties().clone();
        allprops.putAll((Map<?, ?>)props);
        this._isOwnSession = false;
        this.socketMgr = mgr;
        this.socketMgr.addDisconnectListener(new DisconnectListener());
        this.forceFlush = Boolean.parseBoolean(allprops.getProperty(PROP_FORCE_FLUSH, DEFAULT_FORCE_FLUSH));
        this.listenProtocol = 6;
        this.listenPort = listenport;
        this.server = null;
    }

    @Override
    public void start() {
        if (this.server != null) {
            I2PAppThread t = new I2PAppThread(this.server, "SAMStreamSessionServer");
            ((Thread)t).start();
        }
    }

    @Override
    public int getListenProtocol() {
        return this.listenProtocol;
    }

    @Override
    public int getListenPort() {
        return this.listenPort;
    }

    @Override
    public Destination getDestination() {
        return this.socketMgr.getSession().getMyDestination();
    }

    public boolean connect(int id, String dest, Properties props) throws I2PException, ConnectException, NoRouteToHostException, DataFormatException, InterruptedIOException, SAMInvalidDirectionException, IOException {
        if (!this.canCreate) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Trying to create an outgoing connection using a receive-only session");
            }
            throw new SAMInvalidDirectionException("Trying to create connections through a receive-only session");
        }
        if (this.checkSocketHandlerId(id)) {
            if (this._log.shouldLog(10)) {
                this._log.debug("The specified id (" + id + ") is already in use");
            }
            return false;
        }
        Destination d = SAMUtils.getDest(dest);
        I2PSocketOptions opts = this.socketMgr.buildOptions(props);
        if (props.getProperty("i2p.streaming.connectTimeout") == null) {
            opts.setConnectTimeout(60000L);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Connecting new I2PSocket...");
        }
        I2PSocket i2ps = this.socketMgr.connect(d, opts);
        this.createSocketHandler(i2ps, id);
        this.recv.notifyStreamOutgoingConnection(id, "OK", null);
        return true;
    }

    public boolean sendBytes(int id, InputStream in, int size) throws IOException {
        StreamSender sender = this.getSender(id);
        if (sender == null) {
            int c;
            if (this._log.shouldLog(30)) {
                this._log.warn("Trying to send bytes through nonexistent handler " + id);
            }
            for (int i = 0; i < size && (c = in.read()) != -1; ++i) {
            }
            return false;
        }
        sender.sendBytes(in, size);
        return true;
    }

    @Override
    public void close() {
        if (this.server != null) {
            this.server.stopRunning();
        }
        this.removeAllSocketHandlers();
        this.recv.stopStreamReceiving();
        if (this._isOwnSession) {
            this.socketMgr.destroySocketManager();
        }
    }

    public boolean closeConnection(int id) {
        if (!this.checkSocketHandlerId(id)) {
            if (this._log.shouldLog(10)) {
                this._log.debug("The specified id (" + id + ") does not exist!");
            }
            return false;
        }
        this.removeSocketHandler(id);
        return true;
    }

    @Override
    public boolean sendBytes(String s, byte[] b, int pr, int fp, int tp) throws I2PSessionException {
        throw new I2PSessionException("Unsupported in STREAM or MASTER session");
    }

    @Override
    public boolean sendBytes(String s, byte[] b, int pr, int fp, int tp, boolean sendLeaseSet, int sendTags, int tagThreshold, int expiration) throws I2PSessionException {
        throw new I2PSessionException("Unsupported in STREAM or MASTER session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int createSocketHandler(I2PSocket s, int id) {
        StreamSender sender;
        SAMStreamSessionSocketReader reader;
        if (id == 0) {
            id = this.createUniqueId();
        }
        try {
            reader = this.newSAMStreamSessionSocketReader(s, id);
            sender = this.newStreamSender(s, id);
        }
        catch (IOException e) {
            this._log.error("IOException when creating SAM STREAM session socket handler", e);
            this.recv.stopStreamReceiving();
            return 0;
        }
        HashMap<Integer, SAMStreamSessionSocketReader> e = this.handlersMap;
        synchronized (e) {
            this.handlersMap.put(id, reader);
            this.sendersMap.put(id, sender);
        }
        I2PAppThread t = new I2PAppThread(reader, "SAMReader" + id);
        t.start();
        t = new I2PAppThread(sender, "SAMSender" + id);
        t.start();
        return id;
    }

    private int createUniqueId() {
        return this.lastNegativeId.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SAMStreamSessionSocketReader getSocketReader(int id) {
        HashMap<Integer, SAMStreamSessionSocketReader> hashMap = this.handlersMap;
        synchronized (hashMap) {
            return this.handlersMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSender getSender(int id) {
        HashMap<Integer, SAMStreamSessionSocketReader> hashMap = this.handlersMap;
        synchronized (hashMap) {
            return this.sendersMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkSocketHandlerId(int id) {
        HashMap<Integer, SAMStreamSessionSocketReader> hashMap = this.handlersMap;
        synchronized (hashMap) {
            return this.handlersMap.get(id) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSocketHandler(int id) {
        StreamSender sender;
        SAMStreamSessionSocketReader reader;
        HashMap<Integer, SAMStreamSessionSocketReader> hashMap = this.handlersMap;
        synchronized (hashMap) {
            Integer iid = id;
            reader = this.handlersMap.remove(iid);
            sender = this.sendersMap.remove(iid);
        }
        if (reader != null) {
            reader.stopRunning();
        }
        if (sender != null) {
            sender.shutDownGracefully();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Removed SAM STREAM session socket handler (gracefully) " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllSocketHandlers() {
        HashMap<Integer, SAMStreamSessionSocketReader> hashMap = this.handlersMap;
        synchronized (hashMap) {
            for (Map.Entry<Integer, SAMStreamSessionSocketReader> e : this.handlersMap.entrySet()) {
                Integer id = e.getKey();
                e.getValue().stopRunning();
                this.sendersMap.get(id).shutDownGracefully();
            }
            this.handlersMap.clear();
            this.sendersMap.clear();
        }
    }

    boolean setReceiveLimit(int id, long limit, boolean nolimit) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Protocol v1 does not support a receive limit for streams");
        }
        return false;
    }

    protected SAMStreamSessionSocketReader newSAMStreamSessionSocketReader(I2PSocket s, int id) throws IOException {
        return new SAMv1StreamSessionSocketReader(s, id);
    }

    protected StreamSender newStreamSender(I2PSocket s, int id) throws IOException {
        return new V1StreamSender(s, id);
    }

    private class V1StreamSender
    extends StreamSender {
        private final List<ByteArray> _data;
        private final ByteCache _cache;
        private final OutputStream _out;
        private volatile boolean _stillRunning;
        private volatile boolean _shuttingDownGracefully;
        private final Object runningLock;

        public V1StreamSender(I2PSocket s, int id) throws IOException {
            super(s, id);
            this.runningLock = new Object();
            this._data = new ArrayList<ByteArray>(1);
            this._cache = ByteCache.getInstance(4, 32768);
            this._out = s.getOutputStream();
            this._stillRunning = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendBytes(InputStream in, int size) throws IOException {
            ByteArray ba;
            int read;
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("Handler " + this._id + ": sending " + size + " bytes");
            }
            if ((read = DataHelper.read(in, (ba = (ByteArray)this._cache.acquire()).getData(), 0, size)) != size) {
                throw new IOException("Insufficient data from the SAM client (" + read + "/" + size + ")");
            }
            ba.setValid(read);
            List<ByteArray> list = this._data;
            synchronized (list) {
                this._data.add(ba);
                this._data.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopRunning() {
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("stopRunning() invoked on socket sender " + this._id);
            }
            Object object = this.runningLock;
            synchronized (object) {
                if (this._stillRunning) {
                    block10: {
                        this._stillRunning = false;
                        try {
                            this.i2pSocket.close();
                        }
                        catch (IOException e) {
                            if (!SAMStreamSession.this._log.shouldLog(10)) break block10;
                            SAMStreamSession.this._log.debug("Caught IOException", e);
                        }
                    }
                    List<ByteArray> list = this._data;
                    synchronized (list) {
                        this._data.clear();
                        this._data.notifyAll();
                    }
                }
            }
        }

        @Override
        public void shutDownGracefully() {
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("shutDownGracefully() invoked on socket sender " + this._id);
            }
            this._shuttingDownGracefully = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<ByteArray> list;
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("run() called for socket sender " + this._id);
            }
            ByteArray data = null;
            while (this._stillRunning) {
                data = null;
                try {
                    list = this._data;
                    synchronized (list) {
                        if (!this._data.isEmpty()) {
                            data = this._data.remove(0);
                        } else {
                            if (this._shuttingDownGracefully) {
                                this.stopRunning();
                                break;
                            }
                            this._data.wait(5000L);
                        }
                    }
                    if (data == null) continue;
                    try {
                        this._out.write(data.getData(), 0, data.getValid());
                        if (!SAMStreamSession.this.forceFlush) continue;
                        this._out.flush();
                    }
                    catch (IOException ioe) {
                        if (SAMStreamSession.this._log.shouldLog(30)) {
                            SAMStreamSession.this._log.warn("Stream failed", ioe);
                        }
                        SAMStreamSession.this.removeSocketHandler(this._id);
                        this.stopRunning();
                    }
                    finally {
                        this._cache.release(data);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            list = this._data;
            synchronized (list) {
                this._data.clear();
            }
        }
    }

    protected static abstract class StreamSender
    implements Runnable {
        protected final int _id;
        protected final I2PSocket i2pSocket;

        public StreamSender(I2PSocket s, int id) throws IOException {
            this._id = id;
            this.i2pSocket = s;
        }

        public abstract void sendBytes(InputStream var1, int var2) throws IOException;

        public abstract void stopRunning();

        public abstract void shutDownGracefully();

        @Override
        public abstract void run();
    }

    public class SAMv1StreamSessionSocketReader
    extends SAMStreamSessionSocketReader {
        public SAMv1StreamSessionSocketReader(I2PSocket s, int id) throws IOException {
            super(s, id);
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("Instantiating new SAM STREAM session socket reader");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopRunning() {
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("stopRunning() invoked on socket reader " + this.id);
            }
            Object object = this.runningLock;
            synchronized (object) {
                if (this.stillRunning) {
                    this.stillRunning = false;
                }
                this.runningLock.notifyAll();
            }
        }

        @Override
        public void run() {
            block14: {
                block13: {
                    block12: {
                        if (SAMStreamSession.this._log.shouldLog(10)) {
                            SAMStreamSession.this._log.debug("run() called for socket reader " + this.id);
                        }
                        int read = -1;
                        ByteBuffer data = ByteBuffer.allocate(32768);
                        try {
                            InputStream in = this.i2pSocket.getInputStream();
                            while (this.stillRunning) {
                                data.clear();
                                read = Channels.newChannel(in).read(data);
                                if (read == -1) {
                                    if (SAMStreamSession.this._log.shouldLog(10)) {
                                        SAMStreamSession.this._log.debug("Handler " + this.id + ": connection closed");
                                    }
                                    break;
                                }
                                data.flip();
                                SAMStreamSession.this.recv.receiveStreamBytes(this.id, data);
                            }
                        }
                        catch (IOException e) {
                            if (!SAMStreamSession.this._log.shouldLog(10)) break block12;
                            SAMStreamSession.this._log.debug("Caught IOException", e);
                        }
                    }
                    try {
                        this.i2pSocket.close();
                    }
                    catch (IOException e) {
                        if (!SAMStreamSession.this._log.shouldLog(10)) break block13;
                        SAMStreamSession.this._log.debug("Caught IOException", e);
                    }
                }
                if (this.stillRunning) {
                    SAMStreamSession.this.removeSocketHandler(this.id);
                    try {
                        SAMStreamSession.this.recv.notifyStreamDisconnection(this.id, "OK", null);
                    }
                    catch (IOException e) {
                        if (!SAMStreamSession.this._log.shouldLog(10)) break block14;
                        SAMStreamSession.this._log.debug("Error sending disconnection notice for handler " + this.id, e);
                    }
                }
            }
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("Shutting down SAM STREAM session socket handler " + this.id);
            }
        }
    }

    public class SAMStreamSessionSocketReader
    implements Runnable {
        protected final I2PSocket i2pSocket;
        protected final Object runningLock = new Object();
        protected volatile boolean stillRunning = true;
        protected final int id;

        public SAMStreamSessionSocketReader(I2PSocket s, int id) throws IOException {
            this.i2pSocket = s;
            this.id = id;
        }

        public void stopRunning() {
        }

        @Override
        public void run() {
        }
    }

    public class SAMStreamSessionServer
    implements Runnable {
        private final Object runningLock = new Object();
        private volatile boolean stillRunning = true;
        private final I2PServerSocket serverSocket;

        public SAMStreamSessionServer() {
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("Instantiating new SAM STREAM session server");
            }
            this.serverSocket = SAMStreamSession.this.socketMgr.getServerSocket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("SAMStreamSessionServer.stopRunning() invoked");
            }
            Object object = this.runningLock;
            synchronized (object) {
                if (this.stillRunning) {
                    this.stillRunning = false;
                    try {
                        this.serverSocket.close();
                    }
                    catch (I2PException e) {
                        SAMStreamSession.this._log.error("I2PException caught", e);
                    }
                }
            }
        }

        @Override
        public void run() {
            block11: {
                if (SAMStreamSession.this._log.shouldLog(10)) {
                    SAMStreamSession.this._log.debug("SAM STREAM session server running");
                }
                while (this.stillRunning) {
                    try {
                        int id;
                        I2PSocket i2ps = this.serverSocket.accept();
                        if (i2ps == null) break;
                        if (SAMStreamSession.this._log.shouldLog(10)) {
                            SAMStreamSession.this._log.debug("New incoming connection");
                        }
                        if ((id = SAMStreamSession.this.createSocketHandler(i2ps, 0)) == 0) {
                            SAMStreamSession.this._log.error("SAM STREAM session handler not created!");
                            i2ps.reset();
                            continue;
                        }
                        if (SAMStreamSession.this._log.shouldLog(10)) {
                            SAMStreamSession.this._log.debug("New connection id: " + id);
                        }
                        SAMStreamSession.this.recv.notifyStreamIncomingConnection(id, i2ps.getPeerDestination());
                    }
                    catch (I2PException e) {
                        if (!SAMStreamSession.this._log.shouldLog(10)) break;
                        SAMStreamSession.this._log.debug("Caught I2PException", e);
                        break;
                    }
                    catch (IOException e) {
                        if (!SAMStreamSession.this._log.shouldLog(10)) break;
                        SAMStreamSession.this._log.debug("Caught IOException", e);
                        break;
                    }
                }
                try {
                    this.serverSocket.close();
                }
                catch (I2PException e) {
                    if (!SAMStreamSession.this._log.shouldLog(10)) break block11;
                    SAMStreamSession.this._log.debug("Caught I2PException", e);
                }
            }
            SAMStreamSession.this.close();
            if (SAMStreamSession.this._log.shouldLog(10)) {
                SAMStreamSession.this._log.debug("Shutting down SAM STREAM session server");
            }
        }
    }

    protected class DisconnectListener
    implements I2PSocketManager.DisconnectListener {
        protected DisconnectListener() {
        }

        @Override
        public void sessionDisconnected() {
            SAMStreamSession.this.close();
        }
    }
}

