/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.SendMessageOptions;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.SAMMessageSess;
import net.i2p.sam.SAMUtils;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

abstract class SAMMessageSession
implements SAMMessageSess {
    protected final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
    private final I2PSession session;
    protected final boolean _isOwnSession;
    private final SAMMessageSessionHandler handler;
    private final int listenProtocol;
    private final int listenPort;

    protected SAMMessageSession(String dest, Properties props) throws IOException, DataFormatException, I2PSessionException {
        this(new ByteArrayInputStream(Base64.decode(dest)), props);
    }

    protected SAMMessageSession(InputStream destStream, Properties props) throws IOException, DataFormatException, I2PSessionException {
        if (this._log.shouldLog(10)) {
            this._log.debug("Initializing SAM message-based session");
        }
        this.listenProtocol = 0;
        this.listenPort = 0;
        this._isOwnSession = true;
        this.handler = new SAMMessageSessionHandler(destStream, props);
        this.session = this.handler.getSession();
    }

    protected SAMMessageSession(I2PSession sess, int listenProtocol, int listenPort) throws IOException, DataFormatException, I2PSessionException {
        if (this._log.shouldLog(10)) {
            this._log.debug("Initializing SAM message-based session");
        }
        this.listenProtocol = listenProtocol;
        this.listenPort = listenPort;
        this._isOwnSession = false;
        this.session = sess;
        this.handler = new SAMMessageSessionHandler(this.session);
    }

    @Override
    public void start() {
        I2PAppThread t = new I2PAppThread(this.handler, "SAMMessageSessionHandler");
        ((Thread)t).start();
    }

    @Override
    public Destination getDestination() {
        return this.session.getMyDestination();
    }

    @Override
    public int getListenProtocol() {
        return this.listenProtocol;
    }

    @Override
    public int getListenPort() {
        return this.listenPort;
    }

    @Override
    public abstract boolean sendBytes(String var1, byte[] var2, int var3, int var4, int var5) throws DataFormatException, I2PSessionException;

    protected boolean sendBytesThroughMessageSession(String dest, byte[] data, int proto, int fromPort, int toPort) throws DataFormatException, I2PSessionException {
        Destination d = SAMUtils.getDest(dest);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending " + data.length + " bytes to " + dest);
        }
        return this.session.sendMessage(d, data, proto, fromPort, toPort);
    }

    protected boolean sendBytesThroughMessageSession(String dest, byte[] data, int proto, int fromPort, int toPort, boolean sendLeaseSet, int sendTags, int tagThreshold, int expiration) throws DataFormatException, I2PSessionException {
        Destination d = SAMUtils.getDest(dest);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending " + data.length + " bytes to " + dest);
        }
        SendMessageOptions opts = new SendMessageOptions();
        if (!sendLeaseSet) {
            opts.setSendLeaseSet(false);
        }
        if (sendTags > 0) {
            opts.setTagsToSend(sendTags);
        }
        if (tagThreshold > 0) {
            opts.setTagThreshold(tagThreshold);
        }
        if (expiration > 0) {
            opts.setDate(I2PAppContext.getGlobalContext().clock().now() + (long)(expiration * 1000));
        }
        return this.session.sendMessage(d, data, 0, data.length, proto, fromPort, toPort, opts);
    }

    @Override
    public void close() {
        this.handler.stopRunning();
    }

    protected abstract void messageReceived(byte[] var1, int var2, int var3, int var4);

    protected abstract void shutDown();

    protected I2PSession getI2PSession() {
        return this.session;
    }

    private class SAMMessageSessionHandler
    implements Runnable,
    I2PSessionMuxedListener {
        private final I2PSession _session;
        private final Object runningLock = new Object();
        private volatile boolean stillRunning = true;

        public SAMMessageSessionHandler(InputStream destStream, Properties props) throws I2PSessionException {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("Instantiating new SAM message-based session handler");
            }
            I2PClient client = I2PClientFactory.createClient();
            if (!props.containsKey("inbound.nickname") && !props.containsKey("outbound.nickname")) {
                props.setProperty("inbound.nickname", "SAM UDP Client");
                props.setProperty("outbound.nickname", "SAM UDP Client");
            }
            this._session = client.createSession(destStream, props);
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("Connecting I2P session...");
            }
            this._session.connect();
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("I2P session connected");
            }
            this._session.addMuxedSessionListener(this, SAMMessageSession.this.listenProtocol, SAMMessageSession.this.listenPort);
        }

        public SAMMessageSessionHandler(I2PSession sess) throws I2PSessionException {
            this._session = sess;
            this._session.addMuxedSessionListener(this, SAMMessageSession.this.listenProtocol, SAMMessageSession.this.listenPort);
        }

        public final I2PSession getSession() {
            return this._session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stopRunning() {
            Object object = this.runningLock;
            synchronized (object) {
                this.stillRunning = false;
                this.runningLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("SAM message-based session handler running");
            }
            Object object = this.runningLock;
            synchronized (object) {
                while (this.stillRunning) {
                    try {
                        this.runningLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("Shutting down SAM message-based session handler");
            }
            SAMMessageSession.this.shutDown();
            SAMMessageSession.this.session.removeListener(SAMMessageSession.this.listenProtocol, SAMMessageSession.this.listenPort);
            if (SAMMessageSession.this._isOwnSession) {
                try {
                    if (SAMMessageSession.this._log.shouldLog(10)) {
                        SAMMessageSession.this._log.debug("Destroying I2P session...");
                    }
                    SAMMessageSession.this.session.destroySession();
                    if (SAMMessageSession.this._log.shouldLog(10)) {
                        SAMMessageSession.this._log.debug("I2P session destroyed");
                    }
                }
                catch (I2PSessionException e) {
                    SAMMessageSession.this._log.error("Error destroying I2P session", e);
                }
            }
        }

        @Override
        public void disconnected(I2PSession session) {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("I2P session disconnected");
            }
            this.stopRunning();
        }

        @Override
        public void errorOccurred(I2PSession session, String message, Throwable error) {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("I2P error: " + message, error);
            }
            this.stopRunning();
        }

        @Override
        public void messageAvailable(I2PSession session, int msgId, long size) {
            this.messageAvailable(session, msgId, size, 0, 0, 0);
        }

        @Override
        public void messageAvailable(I2PSession session, int msgId, long size, int proto, int fromPort, int toPort) {
            if (SAMMessageSession.this._log.shouldLog(10)) {
                SAMMessageSession.this._log.debug("I2P message available (id: " + msgId + "; size: " + size + ")");
            }
            try {
                byte[] msg = session.receiveMessage(msgId);
                if (msg == null) {
                    return;
                }
                SAMMessageSession.this.messageReceived(msg, proto, fromPort, toPort);
            }
            catch (I2PSessionException e) {
                SAMMessageSession.this._log.error("Error fetching I2P message", e);
                this.stopRunning();
            }
        }

        @Override
        public void reportAbuse(I2PSession session, int severity) {
            SAMMessageSession.this._log.warn("Abuse reported (severity: " + severity + ")");
            this.stopRunning();
        }
    }
}

