/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.TunnelId;

public class Lease2
extends Lease {
    public static final int LENGTH = 40;

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._gateway = Hash.create(in);
        this._tunnelId = new TunnelId();
        this._tunnelId.readBytes(in);
        this._end = new Date(DataHelper.readLong(in, 4) * 1000L);
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._gateway == null || this._tunnelId == null) {
            throw new DataFormatException("Not enough data to write out a Lease");
        }
        this._gateway.writeBytes(out);
        this._tunnelId.writeBytes(out);
        DataHelper.writeLong(out, 4, this._end.getTime() / 1000L);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Lease2)) {
            return false;
        }
        Lease2 lse = (Lease2)object;
        return DataHelper.eq(this._end, lse.getEndDate()) && DataHelper.eq(this._tunnelId, lse.getTunnelId()) && DataHelper.eq(this._gateway, lse.getGateway());
    }

    @Override
    public int hashCode() {
        return (int)this._end.getTime() ^ DataHelper.hashCode(this._gateway) ^ (int)this._tunnelId.getTunnelId();
    }
}

