/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.InputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSimpleClient;
import net.i2p.data.Base32;
import net.i2p.data.Destination;
import net.i2p.data.Hash;

public class LookupDest {
    private static final long DEFAULT_TIMEOUT = 15000L;

    protected LookupDest(I2PAppContext context) {
    }

    static Destination lookupBase32Hash(I2PAppContext ctx, String key) throws I2PSessionException {
        byte[] h = Base32.decode(key);
        if (h == null) {
            return null;
        }
        return LookupDest.lookupHash(ctx, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Destination lookupHash(I2PAppContext ctx, byte[] h) throws I2PSessionException {
        Hash key = Hash.create(h);
        Destination rv = null;
        I2PSimpleClient client = new I2PSimpleClient();
        Properties opts = LookupDest.getOpts(ctx);
        I2PSession session = null;
        try {
            session = client.createSession((InputStream)null, opts);
            session.connect();
            rv = session.lookupDest(key, 15000L);
        }
        finally {
            if (session != null) {
                session.destroySession();
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Destination lookupHostname(I2PAppContext ctx, String hostname) throws I2PSessionException {
        Destination rv = null;
        I2PSimpleClient client = new I2PSimpleClient();
        Properties opts = LookupDest.getOpts(ctx);
        I2PSession session = null;
        try {
            session = client.createSession((InputStream)null, opts);
            session.connect();
            rv = session.lookupDest(hostname, 15000L);
        }
        finally {
            if (session != null) {
                session.destroySession();
            }
        }
        return rv;
    }

    private static Properties getOpts(I2PAppContext ctx) {
        Properties opts = new Properties();
        if (!ctx.isRouterContext()) {
            String s = ctx.getProperty("i2cp.tcp.host");
            if (s != null) {
                opts.put("i2cp.tcp.host", s);
            }
            if ((s = ctx.getProperty("i2cp.tcp.port")) != null) {
                opts.put("i2cp.tcp.port", s);
            }
            if ((s = ctx.getProperty("i2cp.SSL")) != null) {
                opts.put("i2cp.SSL", s);
            }
            if ((s = ctx.getProperty("i2cp.username")) != null) {
                opts.put("i2cp.username", s);
            }
            if ((s = ctx.getProperty("i2cp.password")) != null) {
                opts.put("i2cp.password", s);
            }
        }
        return opts;
    }

    public static void main(String[] args) {
        byte[] h;
        String arg;
        if (args.length != 1) {
            System.err.println("Usage: LookupDest base32");
            System.exit(1);
        }
        if ((arg = args[0]).endsWith(".b32.i2p")) {
            arg = arg.substring(0, arg.length() - 8);
        }
        if (arg.length() != 52) {
            System.err.println("Bad Base32 format");
            System.exit(1);
        }
        if ((h = Base32.decode(arg)) == null) {
            System.err.println("Bad Base32 format");
            System.exit(1);
        }
        try {
            Destination dest = LookupDest.lookupHash(I2PAppContext.getGlobalContext(), h);
            if (dest == null) {
                System.err.println("Destination not found!");
            } else {
                System.out.println(dest.toBase64());
            }
        }
        catch (I2PSessionException ise) {
            ise.printStackTrace();
        }
    }
}

