/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.Debug;

public class HTTPUSocket {
    private DatagramSocket ssdpUniSock = null;
    private String localAddr = "";

    public DatagramSocket getDatagramSocket() {
        return this.ssdpUniSock;
    }

    public HTTPUSocket() {
        this.open();
    }

    public HTTPUSocket(String bindAddr, int bindPort) {
        this.open(bindAddr, bindPort);
    }

    public HTTPUSocket(int bindPort) {
        this.open(bindPort);
    }

    protected void finalize() {
        this.close();
    }

    public void setLocalAddress(String addr) {
        this.localAddr = addr;
    }

    public DatagramSocket getUDPSocket() {
        return this.ssdpUniSock;
    }

    public String getLocalAddress() {
        if (0 < this.localAddr.length()) {
            return this.localAddr;
        }
        if (this.ssdpUniSock == null) {
            return "";
        }
        return this.ssdpUniSock.getLocalAddress().getHostAddress();
    }

    public boolean open() {
        this.close();
        try {
            this.ssdpUniSock = new DatagramSocket();
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public boolean open(String bindAddr, int bindPort) {
        this.close();
        try {
            InetSocketAddress bindInetAddr = new InetSocketAddress(InetAddress.getByName(bindAddr), bindPort);
            this.ssdpUniSock = new DatagramSocket(bindInetAddr);
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        this.setLocalAddress(bindAddr);
        return true;
    }

    public boolean open(int bindPort) {
        this.close();
        try {
            InetSocketAddress bindSock = new InetSocketAddress(bindPort);
            this.ssdpUniSock = new DatagramSocket(null);
            this.ssdpUniSock.setReuseAddress(true);
            this.ssdpUniSock.bind(bindSock);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean close() {
        if (this.ssdpUniSock == null) {
            return true;
        }
        try {
            this.ssdpUniSock.close();
            this.ssdpUniSock = null;
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public boolean post(String addr, int port, String msg) {
        try {
            InetAddress inetAddr = InetAddress.getByName(addr);
            DatagramPacket dgmPacket = new DatagramPacket(msg.getBytes(), msg.length(), inetAddr, port);
            this.ssdpUniSock.send(dgmPacket);
        }
        catch (Exception e) {
            Debug.warning("addr = " + this.ssdpUniSock.getLocalAddress().getHostName());
            Debug.warning("port = " + this.ssdpUniSock.getLocalPort());
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public SSDPPacket receive() {
        byte[] ssdvRecvBuf = new byte[1024];
        SSDPPacket recvPacket = new SSDPPacket(ssdvRecvBuf, ssdvRecvBuf.length);
        recvPacket.setLocalAddress(this.getLocalAddress());
        try {
            this.ssdpUniSock.receive(recvPacket.getDatagramPacket());
            recvPacket.setTimeStamp(System.currentTimeMillis());
            Debug.message("Received SSDP unicast packet on " + this.getLocalAddress() + " from " + recvPacket.getRemoteAddress());
        }
        catch (Exception e) {
            return null;
        }
        return recvPacket;
    }
}

