/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.http.HTTPRequestListener;
import org.cybergarage.http.HTTPServerList;
import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceList;
import org.cybergarage.upnp.UPnP;
import org.cybergarage.upnp.control.RenewSubscriber;
import org.cybergarage.upnp.device.DeviceChangeListener;
import org.cybergarage.upnp.device.Disposer;
import org.cybergarage.upnp.device.NotifyListener;
import org.cybergarage.upnp.device.SearchResponseListener;
import org.cybergarage.upnp.device.USN;
import org.cybergarage.upnp.event.EventListener;
import org.cybergarage.upnp.event.NotifyRequest;
import org.cybergarage.upnp.event.Property;
import org.cybergarage.upnp.event.PropertyList;
import org.cybergarage.upnp.event.SubscriptionRequest;
import org.cybergarage.upnp.event.SubscriptionResponse;
import org.cybergarage.upnp.ssdp.SSDPNotifySocketList;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.upnp.ssdp.SSDPSearchRequest;
import org.cybergarage.upnp.ssdp.SSDPSearchResponseSocketList;
import org.cybergarage.util.Debug;
import org.cybergarage.util.ListenerList;
import org.cybergarage.util.Mutex;
import org.cybergarage.xml.Node;
import org.cybergarage.xml.NodeList;
import org.cybergarage.xml.Parser;
import org.cybergarage.xml.ParserException;

public class ControlPoint
implements HTTPRequestListener {
    private static final int DEFAULT_EVENTSUB_PORT = 8058;
    private static final int DEFAULT_SSDP_PORT = 8008;
    private static final int DEFAULT_EXPIRED_DEVICE_MONITORING_INTERVAL = 60;
    private static final String DEFAULT_EVENTSUB_URI = "/evetSub";
    private SSDPNotifySocketList ssdpNotifySocketList;
    private SSDPSearchResponseSocketList ssdpSearchResponseSocketList;
    private Mutex mutex = new Mutex();
    private int ssdpPort = 0;
    private int httpPort = 0;
    private boolean nmprMode;
    private NodeList devNodeList = new NodeList();
    private Disposer deviceDisposer;
    private long expiredDeviceMonitoringInterval;
    private ListenerList deviceNotifyListenerList = new ListenerList();
    private ListenerList deviceSearchResponseListenerList = new ListenerList();
    ListenerList deviceChangeListenerList = new ListenerList();
    private int searchMx = 3;
    private HTTPServerList httpServerList = new HTTPServerList();
    private ListenerList eventListenerList = new ListenerList();
    private String eventSubURI = "/evetSub";
    private RenewSubscriber renewSubscriber;
    private Object userData = null;

    private SSDPNotifySocketList getSSDPNotifySocketList() {
        return this.ssdpNotifySocketList;
    }

    private SSDPSearchResponseSocketList getSSDPSearchResponseSocketList() {
        return this.ssdpSearchResponseSocketList;
    }

    public ControlPoint(int ssdpPort, int httpPort, InetAddress[] binds) {
        this.ssdpNotifySocketList = new SSDPNotifySocketList(binds);
        this.ssdpSearchResponseSocketList = new SSDPSearchResponseSocketList(binds);
        this.setSSDPPort(ssdpPort);
        this.setHTTPPort(httpPort);
        this.setDeviceDisposer(null);
        this.setExpiredDeviceMonitoringInterval(60L);
        this.setRenewSubscriber(null);
        this.setNMPRMode(false);
        this.setRenewSubscriber(null);
    }

    public ControlPoint(int ssdpPort, int httpPort) {
        this(ssdpPort, httpPort, null);
    }

    public ControlPoint() {
        this(8008, 8058);
    }

    public void finalize() {
        this.stop();
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public int getSSDPPort() {
        return this.ssdpPort;
    }

    public void setSSDPPort(int port) {
        this.ssdpPort = port;
    }

    public int getHTTPPort() {
        return this.httpPort;
    }

    public void setHTTPPort(int port) {
        this.httpPort = port;
    }

    public void setNMPRMode(boolean flag) {
        this.nmprMode = flag;
    }

    public boolean isNMPRMode() {
        return this.nmprMode;
    }

    private void addDevice(Node rootNode) {
        this.devNodeList.add(rootNode);
    }

    private synchronized void addDevice(SSDPPacket ssdpPacket) {
        if (!ssdpPacket.isRootDevice()) {
            return;
        }
        String usn = ssdpPacket.getUSN();
        String udn = USN.getUDN(usn);
        Device dev = this.getDevice(udn);
        if (dev != null) {
            dev.setSSDPPacket(ssdpPacket);
            return;
        }
        String location = ssdpPacket.getLocation();
        try {
            URL locationUrl = new URL(location);
            Parser parser = UPnP.getXMLParser();
            Node rootNode = parser.parse(locationUrl);
            Device rootDev = this.getDevice(rootNode);
            if (rootDev == null) {
                return;
            }
            rootDev.setSSDPPacket(ssdpPacket);
            Debug.warning("Add root device", new Exception("received on " + ssdpPacket.getLocalAddress()));
            this.addDevice(rootNode);
            this.performAddDeviceListener(rootDev);
        }
        catch (MalformedURLException me) {
            Debug.warning(ssdpPacket.toString());
            Debug.warning(me);
        }
        catch (ParserException pe) {
            Debug.warning(ssdpPacket.toString());
            Debug.warning(pe);
        }
    }

    private Device getDevice(Node rootNode) {
        if (rootNode == null) {
            return null;
        }
        Node devNode = rootNode.getNode("device");
        if (devNode == null) {
            return null;
        }
        return new Device(rootNode, devNode);
    }

    public DeviceList getDeviceList() {
        DeviceList devList = new DeviceList();
        int nRoots = this.devNodeList.size();
        for (int n = 0; n < nRoots; ++n) {
            Node rootNode;
            try {
                rootNode = this.devNodeList.getNode(n);
            }
            catch (ArrayIndexOutOfBoundsException aioob) {
                break;
            }
            Device dev = this.getDevice(rootNode);
            if (dev == null) continue;
            devList.add(dev);
        }
        return devList;
    }

    public Device getDevice(String name) {
        int nRoots = this.devNodeList.size();
        for (int n = 0; n < nRoots; ++n) {
            Node rootNode;
            try {
                rootNode = this.devNodeList.getNode(n);
            }
            catch (ArrayIndexOutOfBoundsException aioob) {
                break;
            }
            Device dev = this.getDevice(rootNode);
            if (dev == null) continue;
            if (dev.isDevice(name)) {
                return dev;
            }
            Device cdev = dev.getDevice(name);
            if (cdev == null) continue;
            return cdev;
        }
        return null;
    }

    public boolean hasDevice(String name) {
        return this.getDevice(name) != null;
    }

    private void removeDevice(Node rootNode) {
        Device dev = this.getDevice(rootNode);
        if (dev != null && dev.isRootDevice()) {
            this.performRemoveDeviceListener(dev);
        }
        this.devNodeList.remove(rootNode);
    }

    protected void removeDevice(Device dev) {
        if (dev == null) {
            return;
        }
        this.removeDevice(dev.getRootNode());
    }

    protected void removeDevice(String name) {
        Device dev = this.getDevice(name);
        this.removeDevice(dev);
    }

    private void removeDevice(SSDPPacket packet) {
        if (!packet.isByeBye()) {
            return;
        }
        String usn = packet.getUSN();
        String udn = USN.getUDN(usn);
        this.removeDevice(udn);
    }

    public void removeExpiredDevices() {
        int n;
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        Device[] dev = new Device[devCnt];
        for (n = 0; n < devCnt; ++n) {
            dev[n] = devList.getDevice(n);
        }
        for (n = 0; n < devCnt; ++n) {
            if (!dev[n].isExpired()) continue;
            Debug.message("Expired device = " + dev[n].getFriendlyName());
            this.removeDevice(dev[n]);
        }
    }

    public void setExpiredDeviceMonitoringInterval(long interval) {
        this.expiredDeviceMonitoringInterval = interval;
    }

    public long getExpiredDeviceMonitoringInterval() {
        return this.expiredDeviceMonitoringInterval;
    }

    public void setDeviceDisposer(Disposer disposer) {
        this.deviceDisposer = disposer;
    }

    public Disposer getDeviceDisposer() {
        return this.deviceDisposer;
    }

    public void addNotifyListener(NotifyListener listener) {
        this.deviceNotifyListenerList.add(listener);
    }

    public void removeNotifyListener(NotifyListener listener) {
        this.deviceNotifyListenerList.remove(listener);
    }

    public void performNotifyListener(SSDPPacket ssdpPacket) {
        int listenerSize = this.deviceNotifyListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            NotifyListener listener = (NotifyListener)this.deviceNotifyListenerList.get(n);
            try {
                listener.deviceNotifyReceived(ssdpPacket);
                continue;
            }
            catch (Exception e) {
                Debug.warning("NotifyListener returned an error:", e);
            }
        }
    }

    public void addSearchResponseListener(SearchResponseListener listener) {
        this.deviceSearchResponseListenerList.add(listener);
    }

    public void removeSearchResponseListener(SearchResponseListener listener) {
        this.deviceSearchResponseListenerList.remove(listener);
    }

    public void performSearchResponseListener(SSDPPacket ssdpPacket) {
        int listenerSize = this.deviceSearchResponseListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            SearchResponseListener listener = (SearchResponseListener)this.deviceSearchResponseListenerList.get(n);
            try {
                listener.deviceSearchResponseReceived(ssdpPacket);
                continue;
            }
            catch (Exception e) {
                Debug.warning("SearchResponseListener returned an error:", e);
            }
        }
    }

    public void addDeviceChangeListener(DeviceChangeListener listener) {
        this.deviceChangeListenerList.add(listener);
    }

    public void removeDeviceChangeListener(DeviceChangeListener listener) {
        this.deviceChangeListenerList.remove(listener);
    }

    public void performAddDeviceListener(Device dev) {
        int listenerSize = this.deviceChangeListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            DeviceChangeListener listener = (DeviceChangeListener)this.deviceChangeListenerList.get(n);
            listener.deviceAdded(dev);
        }
    }

    public void performRemoveDeviceListener(Device dev) {
        int listenerSize = this.deviceChangeListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            DeviceChangeListener listener = (DeviceChangeListener)this.deviceChangeListenerList.get(n);
            listener.deviceRemoved(dev);
        }
    }

    public void notifyReceived(SSDPPacket packet) {
        if (packet.isRootDevice()) {
            if (packet.isAlive()) {
                this.addDevice(packet);
            } else if (packet.isByeBye()) {
                this.removeDevice(packet);
            }
        }
        this.performNotifyListener(packet);
    }

    public void searchResponseReceived(SSDPPacket packet) {
        if (packet.isRootDevice()) {
            this.addDevice(packet);
        }
        this.performSearchResponseListener(packet);
    }

    public int getSearchMx() {
        return this.searchMx;
    }

    public void setSearchMx(int mx) {
        this.searchMx = mx;
    }

    public void search(String target, int mx) {
        SSDPSearchRequest msReq = new SSDPSearchRequest(target, mx);
        SSDPSearchResponseSocketList ssdpSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        ssdpSearchResponseSocketList.post(msReq);
    }

    public void search(String target) {
        this.search(target, 3);
    }

    public void search() {
        this.search("upnp:rootdevice", 3);
    }

    private HTTPServerList getHTTPServerList() {
        return this.httpServerList;
    }

    @Override
    public void httpRequestRecieved(HTTPRequest httpReq) {
        if (Debug.isOn()) {
            httpReq.print();
        }
        if (httpReq.isNotifyRequest()) {
            NotifyRequest notifyReq = new NotifyRequest(httpReq);
            String uuid = notifyReq.getSID();
            long seq = notifyReq.getSEQ();
            PropertyList props = notifyReq.getPropertyList();
            int propCnt = props.size();
            for (int n = 0; n < propCnt; ++n) {
                Property prop = props.getProperty(n);
                String varName = prop.getName();
                String varValue = prop.getValue();
                this.performEventListener(uuid, seq, varName, varValue);
            }
            httpReq.returnOK();
            return;
        }
        httpReq.returnBadRequest();
    }

    public void addEventListener(EventListener listener) {
        this.eventListenerList.add(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.eventListenerList.remove(listener);
    }

    public void performEventListener(String uuid, long seq, String name, String value) {
        int listenerSize = this.eventListenerList.size();
        for (int n = 0; n < listenerSize; ++n) {
            EventListener listener = (EventListener)this.eventListenerList.get(n);
            listener.eventNotifyReceived(uuid, seq, name, value);
        }
    }

    public String getEventSubURI() {
        return this.eventSubURI;
    }

    public void setEventSubURI(String url) {
        this.eventSubURI = url;
    }

    private String getEventSubCallbackURL(String host) {
        return HostInterface.getHostURL(host, this.getHTTPPort(), this.getEventSubURI());
    }

    public boolean subscribe(Service service, long timeout) {
        if (service.isSubscribed()) {
            String sid = service.getSID();
            return this.subscribe(service, sid, timeout);
        }
        Device rootDev = service.getRootDevice();
        if (rootDev == null) {
            return false;
        }
        String ifAddress = rootDev.getInterfaceAddress();
        SubscriptionRequest subReq = new SubscriptionRequest();
        subReq.setSubscribeRequest(service, this.getEventSubCallbackURL(ifAddress), timeout);
        SubscriptionResponse subRes = subReq.post();
        if (subRes.isSuccessful()) {
            service.setSID(subRes.getSID());
            service.setTimeout(subRes.getTimeout());
            return true;
        }
        service.clearSID();
        return false;
    }

    public boolean subscribe(Service service) {
        return this.subscribe(service, -1L);
    }

    public boolean subscribe(Service service, String uuid, long timeout) {
        SubscriptionRequest subReq = new SubscriptionRequest();
        subReq.setRenewRequest(service, uuid, timeout);
        if (Debug.isOn()) {
            subReq.print();
        }
        SubscriptionResponse subRes = subReq.post();
        if (Debug.isOn()) {
            subRes.print();
        }
        if (subRes.isSuccessful()) {
            service.setSID(subRes.getSID());
            service.setTimeout(subRes.getTimeout());
            return true;
        }
        service.clearSID();
        return false;
    }

    public boolean subscribe(Service service, String uuid) {
        return this.subscribe(service, uuid, -1L);
    }

    public boolean isSubscribed(Service service) {
        if (service == null) {
            return false;
        }
        return service.isSubscribed();
    }

    public boolean unsubscribe(Service service) {
        SubscriptionRequest subReq = new SubscriptionRequest();
        subReq.setUnsubscribeRequest(service);
        SubscriptionResponse subRes = subReq.post();
        if (subRes.isSuccessful()) {
            service.clearSID();
            return true;
        }
        return false;
    }

    public void unsubscribe(Device device) {
        ServiceList serviceList = device.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            Service service = serviceList.getService(n);
            if (!service.hasSID()) continue;
            this.unsubscribe(service);
        }
        DeviceList childDevList = device.getDeviceList();
        int childDevCnt = childDevList.size();
        for (int n = 0; n < childDevCnt; ++n) {
            Device cdev = childDevList.getDevice(n);
            this.unsubscribe(cdev);
        }
    }

    public void unsubscribe() {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            this.unsubscribe(dev);
        }
    }

    public Service getSubscriberService(String uuid) {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            Service service = dev.getSubscriberService(uuid);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public void renewSubscriberService(Device dev, long timeout) {
        ServiceList serviceList = dev.getServiceList();
        int serviceCnt = serviceList.size();
        for (int n = 0; n < serviceCnt; ++n) {
            String sid;
            boolean isRenewed;
            Service service = serviceList.getService(n);
            if (!service.isSubscribed() || (isRenewed = this.subscribe(service, sid = service.getSID(), timeout))) continue;
            this.subscribe(service, timeout);
        }
        DeviceList cdevList = dev.getDeviceList();
        int cdevCnt = cdevList.size();
        for (int n = 0; n < cdevCnt; ++n) {
            Device cdev = cdevList.getDevice(n);
            this.renewSubscriberService(cdev, timeout);
        }
    }

    public void renewSubscriberService(long timeout) {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            this.renewSubscriberService(dev, timeout);
        }
    }

    public void renewSubscriberService() {
        this.renewSubscriberService(-1L);
    }

    public void setRenewSubscriber(RenewSubscriber sub) {
        this.renewSubscriber = sub;
    }

    public RenewSubscriber getRenewSubscriber() {
        return this.renewSubscriber;
    }

    public boolean start(String target, int mx) {
        this.stop();
        int retryCnt = 0;
        int bindPort = this.getHTTPPort();
        HTTPServerList httpServerList = this.getHTTPServerList();
        while (!httpServerList.open(bindPort)) {
            if (4 < ++retryCnt) {
                Debug.warning("Failed to open HTTP event listener port " + bindPort);
                return false;
            }
            this.setHTTPPort(bindPort - 1);
            bindPort = this.getHTTPPort();
        }
        httpServerList.addRequestListener(this);
        httpServerList.start();
        SSDPNotifySocketList ssdpNotifySocketList = this.getSSDPNotifySocketList();
        if (!ssdpNotifySocketList.open()) {
            Debug.warning("Failed to open SSDP notify port 1900");
            return false;
        }
        ssdpNotifySocketList.setControlPoint(this);
        ssdpNotifySocketList.start();
        int ssdpPort = this.getSSDPPort();
        retryCnt = 0;
        SSDPSearchResponseSocketList ssdpSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        while (!ssdpSearchResponseSocketList.open(ssdpPort)) {
            if (4 < ++retryCnt) {
                Debug.warning("Failed to open SSDP search response port " + ssdpPort);
                return false;
            }
            this.setSSDPPort(ssdpPort - 1);
            ssdpPort = this.getSSDPPort();
        }
        ssdpSearchResponseSocketList.setControlPoint(this);
        ssdpSearchResponseSocketList.start();
        this.search(target, mx);
        Disposer disposer = new Disposer(this);
        this.setDeviceDisposer(disposer);
        disposer.start();
        if (this.isNMPRMode()) {
            RenewSubscriber renewSub = new RenewSubscriber(this);
            this.setRenewSubscriber(renewSub);
            renewSub.start();
        }
        return true;
    }

    public boolean start(String target) {
        return this.start(target, 3);
    }

    public boolean start() {
        return this.start("upnp:rootdevice", 3);
    }

    public boolean stop() {
        RenewSubscriber renewSub;
        this.unsubscribe();
        SSDPNotifySocketList ssdpNotifySocketList = this.getSSDPNotifySocketList();
        ssdpNotifySocketList.stop();
        ssdpNotifySocketList.close();
        ssdpNotifySocketList.clear();
        SSDPSearchResponseSocketList ssdpSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        ssdpSearchResponseSocketList.stop();
        ssdpSearchResponseSocketList.close();
        ssdpSearchResponseSocketList.clear();
        HTTPServerList httpServerList = this.getHTTPServerList();
        httpServerList.stop();
        httpServerList.close();
        httpServerList.clear();
        Disposer disposer = this.getDeviceDisposer();
        if (disposer != null) {
            disposer.stop();
            this.setDeviceDisposer(null);
        }
        if ((renewSub = this.getRenewSubscriber()) != null) {
            renewSub.stop();
            this.setRenewSubscriber(null);
        }
        DeviceList dl = this.getDeviceList();
        for (int i = 0; i < dl.size(); ++i) {
            this.removeDevice(dl.getDevice(i));
        }
        return true;
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void print() {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        Debug.message("Device Num = " + devCnt);
        for (int n = 0; n < devCnt; ++n) {
            Device dev = devList.getDevice(n);
            Debug.message("[" + n + "] " + dev.getFriendlyName() + ", " + dev.getLeaseTime() + ", " + dev.getElapsedTime());
        }
    }

    static {
        UPnP.initialize();
    }
}

