/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.TunnelId;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.router.tunnel.pool.TunnelPoolManager;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class TunnelPool {
    private final List<PooledTunnelCreatorConfig> _inProgress = new ArrayList<PooledTunnelCreatorConfig>();
    protected final RouterContext _context;
    protected final Log _log;
    private TunnelPoolSettings _settings;
    private final List<TunnelInfo> _tunnels;
    private final TunnelPeerSelector _peerSelector;
    private final TunnelPoolManager _manager;
    protected volatile boolean _alive;
    private long _lifetimeProcessed;
    private int _lastSelectedIdx;
    private final int _expireSkew;
    private long _started;
    private long _lastRateUpdate;
    private long _lastLifetimeProcessed;
    private final String _rateName;
    private final long _firstInstalled;
    private static final int TUNNEL_LIFETIME = 600000;
    private static final int BUILD_TRIES_QUANTITY_OVERRIDE = 12;
    private static final int BUILD_TRIES_LENGTH_OVERRIDE_1 = 8;
    private static final int BUILD_TRIES_LENGTH_OVERRIDE_2 = 12;
    private static final long STARTUP_TIME = 1800000L;

    TunnelPool(RouterContext ctx, TunnelPoolManager mgr, TunnelPoolSettings settings, TunnelPeerSelector sel) {
        String name;
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelPool.class);
        this._manager = mgr;
        this._settings = settings;
        this._tunnels = new ArrayList<TunnelInfo>(settings.getTotalQuantity());
        this._peerSelector = sel;
        this._expireSkew = this._context.random().nextInt(90000);
        this._lastRateUpdate = this._started = System.currentTimeMillis();
        this._firstInstalled = ctx.getProperty("router.firstInstalled", 0L) + 3600000L;
        name = this._settings.isExploratory() ? "exploratory" : ((name = this._settings.getDestinationNickname()) != null ? DataHelper.stripHTML(name) : this._settings.getDestination().toBase32());
        this._rateName = "tunnel.Bps." + name + (this._settings.isInbound() ? ".in" : ".out");
        this.refreshSettings();
        ctx.statManager().createRateStat("tunnel.matchLease", "How often does our OBEP match their IBGW?", "Tunnels", new long[]{3600000L});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void startup() {
        List<PooledTunnelCreatorConfig> list = this._inProgress;
        synchronized (list) {
            this._inProgress.clear();
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.toString() + ": Startup() called, was already alive? " + this._alive, new Exception());
        }
        this._alive = true;
        this._lastRateUpdate = this._started = System.currentTimeMillis();
        this._lastLifetimeProcessed = 0L;
        this._manager.getExecutor().repoll();
        if (this._settings.isInbound() && !this._settings.isExploratory()) {
            LeaseSet ls = null;
            List<TunnelInfo> list2 = this._tunnels;
            synchronized (list2) {
                ls = this.locked_buildNewLeaseSet();
            }
            if (ls != null) {
                this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
            }
        }
        this._context.statManager().createRequiredRateStat(this._rateName, "Tunnel Bandwidth (Bytes/sec)", "Tunnels", new long[]{300000L});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void shutdown() {
        if (this._log.shouldLog(30)) {
            this._log.warn(this.toString() + ": Shutdown called");
        }
        this._alive = false;
        this._context.statManager().removeRateStat(this._rateName);
        List<PooledTunnelCreatorConfig> list = this._inProgress;
        synchronized (list) {
            this._inProgress.clear();
        }
    }

    public String getRateName() {
        return this._rateName;
    }

    private void refreshSettings() {
        if (!this._settings.isExploratory()) {
            return;
        }
        Properties props = new Properties();
        props.putAll(this._context.router().getConfigMap());
        if (this._settings.isInbound()) {
            this._settings.readFromProperties("router.inboundPool.", props);
        } else {
            this._settings.readFromProperties("router.outboundPool.", props);
        }
    }

    private long getLifetime() {
        return System.currentTimeMillis() - this._started;
    }

    TunnelInfo selectTunnel() {
        return this.selectTunnel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TunnelInfo selectTunnel(boolean allowRecurseOnFail) {
        boolean avoidZeroHop = !this._settings.getAllowZeroHop();
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            if (this._tunnels.isEmpty()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.toString() + ": No tunnels to select from");
                }
            } else {
                TunnelInfo info;
                int i;
                TunnelInfo backloggedTunnel = null;
                if (avoidZeroHop) {
                    for (i = 0; i < this._tunnels.size(); ++i) {
                        ++this._lastSelectedIdx;
                        if (this._lastSelectedIdx >= this._tunnels.size()) {
                            this._lastSelectedIdx = 0;
                        }
                        if ((info = this._tunnels.get(this._lastSelectedIdx)).getLength() <= 1 || info.getExpiration() <= this._context.clock().now()) continue;
                        if (this._settings.isInbound() || !this._context.commSystem().isBacklogged(info.getPeer(1))) {
                            return info;
                        }
                        backloggedTunnel = info;
                    }
                    if (backloggedTunnel != null) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn(this.toString() + ": All tunnels are backlogged");
                        }
                        return backloggedTunnel;
                    }
                }
                for (i = 0; i < this._tunnels.size(); ++i) {
                    info = this._tunnels.get(i);
                    if (info.getExpiration() <= this._context.clock().now()) continue;
                    if (this._settings.isInbound() || info.getLength() <= 1 || !this._context.commSystem().isBacklogged(info.getPeer(1))) {
                        return info;
                    }
                    backloggedTunnel = info;
                }
                if (backloggedTunnel != null) {
                    return backloggedTunnel;
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.toString() + ": after " + this._tunnels.size() + " tries, no unexpired ones were found: " + this._tunnels);
                }
            }
        }
        if (this._alive && !avoidZeroHop) {
            this.buildFallback();
        }
        if (allowRecurseOnFail) {
            return this.selectTunnel(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TunnelInfo selectTunnel(Hash closestTo) {
        boolean avoidZeroHop = !this._settings.getAllowZeroHop();
        TunnelInfo rv = null;
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            if (!this._tunnels.isEmpty()) {
                if (this._tunnels.size() > 1) {
                    Collections.sort(this._tunnels, new TunnelInfoComparator(closestTo, avoidZeroHop));
                }
                for (TunnelInfo info : this._tunnels) {
                    if (info.getExpiration() <= this._context.clock().now()) continue;
                    rv = info;
                    break;
                }
            }
        }
        if (rv != null) {
            this._context.statManager().addRateData("tunnel.matchLease", closestTo.equals(rv.getFarEnd()) ? 1L : 0L);
        } else if (this._log.shouldLog(30)) {
            this._log.warn(this.toString() + ": No tunnels to select from");
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelInfo getTunnel(TunnelId gatewayId) {
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            for (int i = 0; i < this._tunnels.size(); ++i) {
                TunnelInfo info = this._tunnels.get(i);
                if (this._settings.isInbound()) {
                    if (!info.getReceiveTunnelId(0).equals(gatewayId)) continue;
                    return info;
                }
                if (!info.getSendTunnelId(0).equals(gatewayId)) continue;
                return info;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TunnelInfo> listTunnels() {
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            return new ArrayList<TunnelInfo>(this._tunnels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needFallback() {
        long exp = this._context.clock().now() + 120000L;
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            for (int i = 0; i < this._tunnels.size(); ++i) {
                TunnelInfo info = this._tunnels.get(i);
                if (info.getLength() > 1 || info.getExpiration() <= exp) continue;
                return false;
            }
        }
        return true;
    }

    private int getAdjustedTotalQuantity() {
        if (this._settings.getLength() == 0 && this._settings.getLengthVariance() == 0) {
            return 1;
        }
        int rv = this._settings.getTotalQuantity();
        if (!this._settings.isExploratory()) {
            return rv;
        }
        if (this._context.netDb().floodfillEnabled() && this._context.router().getUptime() > 300000L) {
            rv += 2;
        }
        if (rv > 1) {
            RateStat e = this._context.statManager().getRate("tunnel.buildExploratoryExpire");
            RateStat r = this._context.statManager().getRate("tunnel.buildExploratoryReject");
            RateStat s = this._context.statManager().getRate("tunnel.buildExploratorySuccess");
            if (e != null && r != null && s != null) {
                long sc;
                long rc;
                RateAverages ra;
                long ec;
                long tot;
                Rate er = e.getRate(600000L);
                Rate rr = r.getRate(600000L);
                Rate sr = s.getRate(600000L);
                if (er != null && rr != null && sr != null && (tot = (ec = er.computeAverages(ra = RateAverages.getTemp(), false).getTotalEventCount()) + (rc = rr.computeAverages(ra, false).getTotalEventCount()) + (sc = sr.computeAverages(ra, false).getTotalEventCount())) >= 12L && 1000L * sc / tot <= 83L) {
                    --rv;
                }
            }
        }
        if (this._context.router().getUptime() < 1800000L) {
            ++rv;
        }
        return rv;
    }

    private void setLengthOverride() {
        if (!this._settings.isExploratory()) {
            return;
        }
        int len = this._settings.getLength();
        if (len > 1) {
            RateStat e = this._context.statManager().getRate("tunnel.buildExploratoryExpire");
            RateStat r = this._context.statManager().getRate("tunnel.buildExploratoryReject");
            RateStat s = this._context.statManager().getRate("tunnel.buildExploratorySuccess");
            if (e != null && r != null && s != null) {
                long sc;
                long rc;
                RateAverages ra;
                long ec;
                long tot;
                Rate er = e.getRate(600000L);
                Rate rr = r.getRate(600000L);
                Rate sr = s.getRate(600000L);
                if (er != null && rr != null && sr != null && ((tot = (ec = er.computeAverages(ra = RateAverages.getTemp(), false).getTotalEventCount()) + (rc = rr.computeAverages(ra, false).getTotalEventCount()) + (sc = sr.computeAverages(ra, false).getTotalEventCount())) >= 8L || this._firstInstalled > this._context.clock().now())) {
                    long succ;
                    long l = succ = tot > 0L ? 1000L * sc / tot : 0L;
                    if (succ <= 125L) {
                        if (len > 2 && succ <= 83L) {
                            this._settings.setLengthOverride(len - 2);
                        } else {
                            this._settings.setLengthOverride(len - 1);
                        }
                        return;
                    }
                }
            }
        }
        this._settings.setLengthOverride(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PooledTunnelCreatorConfig> listPending() {
        List<PooledTunnelCreatorConfig> list = this._inProgress;
        synchronized (list) {
            return new ArrayList<PooledTunnelCreatorConfig>(this._inProgress);
        }
    }

    int getTunnelCount() {
        return this.size();
    }

    public TunnelPoolSettings getSettings() {
        return this._settings;
    }

    void setSettings(TunnelPoolSettings settings) {
        if (settings != null && this._settings != null && !settings.isExploratory() && !this._settings.isExploratory()) {
            settings.getAliases().addAll(this._settings.getAliases());
            settings.setAliasOf(this._settings.getAliasOf());
        }
        this._settings = settings;
        if (this._settings != null) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.toString() + ": Settings updated on the pool: " + settings);
            }
            this._manager.getExecutor().repoll();
        }
    }

    public boolean isAlive() {
        return this._alive && (this._settings.isExploratory() || this._context.clientManager().isLocal(this._settings.getDestination()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            return this._tunnels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTunnel(TunnelInfo info) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.toString() + ": Adding tunnel " + info);
        }
        LeaseSet ls = null;
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            this._tunnels.add(info);
            if (this._settings.isInbound() && !this._settings.isExploratory()) {
                ls = this.locked_buildNewLeaseSet();
            }
        }
        if (ls != null) {
            this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTunnel(TunnelInfo info) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.toString() + ": Removing tunnel " + info);
        }
        int remaining = 0;
        LeaseSet ls = null;
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            boolean removed = this._tunnels.remove(info);
            if (!removed) {
                return;
            }
            if (this._settings.isInbound() && !this._settings.isExploratory()) {
                ls = this.locked_buildNewLeaseSet();
            }
            remaining = this._tunnels.size();
        }
        this._manager.getExecutor().repoll();
        this._lifetimeProcessed += (long)info.getProcessedMessagesCount();
        this.updateRate();
        long lifetimeConfirmed = info.getVerifiedBytesTransferred();
        long lifetime = 600000L;
        for (int i = 0; i < info.getLength(); ++i) {
            this._context.profileManager().tunnelLifetimePushed(info.getPeer(i), lifetime, lifetimeConfirmed);
        }
        if (this._alive && this._settings.isInbound() && !this._settings.isExploratory()) {
            if (ls != null) {
                this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.toString() + ": unable to build a new leaseSet on removal (" + remaining + " remaining), request a new tunnel");
                }
                if (this._settings.getAllowZeroHop()) {
                    this.buildFallback();
                }
            }
        }
        if (this.getTunnelCount() <= 0 && !this.isAlive()) {
            this._manager.removeTunnels(this._settings.getDestination());
        }
    }

    void tunnelFailed(TunnelInfo cfg) {
        this.fail(cfg);
        this.tellProfileFailed(cfg);
    }

    void tunnelFailed(TunnelInfo cfg, Hash blamePeer) {
        this.fail(cfg);
        this._context.profileManager().tunnelFailed(blamePeer, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(TunnelInfo cfg) {
        if (this._log.shouldLog(30)) {
            this._log.warn(this.toString() + ": Tunnel failed: " + cfg);
        }
        LeaseSet ls = null;
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            boolean removed = this._tunnels.remove(cfg);
            if (!removed) {
                return;
            }
            if (this._settings.isInbound() && !this._settings.isExploratory()) {
                ls = this.locked_buildNewLeaseSet();
            }
        }
        this._manager.tunnelFailed();
        this._lifetimeProcessed += (long)cfg.getProcessedMessagesCount();
        this.updateRate();
        if (this._settings.isInbound() && !this._settings.isExploratory() && ls != null) {
            this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
        }
    }

    private void tellProfileFailed(TunnelInfo cfg) {
        int len = cfg.getLength();
        if (len < 2) {
            return;
        }
        int start = 0;
        int end = len;
        if (cfg.isInbound()) {
            --end;
        } else {
            ++start;
        }
        for (int i = start; i < end; ++i) {
            int pct = 100 / (len - 1);
            if (cfg.isInbound() && len > 2) {
                pct = i == start ? (pct *= 2) : (pct /= 2);
            }
            if (this._log.shouldLog(30)) {
                this._log.warn(this.toString() + ": Blaming " + cfg.getPeer(i) + ' ' + pct + '%');
            }
            this._context.profileManager().tunnelFailed(cfg.getPeer(i), pct);
        }
    }

    private void updateRate() {
        long now = this._context.clock().now();
        long et = now - this._lastRateUpdate;
        if (et > 120000L) {
            long bw = 1024L * (this._lifetimeProcessed - this._lastLifetimeProcessed) * 1000L / et;
            this._context.statManager().addRateData(this._rateName, bw, 0L);
            this._lastRateUpdate = now;
            this._lastLifetimeProcessed = this._lifetimeProcessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshLeaseSet() {
        if (this._settings.isInbound() && !this._settings.isExploratory()) {
            LeaseSet ls;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.toString() + ": refreshing leaseSet on tunnel expiration (but prior to grace timeout)");
            }
            List<TunnelInfo> list = this._tunnels;
            synchronized (list) {
                ls = this.locked_buildNewLeaseSet();
            }
            if (ls != null) {
                this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
                Set<Hash> aliases = this._settings.getAliases();
                if (aliases != null && !aliases.isEmpty()) {
                    for (Hash h : aliases) {
                        this._context.clientManager().requestLeaseSet(h, ls);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean buildFallback() {
        int quantity = this.getAdjustedTotalQuantity();
        int usable = 0;
        List<TunnelInfo> list = this._tunnels;
        synchronized (list) {
            usable = this._tunnels.size();
        }
        if (usable > 0) {
            return false;
        }
        if (this._settings.isExploratory() || this._settings.getAllowZeroHop()) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.toString() + ": building a fallback tunnel (usable: " + usable + " needed: " + quantity + ")");
            }
            this._manager.getExecutor().buildTunnel(this.configureNewTunnel(true));
            return true;
        }
        return false;
    }

    protected LeaseSet locked_buildNewLeaseSet() {
        if (!this._alive) {
            return null;
        }
        int wanted = Math.min(this._settings.getQuantity(), 16);
        if (this._tunnels.size() < wanted) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.toString() + ": Not enough tunnels (" + this._tunnels.size() + ", wanted " + wanted + ")");
            }
            if (this._tunnels.isEmpty()) {
                return null;
            }
        }
        long expireAfter = this._context.clock().now();
        TunnelInfo zeroHopTunnel = null;
        Lease zeroHopLease = null;
        TreeSet<Lease> leases = new TreeSet<Lease>(new LeaseComparator());
        for (int i = 0; i < this._tunnels.size(); ++i) {
            TunnelInfo tunnel = this._tunnels.get(i);
            if (tunnel.getExpiration() <= expireAfter) continue;
            if (tunnel.getLength() <= 1) {
                if (zeroHopTunnel != null) {
                    if (zeroHopTunnel.getExpiration() > tunnel.getExpiration()) continue;
                    if (zeroHopLease != null) {
                        leases.remove(zeroHopLease);
                    }
                }
                zeroHopTunnel = tunnel;
            }
            TunnelId inId = tunnel.getReceiveTunnelId(0);
            Hash gw = tunnel.getPeer(0);
            if (inId == null || gw == null) {
                this._log.error(this.toString() + ": broken? tunnel has no inbound gateway/tunnelId? " + tunnel);
                continue;
            }
            Lease lease = new Lease();
            lease.setEndDate(new Date(((TunnelCreatorConfig)tunnel).getConfig(0).getExpiration()));
            lease.setTunnelId(inId);
            lease.setGateway(gw);
            leases.add(lease);
            if (tunnel.getLength() > 1) continue;
            zeroHopLease = lease;
        }
        if (leases.size() < wanted) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.toString() + ": Not enough leases (" + leases.size() + ", wanted " + wanted + ")");
            }
            if (leases.isEmpty()) {
                return null;
            }
        }
        LeaseSet ls = new LeaseSet();
        Iterator<Lease> iter = leases.iterator();
        int count = Math.min(leases.size(), wanted);
        for (int i = 0; i < count; ++i) {
            ls.addLease(iter.next());
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.toString() + ": built new leaseSet: " + ls);
        }
        return ls;
    }

    public long getLifetimeProcessed() {
        return this._lifetimeProcessed;
    }

    private final String buildRateName() {
        if (this._settings.isExploratory()) {
            return "tunnel.buildRatio.exploratory." + (this._settings.isInbound() ? "in" : "out");
        }
        return "tunnel.buildRatio.l" + this._settings.getLength() + "v" + this._settings.getLengthVariance() + (this._settings.isInbound() ? ".in" : ".out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countHowManyToBuild() {
        Rate r;
        if (!this.isAlive()) {
            return 0;
        }
        int wanted = this.getAdjustedTotalQuantity();
        boolean allowZeroHop = this._settings.getAllowZeroHop();
        String rateName = this.buildRateName();
        int avg = 0;
        RateStat rs = this._context.statManager().getRate(rateName);
        if (rs == null) {
            this._context.statManager().createRequiredRateStat(rateName, "Tunnel Build Frequency", "Tunnels", new long[]{600000L});
            rs = this._context.statManager().getRate(rateName);
        }
        if (rs != null && (r = rs.getRate(600000L)) != null) {
            avg = (int)(600000.0 * r.getAverageValue() / (double)wanted);
        }
        if (avg > 0 && avg < 200000) {
            int inProgress;
            int[] expireTime;
            int PANIC_FACTOR = 4;
            avg += 60000;
            if (this._settings.isExploratory()) {
                avg += 60000;
            }
            long now = this._context.clock().now();
            int expireSoon = 0;
            int expireLater = 0;
            int fallback = 0;
            List<TunnelInfo> list = this._tunnels;
            synchronized (list) {
                expireTime = new int[this._tunnels.size()];
                for (int i = 0; i < this._tunnels.size(); ++i) {
                    TunnelInfo info = this._tunnels.get(i);
                    if (allowZeroHop || info.getLength() > 1) {
                        int timeToExpire = (int)(info.getExpiration() - now);
                        if (timeToExpire > 0 && timeToExpire < avg) {
                            expireTime[expireSoon++] = timeToExpire;
                            continue;
                        }
                        ++expireLater;
                        continue;
                    }
                    if (info.getExpiration() - now <= (long)avg) continue;
                    ++fallback;
                }
            }
            List<PooledTunnelCreatorConfig> i = this._inProgress;
            synchronized (i) {
                inProgress = this._inProgress.size();
            }
            int remainingWanted = wanted - expireLater - inProgress;
            int rv = 0;
            int latesttime = 0;
            if (remainingWanted > 0) {
                if (remainingWanted > expireSoon) {
                    rv = 4 * (remainingWanted - expireSoon);
                    remainingWanted = expireSoon;
                }
                for (int i2 = 0; i2 < remainingWanted; ++i2) {
                    int latestidx = 0;
                    for (int j = 0; j < expireSoon; ++j) {
                        if (expireTime[j] <= latesttime) continue;
                        latesttime = expireTime[j];
                        latestidx = j;
                    }
                    expireTime[latestidx] = 0;
                    if (latesttime > avg / 2) {
                        ++rv;
                        continue;
                    }
                    rv += 2 + 2 * ((avg / 2 - latesttime) / (avg / 2));
                }
            }
            if (rv > 0 && this._log.shouldLog(10)) {
                this._log.debug("New Count: rv: " + rv + " allow? " + allowZeroHop + " avg " + avg + " latesttime " + latesttime + " soon " + expireSoon + " later " + expireLater + " std " + wanted + " inProgress " + inProgress + " fallback " + fallback + " for " + this.toString());
            }
            this._context.statManager().addRateData(rateName, rv + inProgress, 0L);
            return rv;
        }
        long expireAfter = this._context.clock().now() + (long)this._expireSkew;
        int expire30s = 0;
        int expire90s = 0;
        int expire150s = 0;
        int expire210s = 0;
        int expire270s = 0;
        int expireLater = 0;
        int fallback = 0;
        List<TunnelInfo> rv = this._tunnels;
        synchronized (rv) {
            for (int i = 0; i < this._tunnels.size(); ++i) {
                TunnelInfo info = this._tunnels.get(i);
                if (allowZeroHop || info.getLength() > 1) {
                    long timeToExpire = info.getExpiration() - expireAfter;
                    if (timeToExpire <= 0L) continue;
                    if (timeToExpire <= 30000L) {
                        ++expire30s;
                        continue;
                    }
                    if (timeToExpire <= 90000L) {
                        ++expire90s;
                        continue;
                    }
                    if (timeToExpire <= 150000L) {
                        ++expire150s;
                        continue;
                    }
                    if (timeToExpire <= 210000L) {
                        ++expire210s;
                        continue;
                    }
                    if (timeToExpire <= 270000L) {
                        ++expire270s;
                        continue;
                    }
                    ++expireLater;
                    continue;
                }
                if (info.getExpiration() <= expireAfter) continue;
                ++fallback;
            }
        }
        int inProgress = 0;
        List<PooledTunnelCreatorConfig> i = this._inProgress;
        synchronized (i) {
            inProgress = this._inProgress.size();
            for (int i3 = 0; i3 < inProgress; ++i3) {
                PooledTunnelCreatorConfig cfg = this._inProgress.get(i3);
                if (cfg.getLength() > 1) continue;
                ++fallback;
            }
        }
        int rv2 = this.countHowManyToBuild(allowZeroHop, expire30s, expire90s, expire150s, expire210s, expire270s, expireLater, wanted, inProgress, fallback);
        this._context.statManager().addRateData(rateName, rv2 > 0 || inProgress > 0 ? 1L : 0L, 0L);
        return rv2;
    }

    private int countHowManyToBuild(boolean allowZeroHop, int expire30s, int expire90s, int expire150s, int expire210s, int expire270s, int expireLater, int standardAmount, int inProgress, int fallback) {
        long lifetime;
        int i;
        int rv = 0;
        int remainingWanted = standardAmount - expireLater;
        if (allowZeroHop) {
            remainingWanted -= fallback;
        }
        for (i = 0; i < expire270s && remainingWanted > 0; --remainingWanted, ++i) {
        }
        if (remainingWanted > 0) {
            for (i = 0; i < expire210s && remainingWanted > 0; --remainingWanted, ++i) {
            }
            if (remainingWanted > 0) {
                for (i = 0; i < expire150s && remainingWanted > 0; --remainingWanted, ++i) {
                }
                if (remainingWanted > 0) {
                    for (i = 0; i < expire90s && remainingWanted > 0; --remainingWanted, ++i) {
                    }
                    if (remainingWanted > 0) {
                        for (i = 0; i < expire30s && remainingWanted > 0; --remainingWanted, ++i) {
                        }
                        if (remainingWanted > 0) {
                            rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                            rv += expire210s;
                            rv += 2 * expire150s;
                            rv += 4 * expire90s;
                            rv += 6 * expire30s;
                            rv += 6 * remainingWanted;
                            rv -= inProgress;
                            rv -= expireLater;
                        } else {
                            rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                            rv += expire210s;
                            rv += 2 * expire150s;
                            rv += 4 * expire90s;
                            rv += 6 * expire30s;
                            rv -= inProgress;
                            rv -= expireLater;
                        }
                    } else {
                        rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                        rv += expire210s;
                        rv += 2 * expire150s;
                        rv += 4 * expire90s;
                        rv -= inProgress;
                        rv -= expireLater;
                    }
                } else {
                    rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                    rv += expire210s;
                    rv += 2 * expire150s;
                    rv -= inProgress;
                    rv -= expireLater;
                }
            } else {
                rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                rv += expire210s;
                rv -= inProgress;
                rv -= expireLater;
            }
        } else {
            rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
            rv -= inProgress;
            rv -= expireLater;
        }
        if (allowZeroHop && rv > standardAmount) {
            rv = standardAmount;
        }
        if (rv + inProgress + expireLater + fallback > 4 * standardAmount) {
            rv = 4 * standardAmount - inProgress - expireLater - fallback;
        }
        if ((lifetime = this.getLifetime()) < 60000L && rv + inProgress + fallback >= standardAmount) {
            rv = standardAmount - inProgress - fallback;
        }
        if (rv > 0 && this._log.shouldLog(10)) {
            this._log.debug("Count: rv: " + rv + " allow? " + allowZeroHop + " 30s " + expire30s + " 90s " + expire90s + " 150s " + expire150s + " 210s " + expire210s + " 270s " + expire270s + " later " + expireLater + " std " + standardAmount + " inProgress " + inProgress + " fallback " + fallback + " for " + this.toString() + " up for " + lifetime);
        }
        if (rv < 0) {
            return 0;
        }
        return rv;
    }

    PooledTunnelCreatorConfig configureNewTunnel() {
        return this.configureNewTunnel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledTunnelCreatorConfig configureNewTunnel(boolean forceZeroHop) {
        TunnelPoolSettings settings = this.getSettings();
        List<Hash> peers = null;
        long now = this._context.clock().now();
        long expiration = now + 600000L;
        if (!forceZeroHop) {
            int len = settings.getLengthOverride();
            if (len < 0) {
                len = settings.getLength();
            }
            if (len > 0 && !settings.isExploratory() && this._context.random().nextInt(4) < 3) {
                ++len;
                List<TunnelInfo> list = this._tunnels;
                synchronized (list) {
                    for (TunnelInfo ti : this._tunnels) {
                        if (ti.getLength() < len || ti.getExpiration() >= now + 180000L || ti.wasReused()) continue;
                        ti.setReused();
                        len = ti.getLength();
                        peers = new ArrayList<Hash>(len);
                        for (int i = len - 1; i >= 0; --i) {
                            peers.add(ti.getPeer(i));
                        }
                    }
                }
            }
            if (peers == null) {
                this.setLengthOverride();
                peers = this._peerSelector.selectPeers(settings);
            }
            if (peers == null || peers.isEmpty()) {
                if (peers == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No peers to put in the new tunnel! selectPeers returned null!  boo, hiss!");
                    }
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("No peers to put in the new tunnel! selectPeers returned an empty list?!");
                }
                return null;
            }
        } else {
            peers = Collections.singletonList(this._context.routerHash());
        }
        PooledTunnelCreatorConfig cfg = new PooledTunnelCreatorConfig(this._context, peers.size(), settings.isInbound(), settings.getDestination(), this);
        for (int i = 0; i < peers.size(); ++i) {
            int j = peers.size() - 1 - i;
            cfg.setPeer(j, peers.get(i));
            HopConfig hop = cfg.getConfig(j);
            hop.setCreation(now);
            hop.setExpiration(expiration);
            hop.setIVKey(this._context.keyGenerator().generateSessionKey());
            hop.setLayerKey(this._context.keyGenerator().generateSessionKey());
        }
        cfg.setExpiration(expiration);
        if (!settings.isInbound()) {
            cfg.setPriority(settings.getPriority());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Config contains " + peers + ": " + cfg);
        }
        List<PooledTunnelCreatorConfig> list = this._inProgress;
        synchronized (list) {
            this._inProgress.add(cfg);
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildComplete(PooledTunnelCreatorConfig cfg) {
        List<PooledTunnelCreatorConfig> list = this._inProgress;
        synchronized (list) {
            this._inProgress.remove(cfg);
        }
    }

    public String toString() {
        if (this._settings.isExploratory()) {
            if (this._settings.isInbound()) {
                return "Inbound exploratory pool";
            }
            return "Outbound exploratory pool";
        }
        StringBuilder rv = new StringBuilder(32);
        if (this._settings.isInbound()) {
            rv.append("Inbound client pool for ");
        } else {
            rv.append("Outbound client pool for ");
        }
        if (this._settings.getDestinationNickname() != null) {
            rv.append(this._settings.getDestinationNickname());
        } else {
            rv.append(this._settings.getDestination().toBase64().substring(0, 4));
        }
        return rv.toString();
    }

    private static class TunnelInfoComparator
    implements Comparator<TunnelInfo>,
    Serializable {
        private final byte[] _base;
        private final boolean _avoidZero;

        public TunnelInfoComparator(Hash target, boolean avoidZeroHop) {
            this._base = target.getData();
            this._avoidZero = avoidZeroHop;
        }

        @Override
        public int compare(TunnelInfo lhs, TunnelInfo rhs) {
            if (this._avoidZero) {
                int llen = lhs.getLength();
                int rlen = rhs.getLength();
                if (llen > 1 && rlen <= 1) {
                    return -1;
                }
                if (rlen > 1 && llen <= 1) {
                    return 1;
                }
            }
            byte[] lhsb = lhs.getFarEnd().getData();
            byte[] rhsb = rhs.getFarEnd().getData();
            for (int i = 0; i < this._base.length; ++i) {
                int ld = (lhsb[i] ^ this._base[i]) & 0xFF;
                int rd = (rhsb[i] ^ this._base[i]) & 0xFF;
                if (ld < rd) {
                    return -1;
                }
                if (ld <= rd) continue;
                return 1;
            }
            return (int)(rhs.getExpiration() - lhs.getExpiration());
        }
    }

    private static class LeaseComparator
    implements Comparator<Lease>,
    Serializable {
        private LeaseComparator() {
        }

        @Override
        public int compare(Lease l, Lease r) {
            return r.getEndDate().compareTo(l.getEndDate());
        }
    }
}

