/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.ntcp.EstablishBase;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.SimpleByteCache;

class OutboundEstablishState
extends EstablishBase {
    public OutboundEstablishState(RouterContext ctx, NTCPTransport transport, NTCPConnection con) {
        super(ctx, transport, con);
        this._state = EstablishBase.State.OB_INIT;
        ctx.sha().calculateHash(this._X, 0, 256, this._hX_xor_bobIdentHash, 0);
        OutboundEstablishState.xor32(con.getRemotePeer().calculateHash().getData(), this._hX_xor_bobIdentHash);
    }

    @Override
    public synchronized void receive(ByteBuffer src) {
        super.receive(src);
        if (!src.hasRemaining()) {
            return;
        }
        this.receiveOutbound(src);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private void receiveOutbound(ByteBuffer src) {
        int toGet;
        if (this._state == EstablishBase.State.OB_SENT_X && src.hasRemaining()) {
            toGet = Math.min(src.remaining(), 256 - this._received);
            src.get(this._Y, this._received, toGet);
            this._received += toGet;
            if (this._received < 256) {
                return;
            }
            try {
                this._dh.setPeerPublicValue(this._Y);
                this._dh.getSessionKey();
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "DH session key calculated (" + this._dh.getSessionKey().toBase64() + ")");
                }
                this.changeState(EstablishBase.State.OB_GOT_Y);
                this._received = 0;
            }
            catch (DHSessionKeyBuilder.InvalidPublicParameterException e) {
                this._context.statManager().addRateData("ntcp.invalidDH", 1L);
                this.fail("Invalid X", e);
                return;
            }
            catch (IllegalStateException ise) {
                this.fail("reused keys?", ise);
                return;
            }
        }
        if (this._state == EstablishBase.State.OB_GOT_Y && src.hasRemaining()) {
            toGet = Math.min(src.remaining(), 48 - this._received);
            src.get(this._e_hXY_tsB, this._received, toGet);
            this._received += toGet;
            if (this._received < 48) {
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "received _e_hXY_tsB fully");
            }
            byte[] hXY_tsB = new byte[48];
            this._context.aes().decrypt(this._e_hXY_tsB, 0, hXY_tsB, 0, this._dh.getSessionKey(), this._Y, 240, 48);
            byte[] XY = new byte[512];
            System.arraycopy(this._X, 0, XY, 0, 256);
            System.arraycopy(this._Y, 0, XY, 256, 256);
            byte[] h = SimpleByteCache.acquire(32);
            this._context.sha().calculateHash(XY, 0, 512, h, 0);
            if (!DataHelper.eq(h, 0, hXY_tsB, 0, 32)) {
                SimpleByteCache.release(h);
                this._context.statManager().addRateData("ntcp.invalidHXY", 1L);
                this.fail("Invalid H(X+Y) - mitm attack attempted?");
                return;
            }
            SimpleByteCache.release(h);
            this.changeState(EstablishBase.State.OB_GOT_HXY);
            this._received = 0;
            this._tsB = DataHelper.fromLong(hXY_tsB, 32, 4);
            long now = this._context.clock().now();
            long rtt = now - this._con.getCreated();
            this._tsA = (now + 500L) / 1000L;
            this._peerSkew = (now - this._tsB * 1000L - rtt / 2L + 500L) / 1000L;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "h(X+Y) is correct, skew = " + this._peerSkew);
            }
            long diff = 1000L * Math.abs(this._peerSkew);
            if (!this._context.clock().getUpdatedSuccessfully()) {
                this._context.clock().setOffset(1000L * (0L - this._peerSkew), true);
                this._peerSkew = 0L;
                if (diff != 0L) {
                    this._log.logAlways(30, "NTP failure, NTCP adjusting clock by " + DataHelper.formatDuration(diff));
                }
            } else {
                if (diff >= 60000L) {
                    this._context.statManager().addRateData("ntcp.invalidOutboundSkew", diff);
                    this._transport.markReachable(this._con.getRemotePeer().calculateHash(), false);
                    this._context.banlist().banlistRouter(DataHelper.formatDuration(diff), this._con.getRemotePeer().calculateHash(), OutboundEstablishState._x("Excessive clock skew: {0}"));
                    this._transport.setLastBadSkew(this._peerSkew);
                    this.fail("Clocks too skewed (" + diff + " ms)", null, true);
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "Clock skew: " + diff + " ms");
                }
            }
            int sigSize = 552;
            byte[] preSign = new byte[sigSize];
            System.arraycopy(this._X, 0, preSign, 0, 256);
            System.arraycopy(this._Y, 0, preSign, 256, 256);
            System.arraycopy(this._con.getRemotePeer().calculateHash().getData(), 0, preSign, 512, 32);
            DataHelper.toLong(preSign, 544, 4, this._tsA);
            DataHelper.toLong(preSign, 548, 4, this._tsB);
            Signature sig = this._context.dsa().sign(preSign, this._context.keyManager().getSigningPrivateKey());
            byte[] ident = this._context.router().getRouterInfo().getIdentity().toByteArray();
            int min = 2 + ident.length + 4 + sig.length();
            int rem = min % 16;
            int padding = 0;
            if (rem > 0) {
                padding = 16 - rem;
            }
            byte[] preEncrypt = new byte[min + padding];
            DataHelper.toLong(preEncrypt, 0, 2, ident.length);
            System.arraycopy(ident, 0, preEncrypt, 2, ident.length);
            DataHelper.toLong(preEncrypt, 2 + ident.length, 4, this._tsA);
            if (padding > 0) {
                this._context.random().nextBytes(preEncrypt, 2 + ident.length + 4, padding);
            }
            System.arraycopy(sig.getData(), 0, preEncrypt, 2 + ident.length + 4 + padding, sig.length());
            this._prevEncrypted = new byte[preEncrypt.length];
            this._context.aes().encrypt(preEncrypt, 0, this._prevEncrypted, 0, this._dh.getSessionKey(), this._hX_xor_bobIdentHash, this._hX_xor_bobIdentHash.length - 16, preEncrypt.length);
            this.changeState(EstablishBase.State.OB_SENT_RI);
            this._transport.getPumper().wantsWrite(this._con, this._prevEncrypted);
        }
        if (this._state == EstablishBase.State.OB_SENT_RI && src.hasRemaining()) {
            int off = 0;
            if (this._e_bobSig == null) {
                int siglen = this._con.getRemotePeer().getSigningPublicKey().getType().getSigLen();
                int rem = siglen % 16;
                int padding = rem > 0 ? 16 - rem : 0;
                this._e_bobSig = new byte[siglen + padding];
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "receiving E(S(X+Y+Alice.identHash+tsA+tsB)+padding, sk, prev) (remaining? " + src.hasRemaining() + ")");
                }
            } else {
                off = this._received;
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "continuing to receive E(S(X+Y+Alice.identHash+tsA+tsB)+padding, sk, prev) (remaining? " + src.hasRemaining() + " off=" + off + " recv=" + this._received + ")");
                }
            }
            while (this._state == EstablishBase.State.OB_SENT_RI && src.hasRemaining()) {
                this._e_bobSig[off++] = src.get();
                ++this._received;
                if (off < this._e_bobSig.length) continue;
                this.changeState(EstablishBase.State.OB_GOT_SIG);
                byte[] bobSig = new byte[this._e_bobSig.length];
                this._context.aes().decrypt(this._e_bobSig, 0, bobSig, 0, this._dh.getSessionKey(), this._e_hXY_tsB, 32, this._e_bobSig.length);
                SigType type = this._con.getRemotePeer().getSigningPublicKey().getType();
                int siglen = type.getSigLen();
                byte[] bobSigData = new byte[siglen];
                System.arraycopy(bobSig, 0, bobSigData, 0, siglen);
                Signature sig = new Signature(type, bobSigData);
                byte[] toVerify = new byte[552];
                int voff = 0;
                System.arraycopy(this._X, 0, toVerify, voff, 256);
                System.arraycopy(this._Y, 0, toVerify, voff += 256, 256);
                System.arraycopy(this._context.routerHash().getData(), 0, toVerify, voff += 256, 32);
                DataHelper.toLong(toVerify, voff += 32, 4, this._tsA);
                DataHelper.toLong(toVerify, voff += 4, 4, this._tsB);
                voff += 4;
                boolean ok = this._context.dsa().verifySignature(sig, toVerify, this._con.getRemotePeer().getSigningPublicKey());
                if (!ok) {
                    this._context.statManager().addRateData("ntcp.invalidSignature", 1L);
                    this.fail("Signature was invalid - attempt to spoof " + this._con.getRemotePeer().calculateHash().toBase64() + "?");
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "signature verified from Bob.  done!");
                    }
                    byte[] nextWriteIV = SimpleByteCache.acquire(16);
                    System.arraycopy(this._prevEncrypted, this._prevEncrypted.length - 16, nextWriteIV, 0, 16);
                    this._con.finishOutboundEstablishment(this._dh.getSessionKey(), this._peerSkew, nextWriteIV, this._e_bobSig);
                    this.changeState(EstablishBase.State.VERIFIED);
                    if (src.hasRemaining()) {
                        if (this._log.shouldInfo()) {
                            this._log.info("extra data " + src.remaining() + " on " + this);
                        }
                        this._con.recvEncryptedI2NP(src);
                    }
                    this.releaseBufs(true);
                    InetAddress ia = this._con.getChannel().socket().getInetAddress();
                    if (ia != null) {
                        this._transport.setIP(this._con.getRemotePeer().calculateHash(), ia.getAddress());
                    }
                }
                return;
            }
        }
        if ((this._state == EstablishBase.State.VERIFIED || this._state == EstablishBase.State.CORRUPT) && src.hasRemaining() && this._log.shouldWarn()) {
            this._log.warn("Received unexpected " + src.remaining() + " on " + this, new Exception());
        }
    }

    @Override
    public synchronized void prepareOutbound() {
        if (this._state == EstablishBase.State.OB_INIT) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "send X");
            }
        } else {
            throw new IllegalStateException(this.prefix() + "unexpected prepareOutbound()");
        }
        byte[] toWrite = new byte[256 + this._hX_xor_bobIdentHash.length];
        System.arraycopy(this._X, 0, toWrite, 0, 256);
        System.arraycopy(this._hX_xor_bobIdentHash, 0, toWrite, 256, this._hX_xor_bobIdentHash.length);
        this.changeState(EstablishBase.State.OB_SENT_X);
        this._transport.getPumper().wantsWrite(this._con, toWrite);
    }

    @Override
    protected void releaseBufs(boolean isVerified) {
        super.releaseBufs(isVerified);
        Arrays.fill(this._Y, (byte)0);
        SimpleByteCache.release(this._Y);
    }
}

