/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import com.southernstorm.noise.protocol.HandshakeState;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;

class SessionKeyAndNonce
extends SessionKey {
    private final int _id;
    private final int _nonce;
    private final HandshakeState _state;
    private final PublicKey _remoteKey;

    public SessionKeyAndNonce(byte[] data, int nonce) {
        this(data, 0, nonce, null);
    }

    public SessionKeyAndNonce(byte[] data, int id, int nonce, PublicKey remoteKey) {
        super(data);
        this._id = id;
        this._nonce = nonce;
        this._remoteKey = remoteKey;
        this._state = null;
    }

    public SessionKeyAndNonce(HandshakeState state) {
        this._id = 0;
        this._nonce = 0;
        this._remoteKey = null;
        this._state = state;
    }

    public int getNonce() {
        return this._nonce;
    }

    public int getID() {
        return this._id;
    }

    public PublicKey getRemoteKey() {
        return this._remoteKey;
    }

    public HandshakeState getHandshakeState() {
        return this._state;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[SessionKeyAndNonce: ");
        buf.append(this.toBase64());
        buf.append(this._state != null ? " NSR" : " ES");
        buf.append(" nonce: ").append(this._nonce);
        buf.append(']');
        return buf.toString();
    }
}

