/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import net.i2p.crypto.EncType;
import net.i2p.data.DataFormatException;
import net.i2p.data.PrivateKey;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.MuxedSKM;
import net.i2p.router.message.CloveSet;
import net.i2p.util.Log;

final class MuxedEngine {
    private final RouterContext _context;
    private final Log _log;

    public MuxedEngine(RouterContext ctx) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(MuxedEngine.class);
    }

    public CloveSet decrypt(byte[] data, PrivateKey elgKey, PrivateKey ecKey, MuxedSKM keyManager) throws DataFormatException {
        byte[] dec;
        if (elgKey.getType() != EncType.ELGAMAL_2048 || ecKey.getType() != EncType.ECIES_X25519) {
            throw new IllegalArgumentException();
        }
        CloveSet rv = null;
        boolean preferRatchet = keyManager.preferRatchet();
        if (preferRatchet) {
            rv = this._context.eciesEngine().decryptFast(data, ecKey, keyManager.getECSKM());
            if (rv != null) {
                return rv;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Ratchet tag not found before AES");
            }
        }
        if (data.length >= 128 && (data.length & 0xF) == 0) {
            dec = this._context.elGamalAESEngine().decryptFast(data, elgKey, keyManager.getElgSKM());
            if (dec != null) {
                block26: {
                    try {
                        rv = this._context.garlicMessageParser().readCloveSet(dec, 0);
                        if (rv == null && this._log.shouldInfo()) {
                            this._log.info("AES cloveset error after AES? " + preferRatchet);
                        }
                    }
                    catch (DataFormatException dfe) {
                        if (!this._log.shouldInfo()) break block26;
                        this._log.info("AES cloveset error after AES? " + preferRatchet, dfe);
                    }
                }
                return rv;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("AES tag not found after ratchet? " + preferRatchet);
            }
        }
        if (!preferRatchet) {
            rv = this._context.eciesEngine().decryptFast(data, ecKey, keyManager.getECSKM());
            if (rv != null) {
                return rv;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Ratchet tag not found after AES");
            }
        }
        if (preferRatchet) {
            rv = this._context.eciesEngine().decryptSlow(data, ecKey, keyManager.getECSKM());
            boolean ok = rv != null;
            keyManager.reportDecryptResult(true, ok);
            if (ok) {
                return rv;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Ratchet NS decrypt failed before ElG");
            }
        }
        if (data.length >= 514 && (data.length & 0xF) == 2) {
            block27: {
                dec = this._context.elGamalAESEngine().decryptSlow(data, elgKey, keyManager.getElgSKM());
                if (dec != null) {
                    try {
                        rv = this._context.garlicMessageParser().readCloveSet(dec, 0);
                        boolean ok = rv != null;
                        keyManager.reportDecryptResult(false, ok);
                        if (ok) {
                            return rv;
                        }
                        if (this._log.shouldInfo()) {
                            this._log.info("ElG cloveset error after ratchet? " + preferRatchet);
                        }
                        break block27;
                    }
                    catch (DataFormatException dfe) {
                        if (this._log.shouldInfo()) {
                            this._log.info("ElG cloveset error afterRatchet? " + preferRatchet, dfe);
                        }
                        break block27;
                    }
                }
                if (this._log.shouldInfo()) {
                    this._log.info("ElG decrypt failed after Ratchet? " + preferRatchet);
                }
            }
            keyManager.reportDecryptResult(false, false);
        }
        if (!preferRatchet) {
            rv = this._context.eciesEngine().decryptSlow(data, ecKey, keyManager.getECSKM());
            boolean ok = rv != null;
            keyManager.reportDecryptResult(true, ok);
            if (!ok && this._log.shouldDebug()) {
                this._log.debug("Ratchet NS decrypt failed after ElG");
            }
        }
        return rv;
    }
}

