/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import com.southernstorm.noise.crypto.x25519.Curve25519;
import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.CipherStatePair;
import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.HandshakeState;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.i2p.crypto.EncType;
import net.i2p.crypto.HKDF;
import net.i2p.data.Base64;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.GarlicClove;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.Elg2KeyFactory;
import net.i2p.router.crypto.ratchet.Elligator2;
import net.i2p.router.crypto.ratchet.MuxedEngine;
import net.i2p.router.crypto.ratchet.MuxedSKM;
import net.i2p.router.crypto.ratchet.NextSessionKey;
import net.i2p.router.crypto.ratchet.RatchetEntry;
import net.i2p.router.crypto.ratchet.RatchetPayload;
import net.i2p.router.crypto.ratchet.RatchetSKM;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.crypto.ratchet.ReplyCallback;
import net.i2p.router.crypto.ratchet.SessionKeyAndNonce;
import net.i2p.router.message.CloveSet;
import net.i2p.util.Log;

public final class ECIESAEADEngine {
    private final RouterContext _context;
    private final Log _log;
    private final MuxedEngine _muxedEngine;
    private final HKDF _hkdf;
    private final Elg2KeyFactory _edhThread;
    private boolean _isRunning;
    private static final byte[] ZEROLEN = new byte[0];
    private static final int TAGLEN = 8;
    private static final int MACLEN = 16;
    private static final int KEYLEN = 32;
    private static final int BHLEN = 3;
    private static final int DATETIME_SIZE = 7;
    private static final int MIN_NS_SIZE = 103;
    private static final int MIN_NSR_SIZE = 56;
    private static final int MIN_ES_SIZE = 24;
    private static final int MIN_ENCRYPTED_SIZE = 24;
    private static final byte[] NULLPK = new byte[32];
    private static final int MAXPAD = 16;
    static final long MAX_NS_AGE = 300000L;
    private static final long MAX_NS_FUTURE = 120000L;
    private static final boolean ACKREQ_IN_ES = false;
    private static final GarlicClove[] NO_GARLIC = new GarlicClove[0];
    private static final CloveSet NO_CLOVES = new CloveSet(NO_GARLIC, Certificate.NULL_CERT, 0L, 0L);
    private static final String INFO_0 = "SessionReplyTags";
    private static final String INFO_6 = "AttachPayloadKDF";

    public ECIESAEADEngine(RouterContext ctx) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(ECIESAEADEngine.class);
        this._muxedEngine = new MuxedEngine(ctx);
        this._hkdf = new HKDF(ctx);
        this._edhThread = new Elg2KeyFactory(ctx);
        this._context.statManager().createFrequencyStat("crypto.eciesAEAD.encryptNewSession", "how frequently we encrypt to a new ECIES/AEAD+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.eciesAEAD.encryptExistingSession", "how frequently we encrypt to an existing ECIES/AEAD+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.eciesAEAD.decryptNewSession", "how frequently we decrypt with a new ECIES/AEAD+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.eciesAEAD.decryptExistingSession", "how frequently we decrypt with an existing ECIES/AEAD+SessionTag session?", "Encryption", new long[]{3600000L});
        this._context.statManager().createFrequencyStat("crypto.eciesAEAD.decryptFailed", "how frequently we fail to decrypt with ECIES/AEAD+SessionTag?", "Encryption", new long[]{3600000L});
    }

    public synchronized void startup() {
        if (!this._isRunning) {
            this._edhThread.start();
            this._isRunning = true;
        }
    }

    public synchronized void shutdown() {
        this._isRunning = false;
        this._edhThread.shutdown();
    }

    public CloveSet decrypt(byte[] data, PrivateKey elgKey, PrivateKey ecKey, MuxedSKM keyManager) throws DataFormatException {
        return this._muxedEngine.decrypt(data, elgKey, ecKey, keyManager);
    }

    public CloveSet decrypt(byte[] data, PrivateKey targetPrivateKey, RatchetSKM keyManager) throws DataFormatException {
        try {
            return this.x_decrypt(data, targetPrivateKey, keyManager);
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldWarn()) {
                this._log.warn("ECIES decrypt error", dfe);
            }
            return NO_CLOVES;
        }
        catch (Exception e) {
            this._log.error("ECIES decrypt error", e);
            return NO_CLOVES;
        }
    }

    private CloveSet x_decrypt(byte[] data, PrivateKey targetPrivateKey, RatchetSKM keyManager) throws DataFormatException {
        if (targetPrivateKey.getType() != EncType.ECIES_X25519) {
            throw new IllegalArgumentException();
        }
        if (data == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Null data being decrypted?");
            }
            return null;
        }
        if (data.length < 24) {
            if (this._log.shouldWarn()) {
                this._log.warn("Data is less than the minimum size (" + data.length + " < " + 24 + ")");
            }
            return null;
        }
        byte[] tag = new byte[8];
        System.arraycopy(data, 0, tag, 0, 8);
        RatchetSessionTag st = new RatchetSessionTag(tag);
        SessionKeyAndNonce key = keyManager.consumeTag(st);
        boolean shouldDebug = this._log.shouldDebug();
        CloveSet decrypted = key != null ? this.xx_decryptFast(tag, st, key, data, targetPrivateKey, keyManager) : this.x_decryptSlow(data, targetPrivateKey, keyManager);
        return decrypted;
    }

    CloveSet decryptFast(byte[] data, PrivateKey targetPrivateKey, RatchetSKM keyManager) throws DataFormatException {
        try {
            return this.x_decryptFast(data, targetPrivateKey, keyManager);
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldWarn()) {
                this._log.warn("ECIES decrypt error", dfe);
            }
            return NO_CLOVES;
        }
        catch (Exception e) {
            this._log.error("ECIES decrypt error", e);
            return NO_CLOVES;
        }
    }

    private CloveSet x_decryptFast(byte[] data, PrivateKey targetPrivateKey, RatchetSKM keyManager) throws DataFormatException {
        if (data.length < 24) {
            if (this._log.shouldWarn()) {
                this._log.warn("Data is less than the minimum size (" + data.length + " < " + 24 + ")");
            }
            return null;
        }
        byte[] tag = new byte[8];
        System.arraycopy(data, 0, tag, 0, 8);
        RatchetSessionTag st = new RatchetSessionTag(tag);
        SessionKeyAndNonce key = keyManager.consumeTag(st);
        CloveSet decrypted = key != null ? this.xx_decryptFast(tag, st, key, data, targetPrivateKey, keyManager) : null;
        return decrypted;
    }

    private CloveSet xx_decryptFast(byte[] tag, RatchetSessionTag st, SessionKeyAndNonce key, byte[] data, PrivateKey targetPrivateKey, RatchetSKM keyManager) throws DataFormatException {
        CloveSet decrypted;
        boolean shouldDebug = this._log.shouldDebug();
        HandshakeState state = key.getHandshakeState();
        if (state == null) {
            if (shouldDebug) {
                this._log.debug("Decrypting ES with tag: " + st.toBase64() + " key: " + key + ": " + data.length + " bytes");
            }
            decrypted = this.decryptExistingSession(tag, data, key, targetPrivateKey, keyManager);
        } else if (data.length >= 56) {
            if (shouldDebug) {
                this._log.debug("Decrypting NSR with tag: " + st.toBase64() + " key: " + key + ": " + data.length + " bytes");
            }
            decrypted = this.decryptNewSessionReply(tag, data, state, keyManager);
        } else {
            decrypted = null;
            if (this._log.shouldWarn()) {
                this._log.warn("ECIES decrypt fail, tag found but no state and too small for NSR: " + data.length + " bytes");
            }
        }
        if (decrypted != null) {
            this._context.statManager().updateFrequency("crypto.eciesAEAD.decryptExistingSession");
        } else {
            this._context.statManager().updateFrequency("crypto.eciesAEAD.decryptFailed");
            if (this._log.shouldWarn()) {
                this._log.warn("ECIES decrypt fail: known tag [" + st + "], failed decrypt with key " + key);
            }
        }
        return decrypted;
    }

    CloveSet decryptSlow(byte[] data, PrivateKey targetPrivateKey, RatchetSKM keyManager) throws DataFormatException {
        try {
            return this.x_decryptSlow(data, targetPrivateKey, keyManager);
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldWarn()) {
                this._log.warn("ECIES decrypt error", dfe);
            }
            return NO_CLOVES;
        }
        catch (Exception e) {
            this._log.error("ECIES decrypt error", e);
            return NO_CLOVES;
        }
    }

    private CloveSet x_decryptSlow(byte[] data, PrivateKey targetPrivateKey, RatchetSKM keyManager) throws DataFormatException {
        CloveSet decrypted;
        if (data.length >= 103) {
            decrypted = this.decryptNewSession(data, targetPrivateKey, keyManager);
            if (decrypted != null) {
                this._context.statManager().updateFrequency("crypto.eciesAEAD.decryptNewSession");
            } else {
                this._context.statManager().updateFrequency("crypto.eciesAEAD.decryptFailed");
                if (this._log.shouldWarn()) {
                    this._log.warn("ECIES decrypt fail as new session");
                }
            }
        } else {
            decrypted = null;
            if (this._log.shouldWarn()) {
                this._log.warn("ECIES decrypt fail, too small for NS: " + data.length + " bytes");
            }
        }
        return decrypted;
    }

    private CloveSet decryptNewSession(byte[] data, PrivateKey targetPrivateKey, RatchetSKM keyManager) throws DataFormatException {
        HandshakeState state;
        try {
            state = new HandshakeState("IK", 2, this._edhThread);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("bad proto", gse);
        }
        state.getLocalKeyPair().setPublicKey(targetPrivateKey.toPublic().getData(), 0);
        state.getLocalKeyPair().setPrivateKey(targetPrivateKey.getData(), 0);
        state.start();
        if (this._log.shouldDebug()) {
            this._log.debug("State before decrypt new session: " + state);
        }
        byte[] xx = new byte[32];
        System.arraycopy(data, 0, xx, 0, 32);
        byte xx31 = xx[31];
        PublicKey pk = Elligator2.decode(xx);
        if (pk == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Elg2 decode fail NS");
            }
            return null;
        }
        System.arraycopy(pk.getData(), 0, data, 0, 32);
        int payloadlen = data.length - 96;
        byte[] payload = new byte[payloadlen];
        try {
            state.readMessage(data, 0, data.length, payload, 0);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Decrypt fail NS", gse);
                if (this._log.shouldDebug()) {
                    this._log.debug("State at failure: " + state);
                }
            }
            System.arraycopy(xx, 0, data, 0, 31);
            data[31] = xx31;
            return null;
        }
        if (keyManager.isDuplicate(pk)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dup eph. key in IB NS: " + pk);
            }
            return NO_CLOVES;
        }
        byte[] bobPK = new byte[32];
        state.getRemotePublicKey().getPublicKey(bobPK, 0);
        if (this._log.shouldDebug()) {
            this._log.debug("NS decrypt success from PK " + Base64.encode(bobPK));
            this._log.debug("State after decrypt new session: " + state);
        }
        if (Arrays.equals(bobPK, NULLPK)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Zero static key in IB NS");
            }
            return NO_CLOVES;
        }
        if (payloadlen == 0) {
            if (this._log.shouldWarn()) {
                this._log.warn("Zero length payload in NS");
            }
            return NO_CLOVES;
        }
        PLCallback pc = new PLCallback();
        try {
            int blocks = RatchetPayload.processPayload(this._context, pc, payload, 0, payload.length, true);
            if (this._log.shouldDebug()) {
                this._log.debug("Processed " + blocks + " blocks in IB NS");
            }
        }
        catch (DataFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataFormatException("NS payload error", e);
        }
        if (pc.datetime == 0L) {
            if (this._log.shouldWarn()) {
                this._log.warn("No datetime block in IB NS");
            }
            return NO_CLOVES;
        }
        PublicKey bob = new PublicKey(EncType.ECIES_X25519, bobPK);
        keyManager.createSession(bob, state, null);
        if (pc.cloveSet.isEmpty() && this._log.shouldWarn()) {
            this._log.warn("No garlic block in NS payload");
        }
        int num = pc.cloveSet.size();
        GarlicClove[] arr = new GarlicClove[num];
        CloveSet rv = new CloveSet(pc.cloveSet.toArray(arr), Certificate.NULL_CERT, 0L, pc.datetime);
        return rv;
    }

    private CloveSet decryptNewSessionReply(byte[] tag, byte[] data, HandshakeState oldState, RatchetSKM keyManager) throws DataFormatException {
        HandshakeState state;
        try {
            state = oldState.clone();
        }
        catch (CloneNotSupportedException e) {
            if (this._log.shouldWarn()) {
                this._log.warn("ECIES decrypt fail: clone()", e);
            }
            return null;
        }
        byte[] yy = new byte[32];
        System.arraycopy(data, 8, yy, 0, 32);
        byte yy31 = yy[31];
        PublicKey k = Elligator2.decode(yy);
        if (k == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Elg2 decode fail NSR");
            }
            return null;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("State before decrypt new session reply: " + state);
        }
        System.arraycopy(k.getData(), 0, data, 8, 32);
        state.mixHash(tag, 0, 8);
        if (this._log.shouldDebug()) {
            this._log.debug("State after mixhash tag before decrypt new session reply: " + state);
        }
        try {
            state.readMessage(data, 8, 48, ZEROLEN, 0);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Decrypt fail NSR part 1", gse);
                if (this._log.shouldDebug()) {
                    this._log.debug("State at failure: " + state);
                }
            }
            System.arraycopy(yy, 0, data, 8, 31);
            data[39] = yy31;
            return null;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("State after decrypt new session reply: " + state);
        }
        byte[] ck = state.getChainingKey();
        byte[] k_ab = new byte[32];
        byte[] k_ba = new byte[32];
        this._hkdf.calculate(ck, ZEROLEN, k_ab, k_ba, 0);
        CipherStatePair ckp = state.split();
        CipherState rcvr = ckp.getReceiver();
        byte[] hash = state.getHandshakeHash();
        byte[] encpayloadkey = new byte[32];
        this._hkdf.calculate(k_ba, ZEROLEN, INFO_6, encpayloadkey);
        rcvr.initializeKey(encpayloadkey, 0);
        byte[] payload = new byte[data.length - 72];
        try {
            rcvr.decryptWithAd(hash, data, 56, payload, 0, payload.length + 16);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Decrypt fail NSR part 2", gse);
                if (this._log.shouldDebug()) {
                    this._log.debug("State at failure: " + state);
                }
            }
            return NO_CLOVES;
        }
        if (payload.length == 0) {
            if (this._log.shouldWarn()) {
                this._log.warn("Zero length payload in NSR");
            }
            return NO_CLOVES;
        }
        PLCallback pc = new PLCallback();
        try {
            int blocks = RatchetPayload.processPayload(this._context, pc, payload, 0, payload.length, false);
            if (this._log.shouldDebug()) {
                this._log.debug("Processed " + blocks + " blocks in IB NSR");
            }
        }
        catch (DataFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataFormatException("NSR payload error", e);
        }
        byte[] bobPK = new byte[32];
        state.getRemotePublicKey().getPublicKey(bobPK, 0);
        if (this._log.shouldDebug()) {
            this._log.debug("NSR decrypt success from PK " + Base64.encode(bobPK));
        }
        if (Arrays.equals(bobPK, NULLPK)) {
            if (this._log.shouldWarn()) {
                this._log.warn("NSR reply to zero static key NS");
            }
            return NO_CLOVES;
        }
        PublicKey bob = new PublicKey(EncType.ECIES_X25519, bobPK);
        keyManager.updateSession(bob, oldState, state, null);
        if (pc.cloveSet.isEmpty() && this._log.shouldWarn()) {
            this._log.warn("No garlic block in NSR payload");
        }
        int num = pc.cloveSet.size();
        GarlicClove[] arr = new GarlicClove[num];
        CloveSet rv = new CloveSet(pc.cloveSet.toArray(arr), Certificate.NULL_CERT, 0L, pc.datetime);
        return rv;
    }

    private CloveSet decryptExistingSession(byte[] tag, byte[] data, SessionKeyAndNonce key, PrivateKey targetPrivateKey, RatchetSKM keyManager) throws DataFormatException {
        int nonce = key.getNonce();
        boolean ok = this.decryptAEADBlock(tag, data, 8, data.length - 8, key, nonce);
        if (!ok) {
            if (this._log.shouldWarn()) {
                this._log.warn("Decrypt of ES failed");
            }
            return null;
        }
        if (data.length == 24) {
            if (this._log.shouldWarn()) {
                this._log.warn("Zero length payload in ES");
            }
            return null;
        }
        PublicKey remote = key.getRemoteKey();
        PLCallback pc = new PLCallback(keyManager, remote);
        try {
            int blocks = RatchetPayload.processPayload(this._context, pc, data, 8, data.length - 24, false);
            if (this._log.shouldDebug()) {
                this._log.debug("Processed " + blocks + " blocks in IB ES");
            }
        }
        catch (DataFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataFormatException("ES payload error", e);
        }
        if (pc.cloveSet.isEmpty() && this._log.shouldWarn()) {
            this._log.warn("No garlic block in ES payload");
        }
        if (pc.nextKeys != null) {
            for (NextSessionKey nextKey : pc.nextKeys) {
                keyManager.nextKeyReceived(remote, nextKey);
            }
        }
        if (pc.ackRequested) {
            keyManager.ackRequested(remote, key.getID(), nonce);
        }
        int num = pc.cloveSet.size();
        GarlicClove[] arr = new GarlicClove[num];
        CloveSet rv = new CloveSet(pc.cloveSet.toArray(arr), Certificate.NULL_CERT, 0L, pc.datetime);
        return rv;
    }

    private boolean decryptAEADBlock(byte[] ad, byte[] encrypted, int offset, int encryptedLen, SessionKey key, long n) throws DataFormatException {
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(key.getData(), 0);
        chacha.setNonce(n);
        try {
            chacha.decryptWithAd(ad, encrypted, offset, encrypted, offset, encryptedLen);
        }
        catch (GeneralSecurityException e) {
            if (this._log.shouldWarn()) {
                this._log.warn("Unable to decrypt AEAD block", e);
            }
            return false;
        }
        return true;
    }

    public byte[] encrypt(CloveSet cloves, PublicKey target, PrivateKey priv, RatchetSKM keyManager, ReplyCallback callback) {
        try {
            return this.x_encrypt(cloves, target, priv, keyManager, callback);
        }
        catch (Exception e) {
            this._log.error("ECIES encrypt error", e);
            return null;
        }
    }

    private byte[] x_encrypt(CloveSet cloves, PublicKey target, PrivateKey priv, RatchetSKM keyManager, ReplyCallback callback) {
        if (target.getType() != EncType.ECIES_X25519) {
            throw new IllegalArgumentException();
        }
        if (Arrays.equals(target.getData(), NULLPK)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Zero static key target");
            }
            return null;
        }
        RatchetEntry re = keyManager.consumeNextAvailableTag(target);
        if (re == null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Encrypting as NS to " + target);
            }
            return this.encryptNewSession(cloves, target, priv, keyManager, callback);
        }
        HandshakeState state = re.key.getHandshakeState();
        if (state != null) {
            try {
                state = state.clone();
            }
            catch (CloneNotSupportedException e) {
                if (this._log.shouldWarn()) {
                    this._log.warn("ECIES encrypt fail: clone()", e);
                }
                return null;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Encrypting as NSR to " + target + " with tag " + re.tag.toBase64());
            }
            return this.encryptNewSessionReply(cloves, target, state, re.tag, keyManager, callback);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Encrypting as ES to " + target + " with key " + re.key + " and tag " + re.tag.toBase64());
        }
        byte[] rv = this.encryptExistingSession(cloves, target, re, callback, keyManager);
        return rv;
    }

    private byte[] encryptNewSession(CloveSet cloves, PublicKey target, PrivateKey priv, RatchetSKM keyManager, ReplyCallback callback) {
        DHState eph;
        HandshakeState state;
        try {
            state = new HandshakeState("IK", 1, this._edhThread);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("bad proto", gse);
        }
        state.getRemotePublicKey().setPublicKey(target.getData(), 0);
        state.getLocalKeyPair().setPublicKey(priv.toPublic().getData(), 0);
        state.getLocalKeyPair().setPrivateKey(priv.getData(), 0);
        state.start();
        if (this._log.shouldDebug()) {
            this._log.debug("State before encrypt new session: " + state);
        }
        byte[] payload = this.createPayload(cloves, cloves.getExpiration());
        byte[] enc = new byte[80 + payload.length + 16];
        try {
            state.writeMessage(enc, 0, payload, 0, payload.length);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Encrypt fail NS", gse);
            }
            return null;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("State after encrypt new session: " + state);
        }
        if ((eph = state.getLocalEphemeralKeyPair()) == null || !eph.hasEncodedPublicKey()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad NS state");
            }
            return null;
        }
        eph.getEncodedPublicKey(enc, 0);
        if (this._log.shouldDebug()) {
            this._log.debug("Elligator2 encoded eph. key: " + Base64.encode(enc, 0, 32));
        }
        keyManager.createSession(target, state, callback);
        return enc;
    }

    private byte[] encryptNewSessionReply(CloveSet cloves, PublicKey target, HandshakeState state, RatchetSessionTag currentTag, RatchetSKM keyManager, ReplyCallback callback) {
        DHState eph;
        if (this._log.shouldDebug()) {
            this._log.debug("State before encrypt new session reply: " + state);
        }
        byte[] tag = currentTag.getData();
        state.mixHash(tag, 0, 8);
        if (this._log.shouldDebug()) {
            this._log.debug("State after mixhash tag before encrypt new session reply: " + state);
        }
        byte[] payload = this.createPayload(cloves, 0L);
        byte[] enc = new byte[56 + payload.length + 16];
        System.arraycopy(tag, 0, enc, 0, 8);
        try {
            state.writeMessage(enc, 8, ZEROLEN, 0, 0);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Encrypt fail NSR part 1", gse);
            }
            return null;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("State after encrypt new session reply: " + state);
        }
        if ((eph = state.getLocalEphemeralKeyPair()) == null || !eph.hasEncodedPublicKey()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad NSR state");
            }
            return null;
        }
        eph.getEncodedPublicKey(enc, 8);
        byte[] ck = state.getChainingKey();
        byte[] k_ab = new byte[32];
        byte[] k_ba = new byte[32];
        this._hkdf.calculate(ck, ZEROLEN, k_ab, k_ba, 0);
        CipherStatePair ckp = state.split();
        CipherState sender = ckp.getSender();
        byte[] hash = state.getHandshakeHash();
        byte[] encpayloadkey = new byte[32];
        this._hkdf.calculate(k_ba, ZEROLEN, INFO_6, encpayloadkey);
        sender.initializeKey(encpayloadkey, 0);
        try {
            sender.encryptWithAd(hash, payload, 0, enc, 56, payload.length);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldWarn()) {
                this._log.warn("Encrypt fail NSR part 2", gse);
            }
            return null;
        }
        keyManager.updateSession(target, null, state, callback);
        return enc;
    }

    private byte[] encryptExistingSession(CloveSet cloves, PublicKey target, RatchetEntry re, ReplyCallback callback, RatchetSKM keyManager) {
        boolean ackreq = callback != null;
        byte[] rawTag = re.tag.getData();
        byte[] payload = this.createPayload(cloves, 0L, ackreq, re.nextForwardKey, re.nextReverseKey, re.acksToSend);
        SessionKeyAndNonce key = re.key;
        int nonce = key.getNonce();
        byte[] encr = this.encryptAEADBlock(rawTag, payload, key, nonce);
        System.arraycopy(rawTag, 0, encr, 0, 8);
        if (callback != null) {
            keyManager.registerCallback(target, re.keyID, nonce, callback);
        }
        return encr;
    }

    public byte[] encrypt(CloveSet cloves, SessionKey key, RatchetSessionTag tag) {
        byte[] rawTag = tag.getData();
        byte[] payload = this.createPayload(cloves, 0L);
        byte[] encr = this.encryptAEADBlock(rawTag, payload, key, 0L);
        System.arraycopy(rawTag, 0, encr, 0, 8);
        return encr;
    }

    private final byte[] encryptAEADBlock(byte[] data, SessionKey key, long n) {
        return this.encryptAEADBlock(null, data, key, n);
    }

    private final byte[] encryptAEADBlock(byte[] ad, byte[] data, SessionKey key, long n) {
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(key.getData(), 0);
        chacha.setNonce(n);
        int adsz = ad != null ? ad.length : 0;
        byte[] enc = new byte[adsz + data.length + 16];
        try {
            chacha.encryptWithAd(ad, data, 0, enc, adsz, data.length);
        }
        catch (GeneralSecurityException e) {
            if (this._log.shouldWarn()) {
                this._log.warn("Unable to encrypt AEAD block", e);
            }
            return null;
        }
        return enc;
    }

    static final PrivateKey doDH(PrivateKey privkey, PublicKey pubkey) {
        byte[] dh = new byte[32];
        Curve25519.eval(dh, 0, privkey.getData(), pubkey.getData());
        return new PrivateKey(EncType.ECIES_X25519, dh);
    }

    private byte[] createPayload(CloveSet cloves, long expiration) {
        return this.createPayload(cloves, expiration, false, null, null, null);
    }

    private byte[] createPayload(CloveSet cloves, long expiration, boolean ackreq, NextSessionKey nextKey1, NextSessionKey nextKey2, List<Integer> acksToSend) {
        RatchetPayload.Block block;
        int count = cloves.getCloveCount();
        int numblocks = count + 1;
        if (expiration > 0L) {
            ++numblocks;
        }
        if (ackreq) {
            ++numblocks;
        }
        if (nextKey1 != null) {
            ++numblocks;
        }
        if (nextKey2 != null) {
            ++numblocks;
        }
        if (acksToSend != null) {
            ++numblocks;
        }
        int len = 0;
        ArrayList<RatchetPayload.Block> blocks = new ArrayList<RatchetPayload.Block>(numblocks);
        if (expiration > 0L) {
            block = new RatchetPayload.DateTimeBlock(expiration);
            blocks.add(block);
            len += block.getTotalLength();
        }
        if (nextKey1 != null) {
            block = new RatchetPayload.NextKeyBlock(nextKey1);
            blocks.add(block);
            len += block.getTotalLength();
        }
        if (nextKey2 != null) {
            block = new RatchetPayload.NextKeyBlock(nextKey2);
            blocks.add(block);
            len += block.getTotalLength();
        }
        for (int i = 0; i < count; ++i) {
            GarlicClove clove = cloves.getClove(i);
            RatchetPayload.GarlicBlock block2 = new RatchetPayload.GarlicBlock(clove);
            blocks.add(block2);
            len += block2.getTotalLength();
        }
        if (ackreq) {
            RatchetPayload.AckRequestBlock block3 = new RatchetPayload.AckRequestBlock();
            blocks.add(block3);
            len += block3.getTotalLength();
        }
        if (acksToSend != null) {
            RatchetPayload.AckBlock block4 = new RatchetPayload.AckBlock(acksToSend);
            blocks.add(block4);
            len += block4.getTotalLength();
        }
        int padlen = 1 + this._context.random().nextInt(16);
        RatchetPayload.PaddingBlock block5 = new RatchetPayload.PaddingBlock(padlen);
        blocks.add(block5);
        byte[] payload = new byte[len += block5.getTotalLength()];
        int payloadlen = this.createPayload(payload, 0, blocks);
        if (payloadlen != len) {
            throw new IllegalStateException("payload size mismatch");
        }
        return payload;
    }

    private int createPayload(byte[] payload, int off, List<RatchetPayload.Block> blocks) {
        return RatchetPayload.writePayload(payload, off, blocks);
    }

    private byte[] doHMAC(SessionKey key, byte[] data) {
        byte[] rv = new byte[32];
        this._context.hmac256().calculate(key, data, 0, data.length, rv, 0);
        return rv;
    }

    private class PLCallback
    implements RatchetPayload.PayloadCallback {
        public final List<GarlicClove> cloveSet = new ArrayList<GarlicClove>(3);
        private final RatchetSKM skm;
        private final PublicKey remote;
        public long datetime;
        public List<NextSessionKey> nextKeys;
        public boolean ackRequested;

        public PLCallback() {
            this(null, null);
        }

        public PLCallback(RatchetSKM keyManager, PublicKey remoteKey) {
            this.skm = keyManager;
            this.remote = remoteKey;
        }

        @Override
        public void gotDateTime(long time) throws DataFormatException {
            if (ECIESAEADEngine.this._log.shouldDebug()) {
                ECIESAEADEngine.this._log.debug("Got DATE block: " + DataHelper.formatTime(time));
            }
            if (this.datetime != 0L) {
                throw new DataFormatException("Multiple DATETIME blocks");
            }
            this.datetime = time;
            long now = ECIESAEADEngine.this._context.clock().now();
            if (time < now - 300000L || time > now + 120000L) {
                throw new DataFormatException("Excess clock skew in IB NS: " + DataHelper.formatTime(time));
            }
        }

        @Override
        public void gotOptions(byte[] options, boolean isHandshake) {
            if (ECIESAEADEngine.this._log.shouldDebug()) {
                ECIESAEADEngine.this._log.debug("Got OPTIONS block length " + options.length);
            }
        }

        @Override
        public void gotGarlic(GarlicClove clove) {
            if (ECIESAEADEngine.this._log.shouldDebug()) {
                ECIESAEADEngine.this._log.debug("Got GARLIC block: " + clove);
            }
            this.cloveSet.add(clove);
        }

        @Override
        public void gotNextKey(NextSessionKey next) {
            if (ECIESAEADEngine.this._log.shouldDebug()) {
                ECIESAEADEngine.this._log.debug("Got NEXTKEY block: " + next);
            }
            if (this.nextKeys == null) {
                this.nextKeys = new ArrayList<NextSessionKey>(2);
            }
            this.nextKeys.add(next);
        }

        @Override
        public void gotAck(int id, int n) {
            if (ECIESAEADEngine.this._log.shouldDebug()) {
                ECIESAEADEngine.this._log.debug("Got ACK block: " + id + " / " + n);
            }
            if (this.skm != null) {
                this.skm.receivedACK(this.remote, id, n);
            } else if (ECIESAEADEngine.this._log.shouldWarn()) {
                ECIESAEADEngine.this._log.warn("ACK in NS/NSR?");
            }
        }

        @Override
        public void gotAckRequest() {
            if (ECIESAEADEngine.this._log.shouldDebug()) {
                ECIESAEADEngine.this._log.debug("Got ACK REQUEST block");
            }
            this.ackRequested = true;
        }

        @Override
        public void gotTermination(int reason, long count) {
            if (ECIESAEADEngine.this._log.shouldDebug()) {
                ECIESAEADEngine.this._log.debug("Got TERMINATION block, reason: " + reason + " count: " + count);
            }
        }

        @Override
        public void gotUnknown(int type, int len) {
            if (ECIESAEADEngine.this._log.shouldDebug()) {
                ECIESAEADEngine.this._log.debug("Got UNKNOWN block, type: " + type + " len: " + len);
            }
        }

        @Override
        public void gotPadding(int paddingLength, int frameLength) {
            if (ECIESAEADEngine.this._log.shouldDebug()) {
                ECIESAEADEngine.this._log.debug("Got PADDING block, len: " + paddingLength + " in frame len: " + frameLength);
            }
        }
    }
}

