/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketEepGet;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.data.Base32;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFile;
import net.i2p.util.SimpleTimer;
import net.i2p.util.Translate;
import org.klomp.snark.PeerID;
import org.klomp.snark.Snark;
import org.klomp.snark.SnarkManager;
import org.klomp.snark.dht.DHT;
import org.klomp.snark.dht.KRPC;

public class I2PSnarkUtil {
    private final I2PAppContext _context;
    private final Log _log;
    private final String _baseName;
    private boolean _shouldProxy;
    private String _proxyHost;
    private int _proxyPort;
    private String _i2cpHost;
    private int _i2cpPort;
    private final Map<String, String> _opts;
    private volatile I2PSocketManager _manager;
    private boolean _configured;
    private volatile boolean _connecting;
    private final Set<Hash> _banlist;
    private int _maxUploaders;
    private int _maxUpBW;
    private int _maxConnections;
    private final File _tmpDir;
    private int _startupDelay;
    private boolean _collapsePanels;
    private boolean _shouldUseOT;
    private boolean _shouldUseDHT;
    private boolean _enableRatings;
    private boolean _enableComments;
    private String _commentsName;
    private boolean _areFilesPublic;
    private List<String> _openTrackers;
    private DHT _dht;
    private long _startedTime;
    private static final int EEPGET_CONNECT_TIMEOUT = 45000;
    private static final int EEPGET_CONNECT_TIMEOUT_SHORT = 5000;
    public static final int DEFAULT_STARTUP_DELAY = 3;
    public static final boolean DEFAULT_COLLAPSE_PANELS = true;
    public static final boolean DEFAULT_USE_OPENTRACKERS = true;
    public static final int MAX_CONNECTIONS = 24;
    public static final String PROP_MAX_BW = "i2cp.outboundBytesPerSecond";
    public static final boolean DEFAULT_USE_DHT = true;
    public static final String EEPGET_USER_AGENT = "I2PSnark";
    private static final int BASE32_HASH_LENGTH = 52;
    private static final String BUNDLE_NAME = "org.klomp.snark.web.messages";

    public I2PSnarkUtil(I2PAppContext ctx) {
        this(ctx, "i2psnark");
    }

    public I2PSnarkUtil(I2PAppContext ctx, String baseName) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(Snark.class);
        this._baseName = baseName;
        this._opts = new HashMap<String, String>();
        this.setI2CPConfig("127.0.0.1", 7654, null);
        this._banlist = new ConcurrentHashSet<Hash>();
        this._maxUploaders = 20;
        this._maxUpBW = 25;
        this._maxConnections = 24;
        this._startupDelay = 3;
        this._shouldUseOT = true;
        this._openTrackers = Collections.emptyList();
        this._shouldUseDHT = true;
        this._collapsePanels = true;
        this._enableComments = true;
        this._enableRatings = true;
        this._commentsName = "";
        this._tmpDir = new SecureDirectory(ctx.getTempDir(), baseName + '-' + ctx.random().nextInt());
        this._tmpDir.mkdirs();
    }

    public I2PAppContext getContext() {
        return this._context;
    }

    public boolean configured() {
        return this._configured;
    }

    public void setI2CPConfig(String i2cpHost, int i2cpPort, Map opts) {
        if (i2cpHost != null) {
            this._i2cpHost = i2cpHost;
        }
        if (i2cpPort > 0) {
            this._i2cpPort = i2cpPort;
        }
        if (opts != null) {
            this._opts.putAll(opts);
        }
        this.setMaxUpBW(this._maxUpBW);
        this._configured = true;
    }

    public void setMaxUploaders(int limit) {
        this._maxUploaders = limit;
        this._configured = true;
    }

    public void setMaxUpBW(int limit) {
        I2PSession sess;
        this._maxUpBW = limit;
        this._opts.put(PROP_MAX_BW, Integer.toString(limit * 1228));
        this._configured = true;
        if (this._manager != null && (sess = this._manager.getSession()) != null) {
            Properties newProps = new Properties();
            newProps.putAll(this._opts);
            sess.updateOptions(newProps);
        }
    }

    public void setMaxConnections(int limit) {
        this._maxConnections = limit;
        this._configured = true;
    }

    public void setStartupDelay(int minutes) {
        this._startupDelay = minutes;
        this._configured = true;
    }

    public String getI2CPHost() {
        return this._i2cpHost;
    }

    public int getI2CPPort() {
        return this._i2cpPort;
    }

    public Map<String, String> getI2CPOptions() {
        return this._opts;
    }

    public String getEepProxyHost() {
        return this._proxyHost;
    }

    public int getEepProxyPort() {
        return this._proxyPort;
    }

    public boolean getEepProxySet() {
        return this._shouldProxy;
    }

    public int getMaxUploaders() {
        return this._maxUploaders;
    }

    public int getMaxUpBW() {
        return this._maxUpBW;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public int getStartupDelay() {
        return this._startupDelay;
    }

    public boolean getFilesPublic() {
        return this._areFilesPublic;
    }

    public void setFilesPublic(boolean yes) {
        this._areFilesPublic = yes;
    }

    public File getTempDir() {
        return this._tmpDir;
    }

    public synchronized boolean connect() {
        if (this._manager == null) {
            String sout;
            String sin;
            this._connecting = true;
            if (this._log.shouldLog(10)) {
                this._log.debug("Connecting to I2P", new Exception("I did it"));
            }
            Properties opts = this._context.getProperties();
            if (this._opts != null) {
                for (Map.Entry<String, String> entry : this._opts.entrySet()) {
                    opts.setProperty(entry.getKey(), entry.getValue());
                }
            }
            if ((sin = opts.getProperty("inbound.quantity")) != null) {
                int in;
                try {
                    in = Integer.parseInt(sin);
                }
                catch (NumberFormatException nfe) {
                    in = 3;
                }
                if (in > 2) {
                    opts.setProperty("inbound.quantity", "2");
                }
            }
            if ((sout = opts.getProperty("outbound.quantity")) != null) {
                int out;
                try {
                    out = Integer.parseInt(sout);
                }
                catch (NumberFormatException nfe) {
                    out = 3;
                }
                if (out > 2) {
                    opts.setProperty("outbound.quantity", "2");
                }
            }
            if (opts.containsKey("inbound.backupQuantity")) {
                opts.setProperty("inbound.backupQuantity", "0");
            }
            if (opts.containsKey("outbound.backupQuantity")) {
                opts.setProperty("outbound.backupQuantity", "0");
            }
            if (opts.getProperty("inbound.nickname") == null) {
                opts.setProperty("inbound.nickname", this._baseName.replace("i2psnark", EEPGET_USER_AGENT));
            }
            if (opts.getProperty("outbound.nickname") == null) {
                opts.setProperty("outbound.nickname", this._baseName.replace("i2psnark", EEPGET_USER_AGENT));
            }
            if (opts.getProperty("outbound.priority") == null) {
                opts.setProperty("outbound.priority", "-10");
            }
            if (opts.getProperty("i2p.streaming.connectTimeout") == null) {
                opts.setProperty("i2p.streaming.connectTimeout", "75000");
            }
            if (opts.getProperty("i2p.streaming.inactivityTimeout") == null) {
                opts.setProperty("i2p.streaming.inactivityTimeout", "240000");
            }
            if (opts.getProperty("i2p.streaming.inactivityAction") == null) {
                opts.setProperty("i2p.streaming.inactivityAction", "1");
            }
            if (opts.getProperty("i2p.streaming.initialWindowSize") == null) {
                opts.setProperty("i2p.streaming.initialWindowSize", "1");
            }
            if (opts.getProperty("i2p.streaming.slowStartGrowthRateFactor") == null) {
                opts.setProperty("i2p.streaming.slowStartGrowthRateFactor", "1");
            }
            if (opts.getProperty("i2p.streaming.maxConnsPerMinute") == null) {
                opts.setProperty("i2p.streaming.maxConnsPerMinute", "2");
            }
            if (opts.getProperty("i2p.streaming.maxTotalConnsPerMinute") == null) {
                opts.setProperty("i2p.streaming.maxTotalConnsPerMinute", "8");
            }
            if (opts.getProperty("i2p.streaming.maxConnsPerHour") == null) {
                opts.setProperty("i2p.streaming.maxConnsPerHour", "20");
            }
            if (opts.getProperty("i2p.streaming.enforceProtocol") == null) {
                opts.setProperty("i2p.streaming.enforceProtocol", "true");
            }
            if (opts.getProperty("i2p.streaming.disableRejectLogging") == null) {
                opts.setProperty("i2p.streaming.disableRejectLogging", "true");
            }
            if (opts.getProperty("i2p.streaming.answerPings") == null) {
                opts.setProperty("i2p.streaming.answerPings", "false");
            }
            if (opts.getProperty("i2cp.destination.sigType") == null) {
                opts.setProperty("i2cp.destination.sigType", "EdDSA_SHA512_Ed25519");
            }
            this._manager = I2PSocketManagerFactory.createManager(this._i2cpHost, this._i2cpPort, opts);
            if (this._manager != null) {
                this._startedTime = this._context.clock().now();
            }
            this._connecting = false;
        }
        if (this._shouldUseDHT && this._manager != null && this._dht == null) {
            this._dht = new KRPC(this._context, this._baseName, this._manager.getSession());
        }
        return this._manager != null;
    }

    public DHT getDHT() {
        return this._dht;
    }

    public boolean connected() {
        return this._manager != null;
    }

    public boolean isConnecting() {
        return this._manager == null && this._connecting;
    }

    public I2PSocketManager getSocketManager() {
        return this._manager;
    }

    public synchronized void disconnect() {
        if (this._dht != null) {
            this._dht.stop();
            this._dht = null;
        }
        this._startedTime = 0L;
        I2PSocketManager mgr = this._manager;
        this._manager = null;
        this._banlist.clear();
        if (mgr != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Disconnecting from I2P", new Exception("I did it"));
            }
            mgr.destroySocketManager();
        }
        FileUtil.rmdir(this._tmpDir, false);
        this._tmpDir.mkdirs();
    }

    public long getStartedTime() {
        return this._startedTime;
    }

    I2PSocket connect(PeerID peer) throws IOException {
        I2PSocketManager mgr = this._manager;
        if (mgr == null) {
            throw new IOException("No socket manager");
        }
        Destination addr = peer.getAddress();
        if (addr == null) {
            throw new IOException("Null address");
        }
        if (addr.equals(this.getMyDestination())) {
            throw new IOException("Attempt to connect to myself");
        }
        Hash dest = addr.calculateHash();
        if (this._banlist.contains(dest)) {
            throw new IOException("Not trying to contact " + dest.toBase64() + ", as they are banlisted");
        }
        try {
            I2PSocket rv = this._manager.connect(addr);
            if (rv != null) {
                this._banlist.remove(dest);
            }
            return rv;
        }
        catch (I2PException ie) {
            this._banlist.add(dest);
            this._context.simpleTimer2().addEvent(new Unbanlist(dest), 600000L);
            IOException ioe = new IOException("Unable to reach the peer " + peer);
            ioe.initCause(ie);
            throw ioe;
        }
    }

    public File get(String url) {
        return this.get(url, true, 0);
    }

    public File get(String url, boolean rewrite) {
        return this.get(url, rewrite, 0);
    }

    public File get(String url, int retries) {
        return this.get(url, true, retries);
    }

    public File get(String url, boolean rewrite, int retries) {
        int timeout;
        if (this._log.shouldLog(10)) {
            this._log.debug("Fetching [" + url + "] proxy=" + this._proxyHost + ":" + this._proxyPort + ": " + this._shouldProxy);
        }
        File out = null;
        try {
            out = SecureFile.createTempFile("i2psnark", null, this._tmpDir);
        }
        catch (IOException ioe) {
            this._log.error("temp file error", ioe);
            if (out != null) {
                out.delete();
            }
            return null;
        }
        out.deleteOnExit();
        String fetchURL = url;
        if (rewrite) {
            fetchURL = this.rewriteAnnounce(url);
        }
        if (retries < 0) {
            if (!this.connected()) {
                return null;
            }
            timeout = 5000;
            retries = 0;
        } else {
            timeout = 45000;
            if (!this.connected() && !this.connect()) {
                return null;
            }
        }
        I2PSocketEepGet get = new I2PSocketEepGet(this._context, this._manager, retries, out.getAbsolutePath(), fetchURL);
        get.addHeader("User-Agent", EEPGET_USER_AGENT);
        if (get.fetch(timeout)) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Fetch successful [" + url + "]: size=" + out.length());
            }
            return out;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Fetch failed [" + url + "]");
        }
        out.delete();
        return null;
    }

    public byte[] get(String url, boolean rewrite, int retries, int initialSize, int maxSize) {
        int timeout;
        if (this._log.shouldLog(10)) {
            this._log.debug("Fetching [" + url + "] to memory");
        }
        String fetchURL = url;
        if (rewrite) {
            fetchURL = this.rewriteAnnounce(url);
        }
        if (retries < 0) {
            if (!this.connected()) {
                return null;
            }
            timeout = 5000;
            retries = 0;
        } else {
            timeout = 45000;
            if (!this.connected() && !this.connect()) {
                return null;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(initialSize);
        I2PSocketEepGet get = new I2PSocketEepGet(this._context, this._manager, retries, -1L, (long)maxSize, null, out, fetchURL);
        get.addHeader("User-Agent", EEPGET_USER_AGENT);
        if (get.fetch(timeout)) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Fetch successful [" + url + "]: size=" + out.size());
            }
            return out.toByteArray();
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Fetch failed [" + url + "]");
        }
        return null;
    }

    public I2PServerSocket getServerSocket() {
        I2PSocketManager mgr = this._manager;
        if (mgr != null) {
            return mgr.getServerSocket();
        }
        return null;
    }

    public String getOurIPString() {
        Destination dest = this.getMyDestination();
        if (dest != null) {
            return dest.toBase64();
        }
        return "unknown";
    }

    Destination getMyDestination() {
        if (this._manager == null) {
            return null;
        }
        I2PSession sess = this._manager.getSession();
        if (sess != null) {
            return sess.getMyDestination();
        }
        return null;
    }

    static Destination getDestinationFromBase64(String ip) {
        if (ip == null) {
            return null;
        }
        if (ip.endsWith(".i2p")) {
            if (ip.length() < 520) {
                return null;
            }
            try {
                return new Destination(ip.substring(0, ip.length() - 4));
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        try {
            return new Destination(ip);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    Destination getDestination(String ip) {
        if (ip == null) {
            return null;
        }
        if (ip.endsWith(".i2p")) {
            if (ip.length() < 520) {
                byte[] b;
                I2PSession sess;
                if (this._manager != null && ip.length() == 60 && ip.endsWith(".b32.i2p") && (sess = this._manager.getSession()) != null && (b = Base32.decode(ip.substring(0, 52))) != null) {
                    Hash h = Hash.create(b);
                    if (this._log.shouldLog(20)) {
                        this._log.info("Using existing session for lookup of " + ip);
                    }
                    try {
                        return sess.lookupDest(h, 15000L);
                    }
                    catch (I2PSessionException i2PSessionException) {
                        // empty catch block
                    }
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Using naming service for lookup of " + ip);
                }
                return this._context.namingService().lookup(ip);
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Creating Destination for " + ip);
            }
            try {
                return new Destination(ip.substring(0, ip.length() - 4));
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Creating Destination for " + ip);
        }
        try {
            return new Destination(ip);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    public String lookup(String name) {
        Destination dest = this.getDestination(name);
        if (dest == null) {
            return null;
        }
        return dest.toBase64();
    }

    String rewriteAnnounce(String origAnnounce) {
        int destStart = "http://".length();
        int destEnd = origAnnounce.indexOf(".i2p");
        if (destEnd < destStart + 516) {
            return origAnnounce;
        }
        int pathStart = origAnnounce.indexOf(47, destEnd);
        String rv = "http://i2p/" + origAnnounce.substring(destStart, destEnd) + origAnnounce.substring(pathStart);
        return rv;
    }

    public void setOpenTrackers(List<String> ot) {
        this._openTrackers = ot;
    }

    public List<String> getOpenTrackers() {
        if (!this.shouldUseOpenTrackers()) {
            return Collections.emptyList();
        }
        return this._openTrackers;
    }

    public boolean isKnownOpenTracker(String url) {
        try {
            URI u = new URI(url);
            String host = u.getHost();
            return host != null && SnarkManager.KNOWN_OPENTRACKERS.contains(host);
        }
        catch (URISyntaxException use) {
            return false;
        }
    }

    public List<String> getBackupTrackers() {
        return this._openTrackers;
    }

    public void setUseOpenTrackers(boolean yes) {
        this._shouldUseOT = yes;
    }

    public boolean shouldUseOpenTrackers() {
        return this._shouldUseOT;
    }

    public synchronized void setUseDHT(boolean yes) {
        this._shouldUseDHT = yes;
        if (yes && this._manager != null && this._dht == null) {
            this._dht = new KRPC(this._context, this._baseName, this._manager.getSession());
        } else if (!yes && this._dht != null) {
            this._dht.stop();
            this._dht = null;
        }
    }

    public boolean shouldUseDHT() {
        return this._shouldUseDHT;
    }

    public void setRatingsEnabled(boolean yes) {
        this._enableRatings = yes;
    }

    public boolean ratingsEnabled() {
        return this._enableRatings;
    }

    public void setCommentsEnabled(boolean yes) {
        this._enableComments = yes;
    }

    public boolean commentsEnabled() {
        return this._enableComments;
    }

    public void setCommentsName(String name) {
        this._commentsName = name;
    }

    public String getCommentsName() {
        return this._commentsName == null ? "" : this._commentsName;
    }

    public boolean utCommentsEnabled() {
        return this._enableRatings || this._enableComments;
    }

    public boolean collapsePanels() {
        return this._collapsePanels;
    }

    public void setCollapsePanels(boolean yes) {
        this._collapsePanels = yes;
    }

    public static String toHex(byte[] b) {
        StringBuilder buf = new StringBuilder(40);
        for (int i = 0; i < b.length; ++i) {
            int bi = b[i] & 0xFF;
            if (bi < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(bi));
        }
        return buf.toString();
    }

    public String getString(String key) {
        return Translate.getString(key, this._context, BUNDLE_NAME);
    }

    public String getString(String s, Object o) {
        return Translate.getString(s, o, this._context, BUNDLE_NAME);
    }

    public String getString(String s, Object o, Object o2) {
        return Translate.getString(s, o, o2, this._context, BUNDLE_NAME);
    }

    public String getString(int n, String s, String p) {
        return Translate.getString(n, s, p, this._context, BUNDLE_NAME);
    }

    private class Unbanlist
    implements SimpleTimer.TimedEvent {
        private Hash _dest;

        public Unbanlist(Hash dest) {
            this._dest = dest;
        }

        @Override
        public void timeReached() {
            I2PSnarkUtil.this._banlist.remove(this._dest);
        }
    }
}

