/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;

public final class SHA256Generator {
    private final LinkedBlockingQueue<MessageDigest> _digests = new LinkedBlockingQueue(32);

    public SHA256Generator(I2PAppContext context) {
    }

    public static final SHA256Generator getInstance() {
        return I2PAppContext.getGlobalContext().sha();
    }

    public final Hash calculateHash(byte[] source) {
        return this.calculateHash(source, 0, source.length);
    }

    public final Hash calculateHash(byte[] source, int start, int len) {
        MessageDigest digest = this.acquire();
        digest.update(source, start, len);
        byte[] rv = digest.digest();
        this.release(digest);
        return Hash.create(rv);
    }

    public final void calculateHash(byte[] source, int start, int len, byte[] out, int outOffset) {
        MessageDigest digest = this.acquire();
        digest.update(source, start, len);
        try {
            digest.digest(out, outOffset, 32);
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release(digest);
        }
    }

    private MessageDigest acquire() {
        MessageDigest rv = this._digests.poll();
        if (rv != null) {
            rv.reset();
        } else {
            rv = SHA256Generator.getDigestInstance();
        }
        return rv;
    }

    private void release(MessageDigest digest) {
        this._digests.offer(digest);
    }

    public static MessageDigest getDigestInstance() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: SHA256Generator 'text to hash'");
            System.exit(1);
        }
        System.out.println(Base64.encode(SHA256Generator.getInstance().calculateHash(DataHelper.getUTF8(args[0])).getData()));
    }
}

