/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class ExpireLeasesJob
extends JobImpl {
    private final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 60000L;

    public ExpireLeasesJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(ExpireLeasesJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Expire Lease Sets Job";
    }

    @Override
    public void runJob() {
        List<Hash> toExpire = this.selectKeysToExpire();
        for (Hash key : toExpire) {
            this._facade.fail(key);
        }
        if (this._log.shouldInfo()) {
            this._log.info("(dbid: " + this._facade + "; db size: " + this._facade.getKnownLeaseSets() + ") Leases expired: " + toExpire);
        }
        this.requeue(60000L);
    }

    private List<Hash> selectKeysToExpire() {
        RouterContext ctx = this.getContext();
        ArrayList<Hash> toExpire = new ArrayList<Hash>(128);
        for (Map.Entry<Hash, DatabaseEntry> entry : this._facade.getDataStore().getMapEntries()) {
            LeaseSet ls;
            DatabaseEntry obj = entry.getValue();
            if (!obj.isLeaseSet() || (ls = (LeaseSet)obj).isCurrent(60000L)) continue;
            Hash h = entry.getKey();
            toExpire.add(h);
            if (!ctx.clientManager().isLocal(h)) continue;
            this._log.logAlways(30, "Expired local leaseset " + h.toBase32());
        }
        return toExpire;
    }
}

