/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class MTU {
    private static final boolean hasMTU = SystemVersion.isJava6();

    private MTU() {
    }

    public static int getMTU(InetAddress ia, boolean isSSU2) {
        Enumeration<NetworkInterface> ifcs;
        if (ia == null || !hasMTU) {
            return 0;
        }
        try {
            ifcs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException se) {
            return 0;
        }
        catch (Error e) {
            return 0;
        }
        if (ifcs != null) {
            ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
            while (ifcs.hasMoreElements()) {
                NetworkInterface ifc = ifcs.nextElement();
                try {
                    if (!ifc.isUp()) {
                    }
                }
                catch (SocketException e) {}
                continue;
                interfaces.add(ifc);
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!ia.equals(addr)) continue;
                    try {
                        boolean isIPv6 = addr instanceof Inet6Address;
                        int mtu = ifc.getMTU();
                        if (mtu < 0) {
                            int n = mtu = isIPv6 ? 1280 : 1500;
                        }
                        if (mtu > 0 && (isIPv6 && mtu < 1280 || !isIPv6 && mtu < 620)) {
                            Log log = I2PAppContext.getGlobalContext().logManager().getLog(MTU.class);
                            log.logAlways(30, "Unusually low MTU " + mtu + " for interface " + ia + ", consider disabling");
                        }
                        if (isIPv6 && mtu > 1420) {
                            byte[] ip = addr.getAddress();
                            if (mtu > 1472 && ip[0] == 32 && ip[1] == 1 && ip[2] == 4 && ip[3] == 112) {
                                return 1472;
                            }
                            if (ip[0] == 42 && ip[1] == 6 && ip[2] == -96 && ip[3] == 4) {
                                return 1420;
                            }
                        }
                        if (isSSU2) {
                            return Math.min(mtu, 1500);
                        }
                        if (mtu == 1280) {
                            return 1280;
                        }
                        return MTU.rectify(isIPv6, mtu);
                    }
                    catch (SocketException isIPv6) {
                    }
                    catch (Throwable t) {
                        return 0;
                    }
                }
            }
            boolean isIPv6 = ia instanceof Inet6Address;
            int rv = 1501;
            block12: for (NetworkInterface ifc : interfaces) {
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    int mtu;
                    byte[] ip;
                    InetAddress addr = addrs.nextElement();
                    if (isIPv6 != addr instanceof Inet6Address || addr.isLinkLocalAddress() || addr.isMulticastAddress() || addr.isAnyLocalAddress() || addr.isLoopbackAddress()) continue;
                    if (isIPv6 && ((ip = addr.getAddress())[0] & 0xFE) == 2) continue block12;
                    try {
                        mtu = ifc.getMTU();
                    }
                    catch (Throwable t) {
                        continue block12;
                    }
                    if (mtu < 0) continue block12;
                    if (isIPv6 && mtu > 1420) {
                        byte[] ip2 = addr.getAddress();
                        if (mtu > 1472 && ip2[0] == 32 && ip2[1] == 1 && ip2[2] == 4 && ip2[3] == 112) {
                            mtu = 1472;
                        }
                        if (ip2[0] == 42 && ip2[1] == 6 && ip2[2] == -96 && ip2[3] == 4) {
                            mtu = 1420;
                        }
                    }
                    if (mtu >= rv) continue block12;
                    rv = mtu;
                    continue block12;
                }
            }
            if (rv < 1501) {
                if (isSSU2) {
                    return rv;
                }
                if (rv == 1280) {
                    return rv;
                }
                return MTU.rectify(isIPv6, rv);
            }
        }
        return 0;
    }

    public static int rectify(boolean isIPv6, int mtu) {
        int rv = mtu;
        int mod = rv % 16;
        if (isIPv6) {
            return Math.max(1280, Math.min(1488, rv -= mod));
        }
        if (mod > 12) {
            rv -= mod - 12;
        } else if (mod < 12) {
            rv -= mod + 4;
        }
        return Math.max(620, Math.min(1484, rv));
    }

    public static void main(String[] args) {
        block12: {
            if (args.length > 0) {
                System.out.println("Cmd line interfaces:");
                for (int i = 0; i < args.length; ++i) {
                    try {
                        InetAddress test = InetAddress.getByName(args[i]);
                        System.out.println("I2P MTU of " + args[i] + " is " + MTU.getMTU(test, false) + "; SSU2 MTU is " + MTU.getMTU(test, true));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            System.out.println("All interfaces:");
            try {
                Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
                if (ifcs == null) break block12;
                TreeMap<InetAddress, Integer> sorted = new TreeMap<InetAddress, Integer>(new IAComparator());
                while (ifcs.hasMoreElements()) {
                    NetworkInterface ifc = ifcs.nextElement();
                    try {
                        if (!ifc.isUp()) {
                        }
                    }
                    catch (SocketException e) {}
                    continue;
                    int mtu = ifc.getMTU();
                    Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress addr = addrs.nextElement();
                        sorted.put(addr, mtu);
                    }
                }
                for (Map.Entry e : sorted.entrySet()) {
                    InetAddress addr = (InetAddress)e.getKey();
                    Integer mtu = (Integer)e.getValue();
                    System.out.println("MTU for " + addr.getHostAddress() + " is " + mtu + "; I2P MTU is " + MTU.getMTU(addr, false) + "; SSU2 MTU is " + MTU.getMTU(addr, true));
                }
            }
            catch (SocketException se) {
                System.out.println("no interfaces");
            }
        }
    }

    private static class IAComparator
    implements Comparator<InetAddress> {
        private IAComparator() {
        }

        @Override
        public int compare(InetAddress l, InetAddress r) {
            return l.getHostAddress().compareTo(r.getHostAddress());
        }
    }
}

