/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.naming.LookupDest;
import net.i2p.client.naming.NamingService;
import net.i2p.data.Destination;
import net.i2p.util.LHMCache;
import net.i2p.util.SystemVersion;

public class DummyNamingService
extends NamingService {
    protected static final int BASE32_HASH_LENGTH = 52;
    public static final String PROP_B32 = "i2p.naming.hostsTxt.useB32";
    protected static final int CACHE_MAX_SIZE = SystemVersion.isAndroid() ? 32 : 128;
    public static final int DEST_SIZE = 516;
    private static final Map<String, Destination> _cache = new LHMCache<String, Destination>(CACHE_MAX_SIZE);

    protected DummyNamingService(I2PAppContext context) {
        super(context);
    }

    @Override
    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        Destination d = DummyNamingService.getCache(hostname);
        if (d != null) {
            return d;
        }
        if (hostname.length() >= 516) {
            d = this.lookupBase64(hostname);
            if (d != null) {
                DummyNamingService.putCache(hostname, d);
            }
            return d;
        }
        if (hostname.length() >= 60 && hostname.toLowerCase(Locale.US).endsWith(".b32.i2p") && this._context.getBooleanPropertyDefaultTrue(PROP_B32)) {
            try {
                d = hostname.length() == 60 ? LookupDest.lookupBase32Hash(this._context, hostname.substring(0, 52)) : LookupDest.lookupHostname(this._context, hostname);
                if (d != null) {
                    DummyNamingService.putCache(hostname, d);
                    return d;
                }
            }
            catch (I2PSessionException i2pse) {
                this._log.warn("couldn't lookup b32", i2pse);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void putCache(String s, Destination d) {
        if (d == null) {
            return;
        }
        Map<String, Destination> map = _cache;
        synchronized (map) {
            _cache.put(s, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Destination getCache(String s) {
        Map<String, Destination> map = _cache;
        synchronized (map) {
            return _cache.get(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeCache(String s) {
        Map<String, Destination> map = _cache;
        synchronized (map) {
            _cache.remove(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void clearCache() {
        Map<String, Destination> map = _cache;
        synchronized (map) {
            _cache.clear();
        }
    }
}

