/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import net.i2p.data.router.RouterInfo;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.TunnelHistory;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;

class CapacityCalculator {
    public static final String PROP_COUNTRY_BONUS = "profileOrganizer.sameCountryBonus";
    static final long GROWTH_FACTOR = 5L;
    private static long ESTIMATE_PERIOD = 3600000L;
    private static final double PENALTY_NEW = 4.0;
    private static final double BONUS_ESTABLISHED = 0.65;
    private static final double BONUS_SAME_COUNTRY = 0.0;
    private static final double BONUS_XOR = 0.25;
    private static final double PENALTY_UNREACHABLE = 2.0;
    private static final double PENALTY_NO_RI = 2.0;
    private static final double PENALTY_L_CAP = 1.0;
    private static final double PENALTY_NO_R_CAP = 1.0;
    private static final double PENALTY_U_CAP = 2.0;
    private static final double PENALTY_LAST_SEND_FAIL = 4.0;
    private static final double PENALTY_RECENT_SEND_FAIL = 4.0;
    private static final double BONUS_LAST_SEND_SUCCESS = 1.0;
    private static final double BONUS_RECENT_SEND_SUCCESS = 1.0;
    private static final double BONUS_NON_FLOODFILL = 1.0;

    CapacityCalculator() {
    }

    public static double calc(PeerProfile profile) {
        NetworkDatabaseFacade ndb;
        long firstHeard;
        long ago;
        double capacity;
        boolean enableAgeChecks;
        RouterContext context = profile.getContext();
        long now = context.clock().now();
        TunnelHistory history = profile.getTunnelHistory();
        long down = context.router().getEstimatedDowntime();
        long up = context.router().getUptime();
        boolean bl = enableAgeChecks = down > 0L && down < 2700000L || up > 3600000L;
        if (enableAgeChecks && CapacityCalculator.tooOld(profile, now)) {
            capacity = 1.0;
        } else {
            RateStat failedStat;
            RateStat rejectStat;
            RateStat acceptStat = profile.getTunnelCreateResponseTime();
            double capacity10m = CapacityCalculator.estimateCapacity(acceptStat, rejectStat = history.getRejectionRate(), failedStat = history.getFailedRate(), 600000);
            if (capacity10m <= 0.0) {
                capacity = 0.0;
            } else {
                double capacity60m = CapacityCalculator.estimateCapacity(acceptStat, rejectStat, failedStat, 3600000);
                double capacity1d = CapacityCalculator.estimateCapacity(acceptStat, rejectStat, failedStat, 86400000);
                long cutoff = now - 351000L;
                if (history.getLastRejectedProbabalistic() > cutoff) {
                    capacity10m /= 2.0;
                } else if (history.getLastRejectedTransient() > cutoff) {
                    capacity10m /= 4.0;
                }
                capacity = capacity10m * 0.4 + capacity60m * 0.5 + capacity1d * 0.1;
            }
        }
        if (enableAgeChecks && (ago = now - (firstHeard = profile.getFirstHeardAbout())) < 0x6DDD00L) {
            capacity -= 4.0 * (double)(0x6DDD00L - ago) / 2.0 * 60.0 * 60.0 * 1000.0;
        }
        if (profile.isEstablished()) {
            capacity += 0.65;
        }
        if (profile.wasUnreachable()) {
            capacity -= 2.0;
        }
        if ((ndb = context.netDb()) != null) {
            RouterInfo ri = (RouterInfo)ndb.lookupLocallyWithoutValidation(profile.getPeer());
            if (ri != null) {
                String caps;
                if (!FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
                    capacity += 1.0;
                }
                if ((caps = ri.getCapabilities()).indexOf(82) < 0) {
                    capacity -= 1.0;
                }
                if (caps.indexOf(85) >= 0) {
                    capacity -= 2.0;
                }
                if (caps.indexOf(76) >= 0) {
                    capacity -= 1.0;
                }
            } else {
                capacity -= 2.0;
            }
        }
        long lastGood = profile.getLastSendSuccessful();
        long lastBad = profile.getLastSendFailed();
        if (lastBad > lastGood) {
            capacity -= 4.0;
            if (lastGood > now - 1800000L) {
                capacity += 4.0;
            }
        } else if (lastGood > 0L) {
            capacity += 1.0;
            if (lastGood > now - 1800000L) {
                capacity += 1.0;
            }
        }
        capacity -= (double)profile.getXORDistance() * 0.001953125;
        if ((capacity += (double)profile.getCapacityBonus()) < 0.0) {
            capacity = 0.0;
        }
        return capacity;
    }

    private static boolean tooOld(PeerProfile profile, long now) {
        return !profile.getIsActive(3600000L, now);
    }

    private static double estimateCapacity(RateStat acceptStat, RateStat rejectStat, RateStat failedStat, int period) {
        double failed;
        long rejected;
        Rate curAccepted = acceptStat.getRate(period);
        Rate curRejected = rejectStat.getRate(period);
        Rate curFailed = failedStat.getRate(period);
        RateAverages ra = RateAverages.getTemp();
        double eventCount = 0.0;
        if (curAccepted != null && (eventCount = (double)curAccepted.computeAverages(ra, false).getTotalEventCount()) > 0.0 && curRejected != null && (rejected = curRejected.computeAverages(ra, false).getTotalEventCount()) > 0L) {
            eventCount *= eventCount / (eventCount + (double)(2L * rejected));
        }
        double stretch = (double)ESTIMATE_PERIOD / (double)period;
        double val = eventCount * stretch;
        if (curFailed != null && (failed = curFailed.computeAverages(ra, false).getTotalValues()) > 0.0) {
            val -= 0.04 * failed * stretch;
        }
        if ((val += 5.0) >= 0.0) {
            return val;
        }
        return 0.0;
    }
}

