/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageHistory;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.Service;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class InNetMessagePool
implements Service {
    private final Log _log;
    private final RouterContext _context;
    private final HandlerJobBuilder[] _handlerJobBuilders;
    private final List<I2NPMessage> _pendingDataMessages;
    private final List<Hash> _pendingDataMessagesFrom;
    private final List<I2NPMessage> _pendingGatewayMessages;
    private SharedShortCircuitDataJob _shortCircuitDataJob;
    private SharedShortCircuitGatewayJob _shortCircuitGatewayJob;
    private boolean _alive;
    private final boolean _dispatchThreaded;
    private static final int MAX_I2NP_MESSAGE_TYPE = 31;
    private static final String PROP_DISPATCH_THREADED = "router.dispatchThreaded";
    private static final boolean DEFAULT_DISPATCH_THREADED = false;
    private static final String PROP_DISPATCH_DIRECT = "router.dispatchDirect";
    private static final boolean DEFAULT_DISPATCH_DIRECT = true;
    private final boolean DISPATCH_DIRECT;

    public InNetMessagePool(RouterContext context) {
        this._context = context;
        this._handlerJobBuilders = new HandlerJobBuilder[32];
        this._dispatchThreaded = this._context.getProperty(PROP_DISPATCH_THREADED, false);
        boolean bl = this.DISPATCH_DIRECT = !this._dispatchThreaded && this._context.getProperty(PROP_DISPATCH_DIRECT, true);
        if (this.DISPATCH_DIRECT) {
            this._pendingDataMessages = null;
            this._pendingDataMessagesFrom = null;
            this._pendingGatewayMessages = null;
        } else {
            this._pendingDataMessages = new ArrayList<I2NPMessage>(16);
            this._pendingDataMessagesFrom = new ArrayList<Hash>(16);
            this._pendingGatewayMessages = new ArrayList<I2NPMessage>(16);
            this._shortCircuitDataJob = new SharedShortCircuitDataJob(context);
            this._shortCircuitGatewayJob = new SharedShortCircuitGatewayJob(context);
        }
        this._log = this._context.logManager().getLog(InNetMessagePool.class);
        this._context.statManager().createRateStat("inNetPool.dropped", "How often do we drop a message", "InNetPool", new long[]{3600000L});
        this._context.statManager().createRateStat("inNetPool.droppedDeliveryStatusDelay", "How long after a delivery status message is created do we receive it back again (for messages that are too slow to be handled)", "InNetPool", new long[]{3600000L});
        this._context.statManager().createRateStat("inNetPool.duplicate", "How often do we receive a duplicate message", "InNetPool", new long[]{3600000L});
        this._context.statManager().createRateStat("inNetPool.droppedDbLookupResponseMessage", "How often we drop a slow-to-arrive db search response", "InNetPool", new long[]{3600000L});
    }

    public synchronized HandlerJobBuilder registerHandlerJobBuilder(int i2npMessageType, HandlerJobBuilder builder) {
        HandlerJobBuilder old = this._handlerJobBuilders[i2npMessageType];
        this._handlerJobBuilders[i2npMessageType] = builder;
        return old;
    }

    public int add(I2NPMessage messageBody, RouterIdentity fromRouter, Hash fromRouterHash) {
        return this.add(messageBody, fromRouter, fromRouterHash, 0L);
    }

    public int add(I2NPMessage messageBody, RouterIdentity fromRouter, Hash fromRouterHash, long msgIDBloomXor) {
        boolean doHistory;
        MessageHistory history;
        block28: {
            block29: {
                int replies;
                history = this._context.messageHistory();
                doHistory = history.getDoLog();
                long exp = messageBody.getMessageExpiration();
                if (this._log.shouldDebug()) {
                    this._log.debug("Rcvd ID " + messageBody.getUniqueId() + " xor-ed ID " + messageBody.getUniqueId(msgIDBloomXor) + " exp. " + new Date(exp) + " type " + messageBody.getClass().getSimpleName());
                }
                int type = messageBody.getType();
                String invalidReason = null;
                invalidReason = type == 18 ? this._context.messageValidator().validateMessage(exp) : this._context.messageValidator().validateMessage(messageBody.getUniqueId(msgIDBloomXor), exp);
                if (invalidReason != null) {
                    int level = 30;
                    if (this._log.shouldLog(level)) {
                        this._log.log(level, "Dropping message ID [" + messageBody.getUniqueId() + " xor-ed: " + messageBody.getUniqueId(msgIDBloomXor) + " expiring on " + exp + "]: " + messageBody.getClass().getSimpleName() + ": " + invalidReason + ": " + messageBody);
                    }
                    this._context.statManager().addRateData("inNetPool.dropped", 1L);
                    this._context.statManager().addRateData("inNetPool.duplicate", 1L);
                    if (doHistory) {
                        history.droppedOtherMessage(messageBody, fromRouter != null ? fromRouter.calculateHash() : fromRouterHash);
                        history.messageProcessingError(messageBody.getUniqueId(msgIDBloomXor), messageBody.getClass().getSimpleName(), "Duplicate/expired");
                    }
                    return -1;
                }
                boolean jobFound = false;
                boolean allowMatches = true;
                switch (type) {
                    case 19: {
                        this.shortCircuitTunnelGateway(messageBody);
                        allowMatches = false;
                        break;
                    }
                    case 18: {
                        this.shortCircuitTunnelData(messageBody, fromRouterHash);
                        allowMatches = false;
                        break;
                    }
                    case 1: {
                        List<OutNetMessage> origMessages = this._context.messageRegistry().getOriginalMessages(messageBody);
                        HandlerJobBuilder dsmbuilder = this._handlerJobBuilders[1];
                        Job dsmjob = dsmbuilder.createJob(messageBody, fromRouter, fromRouterHash);
                        int sz = origMessages.size();
                        if (sz > 0) {
                            DatabaseStoreMessage dbsm = (DatabaseStoreMessage)messageBody;
                            dbsm.setReceivedAsReply();
                            if (dsmjob != null) {
                                dsmjob.runJob();
                            }
                            for (int i = 0; i < sz; ++i) {
                                OutNetMessage omsg = origMessages.get(i);
                                ReplyJob job = omsg.getOnReplyJob();
                                if (job == null) continue;
                                job.setMessage(messageBody);
                                this._context.jobQueue().addJob(job);
                            }
                        } else if (dsmjob != null) {
                            this._context.jobQueue().addJob(dsmjob);
                        }
                        allowMatches = false;
                        break;
                    }
                    default: {
                        if (type <= 0 || type >= this._handlerJobBuilders.length) break;
                        HandlerJobBuilder builder = this._handlerJobBuilders[type];
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Add msg to the pool - builder: " + builder + " type: " + messageBody.getClass().getSimpleName());
                        }
                        if (builder == null) break;
                        Job job = builder.createJob(messageBody, fromRouter, fromRouterHash);
                        if (job != null) {
                            this._context.jobQueue().addJob(job);
                        }
                        jobFound = true;
                    }
                }
                if (!allowMatches || (replies = this.handleReplies(messageBody)) > 0) break block28;
                if (jobFound) break block29;
                if (doHistory) {
                    history.droppedOtherMessage(messageBody, fromRouter != null ? fromRouter.calculateHash() : fromRouterHash);
                }
                switch (type) {
                    case 10: {
                        long arr = ((DeliveryStatusMessage)messageBody).getArrival();
                        if (arr > 10L) {
                            long timeSinceSent = this._context.clock().now() - arr;
                            if (this._log.shouldLog(30)) {
                                this._log.warn("Dropping unhandled delivery status message created " + timeSinceSent + "ms ago: " + messageBody);
                            }
                            this._context.statManager().addRateData("inNetPool.droppedDeliveryStatusDelay", timeSinceSent);
                            break;
                        }
                        break block28;
                    }
                    case 3: {
                        break;
                    }
                    case 2: {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Dropping netDb lookup due to throttling");
                            break;
                        }
                        break block28;
                    }
                    default: {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Message expiring on " + messageBody.getMessageExpiration() + " was not handled by a HandlerJobBuilder - DROPPING: " + messageBody, new Exception("f00!"));
                        }
                        this._context.statManager().addRateData("inNetPool.dropped", 1L);
                        break;
                    }
                }
                break block28;
            }
            if (doHistory) {
                String mtype = messageBody.getClass().getName();
                history.receiveMessage(mtype, messageBody.getUniqueId(msgIDBloomXor), messageBody.getMessageExpiration(), fromRouterHash, true);
            }
            return 0;
        }
        if (doHistory) {
            String mtype = messageBody.getClass().getName();
            history.receiveMessage(mtype, messageBody.getUniqueId(msgIDBloomXor), messageBody.getMessageExpiration(), fromRouterHash, true);
        }
        return 0;
    }

    public int handleReplies(I2NPMessage messageBody) {
        List<OutNetMessage> origMessages = this._context.messageRegistry().getOriginalMessages(messageBody);
        int sz = origMessages.size();
        if (sz <= 0) {
            return 0;
        }
        for (int i = 0; i < sz; ++i) {
            OutNetMessage omsg = origMessages.get(i);
            ReplyJob job = omsg.getOnReplyJob();
            if (job == null) continue;
            job.setMessage(messageBody);
            this._context.jobQueue().addJob(job);
        }
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shortCircuitTunnelGateway(I2NPMessage messageBody) {
        if (this.DISPATCH_DIRECT) {
            this.doShortCircuitTunnelGateway(messageBody);
        } else {
            List<I2NPMessage> list = this._pendingGatewayMessages;
            synchronized (list) {
                this._pendingGatewayMessages.add(messageBody);
                this._pendingGatewayMessages.notifyAll();
            }
            if (!this._dispatchThreaded) {
                this._context.jobQueue().addJob(this._shortCircuitGatewayJob);
            }
        }
    }

    private void doShortCircuitTunnelGateway(I2NPMessage messageBody) {
        this._context.tunnelDispatcher().dispatch((TunnelGatewayMessage)messageBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shortCircuitTunnelData(I2NPMessage messageBody, Hash from) {
        if (this.DISPATCH_DIRECT) {
            this.doShortCircuitTunnelData(messageBody, from);
        } else {
            List<I2NPMessage> list = this._pendingDataMessages;
            synchronized (list) {
                this._pendingDataMessages.add(messageBody);
                this._pendingDataMessagesFrom.add(from);
                this._pendingDataMessages.notifyAll();
            }
            if (!this._dispatchThreaded) {
                this._context.jobQueue().addJob(this._shortCircuitDataJob);
            }
        }
    }

    private void doShortCircuitTunnelData(I2NPMessage messageBody, Hash from) {
        this._context.tunnelDispatcher().dispatch((TunnelDataMessage)messageBody, from);
    }

    @Override
    public void renderStatusHTML(Writer out) {
    }

    @Override
    public synchronized void restart() {
        this.shutdown();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        this._alive = false;
        if (!this.DISPATCH_DIRECT) {
            List<I2NPMessage> list = this._pendingDataMessages;
            synchronized (list) {
                this._pendingDataMessages.clear();
                this._pendingDataMessagesFrom.clear();
                this._pendingDataMessages.notifyAll();
            }
        }
    }

    @Override
    public synchronized void startup() {
        this._alive = true;
        if (this._dispatchThreaded) {
            this._context.statManager().createRateStat("pool.dispatchDataTime", "How long a tunnel dispatch takes", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
            this._context.statManager().createRateStat("pool.dispatchGatewayTime", "How long a tunnel gateway dispatch takes", "Tunnels", new long[]{600000L, 3600000L, 86400000L});
            I2PThread data = new I2PThread(new TunnelDataDispatcher(), "Tunnel data dispatcher");
            data.setDaemon(true);
            data.start();
            I2PThread gw = new I2PThread(new TunnelGatewayDispatcher(), "Tunnel gateway dispatcher");
            gw.setDaemon(true);
            gw.start();
        }
    }

    private class SharedShortCircuitDataJob
    extends JobImpl {
        public SharedShortCircuitDataJob(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public String getName() {
            return "Dispatch tunnel participant message";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            int remaining = 0;
            I2NPMessage msg = null;
            Hash from = null;
            List list = InNetMessagePool.this._pendingDataMessages;
            synchronized (list) {
                if (!InNetMessagePool.this._pendingDataMessages.isEmpty()) {
                    msg = (I2NPMessage)InNetMessagePool.this._pendingDataMessages.remove(0);
                    from = (Hash)InNetMessagePool.this._pendingDataMessagesFrom.remove(0);
                }
                remaining = InNetMessagePool.this._pendingDataMessages.size();
            }
            if (msg != null) {
                InNetMessagePool.this.doShortCircuitTunnelData(msg, from);
            }
            if (remaining > 0) {
                this.getContext().jobQueue().addJob(this);
            }
        }
    }

    private class SharedShortCircuitGatewayJob
    extends JobImpl {
        public SharedShortCircuitGatewayJob(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public String getName() {
            return "Dispatch tunnel gateway message";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            I2NPMessage msg = null;
            int remaining = 0;
            List list = InNetMessagePool.this._pendingGatewayMessages;
            synchronized (list) {
                if (!InNetMessagePool.this._pendingGatewayMessages.isEmpty()) {
                    msg = (I2NPMessage)InNetMessagePool.this._pendingGatewayMessages.remove(0);
                }
                remaining = InNetMessagePool.this._pendingGatewayMessages.size();
            }
            if (msg != null) {
                InNetMessagePool.this.doShortCircuitTunnelGateway(msg);
            }
            if (remaining > 0) {
                this.getContext().jobQueue().addJob(this);
            }
        }
    }

    private class TunnelDataDispatcher
    implements Runnable {
        private TunnelDataDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (InNetMessagePool.this._alive) {
                I2NPMessage msg = null;
                Hash from = null;
                try {
                    List list = InNetMessagePool.this._pendingDataMessages;
                    synchronized (list) {
                        if (InNetMessagePool.this._pendingDataMessages.isEmpty()) {
                            InNetMessagePool.this._pendingDataMessages.wait();
                        } else {
                            msg = (I2NPMessage)InNetMessagePool.this._pendingDataMessages.remove(0);
                            from = (Hash)InNetMessagePool.this._pendingDataMessagesFrom.remove(0);
                        }
                    }
                    if (msg == null) continue;
                    long before = InNetMessagePool.this._context.clock().now();
                    InNetMessagePool.this.doShortCircuitTunnelData(msg, from);
                    long elapsed = InNetMessagePool.this._context.clock().now() - before;
                    InNetMessagePool.this._context.statManager().addRateData("pool.dispatchDataTime", elapsed);
                }
                catch (InterruptedException before) {
                }
                catch (OutOfMemoryError oome) {
                    throw oome;
                }
                catch (RuntimeException e) {
                    if (!InNetMessagePool.this._log.shouldLog(50)) continue;
                    InNetMessagePool.this._log.log(50, "Error in the tunnel data dispatcher", e);
                }
            }
        }
    }

    private class TunnelGatewayDispatcher
    implements Runnable {
        private TunnelGatewayDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (InNetMessagePool.this._alive) {
                I2NPMessage msg = null;
                try {
                    List list = InNetMessagePool.this._pendingGatewayMessages;
                    synchronized (list) {
                        if (InNetMessagePool.this._pendingGatewayMessages.isEmpty()) {
                            InNetMessagePool.this._pendingGatewayMessages.wait();
                        } else {
                            msg = (I2NPMessage)InNetMessagePool.this._pendingGatewayMessages.remove(0);
                        }
                    }
                    if (msg == null) continue;
                    long before = InNetMessagePool.this._context.clock().now();
                    InNetMessagePool.this.doShortCircuitTunnelGateway(msg);
                    long elapsed = InNetMessagePool.this._context.clock().now() - before;
                    InNetMessagePool.this._context.statManager().addRateData("pool.dispatchGatewayTime", elapsed);
                }
                catch (InterruptedException before) {
                }
                catch (OutOfMemoryError oome) {
                    throw oome;
                }
                catch (RuntimeException e) {
                    if (!InNetMessagePool.this._log.shouldLog(50)) continue;
                    InNetMessagePool.this._log.log(50, "Error in the tunnel gateway dispatcher", e);
                }
            }
        }
    }
}

