/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.crypto.X25519KeyFactory;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.IntroductionManager;
import net.i2p.router.transport.udp.MTU;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PacketBuilder2;
import net.i2p.router.transport.udp.PacketHandler;
import net.i2p.router.transport.udp.PacketPusher;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.PeerStateDestroyed;
import net.i2p.router.transport.udp.PeerTestEvent;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.PeerTestState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPEndpoint;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.util.RandomIterator;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public class UDPTransport
extends TransportImpl {
    private final Log _log;
    private final List<UDPEndpoint> _endpoints;
    private final Object _addDropLock = new Object();
    private final Map<Hash, PeerState> _peersByIdent;
    private final Map<RemoteHostId, PeerState> _peersByRemoteHost;
    private final Map<Long, PeerState2> _peersByConnID;
    private final Map<Long, PeerStateDestroyed> _recentlyClosedConnIDs;
    private PacketHandler _handler;
    private EstablishmentManager _establisher;
    private final OutboundMessageFragments _fragments;
    private volatile PacketPusher _pusher;
    private final InboundMessageFragments _inboundFragments;
    private final PeerTestManager _testManager;
    private final IntroductionManager _introManager;
    private final ExpirePeerEvent _expireEvent;
    private final PeerTestEvent _testEvent;
    private CommSystemFacade.Status _reachabilityStatus;
    private CommSystemFacade.Status _reachabilityStatusPending;
    private long _reachabilityStatusLastUpdated;
    private int _reachabilityStatusUnchanged;
    private long _v4IntroducersSelectedOn;
    private long _v6IntroducersSelectedOn;
    private long _lastInboundReceivedOn;
    private int _mtu = 620;
    private int _mtu_ipv6 = 1280;
    private int _mtu_ssu2;
    private int _mtu_ssu2_ipv6;
    private final int _defaultMTU;
    private boolean _mismatchLogged;
    private final int _networkID;
    private volatile boolean _haveIPv6Address;
    private long _lastInboundIPv6;
    private final int _min_peers;
    private final int _min_v6_peers;
    private boolean _needsRebuild;
    private final Object _rebuildLock = new Object();
    private SessionKey _introKey;
    private final Set<RemoteHostId> _dropList;
    private volatile long _expireTimeout;
    private Hash _lastFromv4;
    private Hash _lastFromv6;
    private byte[] _lastOurIPv4;
    private byte[] _lastOurIPv6;
    private int _lastOurPortv4;
    private int _lastOurPortv6;
    private boolean _haveUPnP;
    private RouterAddress _currentOurV4Address;
    private RouterAddress _currentOurV6Address;
    public static final String STYLE2 = "SSU2";
    static final int SSU2_INT_VERSION = 2;
    static final String SSU2_VERSION = Integer.toString(2);
    static final String SSU2_VERSION_ALT = SSU2_VERSION + ',';
    private final PacketBuilder2 _packetBuilder2;
    private final X25519KeyFactory _xdhFactory;
    private final byte[] _ssu2StaticPubKey;
    private final byte[] _ssu2StaticPrivKey;
    private final byte[] _ssu2StaticIntroKey;
    private final String _ssu2B64StaticPubKey;
    private final String _ssu2B64StaticIntroKey;
    public static final String PROP_SSU2_SP = "i2np.ssu2.sp";
    public static final String PROP_SSU2_IKEY = "i2np.ssu2.ikey";
    private static final long MIN_DOWNTIME_TO_REKEY_HIDDEN = 86400000L;
    private static final int DROPLIST_PERIOD = 600000;
    public static final String STYLE = "SSU";
    public static final String PROP_INTERNAL_PORT = "i2np.udp.internalPort";
    @Deprecated
    public static final int DEFAULT_INTERNAL_PORT = 8887;
    public static final String PROP_EXTERNAL_HOST = "i2np.udp.host";
    public static final String PROP_EXTERNAL_PORT = "i2np.udp.port";
    public static final String PROP_PREFER_UDP = "i2np.udp.preferred";
    private static final String DEFAULT_PREFER_UDP = "false";
    private static final String PROP_FIXED_PORT = "i2np.udp.fixedPort";
    public static final String PROP_SOURCES = "i2np.udp.addressSources";
    public static final String DEFAULT_SOURCES = Transport.AddressSource.SOURCE_INTERFACE.toConfigString() + ',' + Transport.AddressSource.SOURCE_UPNP.toConfigString() + ',' + Transport.AddressSource.SOURCE_SSU.toConfigString();
    public static final String PROP_IP = "i2np.lastIP";
    public static final String PROP_IP_CHANGE = "i2np.lastIPChange";
    public static final String PROP_LAPTOP_MODE = "i2np.laptopMode";
    public static final String PROP_IPV6 = "i2np.lastIPv6";
    public static final String PROP_FORCE_INTRODUCERS = "i2np.udp.forceIntroducers";
    public static final String PROP_ALLOW_DIRECT = "i2np.udp.allowDirect";
    public static final String PROP_BIND_INTERFACE = "i2np.udp.bindInterface";
    private static final String PROP_DEFAULT_MTU = "i2np.udp.mtu";
    private static final String PROP_ADVANCED = "routerconsole.advanced";
    public static final String PROP_INTRO_KEY = "i2np.udp.introKey";
    private static final String CAP_TESTING = Character.toString('B');
    private static final String CAP_TESTING_INTRO = CAP_TESTING + 'C';
    private static final String CAP_TESTING_4 = CAP_TESTING + "4";
    private static final String CAP_TESTING_6 = CAP_TESTING + "6";
    public static final int PUBLIC_RELAY_COUNT = 3;
    private static final int[] PRIORITY_LIMITS = new int[]{100, 200, 300, 400, 500, 1000};
    private static final int[] PRIORITY_WEIGHT = new int[]{1, 1, 1, 1, 1, 2};
    private static final int MAX_CONSECUTIVE_FAILED = 3;
    public static final int DEFAULT_COST = 5;
    private static final int SSU_OUTBOUND_COST = 14;
    static final long[] RATES = new long[]{600000L};
    private static final int MIN_PEERS = 5;
    private static final int MIN_PEERS_IF_HAVE_V6 = 30;
    private static final int MIN_INTRODUCER_POOL = 5;
    static final long INTRODUCER_EXPIRATION_MARGIN = 1200000L;
    private static final long MIN_DOWNTIME_TO_REKEY = 2592000000L;
    private static final int[] BID_VALUES = new int[]{15, 20, 50, 65, 80, 95, 100, 115, 999999};
    private static final int FAST_PREFERRED_BID = 0;
    private static final int SLOW_PREFERRED_BID = 1;
    private static final int FAST_BID = 2;
    private static final int SLOW_BID = 3;
    private static final int SLOWEST_BID = 4;
    private static final int SLOWEST_COST_BID = 5;
    private static final int NEAR_CAPACITY_BID = 6;
    private static final int NEAR_CAPACITY_COST_BID = 7;
    private static final int TRANSIENT_FAIL_BID = 8;
    private final TransportBid[] _cachedBid;
    private static final String THINSP = " / ";
    private static final String MIN_SIGTYPE_VERSION = "0.9.17";
    private static final String MIN_PEER_TEST_VERSION = "0.9.62";
    private static final Set<CommSystemFacade.Status> STATUS_IPV4_UNK = EnumSet.of(CommSystemFacade.Status.UNKNOWN, CommSystemFacade.Status.DISCONNECTED, CommSystemFacade.Status.HOSED, CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK, CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED);
    private static final Set<CommSystemFacade.Status> STATUS_IPV6_UNK = EnumSet.of(CommSystemFacade.Status.UNKNOWN, new CommSystemFacade.Status[]{CommSystemFacade.Status.DISCONNECTED, CommSystemFacade.Status.HOSED, CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_DISABLED_IPV6_UNKNOWN});
    private static final Set<CommSystemFacade.Status> STATUS_IPV4_FW = EnumSet.of(CommSystemFacade.Status.DIFFERENT, new CommSystemFacade.Status[]{CommSystemFacade.Status.REJECT_UNSOLICITED, CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK, CommSystemFacade.Status.IPV4_SNAT_IPV6_OK, CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN});
    private static final Set<CommSystemFacade.Status> STATUS_IPV6_FW = EnumSet.of(CommSystemFacade.Status.IPV4_OK_IPV6_FIREWALLED, CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED, CommSystemFacade.Status.IPV4_DISABLED_IPV6_FIREWALLED);
    private static final Set<CommSystemFacade.Status> STATUS_FW = EnumSet.of(CommSystemFacade.Status.DIFFERENT, new CommSystemFacade.Status[]{CommSystemFacade.Status.REJECT_UNSOLICITED, CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK, CommSystemFacade.Status.IPV4_SNAT_IPV6_OK, CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_OK_IPV6_FIREWALLED, CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED, CommSystemFacade.Status.IPV4_DISABLED_IPV6_FIREWALLED});
    private static final Set<CommSystemFacade.Status> STATUS_IPV6_FW_2 = EnumSet.of(CommSystemFacade.Status.IPV4_OK_IPV6_FIREWALLED, CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED, CommSystemFacade.Status.IPV4_DISABLED_IPV6_FIREWALLED, CommSystemFacade.Status.DIFFERENT, CommSystemFacade.Status.REJECT_UNSOLICITED);
    private static final Set<CommSystemFacade.Status> STATUS_IPV6_OK = EnumSet.of(CommSystemFacade.Status.OK, CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK, CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK, CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK, CommSystemFacade.Status.IPV4_SNAT_IPV6_OK);
    private static final Set<CommSystemFacade.Status> STATUS_NO_RETEST = EnumSet.of(CommSystemFacade.Status.OK, new CommSystemFacade.Status[]{CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_OK_IPV6_FIREWALLED, CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK, CommSystemFacade.Status.IPV4_DISABLED_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_DISABLED_IPV6_FIREWALLED, CommSystemFacade.Status.DISCONNECTED});
    private static final Set<CommSystemFacade.Status> STATUS_OK = EnumSet.of(CommSystemFacade.Status.OK, CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK);
    private static final Set<CommSystemFacade.Status> STATUS_IPV4_SYMNAT = EnumSet.of(CommSystemFacade.Status.DIFFERENT, CommSystemFacade.Status.IPV4_SNAT_IPV6_OK, CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN);
    private static final Set<CommSystemFacade.Status> STATUS_IPV4_NO_TEST = EnumSet.of(CommSystemFacade.Status.DIFFERENT, new CommSystemFacade.Status[]{CommSystemFacade.Status.DISCONNECTED, CommSystemFacade.Status.HOSED, CommSystemFacade.Status.UNKNOWN, CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK, CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED, CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK, CommSystemFacade.Status.IPV4_DISABLED_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_DISABLED_IPV6_FIREWALLED, CommSystemFacade.Status.IPV4_SNAT_IPV6_OK, CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN});
    private static final Set<CommSystemFacade.Status> STATUS_IPV6_NO_TEST = EnumSet.of(CommSystemFacade.Status.DIFFERENT, new CommSystemFacade.Status[]{CommSystemFacade.Status.DISCONNECTED, CommSystemFacade.Status.HOSED, CommSystemFacade.Status.UNKNOWN, CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_DISABLED_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN});
    private static final int ALLOW_IP_CHANGE_INTERVAL = 120000;
    private boolean gotIPv4Addr = false;
    private boolean gotIPv6Addr = false;
    public static final int EXPIRE_TIMEOUT = 1200000;
    private static final int MAX_IDLE_TIME = 1200000;
    public static final int MIN_EXPIRE_TIMEOUT = 165000;
    private static final String PROP_REACHABILITY_STATUS_OVERRIDE = "i2np.udp.status";

    public UDPTransport(RouterContext ctx, X25519KeyFactory xdh) {
        super(ctx);
        boolean shouldRekey;
        this._networkID = ctx.router().getNetworkID();
        this._xdhFactory = xdh;
        this._log = ctx.logManager().getLog(UDPTransport.class);
        this._peersByIdent = new ConcurrentHashMap<Hash, PeerState>(128);
        this._peersByRemoteHost = new ConcurrentHashMap<RemoteHostId, PeerState>(128);
        this._peersByConnID = xdh != null ? new ConcurrentHashMap(32) : null;
        int sz = Math.max(16, Math.min(128, this.getMaxConnections() / 16));
        this._recentlyClosedConnIDs = new DestroyedCache(sz);
        this._dropList = new ConcurrentHashSet<RemoteHostId>(2);
        this._endpoints = new CopyOnWriteArrayList<UDPEndpoint>();
        this._cachedBid = new SharedBid[BID_VALUES.length];
        for (int i = 0; i < BID_VALUES.length; ++i) {
            this._cachedBid[i] = new SharedBid(BID_VALUES[i]);
        }
        this._packetBuilder2 = new PacketBuilder2(this._context, this);
        this._fragments = new OutboundMessageFragments(this._context, this);
        this._inboundFragments = new InboundMessageFragments(this._context, this._fragments, this);
        this._expireTimeout = 1200000L;
        this._expireEvent = new ExpirePeerEvent();
        this._testManager = new PeerTestManager(this._context, this);
        this._testEvent = new PeerTestEvent(this._context, this, this._testManager);
        this._reachabilityStatus = CommSystemFacade.Status.UNKNOWN;
        this._reachabilityStatusPending = CommSystemFacade.Status.OK;
        this._introManager = new IntroductionManager(this._context, this);
        this._v4IntroducersSelectedOn = -1L;
        this._v6IntroducersSelectedOn = -1L;
        this._lastInboundReceivedOn = -1L;
        this._mtu = 1484;
        this._mtu_ipv6 = 1280;
        this.setupPort();
        this._needsRebuild = true;
        this._min_peers = this._context.getProperty("i2np.udp.minpeers", 5);
        this._min_v6_peers = this._context.getProperty("i2np.udp.minv6peers", 30);
        this._context.statManager().createRateStat("udp.alreadyConnected", "What is the lifetime of a reestablished session", "udp", RATES);
        this._context.statManager().createRateStat("udp.droppedPeer", "How long ago did we receive from a dropped peer (duration == session lifetime", "udp", RATES);
        this._context.statManager().createRateStat("udp.addressTestInsteadOfUpdate", "How many times we fire off a peer test of ourselves instead of adjusting our own reachable address?", "udp", RATES);
        this._context.statManager().createRateStat("udp.addressUpdated", "How many times we adjust our own reachable IP address", "udp", RATES);
        this._context.statManager().createRateStat("udp.proactiveReestablish", "How long a session was idle for when we proactively reestablished it", "udp", RATES);
        this._context.statManager().createRateStat("udp.dropPeerDroplist", "How many peers currently have their packets dropped outright when a new peer is added to the list?", "udp", RATES);
        this._context.statManager().createRateStat("udp.dropPeerConsecutiveFailures", "How many consecutive failed sends to a peer did we attempt before giving up and reestablishing a new session (lifetime is inactivity perood)", "udp", RATES);
        this._context.statManager().createRateStat("udp.inboundIPv4Conn", "Inbound IPv4 UDP Connection", "udp", RATES);
        this._context.statManager().createRateStat("udp.inboundIPv6Conn", "Inbound IPv6 UDP Connection", "udp", RATES);
        this._context.simpleTimer2().addPeriodicEvent(new PingIntroducers(), 123750L);
        this._defaultMTU = 1500;
        this._mtu_ssu2 = 1280;
        this._mtu_ssu2_ipv6 = 1280;
        SortedSet<String> ipset = Addresses.getAddresses(true, false, false);
        for (String ips : ipset) {
            try {
                InetAddress addr = InetAddress.getByName(ips);
                int mtu = MTU.getMTU(addr, true);
                if (mtu <= 0 || mtu >= 1280) continue;
                this._log.error("MTU too small on address " + ips + "!!!, MTU is " + mtu + ", minimum is " + 1280);
            }
            catch (UnknownHostException addr) {}
        }
        byte[] ikey = null;
        String b64Ikey = null;
        byte[] priv = null;
        boolean shouldSave = false;
        String s = null;
        long minDowntime = this._context.router().isHidden() ? 86400000L : 2592000000L;
        boolean bl = shouldRekey = !this.allowLocal() && this._context.getEstimatedDowntime() >= minDowntime;
        if (!shouldRekey && (s = ctx.getProperty(PROP_SSU2_SP)) != null) {
            priv = Base64.decode(s);
        }
        if (priv == null || priv.length != SSU2Util.KEY_LEN) {
            KeyPair keys = xdh.getKeys();
            this._ssu2StaticPrivKey = keys.getPrivate().getData();
            this._ssu2StaticPubKey = keys.getPublic().getData();
            shouldSave = true;
        } else {
            this._ssu2StaticPrivKey = priv;
            this._ssu2StaticPubKey = new PrivateKey(EncType.ECIES_X25519, priv).toPublic().getData();
        }
        if (!shouldSave && (s = ctx.getProperty(PROP_SSU2_IKEY)) != null) {
            ikey = Base64.decode(s);
            b64Ikey = s;
        }
        if (ikey == null || ikey.length != 32) {
            ikey = new byte[32];
            do {
                ctx.random().nextBytes(ikey);
            } while (DataHelper.eq(ikey, 0, SSU2Util.ZEROKEY, 0, 32));
            shouldSave = true;
        }
        if (shouldSave) {
            HashMap<String, String> changes = new HashMap<String, String>(2);
            String b64Priv = Base64.encode(this._ssu2StaticPrivKey);
            b64Ikey = Base64.encode(ikey);
            changes.put(PROP_SSU2_SP, b64Priv);
            changes.put(PROP_SSU2_IKEY, b64Ikey);
            ctx.router().saveConfig(changes, null);
        }
        this._ssu2StaticIntroKey = ikey;
        this._ssu2B64StaticIntroKey = b64Ikey;
        this._ssu2B64StaticPubKey = this._ssu2StaticPubKey != null ? Base64.encode(this._ssu2StaticPubKey) : null;
    }

    OutboundMessageFragments getOMF() {
        return this._fragments;
    }

    private void setupPort() {
        int port = this.getRequestedPort();
        if (port <= 0) {
            port = TransportUtil.selectRandomPort(this._context, STYLE);
            HashMap<String, String> changes = new HashMap<String, String>(2);
            String sport = Integer.toString(port);
            changes.put(PROP_INTERNAL_PORT, sport);
            changes.put(PROP_EXTERNAL_PORT, sport);
            this._context.router().saveConfig(changes, null);
            this._log.logAlways(20, "UDP selected random port " + port);
        }
    }

    private synchronized void startup() {
        boolean bl;
        String fixedHost;
        String bindTo;
        this._fragments.shutdown();
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        for (UDPEndpoint endpoint : this._endpoints) {
            endpoint.shutdown();
            this._endpoints.remove(endpoint);
        }
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        this._inboundFragments.shutdown();
        this._introManager.reset();
        UDPPacket.clearCache();
        if (this._log.shouldLog(30)) {
            this._log.warn("Starting SSU transport listening");
        }
        if ((bindTo = this._context.getProperty(PROP_BIND_INTERFACE)) == null && (fixedHost = this._context.getProperty(PROP_EXTERNAL_HOST)) != null && fixedHost.length() > 0) {
            TransportUtil.IPv6Config cfg = this.getIPv6Config();
            SortedSet<String> myAddrs = cfg == TransportUtil.IPv6Config.IPV6_DISABLED ? Addresses.getAddresses(false, false) : Addresses.getAddresses(false, true);
            StringBuilder buf = new StringBuilder();
            String[] bta = DataHelper.split(fixedHost, "[,; \r\n\t]");
            for (int i = 0; i < bta.length; ++i) {
                String string = bta[i];
                if (string.length() <= 0) continue;
                try {
                    InetAddress[] all = InetAddress.getAllByName(string);
                    for (int j = 0; j < all.length; ++j) {
                        InetAddress ia = all[j];
                        if (cfg == TransportUtil.IPv6Config.IPV6_ONLY && ia instanceof Inet4Address) {
                            if (!this._log.shouldWarn()) continue;
                            this._log.warn("Configured for IPv6 only, not binding to configured IPv4 host " + string);
                            continue;
                        }
                        String testAddr = ia.getHostAddress();
                        if (myAddrs.contains(testAddr)) {
                            if (buf.length() > 0) {
                                buf.append(',');
                            }
                            buf.append(testAddr);
                            continue;
                        }
                        if (!this._log.shouldWarn()) continue;
                        this._log.warn("Not a local address, not binding to configured IP " + testAddr);
                    }
                    continue;
                }
                catch (UnknownHostException uhe) {
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Not binding to configured host " + string + " - " + uhe);
                }
            }
            if (buf.length() > 0) {
                bindTo = buf.toString();
                if (this._log.shouldWarn() && !fixedHost.equals(bindTo)) {
                    this._log.warn("Expanded external host config \"" + fixedHost + "\" to \"" + bindTo + '\"');
                }
            }
        }
        HashSet<InetAddress> bindToAddrs = new HashSet<InetAddress>(4);
        if (bindTo != null) {
            String[] bta = DataHelper.split(bindTo, "[,; \r\n\t]");
            for (int i = 0; i < bta.length; ++i) {
                String bt = bta[i];
                if (bt.length() <= 0) continue;
                try {
                    bindToAddrs.add(InetAddress.getByName(bt));
                    continue;
                }
                catch (UnknownHostException uhe) {
                    this._log.error("Invalid SSU bind interface specified [" + bt + "]", uhe);
                }
            }
        }
        int oldIPort = this._context.getProperty(PROP_INTERNAL_PORT, -1);
        int oldBindPort = this.getListenPort(false);
        int oldEPort = this._context.getProperty(PROP_EXTERNAL_PORT, -1);
        int port = oldIPort > 0 ? oldIPort : (oldBindPort > 0 ? oldBindPort : oldEPort);
        if (!bindToAddrs.isEmpty() && this._log.shouldLog(30)) {
            this._log.warn("Binding only to " + bindToAddrs);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Binding to the port: " + port);
        }
        if (this._endpoints.isEmpty()) {
            if (bindToAddrs.isEmpty()) {
                UDPEndpoint endpoint = new UDPEndpoint(this._context, this, port, null);
                this._endpoints.add(endpoint);
                this.setMTU(null);
            } else {
                for (InetAddress inetAddress : bindToAddrs) {
                    UDPEndpoint endpoint = new UDPEndpoint(this._context, this, port, inetAddress);
                    this._endpoints.add(endpoint);
                    this.setMTU(inetAddress);
                }
            }
        } else {
            for (UDPEndpoint uDPEndpoint : this._endpoints) {
                if (!uDPEndpoint.isIPv4()) continue;
                uDPEndpoint.setListenPort(port);
                break;
            }
        }
        if (this._establisher == null) {
            this._establisher = new EstablishmentManager(this._context, this);
        }
        if (this._handler == null) {
            this._handler = new PacketHandler(this._context, this, this._establisher, this._inboundFragments, this._testManager, this._introManager);
        }
        int newPort = -1;
        for (UDPEndpoint endpoint : this._endpoints) {
            try {
                endpoint.startup();
                if (newPort < 0 && endpoint.isIPv4()) {
                    newPort = endpoint.getListenPort();
                }
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Started " + endpoint);
            }
            catch (SocketException se) {
                this._endpoints.remove(endpoint);
                this._log.error("Failed to start " + endpoint, se);
            }
        }
        if (this._endpoints.isEmpty()) {
            this._log.log(50, "Unable to open UDP port");
            this.setReachabilityStatus(CommSystemFacade.Status.HOSED);
            return;
        }
        if (newPort > 0 && (newPort != port || newPort != oldIPort)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String sport = Integer.toString(newPort);
            hashMap.put(PROP_INTERNAL_PORT, sport);
            if (oldEPort <= 0) {
                hashMap.put(PROP_EXTERNAL_PORT, sport);
            }
            this._context.router().saveConfig(hashMap, null);
        }
        this._fragments.startup();
        this._inboundFragments.startup();
        this._pusher = new PacketPusher(this._context, this._fragments, this._endpoints);
        this._pusher.startup();
        this._expireEvent.setIsAlive(true);
        this._reachabilityStatus = CommSystemFacade.Status.UNKNOWN;
        this._testEvent.setIsAlive(true);
        boolean bl2 = bl = this.getIPv6Config() == TransportUtil.IPv6Config.IPV6_ONLY;
        if (newPort > 0 && bindToAddrs.isEmpty()) {
            boolean save = this._context.router().isHidden();
            HashMap<String, String> changes = save ? new HashMap<String, String>(4) : null;
            boolean hasv6 = false;
            for (InetAddress ia : this.getSavedLocalAddresses()) {
                RouterAddress local;
                OrderedProperties localOpts;
                byte[] addr = ia.getAddress();
                String prop = addr.length == 4 ? PROP_IP : PROP_IPV6;
                String oldIP = save ? this._context.getProperty(prop) : null;
                String newIP = Addresses.toString(addr);
                if (addr.length == 16) {
                    if (hasv6) continue;
                    hasv6 = true;
                    localOpts = new OrderedProperties();
                    localOpts.setProperty("port", String.valueOf(newPort));
                    localOpts.setProperty("host", newIP);
                    local = new RouterAddress(this.getPublishStyle(), localOpts, 5);
                    this.replaceCurrentExternalAddress(local, true);
                    if (this.isIPv6Firewalled()) {
                        this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED, true);
                    } else if (this._context.getBooleanProperty("i2np.lastIPv6Firewalled")) {
                        this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED, true);
                        this._testEvent.forceRunSoon(true, bl ? 10000L : 60000L);
                    } else {
                        this._lastInboundIPv6 = this._context.clock().now();
                        this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK, true);
                        this.rebuildExternalAddress(newIP, newPort, false);
                        this._testEvent.forceRunSoon(true, bl ? 10000L : 60000L);
                    }
                } else {
                    localOpts = new OrderedProperties();
                    localOpts.setProperty("port", String.valueOf(newPort));
                    localOpts.setProperty("host", newIP);
                    local = new RouterAddress(this.getPublishStyle(), localOpts, 5);
                    this.replaceCurrentExternalAddress(local, false);
                    if (this.isIPv4Firewalled()) {
                        this.setReachabilityStatus(CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN);
                    } else {
                        this.setReachabilityStatus(CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN);
                        this.rebuildExternalAddress(newIP, newPort, false);
                        if (!bl) {
                            this._testEvent.forceRunSoon(false, 10000L);
                        }
                    }
                }
                if (!save || newIP.equals(oldIP)) continue;
                changes.put(prop, newIP);
                if (addr.length == 4) {
                    changes.put(PROP_IP_CHANGE, Long.toString(this._context.clock().now()));
                }
                if (oldIP == null) continue;
                this._context.router().eventLog().addEvent("changeIP", newIP);
            }
            if (save && !changes.isEmpty()) {
                this._context.router().saveConfig(changes, null);
            }
        } else if (newPort > 0 && !bindToAddrs.isEmpty()) {
            for (InetAddress ia : bindToAddrs) {
                if (ia.getAddress().length == 16) {
                    this._lastInboundIPv6 = this._context.clock().now();
                    if (!this.isIPv6Firewalled()) {
                        this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK, true);
                    }
                } else if (!this.isIPv4Firewalled()) {
                    this.setReachabilityStatus(CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN);
                }
                this.rebuildExternalAddress(ia.getHostAddress(), newPort, false);
            }
        } else if (!bl && !this.isIPv4Firewalled() || bl && !this.isIPv6Firewalled()) {
            this._testEvent.forceRunSoon(bl, 10000L);
        }
        if (this.isIPv4Firewalled()) {
            if (this._lastInboundIPv6 > 0L) {
                this.setReachabilityStatus(CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN);
            } else {
                this.setReachabilityStatus(CommSystemFacade.Status.REJECT_UNSOLICITED);
            }
        }
        this._establisher.startup();
        this._handler.startup();
        this.rebuildExternalAddress(false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        boolean fwNew;
        boolean fwOld;
        if (this._haveIPv6Address && (fwOld = this._context.getBooleanProperty("i2np.lastIPv6Firewalled")) != (fwNew = STATUS_IPV6_FW_2.contains((Object)this._reachabilityStatus))) {
            this._context.router().saveConfig("i2np.lastIPv6Firewalled", Boolean.toString(fwNew));
        }
        this.destroyAll();
        for (UDPEndpoint endpoint : this._endpoints) {
            endpoint.shutdown();
            this._endpoints.remove(endpoint);
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        this._fragments.shutdown();
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        this._inboundFragments.shutdown();
        this._expireEvent.setIsAlive(false);
        this._testEvent.setIsAlive(false);
        this._peersByRemoteHost.clear();
        this._peersByIdent.clear();
        if (this._peersByConnID != null) {
            this._peersByConnID.clear();
        }
        if (this._recentlyClosedConnIDs != null) {
            Object object = this._addDropLock;
            synchronized (object) {
                for (PeerStateDestroyed psd : this._recentlyClosedConnIDs.values()) {
                    psd.kill();
                }
                this._recentlyClosedConnIDs.clear();
            }
        }
        this._dropList.clear();
        this._introManager.reset();
        UDPPacket.clearCache();
        UDPAddress.clearCache();
        this._lastInboundIPv6 = 0L;
    }

    public void fail(UDPEndpoint endpoint) {
        if (this._endpoints.remove(endpoint)) {
            this._log.log(50, "UDP port failure: " + endpoint);
            if (this._endpoints.isEmpty()) {
                this._log.log(50, "No more UDP sockets open");
                this.setReachabilityStatus(CommSystemFacade.Status.HOSED);
            }
            this.rebuildExternalAddress(endpoint.isIPv6());
        }
    }

    private boolean isAlive() {
        return this._inboundFragments.isAlive();
    }

    SessionKey getIntroKey() {
        return this._introKey;
    }

    byte[] getSSU2StaticIntroKey() {
        return this._ssu2StaticIntroKey;
    }

    byte[] getSSU2StaticPubKey() {
        return this._ssu2StaticPubKey;
    }

    byte[] getSSU2StaticPrivKey() {
        return this._ssu2StaticPrivKey;
    }

    int getSSUVersion(RouterAddress addr) {
        String style = addr.getTransportStyle();
        if (style.equals(STYLE)) {
            boolean rv = true;
        } else if (style.equals(STYLE2)) {
            int rv = 2;
        } else {
            return 0;
        }
        String v = addr.getOption("v");
        if (v == null || addr.getOption("i") == null || addr.getOption("s") == null || !v.equals(SSU2_VERSION) && !v.startsWith(SSU2_VERSION_ALT)) {
            return 0;
        }
        return 2;
    }

    private void addSSU2Options(Properties props) {
        props.setProperty("i", this._ssu2B64StaticIntroKey);
        props.setProperty("s", this._ssu2B64StaticPubKey);
        props.setProperty("v", SSU2_VERSION);
    }

    int getExternalPort(boolean ipv6) {
        int rv;
        RouterAddress addr = this.getCurrentAddress(ipv6);
        if (addr != null && (rv = addr.getPort()) > 0) {
            return rv;
        }
        return this.getRequestedPort(ipv6);
    }

    byte[] getExternalIP() {
        RouterAddress addr = this.getCurrentAddress(false);
        if (addr != null) {
            return addr.getIP();
        }
        return null;
    }

    boolean hasIPv6Address() {
        return this._haveIPv6Address;
    }

    boolean isTooClose(byte[] ip) {
        byte[] myip;
        if (this.allowLocal()) {
            return false;
        }
        byte[] byArray = myip = ip.length == 16 ? this._lastOurIPv6 : this._lastOurIPv4;
        if (myip == null) {
            return false;
        }
        return ip.length == 4 ? DataHelper.eq(ip, 0, myip, 0, 2) : ip.length == 16 && DataHelper.eq(ip, 0, myip, 0, 4);
    }

    private int getListenPort(boolean ipv6) {
        for (UDPEndpoint endpoint : this._endpoints) {
            if ((ipv6 || !endpoint.isIPv4()) && (!ipv6 || !endpoint.isIPv6())) continue;
            return endpoint.getListenPort();
        }
        return -1;
    }

    @Override
    public int getRequestedPort() {
        return this.getRequestedPort(false);
    }

    private int getRequestedPort(boolean ipv6) {
        int rv = this.getListenPort(ipv6);
        if (rv > 0) {
            return rv;
        }
        rv = this._context.getProperty(PROP_INTERNAL_PORT, -1);
        if (rv > 0) {
            return rv;
        }
        return this._context.getProperty(PROP_EXTERNAL_PORT, -1);
    }

    private int setMTU(InetAddress addr) {
        String p = this._context.getProperty(PROP_DEFAULT_MTU);
        if (p != null) {
            try {
                int pmtu = Integer.parseInt(p);
                this._mtu = MTU.rectify(false, pmtu);
                this._mtu_ipv6 = MTU.rectify(true, pmtu);
                return this._mtu;
            }
            catch (NumberFormatException pmtu) {
                // empty catch block
            }
        }
        int mtu = MTU.getMTU(addr, false);
        if (addr != null && addr.getAddress().length == 16) {
            if (mtu <= 0) {
                mtu = 1280;
            }
            this._mtu_ipv6 = mtu;
        } else {
            if (mtu <= 0) {
                mtu = 1484;
            }
            this._mtu = mtu;
        }
        if (addr != null) {
            int mtussu2 = MTU.getMTU(addr, true);
            if (mtussu2 > 0 && mtussu2 < 1280) {
                this._log.logAlways(30, "Low MTU " + mtussu2 + " for interface " + addr + ", consider disabling SSU2");
                mtussu2 = 1280;
            }
            if (addr.getAddress().length == 16) {
                this._mtu_ssu2_ipv6 = mtussu2;
            } else {
                this._mtu_ssu2 = mtussu2;
            }
        }
        return mtu;
    }

    public int getMTU(boolean ipv6) {
        return this.getSSU2MTU(ipv6);
    }

    public int getSSU2MTU(boolean ipv6) {
        return ipv6 ? this._mtu_ssu2_ipv6 : this._mtu_ssu2;
    }

    void inboundConnectionReceived(boolean isIPv6) {
        if (isIPv6) {
            this._lastInboundIPv6 = this._context.clock().now();
            this._context.statManager().addRateData("udp.inboundIPv6Conn", 1L);
        } else {
            this._lastInboundReceivedOn = System.currentTimeMillis();
            this._context.statManager().addRateData("udp.inboundIPv4Conn", 1L);
        }
    }

    @Override
    public void externalAddressReceived(Transport.AddressSource source, byte[] ip, int port) {
        boolean changed;
        if (this._log.shouldLog(30)) {
            this._log.warn("Received address: " + Addresses.toString(ip, port) + " from: " + (Object)((Object)source));
        }
        if (ip == null) {
            return;
        }
        if (!this.isPubliclyRoutable(ip) && !this.allowLocal()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid address: " + Addresses.toString(ip, port) + " from: " + (Object)((Object)source));
            }
            return;
        }
        if (source == Transport.AddressSource.SOURCE_INTERFACE && ip.length == 16) {
            this._haveIPv6Address = true;
        }
        if (source == Transport.AddressSource.SOURCE_UPNP) {
            this._haveUPnP = true;
        }
        if (this.explicitAddressSpecified()) {
            return;
        }
        String sources = this._context.getProperty(PROP_SOURCES, DEFAULT_SOURCES);
        if (!sources.contains(source.toConfigString())) {
            return;
        }
        if (!this.isAlive()) {
            if (source == Transport.AddressSource.SOURCE_INTERFACE || source == Transport.AddressSource.SOURCE_UPNP) {
                try {
                    InetAddress ia = InetAddress.getByAddress(ip);
                    this.saveLocalAddress(ia);
                    this.setMTU(ia);
                }
                catch (UnknownHostException ia) {
                    // empty catch block
                }
            }
            return;
        }
        if (source == Transport.AddressSource.SOURCE_INTERFACE) {
            if (ip.length == 4) {
                if (this.gotIPv4Addr) {
                    return;
                }
                this.gotIPv4Addr = true;
            } else if (ip.length == 16) {
                if (this.gotIPv6Addr) {
                    return;
                }
                this.gotIPv6Addr = true;
            }
        }
        if ((source == Transport.AddressSource.SOURCE_INTERFACE || source == Transport.AddressSource.SOURCE_UPNP) && this._context.router().isHidden()) {
            String prop = ip.length == 4 ? PROP_IP : PROP_IPV6;
            String oldIP = this._context.getProperty(prop);
            String newIP = Addresses.toString(ip);
            if (!newIP.equals(oldIP)) {
                HashMap<String, String> changes = new HashMap<String, String>(2);
                changes.put(prop, newIP);
                if (ip.length == 4) {
                    changes.put(PROP_IP_CHANGE, Long.toString(this._context.clock().now()));
                }
                this._context.router().saveConfig(changes, null);
                if (oldIP != null) {
                    this._context.router().eventLog().addEvent("changeIP", newIP);
                }
            }
        }
        if ((changed = this.changeAddress(ip, port)) && source == Transport.AddressSource.SOURCE_INTERFACE) {
            if (ip.length == 4) {
                if (!this.isIPv4Firewalled()) {
                    this.setReachabilityStatus(CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN);
                }
            } else if (ip.length == 16 && !this.isIPv6Firewalled()) {
                this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK, true);
            }
        }
    }

    @Override
    public void forwardPortStatus(byte[] ip, int port, int externalPort, boolean success, String reason) {
        if (success) {
            this._haveUPnP = true;
        }
        if (this._log.shouldLog(30)) {
            if (success) {
                this._log.warn("UPnP has opened the SSU port: " + port + " via " + Addresses.toString(ip, externalPort));
            } else {
                this._log.warn("UPnP has failed to open the SSU port: " + Addresses.toString(ip, externalPort) + " reason: " + reason);
            }
        }
        if (success && ip != null) {
            if (ip.length == 4) {
                if (this.getCurrentExternalAddress(false) != null && !this.isIPv4Firewalled()) {
                    this.setReachabilityStatus(CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN);
                }
            } else if (ip.length == 16) {
                boolean fwOld = this._context.getBooleanProperty("i2np.lastIPv6Firewalled");
                if (!fwOld) {
                    this._context.router().saveConfig("i2np.lastIPv6Firewalled", DEFAULT_PREFER_UDP);
                }
                if (!this.isIPv6Firewalled()) {
                    this.setReachabilityStatus(CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void externalAddressReceived(Hash from, byte[] ourIP, int ourPort) {
        boolean inboundRecent;
        boolean isIPv6;
        boolean isValid = this.isValid(ourIP) && TransportUtil.isValidPort(ourPort);
        boolean explicitSpecified = this.explicitAddressSpecified();
        boolean bl = isIPv6 = ourIP.length == 16;
        if (!isIPv6) {
            inboundRecent = this._lastInboundReceivedOn + 120000L > System.currentTimeMillis();
        } else {
            boolean bl2 = inboundRecent = this._lastInboundIPv6 + 120000L > this._context.clock().now();
        }
        if (this._log.shouldLog(20)) {
            this._log.info("External address received: " + Addresses.toString(ourIP, ourPort) + " from " + from + ", isValid? " + isValid + ", explicitSpecified? " + explicitSpecified + ", receivedInboundRecent? " + inboundRecent + " status " + (Object)((Object)this._reachabilityStatus));
        }
        if (explicitSpecified) {
            return;
        }
        String sources = this._context.getProperty(PROP_SOURCES, DEFAULT_SOURCES);
        if (!sources.contains("ssu")) {
            return;
        }
        if (!isValid) {
            if (ourPort < 1024 || ourPort > 65535 || !this.isValid(ourIP)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("The router " + from + " told us we have an invalid IP:port " + Addresses.toString(ourIP, ourPort));
                }
                this.markUnreachable(from);
            } else {
                this._log.logAlways(30, "The router " + from + " told us we have an invalid port " + ourPort + ", check NAT/firewall configuration, the IANA recommended dynamic outside port range is 49152-65535");
            }
            return;
        }
        RouterAddress addr = this.getCurrentExternalAddress(isIPv6);
        if (inboundRecent && addr != null && addr.getPort() > 0 && addr.getHost() != null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Ignoring IP address suggestion, since we have received an inbound con recently");
            }
            return;
        }
        boolean changeIt = false;
        Hash lastFrom = null;
        UDPTransport uDPTransport = this;
        synchronized (uDPTransport) {
            if (!isIPv6) {
                if (from.equals(this._lastFromv4) || !UDPTransport.eq(this._lastOurIPv4, this._lastOurPortv4, ourIP, ourPort)) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("The router " + from + " told us we have a new IP/port - " + Addresses.toString(ourIP, ourPort) + ".  Wait until somebody else tells us the same thing.");
                    }
                } else {
                    changeIt = true;
                    lastFrom = this._lastFromv4;
                }
                this._lastFromv4 = from;
                this._lastOurIPv4 = ourIP;
                this._lastOurPortv4 = ourPort;
            } else {
                if (from.equals(this._lastFromv6) || !UDPTransport.eq(this._lastOurIPv6, this._lastOurPortv6, ourIP, ourPort)) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("The router " + from + " told us we have a new IP/port - " + Addresses.toString(ourIP, ourPort) + ".  Wait until somebody else tells us the same thing.");
                    }
                } else {
                    changeIt = true;
                    lastFrom = this._lastFromv6;
                }
                this._lastFromv6 = from;
                this._lastOurIPv6 = ourIP;
                this._lastOurPortv6 = ourPort;
            }
        }
        if (changeIt) {
            if (this._log.shouldInfo()) {
                this._log.info(from + " and " + lastFrom + " agree our address is " + Addresses.toString(ourIP, ourPort));
            }
            if (this._haveUPnP || ourIP.length == 16) {
                ourPort = 0;
            }
            this.changeAddress(ourIP, ourPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeAddress(byte[] ourIP, int ourPort) {
        boolean updated = false;
        boolean fireTest = false;
        boolean isIPv6 = ourIP.length == 16;
        boolean fixedPort = this.getIsPortFixed(isIPv6);
        Object object = this._rebuildLock;
        synchronized (object) {
            int externalListenPort;
            RouterAddress current = this.getCurrentExternalAddress(isIPv6);
            byte[] externalListenHost = current != null ? current.getIP() : null;
            int n = externalListenPort = current != null ? current.getPort() : this.getRequestedPort(isIPv6);
            if (this._log.shouldDebug()) {
                this._log.debug("Change address? status = " + (Object)((Object)this._reachabilityStatus) + " diff = " + (this._context.clock().now() - this._reachabilityStatusLastUpdated) + " old = " + Addresses.toString(externalListenHost, externalListenPort) + " new = " + Addresses.toString(ourIP, ourPort));
            }
            if (fixedPort && externalListenPort > 0 || ourPort <= 0) {
                ourPort = externalListenPort;
            }
            if (ourPort > 0 && !UDPTransport.eq(externalListenHost, externalListenPort, ourIP, ourPort)) {
                boolean rebuild = true;
                if (isIPv6) {
                    String ipstr;
                    SortedSet<String> ipset = Addresses.getAddresses(false, true);
                    if (!ipset.contains(ipstr = Addresses.toString(ourIP))) {
                        if (this._log.shouldInfo()) {
                            this._log.info("New IPv6 address received but not one of our local addresses: " + ipstr, new Exception());
                        }
                        return false;
                    }
                    if (STATUS_IPV6_FW_2.contains((Object)this._reachabilityStatus)) {
                        String oldIP = this._context.getProperty(PROP_IPV6);
                        String newIP = Addresses.toString(ourIP);
                        if (!newIP.equals(oldIP)) {
                            HashMap<String, String> changes = new HashMap<String, String>(1);
                            changes.put(PROP_IPV6, newIP);
                            this._context.router().saveConfig(changes, null);
                            if (oldIP != null) {
                                this._context.router().eventLog().addEvent("changeIP", newIP);
                            }
                            OrderedProperties localOpts = new OrderedProperties();
                            localOpts.setProperty("port", String.valueOf(ourPort));
                            localOpts.setProperty("host", newIP);
                            RouterAddress local = new RouterAddress(this.getPublishStyle(), localOpts, 5);
                            this.replaceCurrentExternalAddress(local, true);
                            if (this._log.shouldWarn()) {
                                this._log.warn("New IPv6 address, assuming still firewalled [" + newIP + "]:" + ourPort, new Exception());
                            }
                        } else {
                            if (this._log.shouldInfo()) {
                                this._log.info("Same IPv6 address, assuming still firewalled [" + newIP + "]:" + ourPort);
                            }
                            return false;
                        }
                        rebuild = false;
                        fireTest = true;
                    }
                }
                if (rebuild) {
                    RouterAddress newAddr;
                    if (externalListenPort > 0 && ourPort > 0 && externalListenPort != ourPort && this._context.getProperty(PROP_EXTERNAL_PORT, 0) != ourPort) {
                        this._context.router().saveConfig(PROP_EXTERNAL_PORT, Integer.toString(ourPort));
                        this._context.router().eventLog().addEvent("changePort", "IPv" + (isIPv6 ? (char)'6' : '4') + " port " + ourPort);
                    }
                    if (ourPort != externalListenPort) {
                        this._establisher.portChanged();
                    } else if (externalListenHost != null && !Arrays.equals(ourIP, externalListenHost)) {
                        this._establisher.ipChanged(isIPv6);
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Trying to change our external address to " + Addresses.toString(ourIP, ourPort));
                    }
                    updated = (newAddr = this.rebuildExternalAddress(ourIP, ourPort, true)) != null;
                }
            } else if (this._log.shouldDebug()) {
                this._log.debug("Same address as the current one");
            }
        }
        if (fireTest) {
            this._context.statManager().addRateData("udp.addressTestInsteadOfUpdate", 1L);
            this._testEvent.forceRunImmediately(isIPv6);
        } else if (updated) {
            this._context.statManager().addRateData("udp.addressUpdated", 1L);
            HashMap<String, String> changes = new HashMap<String, String>();
            if (!isIPv6 && !fixedPort) {
                changes.put(PROP_EXTERNAL_PORT, Integer.toString(ourPort));
            }
            this._context.commSystem().queueLookup(ourIP);
            String oldIP = this._context.getProperty(PROP_IP);
            String newIP = Addresses.toString(ourIP);
            if (!isIPv6 && !newIP.equals(oldIP)) {
                long lastChanged = 0L;
                long now = this._context.clock().now();
                String lcs = this._context.getProperty(PROP_IP_CHANGE);
                if (lcs != null) {
                    try {
                        lastChanged = Long.parseLong(lcs);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                changes.put(PROP_IP, newIP);
                changes.put(PROP_IP_CHANGE, Long.toString(now));
                this._context.router().saveConfig(changes, null);
                if (oldIP != null) {
                    this._context.router().eventLog().addEvent("changeIP", newIP);
                }
                if (oldIP != null && SystemVersion.hasWrapper() && this._context.getBooleanProperty(PROP_LAPTOP_MODE) && now - lastChanged > 600000L && this._context.router().getUptime() < 600000L) {
                    System.out.println("WARN: IP changed, restarting with a new identity and port");
                    this._log.logAlways(30, "IP changed, restarting with a new identity and port");
                    this._context.router().killKeys();
                    this._context.router().shutdown(4);
                }
            } else if (!isIPv6 && !fixedPort) {
                this._context.router().saveConfig(changes, null);
            } else if (isIPv6 && !newIP.equals(oldIP = this._context.getProperty(PROP_IPV6))) {
                changes.put(PROP_IPV6, newIP);
                this._context.router().saveConfig(changes, null);
                if (oldIP != null) {
                    this._context.router().eventLog().addEvent("changeIP", newIP);
                }
            }
            this._testEvent.forceRunImmediately(isIPv6);
        }
        return updated;
    }

    private static final boolean eq(byte[] laddr, int lport, byte[] raddr, int rport) {
        return rport == lport && DataHelper.eq(laddr, raddr);
    }

    public final boolean isValid(byte[] addr) {
        if (addr == null) {
            return false;
        }
        if (this.isPubliclyRoutable(addr) && (addr.length != 16 || this._haveIPv6Address)) {
            return true;
        }
        return this.allowLocal();
    }

    private boolean getIsPortFixed(boolean isIPv6) {
        String prop = this._context.getProperty(PROP_FIXED_PORT);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        CommSystemFacade.Status status = this.getReachabilityStatus();
        if (isIPv6) {
            if (STATUS_IPV6_UNK.contains((Object)status)) {
                return false;
            }
            return !STATUS_IPV6_FW.contains((Object)status);
        }
        if (STATUS_IPV4_UNK.contains((Object)status)) {
            return false;
        }
        return !STATUS_IPV4_FW.contains((Object)status);
    }

    PeerState getPeerState(RemoteHostId hostInfo) {
        return this._peersByRemoteHost.get(hostInfo);
    }

    List<PeerState> getPeerStatesByIP(RemoteHostId hostInfo) {
        ArrayList<PeerState> rv = new ArrayList<PeerState>(4);
        byte[] ip = hostInfo.getIP();
        if (ip != null && ip.length == 4) {
            for (PeerState ps : this._peersByIdent.values()) {
                if (!DataHelper.eq(ip, ps.getRemoteIP())) continue;
                rv.add(ps);
            }
        }
        return rv;
    }

    PeerState getPeerState(Hash remotePeer) {
        return this._peersByIdent.get(remotePeer);
    }

    PeerState2 getPeerState(long rcvConnID) {
        return this._peersByConnID.get(rcvConnID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerStateDestroyed getRecentlyClosed(long rcvConnID) {
        Long id = rcvConnID;
        Object object = this._addDropLock;
        synchronized (object) {
            return this._recentlyClosedConnIDs.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRecentlyClosed(PeerStateDestroyed peer) {
        PeerStateDestroyed oldPSD;
        Long id = peer.getRcvConnID();
        Object object = this._addDropLock;
        synchronized (object) {
            oldPSD = this._recentlyClosedConnIDs.put(id, peer);
            if (oldPSD != null) {
                this._recentlyClosedConnIDs.put(id, oldPSD);
            }
        }
        if (oldPSD != null) {
            peer.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRecentlyClosed(PeerStateDestroyed peer) {
        Long id = peer.getRcvConnID();
        Object object = this._addDropLock;
        synchronized (object) {
            this._recentlyClosedConnIDs.remove(id);
        }
    }

    public Collection<PeerState> getPeers() {
        return this._peersByIdent.values();
    }

    @Override
    public List<Hash> getEstablished() {
        return new ArrayList<Hash>(this._peersByIdent.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changePeerPort(PeerState peer, int newPort) {
        int oldPort;
        Object object = this._addDropLock;
        synchronized (object) {
            oldPort = peer.getRemotePort();
            if (oldPort != newPort) {
                this._peersByRemoteHost.remove(peer.getRemoteHostId());
                peer.changePort(newPort);
                this._peersByRemoteHost.put(peer.getRemoteHostId(), peer);
            }
        }
        if (this._log.shouldInfo() && oldPort != newPort) {
            this._log.info("Changed port from " + oldPort + " to " + newPort + " for " + peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changePeerAddress(PeerState2 peer, RemoteHostId newAddress) {
        RemoteHostId oldAddress;
        Object object = this._addDropLock;
        synchronized (object) {
            oldAddress = peer.getRemoteHostId();
            if (!oldAddress.equals(newAddress)) {
                this._peersByRemoteHost.remove(oldAddress);
                peer.changeAddress(newAddress);
                this._peersByRemoteHost.put(newAddress, peer);
            }
        }
        if (this._log.shouldInfo() && !oldAddress.equals(newAddress)) {
            this._log.info("Changed address from " + oldAddress + " to " + newAddress + " for " + peer);
        }
    }

    EstablishmentManager getEstablisher() {
        return this._establisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addRemotePeerState(PeerState peer) {
        if (this._log.shouldDebug()) {
            this._log.debug("Add remote peer state: " + peer);
        }
        Object object = this._addDropLock;
        synchronized (object) {
            return this.locked_addRemotePeerState(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean locked_addRemotePeerState(PeerState peer) {
        RouterAddress addr;
        boolean ipv6;
        long tag;
        PeerState oldPeer2;
        Hash remotePeer = peer.getRemotePeer();
        long oldEstablishedOn = -1L;
        PeerState oldPeer = null;
        if (remotePeer != null && (oldPeer = this._peersByIdent.put(remotePeer, peer)) != null && oldPeer != peer) {
            if (this._log.shouldInfo()) {
                this._log.info("Peer already connected (PBID): old=" + oldPeer + " new=" + peer);
            }
            peer.loadFrom(oldPeer);
            oldEstablishedOn = oldPeer.getKeyEstablishedTime();
        }
        if (peer.getVersion() == 2) {
            PeerState2 state2 = (PeerState2)peer;
            this._peersByConnID.put(state2.getRcvConnID(), state2);
        }
        RemoteHostId remoteId = peer.getRemoteHostId();
        if (oldPeer != null) {
            this.sendDestroy(oldPeer, 22);
            oldPeer.dropOutbound();
            this._introManager.remove(oldPeer);
            RemoteHostId oldID = oldPeer.getRemoteHostId();
            if (!remoteId.equals(oldID)) {
                PeerState oldPeer22;
                if (this._log.shouldInfo()) {
                    this._log.info(remotePeer + " changed address FROM " + oldID + " TO " + remoteId);
                }
                if ((oldPeer22 = this._peersByRemoteHost.remove(oldID)) != oldPeer && oldPeer22 != null) {
                    oldPeer22.dropOutbound();
                    this._introManager.remove(oldPeer22);
                }
            }
            if (oldPeer != peer && oldPeer.getVersion() == 2) {
                PeerStateDestroyed newPSD;
                PeerState2 state2 = (PeerState2)oldPeer;
                Long id = state2.getRcvConnID();
                PeerStateDestroyed oldPSD = this._recentlyClosedConnIDs.put(id, newPSD = new PeerStateDestroyed(this._context, this, state2));
                if (oldPSD != null) {
                    this._recentlyClosedConnIDs.put(id, oldPSD);
                    newPSD.kill();
                }
                this._peersByConnID.remove(id);
            }
        }
        if ((oldPeer2 = this._peersByRemoteHost.put(remoteId, peer)) != null && oldPeer2 != peer && oldPeer2 != oldPeer) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer already connected (PBRH): old=" + oldPeer2 + " new=" + peer);
            }
            this.sendDestroy(oldPeer2, 22);
            peer.loadFrom(oldPeer2);
            oldEstablishedOn = oldPeer2.getKeyEstablishedTime();
            oldPeer2.dropOutbound();
            this._introManager.remove(oldPeer2);
        }
        if (this._log.shouldLog(30) && !this._mismatchLogged && this._peersByIdent.size() != this._peersByRemoteHost.size()) {
            this._mismatchLogged = true;
            this._log.warn("Size Mismatch after add: " + peer + " byIDsz = " + this._peersByIdent.size() + " byHostsz = " + this._peersByRemoteHost.size());
        }
        this.markReachable(peer.getRemotePeer(), peer.isInbound());
        this._introManager.add(peer);
        if (oldEstablishedOn > 0L) {
            this._context.statManager().addRateData("udp.alreadyConnected", oldEstablishedOn);
        }
        if ((tag = peer.getTheyRelayToUsAs()) > 0L && this.introducersRequired(ipv6 = peer.isIPv6()) && (addr = this.getCurrentAddress(ipv6)) != null) {
            int count = 0;
            for (String p : UDPAddress.PROP_INTRO_TAG) {
                if (addr.getOption(p) == null) break;
                ++count;
            }
            if (count < 3) {
                long now = this._context.clock().now();
                Object object = this._rebuildLock;
                synchronized (object) {
                    long sinceSelected = now - (ipv6 ? this._v6IntroducersSelectedOn : this._v4IntroducersSelectedOn);
                    if (count == 0 || sinceSelected > 120000L) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Rebuilding address, new introducer added, current count " + count + ": " + peer);
                        }
                        this.rebuildExternalAddress(ipv6);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void messageReceived(I2NPMessage inMsg, RouterIdentity remoteIdent, Hash remoteIdentHash, long msToReceive, int bytesReceived) {
        if (inMsg.getType() == 1) {
            Hash peerHash;
            RouterInfo ri;
            int id;
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)inMsg;
            DatabaseEntry entry = dsm.getEntry();
            if (entry == null) {
                return;
            }
            if (entry.getType() == 0 && (id = (ri = (RouterInfo)entry).getNetworkId()) != this._networkID && (peerHash = entry.getHash()).equals(remoteIdentHash)) {
                PeerState peer = this.getPeerState(peerHash);
                if (peer != null) {
                    RemoteHostId remote = peer.getRemoteHostId();
                    this._dropList.add(remote);
                    this._context.statManager().addRateData("udp.dropPeerDroplist", 1L);
                    this._context.simpleTimer2().addEvent(new RemoveDropList(remote), 600000L);
                }
                this.markUnreachable(peerHash);
                if (id == -1) {
                    this._context.banlist().banlistRouter(peerHash, "No network specified", null, null, this._context.clock().now() + 2592000000L);
                } else {
                    this._context.banlist().banlistRouterForever(peerHash, "Not in our network: " + id);
                }
                if (peer != null) {
                    this.sendDestroy(peer, 21);
                }
                this.dropPeer(peerHash, false, "Not in our network");
                if (this._log.shouldLog(30)) {
                    this._log.warn("Not in our network: " + entry, new Exception());
                }
                return;
            }
        }
        super.messageReceived(inMsg, remoteIdent, remoteIdentHash, msToReceive, bytesReceived);
    }

    boolean isInDropList(RemoteHostId peer) {
        return this._dropList.contains(peer);
    }

    void dropPeer(Hash peer, boolean shouldBanlist, String why) {
        PeerState state = this.getPeerState(peer);
        if (state != null) {
            this.dropPeer(state, shouldBanlist, why);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropPeer(PeerState peer, boolean shouldBanlist, String why) {
        if (this._log.shouldDebug()) {
            long now = this._context.clock().now();
            StringBuilder buf = new StringBuilder(4096);
            long timeSinceSend = now - peer.getLastSendTime();
            long timeSinceRecv = now - peer.getLastReceiveTime();
            long timeSinceAck = now - peer.getLastACKSend();
            long timeSinceSendOK = now - peer.getLastSendFullyTime();
            int consec = peer.getConsecutiveFailedSends();
            buf.append("Dropping remote peer: ").append(peer.toString()).append(" banlist? ").append(shouldBanlist);
            buf.append(" lifetime: ").append(now - peer.getKeyEstablishedTime());
            buf.append(" time since send/fully/recv/ack: ").append(timeSinceSend).append(THINSP);
            buf.append(timeSinceSendOK).append(THINSP);
            buf.append(timeSinceRecv).append(THINSP).append(timeSinceAck);
            buf.append(" consec failures: ").append(consec);
            if (why != null) {
                buf.append(" cause: ").append(why);
            }
            this._log.debug(buf.toString(), new Exception("Dropped by"));
        }
        Object now = this._addDropLock;
        synchronized (now) {
            this.locked_dropPeer(peer, shouldBanlist, why);
        }
        long tag = peer.getTheyRelayToUsAs();
        if (tag > 0L) {
            String p;
            String itag;
            boolean ipv6 = peer.isIPv6();
            if (!this.introducersRequired(ipv6)) {
                return;
            }
            RouterAddress addr = this.getCurrentAddress(ipv6);
            if (addr == null) {
                return;
            }
            String stag = Long.toString(tag);
            String[] stringArray = UDPAddress.PROP_INTRO_TAG;
            int n = stringArray.length;
            for (int i = 0; i < n && (itag = addr.getOption(p = stringArray[i])) != null; ++i) {
                if (!itag.equals(stag)) continue;
                if (this._log.shouldWarn()) {
                    this._log.warn("Rebuilding address, published introducer dropped: " + peer);
                }
                Object object = this._rebuildLock;
                synchronized (object) {
                    this.rebuildExternalAddress(ipv6);
                    break;
                }
            }
        }
    }

    private void locked_dropPeer(PeerState peer, boolean shouldBanlist, String why) {
        RemoteHostId remoteId;
        PeerState altByHost;
        peer.dropOutbound();
        peer.expireInboundMessages();
        this._introManager.remove(peer);
        this._fragments.dropPeer(peer);
        PeerState altByIdent = null;
        if (peer.getRemotePeer() != null) {
            if (shouldBanlist) {
                this.markUnreachable(peer.getRemotePeer());
            }
            long now = this._context.clock().now();
            this._context.statManager().addRateData("udp.droppedPeer", now - peer.getLastReceiveTime(), now - peer.getKeyEstablishedTime());
            altByIdent = this._peersByIdent.remove(peer.getRemotePeer());
        }
        if (peer.getVersion() == 2) {
            PeerStateDestroyed newPSD;
            PeerState2 state2 = (PeerState2)peer;
            Long id = state2.getRcvConnID();
            PeerStateDestroyed oldPSD = this._recentlyClosedConnIDs.put(id, newPSD = new PeerStateDestroyed(this._context, this, state2));
            if (oldPSD != null) {
                this._recentlyClosedConnIDs.put(id, oldPSD);
                newPSD.kill();
            }
            this._peersByConnID.remove(id);
        }
        if (altByIdent != (altByHost = this._peersByRemoteHost.remove(remoteId = peer.getRemoteHostId())) && this._log.shouldLog(30)) {
            this._log.warn("Mismatch on remove, RHID = " + remoteId + " byID = " + altByIdent + " byHost = " + altByHost + " byIDsz = " + this._peersByIdent.size() + " byHostsz = " + this._peersByRemoteHost.size());
        }
        if (altByIdent != null && peer != altByIdent) {
            this.locked_dropPeer(altByIdent, shouldBanlist, "recurse");
        }
        if (altByHost != null && peer != altByHost) {
            this.locked_dropPeer(altByHost, shouldBanlist, "recurse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIfNecessary() {
        Object object = this._rebuildLock;
        synchronized (object) {
            int code = this.locked_needsRebuild();
            if (code != 0) {
                this.rebuildExternalAddress(code == 2);
            }
        }
    }

    private int locked_needsRebuild() {
        RouterAddress addr;
        boolean v4Only;
        RouterAddress addr2;
        boolean v6Only;
        if (this._context.router().isHidden()) {
            return 0;
        }
        TransportUtil.IPv6Config config = this.getIPv6Config();
        boolean bl = v6Only = config == TransportUtil.IPv6Config.IPV6_ONLY;
        if (!v6Only && this.locked_needsRebuild(addr2 = this.getCurrentAddress(false), false)) {
            return 1;
        }
        boolean bl2 = v4Only = config == TransportUtil.IPv6Config.IPV6_DISABLED;
        if (!v4Only && this._haveIPv6Address && this.locked_needsRebuild(addr = this.getCurrentAddress(true), true)) {
            return 2;
        }
        return 0;
    }

    private boolean locked_needsRebuild(RouterAddress addr, boolean ipv6) {
        boolean rv;
        if (this._needsRebuild) {
            return true;
        }
        if (this.introducersRequired(ipv6)) {
            UDPAddress ua = new UDPAddress(addr);
            long now = this._context.clock().now();
            int valid = 0;
            int count = ua.getIntroducerCount();
            for (int i = 0; i < count; ++i) {
                long exp = ua.getIntroducerExpiration(i);
                if (exp > 0L && exp < now + 1200000L) {
                    if (!this._log.shouldInfo()) continue;
                    this._log.info((ipv6 ? "IPv6" : "IPv4") + " Introducer " + i + " expiring soon, need to replace");
                    continue;
                }
                long tag = ua.getIntroducerTag(i);
                if (this._introManager.isInboundTagValid(tag)) {
                    ++valid;
                    continue;
                }
                if (!this._log.shouldInfo()) continue;
                this._log.info((ipv6 ? "IPv6" : "IPv4") + " Introducer " + i + " no longer connected, need to replace");
            }
            long sinceSelected = now - (ipv6 ? this._v6IntroducersSelectedOn : this._v4IntroducersSelectedOn);
            if (valid >= 3) {
                if (this._log.shouldDebug()) {
                    this._log.debug((ipv6 ? "IPv6" : "IPv4") + " introducers valid, selected " + DataHelper.formatDuration(sinceSelected) + " ago");
                }
                return false;
            }
            if (sinceSelected > 120000L) {
                boolean rv2;
                int avail = this._introManager.introducerCount(ipv6);
                boolean bl = rv2 = valid < count || valid < avail;
                if (rv2) {
                    if (this._log.shouldWarn()) {
                        this._log.warn((ipv6 ? "IPv6" : "IPv4") + " Need more introducers (have " + count + " valid " + valid + " need " + 3 + " avail " + avail + ')');
                    }
                } else if (this._log.shouldInfo()) {
                    this._log.info((ipv6 ? "IPv6" : "IPv4") + " Need more introducers, no more avail. (have " + valid + " need " + 3 + " avail " + avail + ')');
                }
                return rv2;
            }
            if (this._log.shouldLog(20)) {
                this._log.info((ipv6 ? "IPv6" : "IPv4") + " Need more introducers (have " + valid + " need " + 3 + ')' + " but we just chose them " + DataHelper.formatDuration(sinceSelected) + " ago so wait");
            }
            return false;
        }
        byte[] externalListenHost = addr != null ? addr.getIP() : null;
        int externalListenPort = addr != null ? addr.getPort() : -1;
        boolean bl = rv = externalListenHost == null || externalListenPort <= 0;
        if (!rv && addr.getOption("itag0") != null) {
            rv = true;
        }
        if (rv) {
            if (this._log.shouldLog(20)) {
                this._log.info((ipv6 ? "IPv6" : "IPv4") + " Need to initialize our direct SSU info (" + Addresses.toString(externalListenHost, externalListenPort) + ')');
            }
        } else if (addr.getPort() <= 0 || addr.getHost() == null) {
            if (this._log.shouldLog(20)) {
                this._log.info((ipv6 ? "IPv6" : "IPv4") + " Our direct SSU info is initialized, but not used in our address yet");
            }
            rv = true;
        }
        return rv;
    }

    void send(UDPPacket packet) {
        if (this._pusher != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending " + packet);
            }
            this._pusher.send(packet);
        } else {
            this._log.error("No pusher", new Exception());
        }
    }

    void sendDestroy(PeerState peer, int reasonCode) {
        UDPPacket pkt;
        try {
            pkt = this._packetBuilder2.buildSessionDestroyPacket(reasonCode, (PeerState2)peer);
        }
        catch (IOException ioe) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending destroy to : " + peer);
        }
        this.send(pkt);
    }

    private void destroyAll() {
        for (UDPEndpoint endpoint : this._endpoints) {
            endpoint.clearOutbound();
        }
        int howMany = this._peersByIdent.size();
        int burst = 8;
        int pps = Math.max(48, this._context.bandwidthLimiter().getOutboundKBytesPerSecond() * 1000 / 4 / 48);
        int burstps = pps / 8;
        int toSleep = Math.max(8, 1000 / burstps);
        int count = 0;
        if (this._log.shouldInfo()) {
            this._log.info("Sending destroy to : " + howMany + " peers");
        }
        for (PeerState peer : this._peersByIdent.values()) {
            this.sendDestroy(peer, 2);
            if (++count % 8 != 0) continue;
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException interruptedException) {}
        }
        toSleep = Math.min(howMany / 3, 750);
        if (toSleep > 0) {
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public TransportBid bid(RouterInfo toAddress, int dataSize) {
        String v;
        RouterIdentity id;
        SigType type;
        PeerProfile prof;
        if (dataSize > 32768) {
            return null;
        }
        Hash to = toAddress.getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (peer != null) {
            if (this.preferUDP()) {
                return this._cachedBid[0];
            }
            return this._cachedBid[2];
        }
        int nid = toAddress.getNetworkId();
        if (nid != this._networkID) {
            if (nid == -1) {
                this._context.banlist().banlistRouter(to, "No network specified", null, null, this._context.clock().now() + 2592000000L);
            } else {
                this._context.banlist().banlistRouterForever(to, "Not in our network: " + nid);
            }
            this.markUnreachable(to);
            return null;
        }
        if (this._reachabilityStatus == CommSystemFacade.Status.HOSED) {
            this.markUnreachable(to);
            return null;
        }
        if (this.isUnreachable(to)) {
            return null;
        }
        if (toAddress.getCapabilities().indexOf(102) >= 0 && ((prof = this._context.profileOrganizer().getProfileNonblocking(to)) == null || prof.getLastHeardFrom() <= 0L)) {
            return null;
        }
        RouterAddress addr = this.getTargetAddress(toAddress);
        if (addr == null) {
            this.markUnreachable(to);
            return null;
        }
        int cost = addr.getCost();
        if (cost == 10) {
            if (VersionComparator.comp(toAddress.getVersion(), "0.9.49") <= 0) {
                this.markUnreachable(to);
                return null;
            }
        } else if (cost == 9 && toAddress.getVersion().equals("0.9.52")) {
            this.markUnreachable(to);
            return null;
        }
        if ((type = toAddress.getIdentity().getSigType()) == null || !type.isAvailable()) {
            this.markUnreachable(to);
            return null;
        }
        RouterInfo us = this._context.router().getRouterInfo();
        if (us != null && (id = us.getIdentity()).getSigType() != SigType.DSA_SHA1 && VersionComparator.comp(v = toAddress.getVersion(), MIN_SIGTYPE_VERSION) < 0) {
            this.markUnreachable(to);
            return null;
        }
        if (!this.allowConnection()) {
            return this._cachedBid[8];
        }
        if (this.alwaysPreferUDP()) {
            if (this.haveCapacity(90)) {
                return this._cachedBid[1];
            }
            if (cost > 5) {
                return this._cachedBid[7];
            }
            return this._cachedBid[6];
        }
        int count = this._peersByIdent.size();
        boolean ipv6 = TransportUtil.isIPv6(addr);
        if (!ipv6 && count < this._min_peers || ipv6 && this._haveIPv6Address && count < this._min_v6_peers || this.introducersRequired(ipv6) && addr.getOption("caps") != null && addr.getOption("caps").indexOf(67) >= 0 && this._introManager.introducerCount(ipv6) < 5) {
            int ratio;
            int n = ratio = this._context.router().isHidden() ? 2 : 4;
            if (this._context.random().nextInt(ratio) == 0) {
                return this._cachedBid[4];
            }
            return this._cachedBid[1];
        }
        if (this.preferUDP()) {
            return this._cachedBid[3];
        }
        if (this.haveCapacity()) {
            if (cost > 5) {
                return this._cachedBid[5];
            }
            return this._cachedBid[4];
        }
        if (cost > 5) {
            return this._cachedBid[7];
        }
        return this._cachedBid[6];
    }

    RouterAddress getTargetAddress(RouterInfo target) {
        List<RouterAddress> addrs = this.getTargetAddresses(target);
        for (int i = 0; i < addrs.size(); ++i) {
            RouterAddress addr = addrs.get(i);
            if (addr.getTransportStyle().equals(STYLE) && !"2".equals(addr.getOption("v"))) continue;
            if (addr.getOption("itag0") == null) {
                byte[] ip = addr.getIP();
                int port = addr.getPort();
                if (ip == null || !TransportUtil.isValidPort(port) || !this.isValid(ip) || Arrays.equals(ip, this.getExternalIP()) && !this.allowLocal()) {
                    continue;
                }
            } else {
                String caps = addr.getOption("caps");
                if (caps != null && caps.contains("6") && !this._haveIPv6Address) continue;
            }
            return addr;
        }
        return null;
    }

    private boolean preferUDP() {
        String pref = this._context.getProperty(PROP_PREFER_UDP, DEFAULT_PREFER_UDP);
        return !DEFAULT_PREFER_UDP.equals(pref);
    }

    private boolean alwaysPreferUDP() {
        return "always".equals(this._context.getProperty(PROP_PREFER_UDP)) || "cn".equals(this._context.commSystem().getOurCountry());
    }

    @Override
    public String getStyle() {
        return STYLE;
    }

    @Override
    public String getAltStyle() {
        return STYLE2;
    }

    private String getPublishStyle() {
        return STYLE2;
    }

    @Override
    public void send(OutNetMessage msg) {
        if (msg == null) {
            return;
        }
        RouterInfo tori = msg.getTarget();
        if (tori == null) {
            return;
        }
        if (tori.getIdentity() == null) {
            return;
        }
        if (this._establisher == null) {
            this.failed(msg, "UDP not up yet");
            return;
        }
        msg.timestamp("sending on UDP transport");
        Hash to = tori.getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending to " + (to != null ? to.toString() : ""));
        }
        if (peer != null) {
            long lastSend = peer.getLastSendFullyTime();
            long lastRecv = peer.getLastReceiveTime();
            long now = this._context.clock().now();
            int inboundActive = peer.expireInboundMessages();
            if (lastSend > 0L && lastRecv > 0L && now - lastSend > 1200000L && now - lastRecv > 1200000L && peer.getConsecutiveFailedSends() > 0 && inboundActive <= 0) {
                this.dropPeer(peer, false, "proactive reconnection");
                msg.timestamp("peer is really idle, dropping con and reestablishing");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Proactive reestablish to " + to);
                }
                this._establisher.establish(msg);
                this._context.statManager().addRateData("udp.proactiveReestablish", now - lastSend, now - peer.getKeyEstablishedTime());
                return;
            }
            msg.timestamp("enqueueing for an already established peer");
            this._fragments.add(msg);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Establish new connection to " + to);
            }
            msg.timestamp("establishing a new connection");
            this._establisher.establish(msg);
        }
    }

    void sendIfEstablished(OutNetMessage msg) {
        this._fragments.add(msg);
    }

    void send(I2NPMessage msg, PeerState peer) {
        block3: {
            try {
                OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msg, peer);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Injecting a data message to a new peer: " + peer);
                }
                this._fragments.add(state, peer);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Shouldnt happen", new Exception("I did it"));
            }
        }
    }

    void send(I2NPMessage msg, List<OutNetMessage> msgs, PeerState peer) {
        block5: {
            try {
                int sz = msgs.size();
                ArrayList<OutboundMessageState> states = new ArrayList<OutboundMessageState>(sz + 1);
                if (msg != null) {
                    OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msg, peer);
                    states.add(state);
                }
                for (int i = 0; i < sz; ++i) {
                    OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msgs.get(i), peer);
                    states.add(state);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Injecting " + states.size() + " data messages to a new peer: " + peer);
                }
                this._fragments.add(states, peer);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block5;
                this._log.warn("Shouldnt happen", new Exception("I did it"));
            }
        }
    }

    void send(List<I2NPMessage> msgs, PeerState peer) {
        block4: {
            try {
                int sz = msgs.size();
                ArrayList<OutboundMessageState> states = new ArrayList<OutboundMessageState>(sz);
                for (int i = 0; i < sz; ++i) {
                    OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msgs.get(i), peer);
                    states.add(state);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Injecting " + sz + " data messages to a new peer: " + peer);
                }
                this._fragments.add(states, peer);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Shouldnt happen", new Exception("I did it"));
            }
        }
    }

    @Override
    protected void outboundMessageReady() {
        throw new UnsupportedOperationException("Not used for UDP");
    }

    @Override
    public void startListening() {
        this.startup();
    }

    @Override
    public void stopListening() {
        this.shutdown();
        this.replaceAddress(null);
    }

    private boolean explicitAddressSpecified() {
        String h = this._context.getProperty(PROP_EXTERNAL_HOST);
        return h != null && h.length() > 0;
    }

    @Override
    public List<RouterAddress> updateAddress() {
        boolean ipv6 = this.getIPv6Config() == TransportUtil.IPv6Config.IPV6_ONLY;
        this.rebuildExternalAddress(false, ipv6);
        return this.getCurrentAddresses();
    }

    private RouterAddress rebuildExternalAddress(boolean ipv6) {
        if (this._log.shouldLog(10)) {
            this._log.debug("REA1 ipv6? " + ipv6);
        }
        return this.rebuildExternalAddress(true, ipv6);
    }

    private RouterAddress rebuildExternalAddress(boolean allowRebuildRouterInfo, boolean ipv6) {
        if (this._log.shouldDebug()) {
            this._log.debug("REA2 " + allowRebuildRouterInfo + " ipv6? " + ipv6);
        }
        int port = this._context.getProperty(PROP_EXTERNAL_PORT, -1);
        String host = null;
        if (this.explicitAddressSpecified()) {
            host = this._context.getProperty(PROP_EXTERNAL_HOST);
            if (host != null) {
                String[] hosts = DataHelper.split(host, "[,; \r\n\t]");
                RouterAddress rv = null;
                boolean v4 = false;
                boolean v6 = false;
                TransportUtil.IPv6Config cfg = this.getIPv6Config();
                if (cfg == TransportUtil.IPv6Config.IPV6_DISABLED) {
                    v6 = true;
                } else if (cfg == TransportUtil.IPv6Config.IPV6_ONLY) {
                    v4 = true;
                }
                for (int i = 0; i < hosts.length; ++i) {
                    String h = hosts[i];
                    if (h.length() <= 0) continue;
                    if (Addresses.isIPv4Address(h)) {
                        if (v4) continue;
                        v4 = true;
                    } else if (Addresses.isIPv6Address(h)) {
                        if (v6) continue;
                        v6 = true;
                    } else {
                        int valid = 0;
                        List<byte[]> ips = Addresses.getIPs(h);
                        if (ips != null) {
                            for (byte[] ip : ips) {
                                RouterAddress trv;
                                if (!this.isValid(ip)) {
                                    if (!this._log.shouldWarn()) continue;
                                    this._log.warn("REA2: skipping invalid " + Addresses.toString(ip) + " for " + h);
                                    continue;
                                }
                                if (v4 && ip.length == 4 || v6 && ip.length == 16) {
                                    if (!this._log.shouldWarn()) continue;
                                    this._log.warn("REA2: skipping additional " + Addresses.toString(ip) + " for " + h);
                                    continue;
                                }
                                if (ip.length == 4) {
                                    v4 = true;
                                } else if (ip.length == 16) {
                                    v6 = true;
                                }
                                ++valid;
                                if (this._log.shouldDebug()) {
                                    this._log.debug("REA2: adding " + Addresses.toString(ip) + " for " + h);
                                }
                                if ((trv = this.rebuildExternalAddress(ip, port, allowRebuildRouterInfo)) == null) continue;
                                rv = trv;
                            }
                        }
                        if (valid != 0) continue;
                        this._log.error("No valid IPs for configured hostname " + h);
                        continue;
                    }
                    RouterAddress trv = this.rebuildExternalAddress(h, port, allowRebuildRouterInfo);
                    if (trv == null) continue;
                    rv = trv;
                }
                return rv;
            }
        } else {
            RouterAddress cur;
            if (!this.introducersRequired(ipv6) && (cur = this.getCurrentExternalAddress(ipv6)) != null) {
                host = cur.getHost();
            }
            if (ipv6 && host == null) {
                host = ":";
            }
        }
        return this.rebuildExternalAddress(host, port, allowRebuildRouterInfo);
    }

    private RouterAddress rebuildExternalAddress(byte[] ip, int port, boolean allowRebuildRouterInfo) {
        if (this._log.shouldDebug()) {
            this._log.debug("REA3 " + Addresses.toString(ip, port));
        }
        if (ip == null) {
            return this.rebuildExternalAddress((String)null, port, allowRebuildRouterInfo);
        }
        if (this.isValid(ip)) {
            return this.rebuildExternalAddress(Addresses.toString(ip), port, allowRebuildRouterInfo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouterAddress rebuildExternalAddress(String host, int port, boolean allowRebuildRouterInfo) {
        Object object = this._rebuildLock;
        synchronized (object) {
            return this.locked_rebuildExternalAddress(host, port, allowRebuildRouterInfo);
        }
    }

    private RouterAddress locked_rebuildExternalAddress(String host, int port, boolean allowRebuildRouterInfo) {
        RouterAddress current;
        RouterAddress addr;
        boolean wantsRebuild;
        boolean directIncluded;
        boolean isIPv6;
        if (this._log.shouldDebug()) {
            this._log.debug("REA4 " + host + ' ' + port, new Exception());
        }
        boolean bl = isIPv6 = host != null && host.contains(":");
        if (isIPv6 && host.equals(":")) {
            host = null;
        }
        OrderedProperties options = new OrderedProperties();
        if (this._context.router().isHidden()) {
            int mtu;
            String caps;
            TransportUtil.IPv6Config config;
            RouterAddress old;
            if (!(port <= 0 || host == null || (old = this.getCurrentExternalAddress(isIPv6)) != null && host.equals(old.getHost()) && port == old.getPort())) {
                options.setProperty("port", String.valueOf(port));
                options.setProperty("host", host);
                RouterAddress local = new RouterAddress(this.getPublishStyle(), options, 14);
                this.replaceCurrentExternalAddress(local, isIPv6);
                options = new OrderedProperties();
            }
            if ((config = this.getIPv6Config()) == TransportUtil.IPv6Config.IPV6_ONLY) {
                caps = "6";
                mtu = this.getMTU(true);
            } else if (config != TransportUtil.IPv6Config.IPV6_DISABLED && this.hasIPv6Address()) {
                caps = "46";
                mtu = this.getMTU(true);
            } else {
                caps = "4";
                mtu = this.getMTU(false);
            }
            options.setProperty("caps", caps);
            if (mtu != this._defaultMTU && mtu > 0) {
                options.setProperty("mtu", Integer.toString(mtu));
            }
            if (mtu >= 1280 || mtu == 0) {
                this.addSSU2Options(options);
            }
            RouterAddress current2 = this.getCurrentAddress(false);
            RouterAddress addr2 = new RouterAddress(this.getPublishStyle(), options, 14);
            if (!addr2.deepEquals(current2)) {
                if (this._log.shouldInfo()) {
                    this._log.info("Address rebuilt: " + addr2, new Exception());
                }
                this.replaceAddress(addr2);
                if (allowRebuildRouterInfo) {
                    this.rebuildRouterInfo();
                }
            } else {
                addr2 = null;
            }
            this._needsRebuild = false;
            return addr2;
        }
        boolean introducersRequired = this.introducersRequired(isIPv6);
        if (!introducersRequired && this.allowDirectUDP() && port > 0 && host != null) {
            options.setProperty("port", String.valueOf(port));
            options.setProperty("host", host);
            directIncluded = true;
        } else {
            directIncluded = false;
        }
        boolean introducersIncluded = false;
        if (introducersRequired) {
            RouterAddress current3 = this.getCurrentAddress(isIPv6);
            int found = this._introManager.pickInbound(current3, isIPv6, options, 3);
            if (found > 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("ipv6? " + isIPv6 + " picked introducers: " + found);
                }
                long now = this._context.clock().now();
                if (isIPv6) {
                    this._v6IntroducersSelectedOn = now;
                } else {
                    this._v4IntroducersSelectedOn = now;
                }
                introducersIncluded = true;
            } else if (this._log.shouldLog(30)) {
                this._log.warn("ipv6? " + isIPv6 + " no introducers");
            }
        }
        String caps = !this.canTestAsCharlie(isIPv6) ? (isIPv6 ? "6" : "4") : (introducersRequired || !this.canIntroduce(isIPv6) ? (!directIncluded ? (isIPv6 ? CAP_TESTING_6 : CAP_TESTING_4) : CAP_TESTING) : CAP_TESTING_INTRO);
        options.setProperty("caps", caps);
        int mtu = this.getMTU(isIPv6);
        if (mtu != this._defaultMTU && mtu > 0) {
            options.setProperty("mtu", Integer.toString(mtu));
        }
        if (directIncluded || introducersIncluded) {
            RouterAddress current4;
            RouterAddress addr3;
            boolean wantsRebuild2;
            int cost = 5;
            if (!this.haveCapacity(91)) {
                ++cost;
            }
            if (introducersIncluded) {
                cost += 2;
            }
            if (isIPv6) {
                TransportUtil.IPv6Config config = this.getIPv6Config();
                if (config == TransportUtil.IPv6Config.IPV6_PREFERRED) {
                    --cost;
                } else if (config == TransportUtil.IPv6Config.IPV6_NOT_PREFERRED) {
                    ++cost;
                }
            }
            if (mtu >= 1280 || mtu == 0) {
                this.addSSU2Options(options);
            }
            boolean bl2 = wantsRebuild2 = !(addr3 = new RouterAddress(this.getPublishStyle(), options, cost)).deepEquals(current4 = this.getCurrentAddress(isIPv6));
            if (port > 0 && host != null) {
                RouterAddress local;
                if (directIncluded) {
                    local = addr3;
                } else {
                    OrderedProperties localOpts = new OrderedProperties();
                    localOpts.setProperty("port", String.valueOf(port));
                    localOpts.setProperty("host", host);
                    local = new RouterAddress(this.getPublishStyle(), localOpts, cost);
                }
                this.replaceCurrentExternalAddress(local, isIPv6);
            }
            if (wantsRebuild2) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Address rebuilt: " + addr3, new Exception());
                }
                this.replaceAddress(addr3);
                if (!isIPv6 && this.getCurrentAddress(true) == null && this.getIPv6Config() != TransportUtil.IPv6Config.IPV6_DISABLED && this.hasIPv6Address()) {
                    OrderedProperties opts = new OrderedProperties();
                    opts.setProperty("caps", "6");
                    mtu = this.getMTU(true);
                    if (mtu != this._defaultMTU && mtu > 0) {
                        opts.setProperty("mtu", Integer.toString(mtu));
                    }
                    this.addSSU2Options(opts);
                    RouterAddress addr6 = new RouterAddress(this.getPublishStyle(), opts, 14);
                    this.replaceAddress(addr6);
                }
                if (allowRebuildRouterInfo) {
                    this.rebuildRouterInfo();
                }
            } else {
                addr3 = null;
            }
            this._needsRebuild = false;
            return addr3;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Wanted to rebuild my SSU address, but couldn't specify either the direct or indirect info (needs introducers? " + introducersRequired + " ipv6? " + isIPv6 + ')');
        }
        this._needsRebuild = true;
        if (port > 0 && host != null) {
            OrderedProperties localOpts = new OrderedProperties();
            localOpts.setProperty("port", String.valueOf(port));
            localOpts.setProperty("host", host);
            RouterAddress local = new RouterAddress(this.getPublishStyle(), localOpts, 5);
            this.replaceCurrentExternalAddress(local, isIPv6);
        }
        OrderedProperties opts = new OrderedProperties();
        opts.setProperty("caps", isIPv6 ? "6" : "4");
        if (mtu != this._defaultMTU && mtu > 0) {
            opts.setProperty("mtu", Integer.toString(mtu));
        }
        if (mtu >= 1280 || mtu == 0) {
            this.addSSU2Options(opts);
        }
        boolean bl3 = wantsRebuild = !(addr = new RouterAddress(this.getPublishStyle(), opts, 14)).deepEquals(current = this.getCurrentAddress(isIPv6));
        if (!wantsRebuild) {
            return null;
        }
        this.replaceAddress(addr);
        if (allowRebuildRouterInfo) {
            this.rebuildRouterInfo();
        }
        return addr;
    }

    private void replaceCurrentExternalAddress(RouterAddress ra, boolean isIPv6) {
        if (isIPv6) {
            this._currentOurV6Address = ra;
        } else {
            this._currentOurV4Address = ra;
        }
        try {
            InetAddress ia = InetAddress.getByName(ra.getHost());
            this.setMTU(ia);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExternalAddress(boolean isIPv6, boolean allowRebuildRouterInfo) {
        Object object = this._rebuildLock;
        synchronized (object) {
            if (this.getCurrentAddress(isIPv6) != null) {
                this.removeAddress(isIPv6);
                if (allowRebuildRouterInfo) {
                    this.rebuildRouterInfo();
                }
            }
        }
    }

    private void rebuildRouterInfo() {
        new RebuildEvent().schedule(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterAddress getCurrentExternalAddress(boolean isIPv6) {
        Object object = this._rebuildLock;
        synchronized (object) {
            return isIPv6 ? this._currentOurV6Address : this._currentOurV4Address;
        }
    }

    @Override
    protected void replaceAddress(RouterAddress address) {
        super.replaceAddress(address);
        this._context.commSystem().notifyReplaceAddress(address);
    }

    @Override
    protected void removeAddress(RouterAddress address) {
        super.removeAddress(address);
        this._context.commSystem().notifyRemoveAddress(address);
    }

    @Override
    protected void removeAddress(boolean ipv6) {
        super.removeAddress(ipv6);
        if (ipv6) {
            this._lastInboundIPv6 = 0L;
        }
        this._context.commSystem().notifyRemoveAddress(ipv6);
    }

    private boolean introducersRequired(boolean ipv6) {
        if (this._context.router().isHidden()) {
            return false;
        }
        CommSystemFacade.Status status = this.getReachabilityStatus();
        TransportUtil.IPv6Config config = this.getIPv6Config();
        if (ipv6) {
            if (!this._haveIPv6Address) {
                return false;
            }
            if (config == TransportUtil.IPv6Config.IPV6_DISABLED) {
                return false;
            }
            if (this.isIPv6Firewalled()) {
                return true;
            }
            switch (status) {
                case REJECT_UNSOLICITED: 
                case DIFFERENT: 
                case IPV4_OK_IPV6_FIREWALLED: 
                case IPV4_UNKNOWN_IPV6_FIREWALLED: {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Require IPv6 introducers, status is " + (Object)((Object)status));
                    }
                    return true;
                }
            }
        } else {
            if (config == TransportUtil.IPv6Config.IPV6_ONLY) {
                return false;
            }
            if (this.isIPv4Firewalled()) {
                return true;
            }
            switch (status) {
                case REJECT_UNSOLICITED: 
                case DIFFERENT: 
                case IPV4_FIREWALLED_IPV6_OK: 
                case IPV4_FIREWALLED_IPV6_UNKNOWN: 
                case IPV4_SNAT_IPV6_OK: 
                case IPV4_SNAT_IPV6_UNKNOWN: {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Require IPv4 introducers, status is " + (Object)((Object)status));
                    }
                    return true;
                }
            }
        }
        if (!this.allowDirectUDP()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Require introducers, because we do not allow direct UDP connections");
            }
            return true;
        }
        return false;
    }

    boolean introducersMaybeRequired(boolean ipv6) {
        if (this._context.router().isHidden()) {
            return false;
        }
        CommSystemFacade.Status status = this.getReachabilityStatus();
        TransportUtil.IPv6Config config = this.getIPv6Config();
        if (ipv6) {
            if (!this._haveIPv6Address) {
                return false;
            }
            if (config == TransportUtil.IPv6Config.IPV6_DISABLED) {
                return false;
            }
            if (this.isIPv6Firewalled()) {
                return true;
            }
            switch (status) {
                case REJECT_UNSOLICITED: 
                case DIFFERENT: 
                case IPV4_OK_IPV6_FIREWALLED: 
                case IPV4_UNKNOWN_IPV6_FIREWALLED: 
                case IPV4_FIREWALLED_IPV6_UNKNOWN: 
                case IPV4_OK_IPV6_UNKNOWN: 
                case UNKNOWN: {
                    return this._introManager.introducerCount(true) < 15;
                }
            }
        } else {
            if (config == TransportUtil.IPv6Config.IPV6_ONLY) {
                return false;
            }
            if (this.isIPv4Firewalled()) {
                return true;
            }
            switch (status) {
                case REJECT_UNSOLICITED: 
                case DIFFERENT: 
                case IPV4_UNKNOWN_IPV6_FIREWALLED: 
                case IPV4_FIREWALLED_IPV6_OK: 
                case IPV4_FIREWALLED_IPV6_UNKNOWN: 
                case UNKNOWN: 
                case IPV4_UNKNOWN_IPV6_OK: {
                    return this._introManager.introducerCount(false) < 15;
                }
            }
        }
        return !this.allowDirectUDP();
    }

    boolean canIntroduce(boolean ipv6) {
        return !SystemVersion.isAndroid() && !this._context.router().isHidden() && !this.introducersRequired(ipv6) && this.haveCapacity() && !this._context.netDb().floodfillEnabled() && (!ipv6 || this._haveIPv6Address) && (!ipv6 && this.getIPv6Config() != TransportUtil.IPv6Config.IPV6_ONLY || ipv6 && this.getIPv6Config() != TransportUtil.IPv6Config.IPV6_DISABLED) && this._introManager.introducedCount() < 100 && this._introManager.introducedCount() < this.getMaxConnections() / 4;
    }

    private boolean allowDirectUDP() {
        return this._context.getBooleanPropertyDefaultTrue(PROP_ALLOW_DIRECT);
    }

    String getPacketHandlerStatus() {
        PacketHandler handler = this._handler;
        if (handler != null) {
            return handler.getHandlerStatus();
        }
        return "";
    }

    PacketHandler getPacketHandler() {
        return this._handler;
    }

    public void failed(OutboundMessageState msg) {
        this.failed(msg, true);
    }

    void failed(OutboundMessageState msg, boolean allowPeerFailure) {
        if (msg == null) {
            return;
        }
        OutNetMessage m = msg.getMessage();
        if (allowPeerFailure && msg.getPeer() != null && (msg.getMaxSends() >= 10 || msg.isExpired())) {
            int consecutive = msg.getPeer().incrementConsecutiveFailedSends();
            if (this._log.shouldLog(20)) {
                this._log.info("Consecutive failure #" + consecutive + " on " + msg.toString() + " to " + msg.getPeer());
            }
            if (consecutive >= 3 && this._context.clock().now() - msg.getPeer().getLastSendFullyTime() > 60000L) {
                this._context.statManager().addRateData("udp.dropPeerConsecutiveFailures", consecutive, msg.getPeer().getInactivityTime());
                this.sendDestroy(msg.getPeer(), 14);
                this.dropPeer(msg.getPeer(), true, "too many failures");
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Failed sending " + msg + " to " + msg.getPeer());
        }
        if (m != null) {
            super.afterSend(m, false);
        }
    }

    public void failed(OutNetMessage msg, String reason) {
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Send failed: " + reason + " msg: " + msg, new Exception("failed from"));
        }
        if (this._context.messageHistory().getDoLog()) {
            this._context.messageHistory().sendMessage(msg.getMessageType(), msg.getMessageId(), msg.getExpiration(), msg.getTarget().getIdentity().calculateHash(), false, reason);
        }
        super.afterSend(msg, false);
    }

    public void succeeded(OutboundMessageState msg) {
        OutNetMessage m;
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending message succeeded: " + msg);
        }
        if ((m = msg.getMessage()) != null) {
            super.afterSend(m, true);
        }
    }

    @Override
    public int countPeers() {
        return this._peersByIdent.size();
    }

    @Override
    public int[] getPeerCounts() {
        int[] rv = new int[8];
        for (PeerState peer : this._peersByIdent.values()) {
            int idx = 0;
            if (peer.getVersion() > 1) {
                idx += 4;
            }
            if (peer.isIPv6()) {
                idx += 2;
            }
            if (!peer.isInbound()) {
                // empty if block
            }
            int n = ++idx;
            rv[n] = rv[n] + 1;
        }
        return rv;
    }

    @Override
    public int countActivePeers() {
        long old = this._context.clock().now() - 300000L;
        int active = 0;
        for (PeerState peer : this._peersByIdent.values()) {
            if ((peer.getMessagesReceived() <= 0 || peer.getLastReceiveTime() < old) && (peer.getMessagesSent() <= 0 || peer.getLastSendTime() < old)) continue;
            ++active;
        }
        return active;
    }

    @Override
    public int countActiveSendPeers() {
        long old = this._context.clock().now() - 60000L;
        int active = 0;
        for (PeerState peer : this._peersByIdent.values()) {
            if (peer.getLastSendFullyTime() < old) continue;
            ++active;
        }
        return active;
    }

    @Override
    public boolean isEstablished(Hash dest) {
        return this._peersByIdent.containsKey(dest);
    }

    @Override
    public boolean isBacklogged(Hash dest) {
        PeerState peer = this._peersByIdent.get(dest);
        return peer != null && peer.isBacklogged();
    }

    @Override
    public void mayDisconnect(Hash peer) {
        PeerState ps = this._peersByIdent.get(peer);
        if (ps != null && ps.getWeRelayToThemAs() <= 0L && (ps.getTheyRelayToUsAs() <= 0L || ps.getIntroducerTime() < this._context.clock().now() - 0x6DDD00L) && ps.getMessagesReceived() <= 2 && ps.getMessagesSent() <= 2) {
            ps.setMayDisconnect();
        }
    }

    @Override
    public void forceDisconnect(Hash peer) {
        PeerState ps = this._peersByIdent.get(peer);
        if (ps != null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Force disconnect of " + peer, new Exception("I did it"));
            }
            this.dropPeer(ps, true, "router");
        }
    }

    public boolean allowConnection() {
        return this._peersByIdent.size() < this.getMaxConnections();
    }

    @Override
    public List<Long> getClockSkews() {
        ArrayList<Long> skews = new ArrayList<Long>(this._peersByIdent.size());
        boolean includeEverybody = this._context.router().getUptime() < 600000L || this._peersByIdent.size() < 10;
        long now = this._context.clock().now();
        for (PeerState peer : this._peersByIdent.values()) {
            if (!includeEverybody && now - peer.getLastReceiveTime() > 300000L || peer.getRTT() > 1250) continue;
            skews.add(peer.getClockSkew() / 1000L);
        }
        return skews;
    }

    X25519KeyFactory getXDHFactory() {
        return this._xdhFactory;
    }

    PacketBuilder2 getBuilder2() {
        return this._packetBuilder2;
    }

    IntroductionManager getIntroManager() {
        return this._introManager;
    }

    PeerTestManager getPeerTestManager() {
        return this._testManager;
    }

    InboundMessageFragments getInboundFragments() {
        return this._inboundFragments;
    }

    @Override
    @Deprecated
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
    }

    private void setReachabilityStatus(CommSystemFacade.Status status) {
        this.setReachabilityStatus(status, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReachabilityStatus(CommSystemFacade.Status status, boolean isIPv6) {
        Object object = this._rebuildLock;
        synchronized (object) {
            this.locked_setReachabilityStatus(status, isIPv6);
        }
    }

    private void locked_setReachabilityStatus(CommSystemFacade.Status newStatus, boolean isIPv6) {
        CommSystemFacade.Status old = this._reachabilityStatus;
        if (newStatus == CommSystemFacade.Status.UNKNOWN) {
            boolean runtest = false;
            switch (old) {
                case UNKNOWN: {
                    runtest = true;
                    break;
                }
                case IPV4_UNKNOWN_IPV6_FIREWALLED: 
                case IPV4_UNKNOWN_IPV6_OK: {
                    if (isIPv6) break;
                    runtest = true;
                    break;
                }
                case IPV4_FIREWALLED_IPV6_UNKNOWN: 
                case IPV4_SNAT_IPV6_UNKNOWN: 
                case IPV4_OK_IPV6_UNKNOWN: 
                case IPV4_DISABLED_IPV6_UNKNOWN: {
                    if (!isIPv6) break;
                    runtest = true;
                }
            }
            if (runtest || old != this._reachabilityStatusPending) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Old status: " + (Object)((Object)old) + " unchanged after update: UNKNOWN, reschedule test soon, ipv6? " + isIPv6);
                }
                this._testEvent.forceRunSoon(isIPv6, 60000L);
            } else {
                this._testEvent.forceRunSoon(isIPv6, 300000L);
            }
            return;
        }
        CommSystemFacade.Status status = CommSystemFacade.Status.merge(old, newStatus);
        this._testEvent.setLastTested(isIPv6);
        TransportUtil.IPv6Config config = this.getIPv6Config();
        if (config == TransportUtil.IPv6Config.IPV6_ONLY) {
            if (status == CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK) {
                status = CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK;
            } else if (status == CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED) {
                status = CommSystemFacade.Status.IPV4_DISABLED_IPV6_FIREWALLED;
            } else if (status == CommSystemFacade.Status.UNKNOWN) {
                status = CommSystemFacade.Status.IPV4_DISABLED_IPV6_UNKNOWN;
            }
        }
        if (status != CommSystemFacade.Status.UNKNOWN) {
            if (this._currentOurV6Address == null && !this._haveIPv6Address) {
                if (status == CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN) {
                    status = CommSystemFacade.Status.OK;
                } else if (status == CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN) {
                    status = CommSystemFacade.Status.REJECT_UNSOLICITED;
                } else if (status == CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN) {
                    status = CommSystemFacade.Status.DIFFERENT;
                } else if (status == CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK) {
                    status = CommSystemFacade.Status.REJECT_UNSOLICITED;
                } else if (status == CommSystemFacade.Status.IPV4_SNAT_IPV6_OK) {
                    status = CommSystemFacade.Status.DIFFERENT;
                }
            }
            if (status != old) {
                long now;
                if ((STATUS_OK.contains((Object)old) && STATUS_FW.contains((Object)status) || STATUS_OK.contains((Object)status) && STATUS_FW.contains((Object)old) || STATUS_FW.contains((Object)status) && STATUS_FW.contains((Object)old) || !isIPv6 && STATUS_IPV4_UNK.contains((Object)old) && !STATUS_IPV4_UNK.contains((Object)status)) && status != this._reachabilityStatusPending) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Old status: " + (Object)((Object)old) + " status pending confirmation: " + (Object)((Object)status) + " Caused by update: " + (Object)((Object)newStatus));
                    }
                    this._reachabilityStatusPending = status;
                    this._testEvent.forceRunSoon(isIPv6);
                    return;
                }
                this._reachabilityStatusUnchanged = 0;
                this._reachabilityStatusLastUpdated = now = this._context.clock().now();
                this._reachabilityStatus = status;
            } else {
                ++this._reachabilityStatusUnchanged;
            }
            this._reachabilityStatusPending = status;
        }
        if (status != old) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Old status: " + (Object)((Object)old) + " New status: " + (Object)((Object)status) + " Caused by update: " + (Object)((Object)newStatus) + " from: ", new Exception("traceback"));
            }
            if (old != CommSystemFacade.Status.UNKNOWN && this._context.router().getUptime() > 300000L) {
                this._context.router().eventLog().addEvent("reachability", "from " + this._t(old.toStatusString()) + " to " + this._t(status.toStatusString()));
            }
            if (isIPv6) {
                if (STATUS_IPV6_FW_2.contains((Object)status)) {
                    this.rebuildExternalAddress(true);
                } else if (STATUS_IPV6_FW_2.contains((Object)old) && STATUS_IPV6_OK.contains((Object)status) && !this.explicitAddressSpecified()) {
                    RouterAddress ra = this._currentOurV6Address;
                    if (ra != null) {
                        String addr = ra.getHost();
                        if (addr != null) {
                            int port = this._context.getProperty(PROP_EXTERNAL_PORT, -1);
                            this.rebuildExternalAddress(addr, port, true);
                        } else if (this._log.shouldWarn()) {
                            this._log.warn("Not IPv6 firewalled but no address?");
                        }
                    } else if (this._log.shouldWarn()) {
                        this._log.warn("Not IPv6 firewalled but no address?");
                    }
                }
            } else {
                this.rebuildExternalAddress(false);
            }
        } else {
            if (newStatus == CommSystemFacade.Status.UNKNOWN && status != this._reachabilityStatusPending) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Old status: " + (Object)((Object)status) + " status pending confirmation: " + (Object)((Object)this._reachabilityStatusPending) + " Caused by update: " + (Object)((Object)newStatus));
                }
                this._testEvent.forceRunSoon(isIPv6);
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Status unchanged: " + (Object)((Object)this._reachabilityStatus) + " after update: " + (Object)((Object)newStatus) + " (unchanged " + this._reachabilityStatusUnchanged + " consecutive times), last updated " + DataHelper.formatDuration(this._context.clock().now() - this._reachabilityStatusLastUpdated) + " ago");
            }
        }
    }

    @Override
    public CommSystemFacade.Status getReachabilityStatus() {
        String override = this._context.getProperty(PROP_REACHABILITY_STATUS_OVERRIDE);
        if (override != null) {
            if ("ok".equals(override)) {
                return CommSystemFacade.Status.OK;
            }
            if ("err-reject".equals(override)) {
                return CommSystemFacade.Status.REJECT_UNSOLICITED;
            }
            if ("err-different".equals(override)) {
                return CommSystemFacade.Status.DIFFERENT;
            }
        }
        return this._reachabilityStatus;
    }

    boolean isSymNatted() {
        return STATUS_IPV4_SYMNAT.contains((Object)this.getReachabilityStatus());
    }

    boolean canTestAsCharlie(boolean ipv6) {
        CommSystemFacade.Status status = this.getReachabilityStatus();
        if (ipv6) {
            return !STATUS_IPV6_NO_TEST.contains((Object)status);
        }
        return !STATUS_IPV4_NO_TEST.contains((Object)status);
    }

    @Override
    @Deprecated
    public void recheckReachability() {
    }

    PeerState pickTestPeer(PeerTestState.Role peerRole, int version, boolean isIPv6, RemoteHostId dontInclude) {
        if (peerRole == PeerTestState.Role.ALICE) {
            throw new IllegalArgumentException();
        }
        boolean requireV2 = peerRole == PeerTestState.Role.BOB && !isIPv6 && (this.isSymNatted() || STATUS_IPV4_SYMNAT.contains((Object)this._reachabilityStatusPending));
        ArrayList<PeerState> peers = new ArrayList<PeerState>(this._peersByIdent.values());
        RandomIterator<PeerState> iter = new RandomIterator<PeerState>(peers);
        while (iter.hasNext()) {
            String v;
            PeerState2 bob;
            PeerState peer = (PeerState)iter.next();
            if ((peerRole != PeerTestState.Role.BOB ? peer.getVersion() != version : ((version = peer.getVersion()) == 1 ? requireV2 : (bob = (PeerState2)peer).getOurIP() == null || bob.getOurPort() <= 0)) || dontInclude != null && dontInclude.equals(peer.getRemoteHostId())) continue;
            byte[] ip = peer.getRemoteIP();
            if (peerRole == PeerTestState.Role.BOB && (!isIPv6 ? ip.length != 4 : ip.length != 16)) continue;
            RouterInfo peerInfo = this._context.netDb().lookupRouterInfoLocally(peer.getRemotePeer());
            if (peerInfo == null || VersionComparator.comp(v = peerInfo.getVersion(), MIN_PEER_TEST_VERSION) < 0) continue;
            ip = null;
            List<RouterAddress> addrs = this.getTargetAddresses(peerInfo);
            for (RouterAddress addr : addrs) {
                String style = addr.getTransportStyle();
                if (version != 1 ? style.equals(STYLE) && !"2".equals(addr.getOption("v")) : style.equals(STYLE2)) continue;
                byte[] rip = addr.getIP();
                if (rip == null || (!isIPv6 ? rip.length != 4 : rip.length != 16)) continue;
                String caps = addr.getOption("caps");
                if (caps == null || !caps.contains(CAP_TESTING)) continue;
                ip = rip;
                break;
            }
            if (ip == null || this.isTooClose(ip)) continue;
            return peer;
        }
        return null;
    }

    private static class DestroyedCache
    extends LHMCache<Long, PeerStateDestroyed> {
        public DestroyedCache(int max) {
            super(max);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, PeerStateDestroyed> eldest) {
            boolean rv = super.removeEldestEntry(eldest);
            if (rv) {
                eldest.getValue().kill();
            }
            return rv;
        }
    }

    private class ExpirePeerEvent
    extends SimpleTimer2.TimedEvent {
        private final List<PeerState> _expireBuffer;
        private volatile boolean _alive;
        private int _runCount;
        private boolean _lastLoopShort;
        private static final long PING_FIREWALL_TIME = 30000L;
        private static final long PING_FIREWALL_CUTOFF = 15000L;
        private static final int SLICES = 4;
        private static final long SHORT_LOOP_TIME = 3000L;
        private static final long LONG_LOOP_TIME = 25000L;
        private static final long EXPIRE_INCREMENT = 15000L;
        private static final long EXPIRE_DECREMENT = 45000L;
        private static final long MAY_DISCON_TIMEOUT = 10000L;
        private static final long RI_STORE_INTERVAL = 1740000L;

        public ExpirePeerEvent() {
            super(UDPTransport.this._context.simpleTimer2());
            this._expireBuffer = new ArrayList<PeerState>();
        }

        @Override
        public void timeReached() {
            boolean haveCap = UDPTransport.this.haveCapacity(33);
            if (haveCap) {
                long inc = this._lastLoopShort ? 1800L : 15000L;
                UDPTransport.this._expireTimeout = Math.min(UDPTransport.this._expireTimeout + inc, 1200000L);
            } else {
                long dec = this._lastLoopShort ? 5400L : 45000L;
                UDPTransport.this._expireTimeout = Math.max(UDPTransport.this._expireTimeout - dec, 165000L);
            }
            long now = UDPTransport.this._context.clock().now();
            long shortInactivityCutoff = now - UDPTransport.this._expireTimeout;
            long longInactivityCutoff = now - 1200000L;
            long mayDisconCutoff = now - 10000L;
            long pingCutoff = now - 0x6DDD00L;
            long pingFirewallCutoff = now - 15000L;
            boolean shouldPingFirewall = !STATUS_OK.contains((Object)UDPTransport.this._reachabilityStatus);
            int currentListenPort = UDPTransport.this.getListenPort(false);
            boolean pingOneOnly = shouldPingFirewall && UDPTransport.this.getExternalPort(false) == currentListenPort;
            boolean shortLoop = shouldPingFirewall || !haveCap || UDPTransport.this._context.netDb().floodfillEnabled();
            long loopTime = shortLoop ? 3000L : 25000L;
            this._lastLoopShort = shortLoop;
            this._expireBuffer.clear();
            ++this._runCount;
            for (PeerState peer : UDPTransport.this._peersByIdent.values()) {
                long mod;
                long inactivityCutoff = peer.getWeRelayToThemAs() > 0L || peer.getIntroducerTime() > pingCutoff ? longInactivityCutoff : ((!haveCap || !peer.isInbound()) && peer.getMayDisconnect() && peer.getMessagesReceived() <= 2 && peer.getMessagesSent() <= 2 ? mayDisconCutoff : shortInactivityCutoff);
                if (peer.getLastReceiveTime() < inactivityCutoff && peer.getLastSendTime() < inactivityCutoff) {
                    this._expireBuffer.add(peer);
                    continue;
                }
                if (shouldPingFirewall && ((this._runCount ^ peer.hashCode()) & 3) == 0 && peer.getLastSendOrPingTime() < pingFirewallCutoff && peer.getLastReceiveTime() < pingFirewallCutoff) {
                    UDPPacket ping;
                    if (UDPTransport.this._log.shouldLog(10)) {
                        UDPTransport.this._log.debug("Pinging for firewall: " + peer);
                    }
                    try {
                        ping = UDPTransport.this._packetBuilder2.buildPing((PeerState2)peer);
                    }
                    catch (IOException ioe) {
                        continue;
                    }
                    UDPTransport.this.send(ping);
                    peer.setLastPingTime(now);
                    if (!pingOneOnly) continue;
                    shouldPingFirewall = false;
                    continue;
                }
                long uptime = now - peer.getKeyEstablishedTime();
                if (uptime < 1740000L || (mod = uptime % 1740000L) >= loopTime) continue;
                DatabaseStoreMessage dsm = UDPTransport.this._establisher.getOurInfo();
                UDPTransport.this.send(dsm, peer);
            }
            if (!this._expireBuffer.isEmpty()) {
                if (UDPTransport.this._log.shouldDebug()) {
                    UDPTransport.this._log.debug("Expiring " + this._expireBuffer.size() + " peers");
                }
                for (PeerState peer : this._expireBuffer) {
                    UDPTransport.this.sendDestroy(peer, 2);
                    UDPTransport.this.dropPeer(peer, false, "idle too long");
                }
                this._expireBuffer.clear();
            }
            if (this._alive) {
                this.schedule(loopTime);
            }
        }

        public void setIsAlive(boolean isAlive) {
            this._alive = isAlive;
            if (isAlive) {
                this.reschedule(25000L);
            } else {
                this.cancel();
            }
        }
    }

    private class PingIntroducers
    implements SimpleTimer.TimedEvent {
        private PingIntroducers() {
        }

        @Override
        public void timeReached() {
            if (UDPTransport.this.introducersRequired(false) || UDPTransport.this.introducersRequired(true)) {
                UDPTransport.this._introManager.pingIntroducers();
            }
        }
    }

    private class RebuildEvent
    extends SimpleTimer2.TimedEvent {
        public RebuildEvent() {
            super(UDPTransport.this._context.simpleTimer2());
        }

        @Override
        public void timeReached() {
            UDPTransport.this._context.router().rebuildRouterInfo(true);
        }
    }

    private class RemoveDropList
    implements SimpleTimer.TimedEvent {
        private final RemoteHostId _peer;

        public RemoveDropList(RemoteHostId peer) {
            this._peer = peer;
        }

        @Override
        public void timeReached() {
            UDPTransport.this._dropList.remove(this._peer);
        }
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        @Override
        public Transport getTransport() {
            return UDPTransport.this;
        }

        public String toString() {
            return "UDP bid @ " + this.getLatencyMs();
        }
    }
}

