/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.TransientDataStore;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PThread;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

public class PersistentDataStore
extends TransientDataStore {
    private final File _dbDir;
    private final KademliaNetworkDatabaseFacade _facade;
    private final Writer _writer;
    private final ReadJob _readJob;
    private volatile boolean _initialized;
    private final boolean _flat;
    private final int _networkID;
    private static final int READ_DELAY = 120000;
    private static final String PROP_FLAT = "router.networkDatabase.flat";
    static final String DIR_PREFIX = "r";
    private static final String B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~";
    private static final int MAX_ROUTERS_INIT = SystemVersion.isSlow() ? 1000 : 4000;
    private static final int WRITE_LIMIT = 10000;
    private static final long WRITE_DELAY = 600000L;
    private static final String ROUTERINFO_PREFIX = "routerInfo-";
    private static final String ROUTERINFO_SUFFIX = ".dat";
    public static final FileFilter RI_FILTER = new FileSuffixFilter("routerInfo-", ".dat");

    public PersistentDataStore(RouterContext ctx, String dbDir, KademliaNetworkDatabaseFacade facade) throws IOException {
        super(ctx);
        this._networkID = ctx.router().getNetworkID();
        this._flat = ctx.getBooleanProperty(PROP_FLAT);
        this._dbDir = this.getDbDir(dbDir);
        this._facade = facade;
        this._readJob = new ReadJob();
        this._context.jobQueue().addJob(this._readJob);
        ctx.statManager().createRateStat("netDb.writeClobber", "How often we clobber a pending netDb write", "NetworkDatabase", new long[]{1200000L});
        ctx.statManager().createRateStat("netDb.writePending", "How many pending writes are there", "NetworkDatabase", new long[]{60000L});
        ctx.statManager().createRateStat("netDb.writeOut", "How many we wrote", "NetworkDatabase", new long[]{1200000L});
        ctx.statManager().createRateStat("netDb.writeTime", "How long it took", "NetworkDatabase", new long[]{1200000L});
        this._writer = new Writer();
        I2PThread writer = new I2PThread(this._writer, "DBWriter");
        writer.start();
    }

    @Override
    public boolean isInitialized() {
        return this._initialized || this._readJob.isNetDbReady();
    }

    @Override
    public void stop() {
        super.stop();
        this._writer.flush();
    }

    @Override
    public void rescan() {
        if (this._initialized) {
            this._readJob.wakeup();
        }
    }

    @Override
    public DatabaseEntry get(Hash key) {
        return this.get(key, true);
    }

    @Override
    public DatabaseEntry get(Hash key, boolean persist) {
        DatabaseEntry rv = super.get(key);
        return rv;
    }

    @Override
    public DatabaseEntry remove(Hash key) {
        return this.remove(key, true);
    }

    @Override
    public DatabaseEntry remove(Hash key, boolean persist) {
        if (persist) {
            this._writer.remove(key);
        }
        return super.remove(key);
    }

    @Override
    public boolean put(Hash key, DatabaseEntry data) {
        return this.put(key, data, true);
    }

    @Override
    public boolean put(Hash key, DatabaseEntry data, boolean persist) {
        if (data == null || key == null) {
            return false;
        }
        boolean rv = super.put(key, data);
        if (rv && persist && data.getType() == 0) {
            this._writer.queue(key, data);
        }
        return rv;
    }

    @Override
    public boolean forcePut(Hash key, DatabaseEntry data) {
        boolean rv = super.forcePut(key, data);
        if (rv && data.getType() == 0) {
            this._writer.queue(key, data);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Hash key, DatabaseEntry data) {
        if (this._log.shouldLog(20)) {
            this._log.info("Writing key " + key);
        }
        OutputStream fos = null;
        File dbFile = null;
        try {
            String filename = null;
            if (data.getType() != 0) {
                throw new IOException("We don't know how to write objects of type " + data.getClass().getName());
            }
            filename = this.getRouterInfoName(key);
            dbFile = new File(this._dbDir, filename);
            long dataPublishDate = PersistentDataStore.getPublishDate(data);
            if (dbFile.lastModified() < dataPublishDate) {
                fos = new SecureFileOutputStream(dbFile);
                fos = new BufferedOutputStream(fos);
                try {
                    data.writeBytes(fos);
                    fos.close();
                    dbFile.setLastModified(dataPublishDate);
                }
                catch (DataFormatException dfe) {
                    this._log.error("Error writing out malformed object as " + key + ": " + data, dfe);
                    dbFile.delete();
                }
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Not writing " + key.toBase64() + ", as its up to date on disk (file mod-publish=" + (dbFile.lastModified() - dataPublishDate) + ")");
            }
        }
        catch (IOException ioe) {
            this._log.error("Error writing out the object", ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static long getPublishDate(DatabaseEntry data) {
        return data.getDate();
    }

    private File getDbDir(String dbDir) throws IOException {
        boolean created;
        SecureDirectory f = new SecureDirectory(this._context.getRouterDir(), dbDir);
        if (!f.exists() && !(created = ((File)f).mkdirs())) {
            throw new IOException("Unable to create the DB directory [" + f.getAbsolutePath() + "]");
        }
        if (!f.isDirectory()) {
            throw new IOException("DB directory [" + f.getAbsolutePath() + "] is not a directory!");
        }
        if (!f.canRead()) {
            throw new IOException("DB directory [" + f.getAbsolutePath() + "] is not readable!");
        }
        if (!f.canWrite()) {
            throw new IOException("DB directory [" + f.getAbsolutePath() + "] is not writable!");
        }
        if (this._flat) {
            PersistentDataStore.unmigrate(f);
        } else {
            for (int j = 0; j < B64.length(); ++j) {
                SecureDirectory subdir = new SecureDirectory(f, DIR_PREFIX + B64.charAt(j));
                if (subdir.exists()) continue;
                ((File)subdir).mkdir();
            }
            File[] routerInfoFiles = f.listFiles(RI_FILTER);
            if (routerInfoFiles != null) {
                PersistentDataStore.migrate(f, routerInfoFiles);
            }
        }
        return f;
    }

    private static void unmigrate(File dbdir) {
        for (int j = 0; j < B64.length(); ++j) {
            File subdir = new File(dbdir, DIR_PREFIX + B64.charAt(j));
            File[] files = subdir.listFiles(RI_FILTER);
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                File from = files[i];
                File to = new File(dbdir, from.getName());
                FileUtil.rename(from, to);
            }
        }
    }

    private static void migrate(File dbdir, File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File from = files[i];
            if (!from.isFile()) continue;
            File dir = new File(dbdir, DIR_PREFIX + from.getName().charAt(ROUTERINFO_PREFIX.length()));
            File to = new File(dir, from.getName());
            FileUtil.rename(from, to);
        }
    }

    private String getRouterInfoName(Hash hash) {
        String b64 = hash.toBase64();
        if (this._flat) {
            return ROUTERINFO_PREFIX + b64 + ROUTERINFO_SUFFIX;
        }
        return DIR_PREFIX + b64.charAt(0) + File.separatorChar + ROUTERINFO_PREFIX + b64 + ROUTERINFO_SUFFIX;
    }

    public static File getRouterInfoFile(RouterContext ctx, Hash hash) {
        String b64 = hash.toBase64();
        File dir = new File(ctx.getRouterDir(), ctx.getProperty("router.networkDatabase.dbDir", "netDb"));
        if (ctx.getBooleanProperty(PROP_FLAT)) {
            return new File(dir, ROUTERINFO_PREFIX + b64 + ROUTERINFO_SUFFIX);
        }
        return new File(dir, DIR_PREFIX + b64.charAt(0) + File.separatorChar + ROUTERINFO_PREFIX + b64 + ROUTERINFO_SUFFIX);
    }

    static Hash getRouterInfoHash(String filename) {
        return PersistentDataStore.getHash(filename, ROUTERINFO_PREFIX, ROUTERINFO_SUFFIX);
    }

    private static Hash getHash(String filename, String prefix, String suffix) {
        try {
            String key = filename.substring(prefix.length());
            key = key.substring(0, key.length() - suffix.length());
            byte[] b = Base64.decode(key);
            if (b == null) {
                return null;
            }
            Hash h = Hash.create(b);
            return h;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private void removeFile(Hash key, File dir) throws IOException {
        String riName = this.getRouterInfoName(key);
        File f = new File(dir, riName);
        if (f.exists()) {
            boolean removed = f.delete();
            if (!removed) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to remove router info at " + f.getAbsolutePath());
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("Removed router info at " + f.getAbsolutePath());
            }
            return;
        }
    }

    private class ReadJob
    extends JobImpl {
        private volatile long _lastModified;
        private volatile long _lastReseed;
        private volatile boolean _setNetDbReady;
        private static final int MIN_ROUTERS = 50;
        private static final long MIN_RESEED_INTERVAL = 5400000L;

        public ReadJob() {
            super(PersistentDataStore.this._context);
        }

        @Override
        public String getName() {
            return "DB Read Job";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            boolean shouldScan;
            if (this.getContext().router().gracefulShutdownInProgress()) {
                this.requeue(120000L);
                return;
            }
            long now = System.currentTimeMillis();
            long lastMod = PersistentDataStore.this._dbDir.lastModified();
            boolean bl = shouldScan = lastMod > this._lastModified || PersistentDataStore.this.size() < 60;
            if (!shouldScan && !PersistentDataStore.this._flat) {
                for (int j = 0; j < PersistentDataStore.B64.length(); ++j) {
                    File subdir = new File(PersistentDataStore.this._dbDir, PersistentDataStore.DIR_PREFIX + PersistentDataStore.B64.charAt(j));
                    if (subdir.lastModified() <= this._lastModified) continue;
                    shouldScan = true;
                    break;
                }
            }
            if (shouldScan) {
                PersistentDataStore.this._log.info("Rereading new files");
                File file = PersistentDataStore.this._dbDir;
                synchronized (file) {
                    this.readFiles();
                }
                this._lastModified = now;
            }
            this.requeue(120000L);
        }

        public void wakeup() {
            this.requeue(0L);
        }

        public boolean isNetDbReady() {
            return this._setNetDbReady;
        }

        private void readFiles() {
            int count;
            int routerCount = 0;
            File[] routerInfoFiles = PersistentDataStore.this._dbDir.listFiles(RI_FILTER);
            if (PersistentDataStore.this._flat) {
                if (routerInfoFiles != null) {
                    routerCount = routerInfoFiles.length;
                    for (int i = 0; i < routerInfoFiles.length && PersistentDataStore.this._context.router().isAlive(); ++i) {
                        Hash key = PersistentDataStore.getRouterInfoHash(routerInfoFiles[i].getName());
                        if (key == null) continue;
                        new ReadRouterJob(routerInfoFiles[i], key).runJob();
                    }
                }
            } else {
                if (routerInfoFiles != null) {
                    PersistentDataStore.migrate(PersistentDataStore.this._dbDir, routerInfoFiles);
                }
                ArrayList<File> toRead = new ArrayList<File>(2048);
                for (int j = 0; j < PersistentDataStore.B64.length(); ++j) {
                    File subdir = new File(PersistentDataStore.this._dbDir, PersistentDataStore.DIR_PREFIX + PersistentDataStore.B64.charAt(j));
                    File[] files = subdir.listFiles(RI_FILTER);
                    if (files == null) continue;
                    long lastMod = subdir.lastModified();
                    if (routerCount >= 50 && lastMod <= this._lastModified) continue;
                    routerCount += files.length;
                    if (lastMod <= this._lastModified) continue;
                    for (int i = 0; i < files.length; ++i) {
                        toRead.add(files[i]);
                    }
                }
                Collections.shuffle(toRead, PersistentDataStore.this._context.random());
                int i = 0;
                for (File file : toRead) {
                    ReadRouterJob rrj;
                    if (i >= MAX_ROUTERS_INIT && !PersistentDataStore.this._initialized) {
                        file.delete();
                        continue;
                    }
                    Hash key = PersistentDataStore.getRouterInfoHash(file.getName());
                    if (key == null || !(rrj = new ReadRouterJob(file, key)).read()) continue;
                    if (i++ == 150 && SystemVersion.isSlow() && !PersistentDataStore.this._initialized) {
                        this._setNetDbReady = true;
                        PersistentDataStore.this._context.router().setNetDbReady();
                        continue;
                    }
                    if (i != 500 || this._setNetDbReady) continue;
                    this._setNetDbReady = true;
                    PersistentDataStore.this._context.router().setNetDbReady();
                }
            }
            if (!PersistentDataStore.this._initialized) {
                PersistentDataStore.this._initialized = true;
                if (PersistentDataStore.this._facade.reseedChecker().checkReseed(routerCount)) {
                    this._lastReseed = PersistentDataStore.this._context.clock().now();
                } else if (!this._setNetDbReady) {
                    this._setNetDbReady = true;
                    PersistentDataStore.this._context.router().setNetDbReady();
                }
            } else if (this._lastReseed < PersistentDataStore.this._context.clock().now() - 5400000L) {
                count = Math.min(routerCount, PersistentDataStore.this.size());
                if (count < 50) {
                    if (PersistentDataStore.this._facade.reseedChecker().checkReseed(count)) {
                        this._lastReseed = PersistentDataStore.this._context.clock().now();
                    }
                } else if (!this._setNetDbReady) {
                    this._setNetDbReady = true;
                    PersistentDataStore.this._context.router().setNetDbReady();
                }
            } else if (!this._setNetDbReady && (count = Math.min(routerCount, PersistentDataStore.this.size())) >= 50) {
                this._setNetDbReady = true;
                PersistentDataStore.this._context.router().setNetDbReady();
            }
        }
    }

    private class ReadRouterJob
    extends JobImpl {
        private final File _routerFile;
        private final Hash _key;
        private long _knownDate;

        public ReadRouterJob(File routerFile, Hash key) {
            super(PersistentDataStore.this._context);
            this._routerFile = routerFile;
            this._key = key;
        }

        @Override
        public String getName() {
            return "Read RouterInfo";
        }

        private boolean shouldRead() {
            DatabaseEntry data = PersistentDataStore.this.get(this._key, false);
            if (data == null) {
                return true;
            }
            if (data.getType() == 0) {
                this._knownDate = ((RouterInfo)data).getPublished();
                long fileDate = this._routerFile.lastModified();
                return fileDate > this._knownDate + 3600000L;
            }
            PersistentDataStore.this._log.error("Prevented LS overwrite by RI " + this._key + " from " + this._routerFile);
            return false;
        }

        @Override
        public void runJob() {
            this.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean read() {
            boolean corrupt;
            block40: {
                if (this._routerFile.length() > 4096L) {
                    if (PersistentDataStore.this._log.shouldWarn()) {
                        PersistentDataStore.this._log.warn("RI file too big " + this._routerFile.length() + ": " + this._routerFile);
                    }
                    this._routerFile.delete();
                    return false;
                }
                if (!this.shouldRead()) {
                    return false;
                }
                if (PersistentDataStore.this._log.shouldLog(10)) {
                    PersistentDataStore.this._log.debug("Reading " + this._routerFile);
                }
                InputStream fis = null;
                corrupt = false;
                try {
                    fis = new FileInputStream(this._routerFile);
                    fis = new BufferedInputStream(fis);
                    RouterInfo ri = new RouterInfo();
                    ri.readBytes(fis, true);
                    Hash h = ri.getIdentity().calculateHash();
                    if (ri.getNetworkId() != PersistentDataStore.this._networkID) {
                        corrupt = true;
                        if (PersistentDataStore.this._log.shouldLog(40)) {
                            PersistentDataStore.this._log.error("The router " + h.toBase64() + " is from a different network");
                        }
                        break block40;
                    }
                    if (!h.equals(this._key)) {
                        corrupt = true;
                        if (PersistentDataStore.this._log.shouldLog(30)) {
                            PersistentDataStore.this._log.warn(h + " does not match " + this._key + " from " + this._routerFile);
                        }
                        break block40;
                    }
                    if (ri.getPublished() <= this._knownDate) {
                        if (PersistentDataStore.this._log.shouldLog(30)) {
                            PersistentDataStore.this._log.warn("Skipping since netdb newer than " + this._routerFile);
                        }
                        break block40;
                    }
                    if (this.getContext().blocklist().isBlocklisted(ri)) {
                        corrupt = true;
                        if (PersistentDataStore.this._log.shouldLog(30)) {
                            PersistentDataStore.this._log.warn(h + " is blocklisted");
                        }
                        break block40;
                    }
                    try {
                        PersistentDataStore.this._facade.store(h, ri, false);
                        if (ri.getCapabilities().indexOf(82) >= 0) {
                            this.getContext().profileManager().heardAbout(h, ri.getPublished());
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        if (PersistentDataStore.this._log.shouldLog(20)) {
                            PersistentDataStore.this._log.info("Refused locally loaded routerInfo - deleting", iae);
                        }
                        corrupt = true;
                    }
                }
                catch (DataFormatException dfe) {
                    if (PersistentDataStore.this._log.shouldLog(20)) {
                        PersistentDataStore.this._log.info("Error reading the routerInfo from " + this._routerFile.getName(), dfe);
                    }
                    corrupt = true;
                }
                catch (IOException ioe) {
                    if (PersistentDataStore.this._log.shouldLog(20)) {
                        PersistentDataStore.this._log.info("Unable to read the router reference in " + this._routerFile.getName(), ioe);
                    }
                    corrupt = true;
                }
                catch (RuntimeException e) {
                    if (PersistentDataStore.this._log.shouldLog(20)) {
                        PersistentDataStore.this._log.info("Unable to read the router reference in " + this._routerFile.getName(), e);
                    }
                    corrupt = true;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException dfe) {}
                    }
                }
            }
            if (corrupt) {
                this._routerFile.delete();
            }
            return !corrupt;
        }
    }

    private class Writer
    implements Runnable,
    Flushable {
        private final Map<Hash, DatabaseEntry> _keys = new ConcurrentHashMap<Hash, DatabaseEntry>(64);
        private final Set<Hash> _keysToRemove = new ConcurrentHashSet<Hash>();
        private final Object _waitLock = new Object();
        private volatile boolean _quit;

        public void queue(Hash key, DatabaseEntry data) {
            boolean exists;
            int pending = this._keys.size();
            this._keysToRemove.remove(key);
            boolean bl = exists = null != this._keys.put(key, data);
            if (exists) {
                PersistentDataStore.this._context.statManager().addRateData("netDb.writeClobber", pending);
            }
            PersistentDataStore.this._context.statManager().addRateData("netDb.writePending", pending);
        }

        public void remove(Hash key) {
            this._keys.remove(key);
            this._keysToRemove.add(key);
        }

        private void removeQueued() {
            if (this._keysToRemove.isEmpty()) {
                return;
            }
            Iterator<Hash> iter = this._keysToRemove.iterator();
            while (iter.hasNext()) {
                Hash key = iter.next();
                iter.remove();
                try {
                    PersistentDataStore.this.removeFile(key, PersistentDataStore.this._dbDir);
                }
                catch (IOException ioe) {
                    if (!PersistentDataStore.this._log.shouldWarn()) continue;
                    PersistentDataStore.this._log.warn("Error removing key " + key, ioe);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._quit = false;
            Hash key = null;
            DatabaseEntry data = null;
            int count = 0;
            int lastCount = 0;
            long startTime = 0L;
            while (true) {
                Iterator<Map.Entry<Hash, DatabaseEntry>> iter = this._keys.entrySet().iterator();
                try {
                    Map.Entry<Hash, DatabaseEntry> entry = iter.next();
                    key = entry.getKey();
                    data = entry.getValue();
                    iter.remove();
                    ++count;
                }
                catch (NoSuchElementException nsee) {
                    lastCount = count;
                    count = 0;
                }
                catch (IllegalStateException ise) {
                    lastCount = count;
                    count = 0;
                }
                if (key != null) {
                    if (data != null) {
                        File ise = PersistentDataStore.this._dbDir;
                        synchronized (ise) {
                            PersistentDataStore.this.write(key, data);
                        }
                        data = null;
                    }
                    key = null;
                }
                if (count >= 10000) {
                    count = 0;
                }
                if (count != 0) continue;
                this.removeQueued();
                if (lastCount > 0) {
                    long time = PersistentDataStore.this._context.clock().now() - startTime;
                    if (PersistentDataStore.this._log.shouldLog(20)) {
                        PersistentDataStore.this._log.info("Wrote " + lastCount + " entries to disk in " + time);
                    }
                    PersistentDataStore.this._context.statManager().addRateData("netDb.writeOut", lastCount);
                    PersistentDataStore.this._context.statManager().addRateData("netDb.writeTime", time);
                }
                if (this._quit) break;
                Object object = this._waitLock;
                synchronized (object) {
                    try {
                        this._waitLock.wait(600000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                startTime = PersistentDataStore.this._context.clock().now();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            Object object = this._waitLock;
            synchronized (object) {
                this._quit = true;
                this._waitLock.notifyAll();
            }
        }
    }
}

