/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class TLSA
extends Data {
    private static final Map<Byte, CertUsage> CERT_USAGE_LUT = new HashMap<Byte, CertUsage>();
    private static final Map<Byte, Selector> SELECTOR_LUT = new HashMap<Byte, Selector>();
    private static final Map<Byte, MatchingType> MATCHING_TYPE_LUT = new HashMap<Byte, MatchingType>();
    public final byte certUsageByte;
    public final CertUsage certUsage;
    public final byte selectorByte;
    public final Selector selector;
    public final byte matchingTypeByte;
    public final MatchingType matchingType;
    private final byte[] certificateAssociation;

    public static TLSA parse(DataInputStream dis, int length) throws IOException {
        byte certUsage = dis.readByte();
        byte selector = dis.readByte();
        byte matchingType = dis.readByte();
        byte[] certificateAssociation = new byte[length - 3];
        if (dis.read(certificateAssociation) != certificateAssociation.length) {
            throw new IOException();
        }
        return new TLSA(certUsage, selector, matchingType, certificateAssociation);
    }

    TLSA(byte certUsageByte, byte selectorByte, byte matchingTypeByte, byte[] certificateAssociation) {
        this.certUsageByte = certUsageByte;
        this.certUsage = CERT_USAGE_LUT.get(certUsageByte);
        this.selectorByte = selectorByte;
        this.selector = SELECTOR_LUT.get(selectorByte);
        this.matchingTypeByte = matchingTypeByte;
        this.matchingType = MATCHING_TYPE_LUT.get(matchingTypeByte);
        this.certificateAssociation = certificateAssociation;
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.TLSA;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeByte(this.certUsageByte);
        dos.writeByte(this.selectorByte);
        dos.writeByte(this.matchingTypeByte);
        dos.write(this.certificateAssociation);
    }

    public String toString() {
        return "" + this.certUsageByte + ' ' + this.selectorByte + ' ' + this.matchingTypeByte + ' ' + new BigInteger(1, this.certificateAssociation).toString(16);
    }

    public byte[] getCertificateAssociation() {
        return (byte[])this.certificateAssociation.clone();
    }

    public boolean certificateAssociationEquals(byte[] otherCertificateAssociation) {
        return Arrays.equals(this.certificateAssociation, otherCertificateAssociation);
    }

    static {
        CertUsage.values();
        Selector.values();
        MatchingType.values();
    }

    public static enum CertUsage {
        caConstraint(0),
        serviceCertificateConstraint(1),
        trustAnchorAssertion(2),
        domainIssuedCertificate(3);

        public final byte byteValue;

        private CertUsage(byte byteValue) {
            this.byteValue = byteValue;
            CERT_USAGE_LUT.put(byteValue, this);
        }
    }

    public static enum MatchingType {
        noHash(0),
        sha256(1),
        sha512(2);

        public final byte byteValue;

        private MatchingType(byte byteValue) {
            this.byteValue = byteValue;
            MATCHING_TYPE_LUT.put(byteValue, this);
        }
    }

    public static enum Selector {
        fullCertificate(0),
        subjectPublicKeyInfo(1);

        public final byte byteValue;

        private Selector(byte byteValue) {
            this.byteValue = byteValue;
            SELECTOR_LUT.put(byteValue, this);
        }
    }
}

