/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.ByteArray;
import net.i2p.i2ptunnel.util.LimitOutputStream;
import net.i2p.util.ByteCache;
import net.i2p.util.Clock;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class I2PTunnelRunner
extends I2PAppThread
implements I2PSocket.SocketErrorListener,
LimitOutputStream.DoneCallback {
    protected final Log _log;
    private static final AtomicLong __runnerId = new AtomicLong();
    private final long _runnerId;
    static int MAX_PACKET_SIZE;
    static final int NETWORK_BUFFER_SIZE;
    private final Socket s;
    private final I2PSocket i2ps;
    private final Object slock;
    private final Object finishLock = new Object();
    private volatile boolean finished;
    private final byte[] initialI2PData;
    private final byte[] initialSocketData;
    private final long startedOn;
    private final List<I2PSocket> sockList;
    private final Runnable onTimeout;
    private final FailCallback _onFail;
    private SuccessCallback _onSuccess;
    private long totalSent;
    private long totalReceived;
    protected volatile boolean _keepAliveI2P;
    protected volatile boolean _keepAliveSocket;
    private StreamForwarder toI2P;
    private StreamForwarder fromI2P;
    private static final byte[] POST;
    private static final byte[] PUT;

    @Deprecated
    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, List<I2PSocket> sockList) {
        this(s, i2ps, slock, initialI2PData, null, sockList, null, null, true);
    }

    @Deprecated
    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList) {
        this(s, i2ps, slock, initialI2PData, initialSocketData, sockList, null, null, true);
    }

    @Deprecated
    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, List<I2PSocket> sockList, Runnable onTimeout) {
        this(s, i2ps, slock, initialI2PData, null, sockList, onTimeout, null, true);
    }

    @Deprecated
    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList, Runnable onTimeout) {
        this(s, i2ps, slock, initialI2PData, initialSocketData, sockList, onTimeout, null, true);
    }

    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList, FailCallback onFail) {
        this(s, i2ps, slock, initialI2PData, initialSocketData, sockList, null, onFail, false);
    }

    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList, FailCallback onFail, boolean keepAliveI2P, boolean keepAliveSocket) {
        this(s, i2ps, slock, initialI2PData, initialSocketData, sockList, null, onFail, keepAliveI2P, keepAliveSocket, false);
    }

    private I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList, Runnable onTimeout, FailCallback onFail, boolean shouldStart) {
        this(s, i2ps, slock, initialI2PData, initialSocketData, sockList, null, onFail, false, false, shouldStart);
    }

    private I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList, Runnable onTimeout, FailCallback onFail, boolean keepAliveI2P, boolean keepAliveSocket, boolean shouldStart) {
        this.sockList = sockList;
        this.s = s;
        this.i2ps = i2ps;
        this.slock = slock;
        this.initialI2PData = initialI2PData;
        this.initialSocketData = initialSocketData;
        this.onTimeout = onTimeout;
        this._onFail = onFail;
        this.startedOn = Clock.getInstance().now();
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
        this._keepAliveI2P = keepAliveI2P;
        this._keepAliveSocket = keepAliveSocket;
        if (this._log.shouldLog(20)) {
            this._log.info("I2PTunnelRunner started");
        }
        this._runnerId = __runnerId.incrementAndGet();
        if (shouldStart) {
            this.setName("I2PTunnelRunner " + this._runnerId);
            this.start();
        }
    }

    @Deprecated
    public boolean isFinished() {
        return this.finished;
    }

    @Deprecated
    public long getLastActivityOn() {
        return -1L;
    }

    public long getStartedOn() {
        return this.startedOn;
    }

    public void setSuccessCallback(SuccessCallback sc) {
        this._onSuccess = sc;
    }

    protected InputStream getSocketIn() throws IOException {
        return this.s.getInputStream();
    }

    protected OutputStream getSocketOut() throws IOException {
        return this.s.getOutputStream();
    }

    boolean getKeepAliveI2P() {
        return this._keepAliveI2P;
    }

    boolean getKeepAliveSocket() {
        return this._keepAliveSocket;
    }

    @Override
    public void streamDone() {
        if (this._keepAliveSocket && this.fromI2P != null) {
            if (this._log.shouldInfo()) {
                this._log.info("Stream done from I2P", new Exception("I did it"));
            }
            this.fromI2P.done = true;
        } else if (this._keepAliveI2P && this.toI2P != null) {
            if (this._log.shouldInfo()) {
                this._log.info("Stream done from Server", new Exception("I did it"));
            }
            this.toI2P.done = true;
        } else if (this._log.shouldWarn()) {
            this._log.info("Unexpected stream done", new Exception("I did it"));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void close(OutputStream out, InputStream in, OutputStream i2pout, InputStream i2pin, Socket s, I2PSocket i2ps, Thread t1, Thread t2) throws InterruptedException {
        if (out != null) {
            try {
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (i2pout != null) {
            try {
                i2pout.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (i2pin != null) {
            try {
                i2pin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            i2ps.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (t1 != null) {
            t1.join(30000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void errorOccurred() {
        Object object = this.finishLock;
        synchronized (object) {
            this.finished = true;
            this.finishLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRef() {
        if (this.sockList != null) {
            Object object = this.slock;
            synchronized (object) {
                this.sockList.remove(this.i2ps);
            }
        }
    }

    static {
        NETWORK_BUFFER_SIZE = MAX_PACKET_SIZE = 4096;
        POST = new byte[]{80, 79, 83, 84, 32};
        PUT = new byte[]{80, 85, 84, 32};
    }

    public static interface FailCallback {
        public void onFail(Exception var1);
    }

    private class StreamForwarder
    extends I2PAppThread {
        private final InputStream in;
        private final OutputStream out;
        private final String direction;
        private final boolean _toI2P;
        private final ByteCache _cache;
        private final SuccessCallback _callback;
        private volatile Exception _failure;
        public boolean done;

        public StreamForwarder(InputStream in, OutputStream out, boolean toI2P, SuccessCallback cb) {
            this.in = in;
            this.out = out;
            this._toI2P = toI2P;
            this._callback = cb;
            this.direction = toI2P ? "toI2P" : "fromI2P";
            this._cache = ByteCache.getInstance(32, NETWORK_BUFFER_SIZE);
            if (toI2P) {
                this.setName("StreamForwarder " + I2PTunnelRunner.this._runnerId + '.' + this.direction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            ByteArray ba;
            String to;
            String from;
            block92: {
                boolean keepAliveTo;
                block91: {
                    boolean keepAliveFrom;
                    block90: {
                        int len;
                        from = I2PTunnelRunner.this.i2ps.getThisDestination().calculateHash().toBase64().substring(0, 6);
                        to = I2PTunnelRunner.this.i2ps.getPeerDestination().calculateHash().toBase64().substring(0, 6);
                        if (I2PTunnelRunner.this._log.shouldLog(10)) {
                            I2PTunnelRunner.this._log.debug(this.direction + ": Forwarding between " + from + " and " + to);
                        }
                        ba = (ByteArray)this._cache.acquire();
                        byte[] buffer = ba.getData();
                        while (!this.done && (len = this.in.read(buffer)) != -1) {
                            if (len > 0) {
                                this.out.write(buffer, 0, len);
                                if (this._toI2P) {
                                    I2PTunnelRunner.this.totalSent = I2PTunnelRunner.this.totalSent + (long)len;
                                } else {
                                    if (I2PTunnelRunner.this.totalReceived == 0L && this._callback != null) {
                                        this._callback.onSuccess();
                                    }
                                    I2PTunnelRunner.this.totalReceived = I2PTunnelRunner.this.totalReceived + (long)len;
                                }
                            }
                            if (this.in.available() != 0) continue;
                            this.out.flush();
                        }
                        this._cache.release(ba);
                        if (this._toI2P) {
                            keepAliveFrom = I2PTunnelRunner.this._keepAliveSocket;
                            keepAliveTo = I2PTunnelRunner.this._keepAliveI2P;
                        } else {
                            keepAliveFrom = I2PTunnelRunner.this._keepAliveI2P;
                            keepAliveTo = I2PTunnelRunner.this._keepAliveSocket;
                        }
                        if (!I2PTunnelRunner.this._log.shouldLog(20)) break block90;
                        I2PTunnelRunner.this._log.info(this.direction + ": done forwarding from " + from + " to " + to + " keepalive from? " + keepAliveFrom + " keepalive to? " + keepAliveTo + " bytes: " + (this._toI2P ? I2PTunnelRunner.this.totalSent : I2PTunnelRunner.this.totalReceived));
                    }
                    if (!keepAliveFrom) {
                        try {
                            this.in.close();
                        }
                        catch (IOException ex) {
                            if (!I2PTunnelRunner.this._log.shouldLog(30)) break block91;
                            I2PTunnelRunner.this._log.warn(this.direction + ": Error closing input stream", ex);
                        }
                    }
                }
                try {
                    if (I2PTunnelRunner.this.onTimeout == null && I2PTunnelRunner.this._onFail == null || this._toI2P || I2PTunnelRunner.this.totalReceived > 0L) {
                        if (keepAliveTo) {
                            this.out.flush();
                        } else {
                            this.out.close();
                        }
                    } else {
                        if (I2PTunnelRunner.this._log.shouldInfo()) {
                            I2PTunnelRunner.this._log.info(this.direction + ": not closing so we can write the error message");
                        }
                        if (keepAliveTo) {
                            this.out.flush();
                        }
                    }
                }
                catch (IOException ioe3) {
                    if (!I2PTunnelRunner.this._log.shouldLog(10)) break block92;
                    I2PTunnelRunner.this._log.debug(this.direction + ": Error flushing to close", ioe3);
                }
            }
            Object ioe3 = I2PTunnelRunner.this.finishLock;
            synchronized (ioe3) {
                I2PTunnelRunner.this.finished = true;
                I2PTunnelRunner.this.finishLock.notifyAll();
            }
            catch (SocketException ex) {
                block95: {
                    boolean keepAliveTo;
                    block94: {
                        boolean keepAliveFrom;
                        block93: {
                            if (I2PTunnelRunner.this._log.shouldDebug()) {
                                boolean fnshd;
                                ioe3 = I2PTunnelRunner.this.finishLock;
                                synchronized (ioe3) {
                                    fnshd = I2PTunnelRunner.this.finished;
                                }
                                if (!fnshd) {
                                    I2PTunnelRunner.this._log.debug(this.direction + ": IOE - error forwarding", ex);
                                } else {
                                    I2PTunnelRunner.this._log.debug(this.direction + ": IOE caused by other direction", ex);
                                }
                            }
                            this._failure = ex;
                            this._cache.release(ba);
                            if (this._toI2P) {
                                keepAliveFrom = I2PTunnelRunner.this._keepAliveSocket;
                                keepAliveTo = I2PTunnelRunner.this._keepAliveI2P;
                            } else {
                                keepAliveFrom = I2PTunnelRunner.this._keepAliveI2P;
                                keepAliveTo = I2PTunnelRunner.this._keepAliveSocket;
                            }
                            if (!I2PTunnelRunner.this._log.shouldLog(20)) break block93;
                            I2PTunnelRunner.this._log.info(this.direction + ": done forwarding from " + from + " to " + to + " keepalive from? " + keepAliveFrom + " keepalive to? " + keepAliveTo + " bytes: " + (this._toI2P ? I2PTunnelRunner.this.totalSent : I2PTunnelRunner.this.totalReceived));
                        }
                        if (!keepAliveFrom) {
                            try {
                                this.in.close();
                            }
                            catch (IOException ex2) {
                                if (!I2PTunnelRunner.this._log.shouldLog(30)) break block94;
                                I2PTunnelRunner.this._log.warn(this.direction + ": Error closing input stream", ex2);
                            }
                        }
                    }
                    try {
                        if (I2PTunnelRunner.this.onTimeout == null && I2PTunnelRunner.this._onFail == null || this._toI2P || I2PTunnelRunner.this.totalReceived > 0L) {
                            if (keepAliveTo) {
                                this.out.flush();
                            } else {
                                this.out.close();
                            }
                        } else {
                            if (I2PTunnelRunner.this._log.shouldInfo()) {
                                I2PTunnelRunner.this._log.info(this.direction + ": not closing so we can write the error message");
                            }
                            if (keepAliveTo) {
                                this.out.flush();
                            }
                        }
                    }
                    catch (IOException ioe2) {
                        if (!I2PTunnelRunner.this._log.shouldLog(10)) break block95;
                        I2PTunnelRunner.this._log.debug(this.direction + ": Error flushing to close", ioe2);
                    }
                }
                Object ioe3 = I2PTunnelRunner.this.finishLock;
                synchronized (ioe3) {
                    I2PTunnelRunner.this.finished = true;
                    I2PTunnelRunner.this.finishLock.notifyAll();
                }
            }
            catch (IOException ex2) {
                block98: {
                    boolean keepAliveTo;
                    block97: {
                        boolean keepAliveFrom;
                        block96: {
                            if (I2PTunnelRunner.this._log.shouldWarn()) {
                                boolean fnshd;
                                Object ioe2 = I2PTunnelRunner.this.finishLock;
                                synchronized (ioe2) {
                                    fnshd = I2PTunnelRunner.this.finished;
                                }
                                if (!fnshd) {
                                    I2PTunnelRunner.this._log.warn(this.direction + ": IOE - error forwarding", ex2);
                                } else if (I2PTunnelRunner.this._log.shouldDebug()) {
                                    I2PTunnelRunner.this._log.debug(this.direction + ": IOE caused by other direction", ex2);
                                }
                            }
                            this._failure = ex2;
                            this._cache.release(ba);
                            if (this._toI2P) {
                                keepAliveFrom = I2PTunnelRunner.this._keepAliveSocket;
                                keepAliveTo = I2PTunnelRunner.this._keepAliveI2P;
                            } else {
                                keepAliveFrom = I2PTunnelRunner.this._keepAliveI2P;
                                keepAliveTo = I2PTunnelRunner.this._keepAliveSocket;
                            }
                            if (!I2PTunnelRunner.this._log.shouldLog(20)) break block96;
                            I2PTunnelRunner.this._log.info(this.direction + ": done forwarding from " + from + " to " + to + " keepalive from? " + keepAliveFrom + " keepalive to? " + keepAliveTo + " bytes: " + (this._toI2P ? I2PTunnelRunner.this.totalSent : I2PTunnelRunner.this.totalReceived));
                            {
                                catch (Throwable throwable) {
                                    block100: {
                                        boolean keepAliveTo22;
                                        block99: {
                                            boolean keepAliveFrom22;
                                            this._cache.release(ba);
                                            if (this._toI2P) {
                                                keepAliveFrom22 = I2PTunnelRunner.this._keepAliveSocket;
                                                keepAliveTo22 = I2PTunnelRunner.this._keepAliveI2P;
                                            } else {
                                                keepAliveFrom22 = I2PTunnelRunner.this._keepAliveI2P;
                                                keepAliveTo22 = I2PTunnelRunner.this._keepAliveSocket;
                                            }
                                            if (I2PTunnelRunner.this._log.shouldLog(20)) {
                                                I2PTunnelRunner.this._log.info(this.direction + ": done forwarding from " + from + " to " + to + " keepalive from? " + keepAliveFrom22 + " keepalive to? " + keepAliveTo22 + " bytes: " + (this._toI2P ? I2PTunnelRunner.this.totalSent : I2PTunnelRunner.this.totalReceived));
                                            }
                                            if (!keepAliveFrom22) {
                                                try {
                                                    this.in.close();
                                                }
                                                catch (IOException ex3) {
                                                    if (!I2PTunnelRunner.this._log.shouldLog(30)) break block99;
                                                    I2PTunnelRunner.this._log.warn(this.direction + ": Error closing input stream", ex3);
                                                }
                                            }
                                        }
                                        try {
                                            if (I2PTunnelRunner.this.onTimeout == null && I2PTunnelRunner.this._onFail == null || this._toI2P || I2PTunnelRunner.this.totalReceived > 0L) {
                                                if (keepAliveTo22) {
                                                    this.out.flush();
                                                } else {
                                                    this.out.close();
                                                }
                                            } else {
                                                if (I2PTunnelRunner.this._log.shouldInfo()) {
                                                    I2PTunnelRunner.this._log.info(this.direction + ": not closing so we can write the error message");
                                                }
                                                if (keepAliveTo22) {
                                                    this.out.flush();
                                                }
                                            }
                                        }
                                        catch (IOException ioe4) {
                                            if (!I2PTunnelRunner.this._log.shouldLog(10)) break block100;
                                            I2PTunnelRunner.this._log.debug(this.direction + ": Error flushing to close", ioe4);
                                        }
                                    }
                                    Object object = I2PTunnelRunner.this.finishLock;
                                    synchronized (object) {
                                        I2PTunnelRunner.this.finished = true;
                                        I2PTunnelRunner.this.finishLock.notifyAll();
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        if (!keepAliveFrom) {
                            try {
                                this.in.close();
                            }
                            catch (IOException ex4) {
                                if (!I2PTunnelRunner.this._log.shouldLog(30)) break block97;
                                I2PTunnelRunner.this._log.warn(this.direction + ": Error closing input stream", ex4);
                            }
                        }
                    }
                    try {
                        if (I2PTunnelRunner.this.onTimeout == null && I2PTunnelRunner.this._onFail == null || this._toI2P || I2PTunnelRunner.this.totalReceived > 0L) {
                            if (keepAliveTo) {
                                this.out.flush();
                            } else {
                                this.out.close();
                            }
                        } else {
                            if (I2PTunnelRunner.this._log.shouldInfo()) {
                                I2PTunnelRunner.this._log.info(this.direction + ": not closing so we can write the error message");
                            }
                            if (keepAliveTo) {
                                this.out.flush();
                            }
                        }
                    }
                    catch (IOException ioe5) {
                        if (!I2PTunnelRunner.this._log.shouldLog(10)) break block98;
                        I2PTunnelRunner.this._log.debug(this.direction + ": Error flushing to close", ioe5);
                    }
                }
                Object object = I2PTunnelRunner.this.finishLock;
                synchronized (object) {
                    I2PTunnelRunner.this.finished = true;
                    I2PTunnelRunner.this.finishLock.notifyAll();
                }
            }
        }

        public Exception getFailure() {
            return this._failure;
        }
    }

    public static interface SuccessCallback {
        public void onSuccess();
    }
}

